/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.ezplug;

import icy.gui.frame.IcyInternalFrame;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.plaf.InternalFrameUI;
import org.jdesktop.swingx.graphics.ShadowRenderer;
import org.pushingpixels.substance.internal.ui.SubstanceInternalFrameUI;
import org.pushingpixels.substance.internal.utils.SubstanceInternalFrameTitlePane;
import plugins.adufour.ezplug.EzGUI;

public class EzInternalFrame
extends IcyInternalFrame {
    private static final long serialVersionUID = 1L;
    protected static final int SHADOW_SIZE = 4;
    protected static final int BORDER_SIZE_X = 8;
    protected static final int BORDER_SIZE_Y = 8;
    protected static final int ARC_SIZE = 20;
    private final ShadowRenderer renderer = new ShadowRenderer(4, 0.75f, Color.BLACK);
    private BufferedImage shadow;

    EzInternalFrame(String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable) {
        super(title, resizable, closable, maximizable, iconifiable);
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.updateUI();
    }

    public void doLayout() {
        if (this.isVisible()) {
            super.doLayout();
        }
    }

    public boolean isOpaque() {
        return false;
    }

    public void dispose() {
        if (this.isVisible()) {
            this.getUI().uninstallUI((JComponent)((Object)this));
        }
        super.dispose();
    }

    public void paintComponent(Graphics g) {
        if (this.shadow != null) {
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            g2.drawImage((Image)this.shadow, 0, 0, null);
            g2.dispose();
        }
        super.paintComponent(g);
    }

    public void setBounds(int x, int y, int width, int height) {
        if (width != this.getWidth() || height != this.getHeight()) {
            this.shadow = new BufferedImage(width, height, 2);
            Graphics2D g2 = this.shadow.createGraphics();
            g2.setColor(Color.WHITE);
            g2.fillRoundRect(2, 4, 2 + width - 12, height - 12, 20, 20);
            g2.fillRect(2, 4 + height / 2, 2 + width - 12, height / 2 - 12);
            g2.dispose();
            this.shadow = this.renderer.createShadow(this.shadow);
            g2.dispose();
        }
        super.setBounds(x, y, width, height);
    }

    public void updateUI() {
        EzInternalFrameUI newUI = new EzInternalFrameUI();
        this.setUI((InternalFrameUI)((Object)newUI));
        this.updateTitlePane(newUI.getTitlePane());
    }

    private final class EzInternalFrameTitlePane
    extends SubstanceInternalFrameTitlePane {
        private static final long serialVersionUID = 1L;
        private BufferedImage titleBar;

        public EzInternalFrameTitlePane() {
            super((JInternalFrame)((Object)EzInternalFrame.this));
            this.setFont(this.getFont().deriveFont(3, 16.0f));
            FontMetrics m = this.getFontMetrics(this.getFont());
            int titleWidth = m.stringWidth(EzInternalFrame.this.getTitle());
            this.setPreferredSize(new Dimension(titleWidth + 100, 32));
        }

        protected LayoutManager createLayout() {
            return new EzTitlePaneLayout();
        }

        public void paintComponent(Graphics g) {
            if (this.titleBar == null || this.titleBar.getWidth() != this.getWidth()) {
                int titleWidth = this.getWidth();
                int titleHeight = this.getHeight();
                this.titleBar = new BufferedImage(titleWidth, titleHeight, 2);
                Graphics2D g2 = this.titleBar.createGraphics();
                g2.setFont(this.getFont().deriveFont(3, 16.0f));
                EzGUI.paintTitlePane(g2, titleWidth, titleHeight, EzInternalFrame.this.getTitle(), true);
                g2.dispose();
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            g2.drawImage((Image)this.titleBar, 0, 0, null);
        }

        protected class EzTitlePaneLayout
        extends SubstanceInternalFrameTitlePane.SubstanceTitlePaneLayout {
            protected EzTitlePaneLayout() {
                super((SubstanceInternalFrameTitlePane)EzInternalFrameTitlePane.this);
            }

            public void layoutContainer(Container c) {
                boolean leftToRight = EzInternalFrameTitlePane.this.getComponentOrientation().isLeftToRight();
                int w = EzInternalFrameTitlePane.this.getWidth();
                int y = 4;
                int buttonHeight = EzInternalFrameTitlePane.this.closeButton.getIcon().getIconHeight();
                int buttonWidth = EzInternalFrameTitlePane.this.closeButton.getIcon().getIconWidth();
                int spacing = 5;
                int x = leftToRight ? spacing : w - 16 - spacing;
                EzInternalFrameTitlePane.this.menuBar.setBounds(x, y, 16, 16);
                int n = x = leftToRight ? w : 0;
                if (EzInternalFrame.this.isClosable()) {
                    spacing = 4;
                    EzInternalFrameTitlePane.this.closeButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                    if (!leftToRight) {
                        x += buttonWidth;
                    }
                }
                if (EzInternalFrame.this.isMaximizable()) {
                    spacing = EzInternalFrame.this.isClosable() ? 2 : 4;
                    EzInternalFrameTitlePane.this.maxButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                    if (!leftToRight) {
                        x += buttonWidth;
                    }
                }
                if (EzInternalFrame.this.isIconifiable()) {
                    spacing = EzInternalFrame.this.isMaximizable() ? 2 : (EzInternalFrame.this.isClosable() ? 2 : 4);
                    EzInternalFrameTitlePane.this.iconButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                    if (!leftToRight) {
                        x += buttonWidth;
                    }
                }
            }
        }
    }

    private final class EzInternalFrameUI
    extends SubstanceInternalFrameUI {
        public EzInternalFrameUI() {
            super((JInternalFrame)((Object)EzInternalFrame.this));
        }

        protected JComponent createNorthPane(JInternalFrame w) {
            try {
                Field titlePane = null;
                titlePane = SubstanceInternalFrameUI.class.getDeclaredField("titlePane");
                titlePane.setAccessible(true);
                titlePane.set((Object)this, (Object)new EzInternalFrameTitlePane());
                return (SubstanceInternalFrameTitlePane)titlePane.get((Object)this);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

