package plugins.ylemontag.complex;

/**
 * 
 * @author Yoann Le Montagner
 * 
 * Complex conversion functions
 */
public class ComplexUtil
{
	/**
	 * Return the real part of a complex value represented in polar coordinates
	 * @param r Modulus
	 * @param theta Argument
	 */
	public static double real(double r, double theta)
	{
		return r*Math.cos(theta);
	}
	
	/**
	 * Return the imaginary part of a complex value represented in polar coordinates
	 * @param r Modulus
	 * @param theta Argument
	 */
	public static double imaginary(double r, double theta)
	{
		return r*Math.sin(theta);
	}
	
	/**
	 * Return the modulus of a complex value represented in Cartesian coordinates
	 * @param a Real part
	 * @param b Imaginary part
	 */
	public static double modulus(double a, double b)
	{
		return Math.sqrt(a*a + b*b);
	}
	
	/**
	 * Return the argument of a complex value represented in Cartesian coordinates
	 * @param a Real part
	 * @param b Imaginary part
	 * @remark -pi < argument(a,b) <= pi
	 * @return 0 If a==0 and b==0
	 */
	public static double argument(double a, double b)
	{
		return Math.atan2(b, a);
	}
}
