/*
 * Decompiled with CFR 0.152.
 */
package icy.type.geom;

import icy.type.geom.Polygon2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class Polyline2D
implements Shape,
Cloneable {
    private static final double ASSUME_ZERO = 1.0E-5;
    public int npoints;
    public double[] xpoints;
    public double[] ypoints;
    protected Rectangle2D bounds;
    protected Path2D.Double path;

    public Polyline2D() {
        this.reset();
    }

    public Polyline2D(double[] xpoints, double[] ypoints, int npoints) {
        if (npoints > xpoints.length || npoints > ypoints.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        this.npoints = npoints;
        this.xpoints = new double[npoints];
        this.ypoints = new double[npoints];
        System.arraycopy(xpoints, 0, this.xpoints, 0, npoints);
        System.arraycopy(ypoints, 0, this.ypoints, 0, npoints);
        this.calculatePath();
    }

    public Polyline2D(int[] xpoints, int[] ypoints, int npoints) {
        if (npoints > xpoints.length || npoints > ypoints.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        this.npoints = npoints;
        this.xpoints = new double[npoints];
        this.ypoints = new double[npoints];
        int i = 0;
        while (i < npoints) {
            this.xpoints[i] = xpoints[i];
            this.ypoints[i] = ypoints[i];
            ++i;
        }
        this.calculatePath();
    }

    public Polyline2D(Line2D line) {
        this.npoints = 2;
        this.xpoints = new double[2];
        this.ypoints = new double[2];
        this.xpoints[0] = line.getX1();
        this.xpoints[1] = line.getX2();
        this.ypoints[0] = line.getY1();
        this.ypoints[1] = line.getY2();
        this.calculatePath();
    }

    public Polyline2D(Polygon polygon) {
        this(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public void reset() {
        this.npoints = 0;
        this.xpoints = new double[0];
        this.ypoints = new double[0];
        this.bounds = new Rectangle2D.Double();
        this.path = null;
    }

    public Object clone() {
        Polyline2D pol = new Polyline2D();
        int i = 0;
        while (i < this.npoints) {
            pol.addPoint(this.xpoints[i], this.ypoints[i]);
            ++i;
        }
        return pol;
    }

    public void calculatePath() {
        this.path = new Path2D.Double();
        if (this.npoints > 0) {
            this.path.moveTo(this.xpoints[0], this.ypoints[0]);
        }
        int i = 1;
        while (i < this.npoints) {
            this.path.lineTo(this.xpoints[i], this.ypoints[i]);
            ++i;
        }
        this.bounds = this.path.getBounds2D();
    }

    protected void updatePath(double x, double y) {
        if (this.path == null) {
            this.path = new Path2D.Double(0);
            this.path.moveTo(x, y);
            this.bounds = new Rectangle2D.Double(x, y, 0.0, 0.0);
        } else {
            this.path.lineTo(x, y);
            double _xmax = this.bounds.getMaxX();
            double _ymax = this.bounds.getMaxY();
            double _xmin = this.bounds.getMinX();
            double _ymin = this.bounds.getMinY();
            if (x < _xmin) {
                _xmin = x;
            } else if (x > _xmax) {
                _xmax = x;
            }
            if (y < _ymin) {
                _ymin = y;
            } else if (y > _ymax) {
                _ymax = y;
            }
            this.bounds = new Rectangle2D.Double(_xmin, _ymin, _xmax - _xmin, _ymax - _ymin);
        }
    }

    public void addPoint(Point2D p) {
        this.addPoint(p.getX(), p.getY());
    }

    public void addPoint(double x, double y) {
        if (this.npoints == this.xpoints.length) {
            double[] tmp = new double[this.npoints * 2 + 1];
            System.arraycopy(this.xpoints, 0, tmp, 0, this.npoints);
            this.xpoints = tmp;
            tmp = new double[this.npoints * 2 + 1];
            System.arraycopy(this.ypoints, 0, tmp, 0, this.npoints);
            this.ypoints = tmp;
        }
        this.xpoints[this.npoints] = x;
        this.ypoints[this.npoints] = y;
        ++this.npoints;
        this.updatePath(x, y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return (Rectangle2D)this.bounds.clone();
    }

    @Override
    public Rectangle getBounds() {
        if (this.bounds == null) {
            return new Rectangle();
        }
        return this.bounds.getBounds();
    }

    public List<Point2D> getPoints() {
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        int i = 0;
        while (i < this.npoints) {
            result.add(new Point2D.Double(this.xpoints[i], this.ypoints[i]));
            ++i;
        }
        return result;
    }

    public boolean contains(Point p) {
        return false;
    }

    @Override
    public boolean contains(double x, double y) {
        return false;
    }

    public boolean contains(int x, int y) {
        return false;
    }

    @Override
    public boolean contains(Point2D p) {
        return false;
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        if (this.path == null || !this.bounds.intersects(x, y, w, h)) {
            return false;
        }
        return this.path.intersects(x, y, w, h);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return false;
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return false;
    }

    public Polygon2D getPolygon2D() {
        Polygon2D pol = new Polygon2D();
        int i = 0;
        while (i < this.npoints - 1) {
            pol.addPoint(this.xpoints[i], this.ypoints[i]);
            ++i;
        }
        Point2D.Double p0 = new Point2D.Double(this.xpoints[0], this.ypoints[0]);
        Point2D.Double p1 = new Point2D.Double(this.xpoints[this.npoints - 1], this.ypoints[this.npoints - 1]);
        if (p0.distance(p1) > 1.0E-5) {
            pol.addPoint(this.xpoints[this.npoints - 1], this.ypoints[this.npoints - 1]);
        }
        return pol;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        if (this.path == null) {
            return new Path2D.Double().getPathIterator(at);
        }
        return this.path.getPathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }
}

