package plugins.fantm.trackprocessorfilteredrois;
// Version 0.1
// Marcus Fantham, University of Cambridge
// mjf74@cam.ac.uk
// April 2016
// 
// This plugin was written to address a request from our lab. We
// had a t-stack of mitochondria, some of which were moving from
// right to left across the image. 
// To highlight the moving mitochondria for a presentation, the 
// biologist wanted circles drawn around them. 
// This plugin works well when added in TrackManager after the 
// Motion Profiler plugin. 
//
// TODO: Let user change size and colour of ROI from the plugin-in
// panel. (At the moment this can be done by highlighting all ROIs
// in the ROI window, not very neat though. )


import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.gui.component.button.ColorChooserButton;
import icy.gui.component.button.ColorChooserButton.ColorChangeListener;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import plugins.fab.trackmanager.PluginTrackManagerProcessor;
import plugins.fab.trackmanager.TrackSegment;
import plugins.kernel.roi.roi2d.ROI2DEllipse;
import plugins.nchenouard.spot.Detection;


public class TrackProcessorFilteredROIs extends PluginTrackManagerProcessor implements ActionListener{
JTextField radiusTextField = new JTextField("8");
ColorChooserButton colorButton = new ColorChooserButton(Color.red);
JButton updateButton = new JButton("Update");

	public TrackProcessorFilteredROIs() {
		radiusTextField.setPreferredSize(new Dimension(50, 25));
		// Set up panel environment
		setName( "Draw Filtered ROIs on Sequence" );
		panel.setLayout( new GridLayout(1,3));	
		
		JPanel sizePanel = new JPanel(new FlowLayout(FlowLayout.LEADING));
		sizePanel.add(new JLabel("Radius of ROIs:"));
		sizePanel.add(radiusTextField);
		radiusTextField.addActionListener( this );
		
		JPanel colorPanel = new JPanel(new FlowLayout(FlowLayout.LEADING));
		colorPanel.add(new JLabel("Color:"));
		colorPanel.add(colorButton);
		colorButton.addColorChangeListener(new ColorChangeListener()
			{
				@Override
				public void colorChanged(ColorChooserButton source)
				{
					Compute();
				}
			});
		
		panel.add(sizePanel);
		panel.add(colorPanel);
		
		//TODO: add an 'update' button to change the colors. 
	}
	
	
	@Override
	public void Close() {

	}

	@Override
	public void Compute() {	
		Sequence sequence = trackPool.getDisplaySequence();
		if (sequence != null ) {
			// First, delete all old ROIs
			ArrayList<ROI2D> oldROIs = sequence.getROI2Ds(); 
			for (ROI2D oldROI : oldROIs) {
				if (oldROI.getName().equals("Filtered ROIs")){
					sequence.removeROI(oldROI);
				}
			}
		
			// Now add filtered ROIs
			if (isEnabled()) {				
				// Get ROI radius
				double cirRad = 8.0; // default value if all else fails
				try {
					cirRad = new Double( radiusTextField.getText() );
				}catch(Exception e){
					cirRad = 8.0;
				}
				
				// Get tracks
				ArrayList<TrackSegment> trackList;
				trackList = (ArrayList<TrackSegment>) trackPool.getTrackSegmentList().clone();
			
				for (TrackSegment ts : trackList) {
					ArrayList<Detection> detectionList = ts.getDetectionList();
					
					// Get detections
					for ( int i = 0;  i < detectionList.size() ; i++  ) {
						Detection d = detectionList.get( i );
						
						// Add detection to ROI list (nb. painted in another method)
						if (d.isEnabled()){
							d.getT();
							d.getX();
							d.getY();
							
							ROI2DEllipse roi = new ROI2DEllipse(d.getX()-cirRad, d.getY()-cirRad, d.getX()+cirRad, d.getY()+cirRad);
							roi.setZ(-1);
							roi.setT(d.getT());
							
							roi.setName("Filtered ROIs");
							roi.setColor(colorButton.getColor());
							sequence.addROI(roi);
						}
					}
				}
			}
		}
	}

	@Override
	public void displaySequenceChanged() {
		
	}


	@Override
	public void actionPerformed(ActionEvent e) {
		// TODO Auto-generated method stub
		Compute();
	}


}
