/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component.sequence;

import icy.image.IcyBufferedImage;
import icy.image.IcyBufferedImageUtil;
import icy.sequence.SequenceModel;
import icy.system.thread.ThreadUtil;
import icy.util.GraphicsUtil;
import icy.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SequencePreviewPanel
extends JPanel
implements ChangeListener,
SequenceModel.SequenceModelListener {
    private static final long serialVersionUID = 4985194381532600393L;
    protected boolean autoHideSliders;
    protected boolean fitToView;
    protected JSlider tSlider;
    protected JSlider zSlider;
    protected CustomPanel imagePanel;
    protected SequenceModel model;
    protected JLabel titleLabel;
    protected JPanel mainPanel;
    protected JPanel zPanel;
    protected JPanel tPanel;
    protected JLabel lblZ;
    protected JLabel lblT;
    protected JLabel lblZValue;
    protected JLabel lblTValue;

    public SequencePreviewPanel(String title, boolean autoHideSliders) {
        this.autoHideSliders = autoHideSliders;
        this.fitToView = true;
        this.model = null;
        this.initializeGui();
        if (autoHideSliders) {
            this.zPanel.setVisible(false);
            this.tPanel.setVisible(false);
        }
        this.setMaxZ(0);
        this.setMaxT(0);
        this.zSlider.addChangeListener(this);
        this.tSlider.addChangeListener(this);
        this.setTitle(title);
        this.setPreferredSize(new Dimension(280, 200));
        this.validate();
    }

    public SequencePreviewPanel(boolean autoHideSliders) {
        this((String)null, autoHideSliders);
    }

    public SequencePreviewPanel(String title) {
        this(title, true);
    }

    public SequencePreviewPanel() {
        this((String)null, true);
    }

    private void initializeGui() {
        this.setLayout(new BorderLayout(0, 0));
        this.titleLabel = new JLabel("Title");
        this.titleLabel.setBorder(new EmptyBorder(2, 0, 4, 0));
        this.titleLabel.setFont(new Font("Tahoma", 1, 13));
        this.titleLabel.setHorizontalAlignment(0);
        this.add((Component)this.titleLabel, "North");
        this.mainPanel = new JPanel();
        this.add((Component)this.mainPanel, "Center");
        GridBagLayout gbl_mainPanel = new GridBagLayout();
        gbl_mainPanel.columnWidths = new int[3];
        gbl_mainPanel.rowHeights = new int[3];
        gbl_mainPanel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gbl_mainPanel.rowWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        this.mainPanel.setLayout(gbl_mainPanel);
        this.imagePanel = new CustomPanel();
        GridBagConstraints gbc_imagePanel = new GridBagConstraints();
        gbc_imagePanel.insets = new Insets(0, 0, 5, 5);
        gbc_imagePanel.fill = 1;
        gbc_imagePanel.gridx = 1;
        gbc_imagePanel.gridy = 0;
        this.mainPanel.add((Component)this.imagePanel, gbc_imagePanel);
        this.zPanel = new JPanel();
        GridBagConstraints gbc_zPanel = new GridBagConstraints();
        gbc_zPanel.insets = new Insets(0, 0, 5, 5);
        gbc_zPanel.fill = 1;
        gbc_zPanel.gridx = 0;
        gbc_zPanel.gridy = 0;
        this.mainPanel.add((Component)this.zPanel, gbc_zPanel);
        GridBagLayout gbl_zPanel = new GridBagLayout();
        gbl_zPanel.columnWidths = new int[2];
        gbl_zPanel.rowHeights = new int[4];
        gbl_zPanel.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gbl_zPanel.rowWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        this.zPanel.setLayout(gbl_zPanel);
        this.lblZ = new JLabel("Z");
        GridBagConstraints gbc_lblZ = new GridBagConstraints();
        gbc_lblZ.fill = 1;
        gbc_lblZ.insets = new Insets(0, 0, 5, 0);
        gbc_lblZ.gridx = 0;
        gbc_lblZ.gridy = 0;
        this.zPanel.add((Component)this.lblZ, gbc_lblZ);
        this.lblZ.setFont(new Font("Tahoma", 1, 12));
        this.lblZ.setHorizontalAlignment(0);
        this.zSlider = new JSlider(1);
        GridBagConstraints gbc_zSlider = new GridBagConstraints();
        gbc_zSlider.fill = 1;
        gbc_zSlider.insets = new Insets(0, 0, 5, 0);
        gbc_zSlider.gridx = 0;
        gbc_zSlider.gridy = 1;
        this.zPanel.add((Component)this.zSlider, gbc_zSlider);
        this.lblZValue = new JLabel("0");
        GridBagConstraints gbc_lblZValue = new GridBagConstraints();
        gbc_lblZValue.fill = 1;
        gbc_lblZValue.gridx = 0;
        gbc_lblZValue.gridy = 2;
        this.zPanel.add((Component)this.lblZValue, gbc_lblZValue);
        this.lblZValue.setHorizontalAlignment(0);
        this.lblZValue.setFont(new Font("Tahoma", 1, 11));
        this.tPanel = new JPanel();
        GridBagConstraints gbc_tPanel = new GridBagConstraints();
        gbc_tPanel.fill = 1;
        gbc_tPanel.gridx = 1;
        gbc_tPanel.gridy = 1;
        this.mainPanel.add((Component)this.tPanel, gbc_tPanel);
        GridBagLayout gbl_tPanel = new GridBagLayout();
        gbl_tPanel.columnWidths = new int[4];
        gbl_tPanel.rowHeights = new int[2];
        gbl_tPanel.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_tPanel.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        this.tPanel.setLayout(gbl_tPanel);
        this.lblTValue = new JLabel("0");
        this.lblTValue.setMaximumSize(new Dimension(1000, 14));
        this.lblTValue.setPreferredSize(new Dimension(20, 14));
        this.lblTValue.setMinimumSize(new Dimension(20, 14));
        GridBagConstraints gbc_lblTValue = new GridBagConstraints();
        gbc_lblTValue.fill = 1;
        gbc_lblTValue.insets = new Insets(0, 0, 0, 5);
        gbc_lblTValue.gridx = 0;
        gbc_lblTValue.gridy = 0;
        this.tPanel.add((Component)this.lblTValue, gbc_lblTValue);
        this.lblTValue.setHorizontalAlignment(0);
        this.lblTValue.setFont(new Font("Tahoma", 1, 11));
        this.tSlider = new JSlider(0);
        GridBagConstraints gbc_tSlider = new GridBagConstraints();
        gbc_tSlider.fill = 1;
        gbc_tSlider.insets = new Insets(0, 0, 0, 5);
        gbc_tSlider.gridx = 1;
        gbc_tSlider.gridy = 0;
        this.tPanel.add((Component)this.tSlider, gbc_tSlider);
        this.lblT = new JLabel("T");
        this.lblT.setPreferredSize(new Dimension(20, 14));
        this.lblT.setMaximumSize(new Dimension(1000, 14));
        this.lblT.setMinimumSize(new Dimension(20, 14));
        GridBagConstraints gbc_lblT = new GridBagConstraints();
        gbc_lblT.fill = 1;
        gbc_lblT.gridx = 2;
        gbc_lblT.gridy = 0;
        this.tPanel.add((Component)this.lblT, gbc_lblT);
        this.lblT.setFont(new Font("Tahoma", 1, 12));
        this.lblT.setHorizontalAlignment(0);
        this.validate();
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public JPanel getZPanel() {
        return this.zPanel;
    }

    public JPanel getTPanel() {
        return this.tPanel;
    }

    public boolean getAutoHideSliders() {
        return this.autoHideSliders;
    }

    public void setAutoHideSliders(boolean value) {
        if (this.autoHideSliders != value) {
            this.autoHideSliders = value;
            this.zPanel.setVisible(this.zSlider.getMaximum() > 0 && value);
            this.tPanel.setVisible(this.tSlider.getMaximum() > 0 && value);
        }
    }

    public void setFitToView(boolean value) {
        if (this.fitToView != value) {
            this.fitToView = value;
            this.imagePanel.imageChanged();
        }
    }

    public void setPositionZ(int z) {
        this.zSlider.setValue(z);
        this.imageChanged();
    }

    public void setPositionT(int t) {
        this.tSlider.setValue(t);
        this.imageChanged();
    }

    private void setMaxZ(int value) {
        this.zSlider.setMaximum(Math.max(0, value));
        if (this.autoHideSliders) {
            this.zPanel.setVisible(value > 0);
        }
    }

    private void setMaxT(int value) {
        this.tSlider.setMaximum(Math.max(0, value));
        if (this.autoHideSliders) {
            this.tPanel.setVisible(value > 0);
        }
    }

    public SequenceModel getModel() {
        return this.model;
    }

    public void setModel(SequenceModel model) {
        if (this.model != model) {
            if (this.model != null) {
                this.model.removeSequenceModelListener(this);
            }
            this.model = model;
            if (model != null) {
                model.addSequenceModelListener(this);
            }
            this.dimensionChanged();
        }
    }

    public void setTitle(String value) {
        if (!this.titleLabel.getText().equals(value)) {
            this.titleLabel.setText(value);
            this.titleLabel.setVisible(!StringUtil.isEmpty(value));
        }
    }

    @Override
    public void dimensionChanged() {
        if (this.model != null) {
            this.setMaxZ(this.model.getSizeZ() - 1);
            this.setMaxT(this.model.getSizeT() - 1);
        } else {
            this.setMaxZ(0);
            this.setMaxT(0);
        }
        this.imagePanel.imageChanged();
    }

    @Override
    public void imageChanged() {
        this.imagePanel.imageChanged();
    }

    BufferedImage getImage() {
        if (this.model == null) {
            return null;
        }
        return this.model.getImage(this.tSlider.getValue(), this.zSlider.getValue());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.imagePanel.imageChanged();
        this.lblZValue.setText(Integer.toString(this.zSlider.getValue()));
        this.lblTValue.setText(Integer.toString(this.tSlider.getValue()));
    }

    private class CustomPanel
    extends JPanel
    implements Runnable {
        private static final long serialVersionUID = 6307431557815572470L;
        private BufferedImage cache = null;

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            int w = this.getWidth();
            int h = this.getHeight();
            Graphics2D g2 = (Graphics2D)g.create();
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setFont(g2.getFont().deriveFont(1, 22.0f));
            if (this.cache == null) {
                GraphicsUtil.drawCenteredString(g2, "No image", w / 2, h / 2, false);
            } else if (w > 0 && h > 0) {
                int fih;
                int fiw;
                int sw = this.getSizeX();
                int sh = this.getSizeY();
                int iw = this.cache.getWidth();
                int ih = this.cache.getHeight();
                if (SequencePreviewPanel.this.fitToView) {
                    double ratio1 = Math.max((double)iw / (double)sw, (double)ih / (double)sh);
                    double ratio2 = Math.max((double)sw / (double)w, (double)sh / (double)h);
                    fiw = (int)((double)iw / (ratio1 * ratio2));
                    fih = (int)((double)ih / (ratio1 * ratio2));
                } else {
                    double ratio = Math.max((double)sw / (double)w, (double)sh / (double)h);
                    fiw = (int)((double)iw / ratio);
                    fih = (int)((double)ih / ratio);
                }
                g2.drawImage(this.cache, (w - fiw) / 2, (h - fih) / 2, fiw, fih, null);
            }
            g2.dispose();
        }

        public void imageChanged() {
            ThreadUtil.runSingle(this);
        }

        int getSizeX() {
            if (SequencePreviewPanel.this.model != null) {
                return SequencePreviewPanel.this.model.getSizeX();
            }
            if (this.cache != null) {
                return this.cache.getWidth();
            }
            return 0;
        }

        int getSizeY() {
            if (SequencePreviewPanel.this.model != null) {
                return SequencePreviewPanel.this.model.getSizeY();
            }
            if (this.cache != null) {
                return this.cache.getHeight();
            }
            return 0;
        }

        @Override
        public void run() {
            BufferedImage img = SequencePreviewPanel.this.getImage();
            this.cache = img instanceof IcyBufferedImage ? IcyBufferedImageUtil.toBufferedImage((IcyBufferedImage)img, 2) : img;
            this.repaint();
        }
    }
}

