/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.frame;

import icy.gui.frame.TitledFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ActionFrame
extends TitledFrame {
    protected static final String OK_CMD = "ok";
    protected static final String CANCEL_CMD = "cancel";
    protected final JPanel buttonPanel = new JPanel();
    protected final JButton okBtn;
    protected final JButton cancelBtn;
    protected ActionListener okAction;
    protected boolean closeAfterAction;

    public ActionFrame(String title) {
        this(title, false, false);
    }

    public ActionFrame(String title, boolean resizable) {
        this(title, resizable, false);
    }

    public ActionFrame(String title, boolean resizable, boolean iconifiable) {
        super(title, resizable, true, false, iconifiable);
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 2));
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.okBtn = new JButton("Ok");
        this.cancelBtn = new JButton("Cancel");
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(this.okBtn);
        this.buttonPanel.add(Box.createHorizontalStrut(10));
        this.buttonPanel.add(this.cancelBtn);
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.add(this.buttonPanel, "South");
        this.okBtn.setActionCommand(OK_CMD);
        this.cancelBtn.setActionCommand(CANCEL_CMD);
        ActionListener buttonActions = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String cmd = e.getActionCommand();
                if (ActionFrame.CANCEL_CMD.equals(cmd)) {
                    ActionFrame.this.close();
                } else if (ActionFrame.OK_CMD.equals(cmd)) {
                    if (ActionFrame.this.okAction != null) {
                        ActionFrame.this.okAction.actionPerformed(e);
                    }
                    if (ActionFrame.this.closeAfterAction) {
                        ActionFrame.this.close();
                    }
                }
            }
        };
        this.okBtn.addActionListener(buttonActions);
        this.cancelBtn.addActionListener(buttonActions);
        this.okAction = null;
        this.closeAfterAction = true;
    }

    public boolean isCloseAfterAction() {
        return this.closeAfterAction;
    }

    public void setCloseAfterAction(boolean closeAfterAction) {
        this.closeAfterAction = closeAfterAction;
    }

    public ActionListener getOkAction() {
        return this.okAction;
    }

    public void setOkAction(ActionListener okAction) {
        this.okAction = okAction;
    }

    public JButton getOkBtn() {
        return this.okBtn;
    }

    public JButton getCancelBtn() {
        return this.cancelBtn;
    }
}

