/*
 * Decompiled with CFR 0.152.
 */
package icy.image;

import icy.image.ARGBImageBuilder;
import icy.image.IcyBufferedImage;
import icy.image.lut.LUT;
import icy.math.Scaler;
import icy.type.DataType;
import icy.type.collection.array.Array1DUtil;
import icy.type.collection.array.ArrayType;
import icy.type.collection.array.ArrayUtil;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.List;
import javax.media.jai.BorderExtender;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.RotateDescriptor;
import javax.media.jai.operator.ScaleDescriptor;

public class IcyBufferedImageUtil {
    private static ARGBImageBuilder argbImageBuilder = new ARGBImageBuilder();

    @Deprecated
    public static IcyBufferedImage toIcyBufferedImage(BufferedImage image) {
        return IcyBufferedImage.createFrom(image);
    }

    @Deprecated
    public static IcyBufferedImage toIcyBufferedImage(List<BufferedImage> images) {
        return IcyBufferedImage.createFrom(images);
    }

    public static BufferedImage toBufferedImage(IcyBufferedImage source, BufferedImage dest, LUT lut) {
        BufferedImage result = dest == null ? new BufferedImage(source.getWidth(), source.getHeight(), 2) : dest;
        Graphics2D g = result.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.drawImage((Image)IcyBufferedImageUtil.getARGBImage(source, lut), 0, 0, null);
        g.dispose();
        return result;
    }

    public static BufferedImage toBufferedImage(IcyBufferedImage source, BufferedImage dest) {
        return IcyBufferedImageUtil.toBufferedImage(source, dest, null);
    }

    public static BufferedImage toBufferedImage(IcyBufferedImage source, int imageType, LUT lut) {
        if (source == null) {
            return null;
        }
        BufferedImage outImg = new BufferedImage(source.getWidth(), source.getHeight(), imageType);
        IcyBufferedImageUtil.toBufferedImage(source, outImg, lut);
        return outImg;
    }

    public static BufferedImage toBufferedImage(IcyBufferedImage source, int imageType) {
        return IcyBufferedImageUtil.toBufferedImage(source, imageType, null);
    }

    @Deprecated
    public static BufferedImage getARGBImage(IcyBufferedImage source, LUT lut, BufferedImage dest) {
        if (source == null) {
            return null;
        }
        if (lut == null) {
            if (!source.getAutoUpdateChannelBounds()) {
                source.updateChannelsBounds();
            }
            return argbImageBuilder.buildARGBImage(source, source.createCompatibleLUT(false), dest);
        }
        return argbImageBuilder.buildARGBImage(source, lut, dest);
    }

    @Deprecated
    public static BufferedImage getARGBImage(IcyBufferedImage source, BufferedImage dest) {
        return IcyBufferedImageUtil.getARGBImage(source, null, dest);
    }

    public static BufferedImage getARGBImage(IcyBufferedImage source, LUT lut) {
        if (source == null) {
            return null;
        }
        if (lut == null) {
            if (!source.getAutoUpdateChannelBounds()) {
                source.updateChannelsBounds();
            }
            return argbImageBuilder.buildARGBImage(source, source.createCompatibleLUT(false));
        }
        return argbImageBuilder.buildARGBImage(source, lut);
    }

    public static BufferedImage getARGBImage(IcyBufferedImage source) {
        return IcyBufferedImageUtil.getARGBImage(source, null);
    }

    public static IcyBufferedImage convertType(IcyBufferedImage source, DataType dataType, Scaler[] scalers) {
        if (source == null) {
            return null;
        }
        DataType srcDataType = source.getDataType_();
        if (srcDataType == null || srcDataType == DataType.UNDEFINED || dataType == null || dataType == DataType.UNDEFINED) {
            return null;
        }
        boolean srcSigned = srcDataType.isSigned();
        boolean dstSigned = dataType.isSigned();
        int sizeC = source.getSizeC();
        IcyBufferedImage result = new IcyBufferedImage(source.getSizeX(), source.getSizeY(), sizeC, dataType);
        result.lockRaster();
        try {
            int c = 0;
            while (c < sizeC) {
                if (scalers == null || c >= scalers.length || scalers[c].isNull()) {
                    ArrayUtil.arrayToSafeArray(source.getDataXY(c), result.getDataXY(c), srcSigned, dstSigned);
                } else {
                    double[] darray = Array1DUtil.arrayToDoubleArray(source.getDataXY(c), srcSigned);
                    scalers[c].scale(darray);
                    Array1DUtil.doubleArrayToSafeArray(darray, result.getDataXY(c), dstSigned);
                }
                ++c;
            }
        }
        finally {
            result.releaseRaster(true);
        }
        result.setColorMaps(source);
        result.dataChanged();
        return result;
    }

    @Deprecated
    public static IcyBufferedImage convertToType(IcyBufferedImage source, DataType dataType, Scaler scaler) {
        if (source == null) {
            return null;
        }
        DataType srcDataType = source.getDataType_();
        if (srcDataType == DataType.UNDEFINED || dataType == DataType.UNDEFINED) {
            return null;
        }
        boolean srcSigned = srcDataType.isSigned();
        boolean dstSigned = dataType.isSigned();
        int sizeC = source.getSizeC();
        IcyBufferedImage result = new IcyBufferedImage(source.getSizeX(), source.getSizeY(), sizeC, dataType);
        result.lockRaster();
        try {
            int c = 0;
            while (c < sizeC) {
                if (scaler == null || scaler.isNull()) {
                    ArrayUtil.arrayToSafeArray(source.getDataXY(c), result.getDataXY(c), srcSigned, dstSigned);
                } else {
                    double[] darray = Array1DUtil.arrayToDoubleArray(source.getDataXY(c), srcSigned);
                    scaler.scale(darray);
                    Array1DUtil.doubleArrayToSafeArray(darray, result.getDataXY(c), dstSigned);
                }
                ++c;
            }
        }
        finally {
            result.releaseRaster(true);
        }
        result.setColorMaps(source);
        result.dataChanged();
        return result;
    }

    public static IcyBufferedImage convertToType(IcyBufferedImage source, DataType dataType, boolean rescale, boolean useDataBounds) {
        if (source == null) {
            return null;
        }
        if (!rescale) {
            return IcyBufferedImageUtil.convertType(source, dataType, null);
        }
        double[] boundsDst = dataType.getDefaultBounds();
        int sizeC = source.getSizeC();
        Scaler[] scalers = new Scaler[sizeC];
        int c = 0;
        while (c < sizeC) {
            double[] boundsSrc = useDataBounds ? source.getChannelBounds(c) : source.getChannelTypeBounds(c);
            scalers[c] = new Scaler(boundsSrc[0], boundsSrc[1], boundsDst[0], boundsDst[1], false);
            ++c;
        }
        return IcyBufferedImageUtil.convertType(source, dataType, scalers);
    }

    public static IcyBufferedImage convertToType(IcyBufferedImage source, DataType dataType, boolean rescale) {
        return IcyBufferedImageUtil.convertToType(source, dataType, rescale, false);
    }

    public static IcyBufferedImage getCopy(IcyBufferedImage source) {
        if (source == null) {
            return null;
        }
        IcyBufferedImage result = new IcyBufferedImage(source.getSizeX(), source.getSizeY(), source.getSizeC(), source.getDataType_());
        result.copyData(source);
        return result;
    }

    public static IcyBufferedImage getSubImage(IcyBufferedImage source, Rectangle region, int c, int sizeC) {
        int endC;
        int startC;
        int endY;
        int startY;
        int endX;
        int startX;
        if (source == null) {
            return null;
        }
        if (region.x == Integer.MIN_VALUE && region.width == Integer.MAX_VALUE) {
            startX = 0;
            endX = source.getSizeX();
        } else {
            startX = Math.max(0, region.x);
            endX = Math.min(source.getSizeX(), region.x + region.width);
        }
        if (region.y == Integer.MIN_VALUE && region.height == Integer.MAX_VALUE) {
            startY = 0;
            endY = source.getSizeY();
        } else {
            startY = Math.max(0, region.y);
            endY = Math.min(source.getSizeY(), region.y + region.height);
        }
        if (c == Integer.MIN_VALUE && sizeC == Integer.MAX_VALUE) {
            startC = 0;
            endC = source.getSizeC();
        } else {
            startC = Math.max(0, c);
            endC = Math.min(source.getSizeC(), c + sizeC);
        }
        int sizeX = endX - startX;
        int sizeY = endY - startY;
        int adjSizeC = endC - startC;
        if (sizeX <= 0 || sizeY <= 0 || adjSizeC <= 0) {
            return null;
        }
        DataType dataType = source.getDataType_();
        boolean signed = dataType.isSigned();
        IcyBufferedImage result = new IcyBufferedImage(sizeX, sizeY, adjSizeC, dataType);
        int srcSizeX = source.getSizeX();
        result.lockRaster();
        try {
            int ch = startC;
            while (ch < endC) {
                Object src = source.getDataXY(ch);
                Object dst = result.getDataXY(ch - startC);
                int srcOffset = source.getOffset(startX, startY);
                int dstOffset = 0;
                int curY = 0;
                while (curY < sizeY) {
                    Array1DUtil.arrayToArray(src, srcOffset, dst, dstOffset, sizeX, signed);
                    srcOffset += srcSizeX;
                    dstOffset += sizeX;
                    ++curY;
                }
                ++ch;
            }
        }
        finally {
            result.releaseRaster(true);
        }
        result.dataChanged();
        return result;
    }

    public static IcyBufferedImage getSubImage(IcyBufferedImage source, Rectangle region) {
        return IcyBufferedImageUtil.getSubImage(source, region, 0, source.getSizeC());
    }

    @Deprecated
    public static IcyBufferedImage getSubImage(IcyBufferedImage source, int x, int y, int c, int sizeX, int sizeY, int sizeC) {
        return IcyBufferedImageUtil.getSubImage(source, new Rectangle(x, y, sizeX, sizeY), c, sizeC);
    }

    public static IcyBufferedImage getSubImage(IcyBufferedImage source, int x, int y, int w, int h) {
        return IcyBufferedImageUtil.getSubImage(source, new Rectangle(x, y, w, h), 0, source.getSizeC());
    }

    public static IcyBufferedImage extractChannel(IcyBufferedImage source, int channel) {
        return IcyBufferedImageUtil.extractChannels(source, channel);
    }

    @Deprecated
    public static IcyBufferedImage extractChannels(IcyBufferedImage source, List<Integer> channelNumbers) {
        if (source == null) {
            return null;
        }
        IcyBufferedImage result = new IcyBufferedImage(source.getSizeX(), source.getSizeY(), channelNumbers.size(), source.getDataType_());
        int sizeC = source.getSizeC();
        int i = 0;
        while (i < channelNumbers.size()) {
            int channel = channelNumbers.get(i);
            if (channel < sizeC) {
                result.setDataXY(i, source.getDataXY(channel));
            }
            ++i;
        }
        return result;
    }

    public static IcyBufferedImage extractChannels(IcyBufferedImage source, int ... channels) {
        if (source == null || channels == null || channels.length == 0) {
            return null;
        }
        IcyBufferedImage result = new IcyBufferedImage(source.getSizeX(), source.getSizeY(), channels.length, source.getDataType_());
        int sizeC = source.getSizeC();
        int i = 0;
        while (i < channels.length) {
            int channel = channels[i];
            if (channel < sizeC) {
                result.setDataXY(i, source.getDataXY(channel));
            }
            ++i;
        }
        return result;
    }

    public static IcyBufferedImage addChannels(IcyBufferedImage source, int index, int num) {
        if (source == null) {
            return null;
        }
        IcyBufferedImage result = new IcyBufferedImage(source.getSizeX(), source.getSizeY(), source.getSizeC() + num, source.getDataType_());
        int c = 0;
        while (c < index) {
            result.copyData((BufferedImage)source, c, c);
            result.setColorMap(c, source.getColorMap(c), false);
            ++c;
        }
        c = index;
        while (c < source.getSizeC()) {
            result.copyData((BufferedImage)source, c, c + num);
            result.setColorMap(c + num, source.getColorMap(c), false);
            ++c;
        }
        return result;
    }

    public static IcyBufferedImage addChannel(IcyBufferedImage source, int index) {
        return IcyBufferedImageUtil.addChannels(source, index, 1);
    }

    public static IcyBufferedImage addChannel(IcyBufferedImage source) {
        return IcyBufferedImageUtil.addChannels(source, source.getSizeC(), 1);
    }

    public static IcyBufferedImage rotate(IcyBufferedImage source, double xOrigin, double yOrigin, double angle, FilterType filterType) {
        Interpolation interpolation;
        if (source == null) {
            return null;
        }
        switch (filterType) {
            default: {
                interpolation = Interpolation.getInstance((int)0);
                break;
            }
            case BILINEAR: {
                interpolation = Interpolation.getInstance((int)1);
                break;
            }
            case BICUBIC: {
                interpolation = Interpolation.getInstance((int)2);
            }
        }
        RenderedOp renderedOp = RotateDescriptor.create((RenderedImage)IcyBufferedImageUtil.getCopy(source), (Float)Float.valueOf((float)xOrigin), (Float)Float.valueOf((float)yOrigin), (Float)Float.valueOf((float)angle), (Interpolation)interpolation, null, (RenderingHints)new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)0)));
        return IcyBufferedImage.createFrom((PlanarImage)renderedOp, source.isSignedDataType());
    }

    public static IcyBufferedImage rotate(IcyBufferedImage source, double angle, FilterType filterType) {
        if (source == null) {
            return null;
        }
        return IcyBufferedImageUtil.rotate(source, (double)source.getSizeX() / 2.0, (double)source.getSizeY() / 2.0, angle, filterType);
    }

    public static IcyBufferedImage rotate(IcyBufferedImage source, double angle) {
        if (source == null) {
            return null;
        }
        return IcyBufferedImageUtil.rotate(source, (double)source.getSizeX() / 2.0, (double)source.getSizeY() / 2.0, angle, FilterType.BILINEAR);
    }

    static void downscaleBy2(byte[] input, int sizeX, int sizeY, boolean signed, boolean filter, byte[] output) {
        int halfSizeX = sizeX / 2;
        int halfSizeY = sizeY / 2;
        if (filter) {
            int inOff = 0;
            int outOff = 0;
            int y = 0;
            while (y < halfSizeY) {
                int x = 0;
                int inOffset = inOff;
                while (x < halfSizeX) {
                    int val;
                    if (signed) {
                        val = input[inOffset + 0];
                        val += input[inOffset + 1];
                        val += input[inOffset + sizeX + 0];
                        val += input[inOffset + sizeX + 1];
                    } else {
                        val = input[inOffset + 0] & 0xFF;
                        val += input[inOffset + 1] & 0xFF;
                        val += input[inOffset + sizeX + 0] & 0xFF;
                        val += input[inOffset + sizeX + 1] & 0xFF;
                    }
                    output[outOff++] = (byte)(val >>= 2);
                    ++x;
                    inOffset += 2;
                }
                inOff += sizeX * 2;
                ++y;
            }
        } else {
            int inOff = 0;
            int outOff = 0;
            int y = 0;
            while (y < halfSizeY) {
                int x = 0;
                int inOffset = inOff;
                while (x < halfSizeX) {
                    output[outOff++] = input[inOffset];
                    ++x;
                    inOffset += 2;
                }
                inOff += sizeX * 2;
                ++y;
            }
        }
    }

    static void downscaleBy2(short[] input, int sizeX, int sizeY, boolean signed, boolean filter, short[] output) {
        int halfSizeX = sizeX / 2;
        int halfSizeY = sizeY / 2;
        if (filter) {
            int inOff = 0;
            int outOff = 0;
            int y = 0;
            while (y < halfSizeY) {
                int x = 0;
                int inOffset = inOff;
                while (x < halfSizeX) {
                    int val;
                    if (signed) {
                        val = input[inOffset + 0];
                        val += input[inOffset + 1];
                        val += input[inOffset + sizeX + 0];
                        val += input[inOffset + sizeX + 1];
                    } else {
                        val = input[inOffset + 0] & 0xFFFF;
                        val += input[inOffset + 1] & 0xFFFF;
                        val += input[inOffset + sizeX + 0] & 0xFFFF;
                        val += input[inOffset + sizeX + 1] & 0xFFFF;
                    }
                    output[outOff++] = (short)(val >>= 2);
                    ++x;
                    inOffset += 2;
                }
                inOff += sizeX * 2;
                ++y;
            }
        } else {
            int inOff = 0;
            int outOff = 0;
            int y = 0;
            while (y < halfSizeY) {
                int x = 0;
                int inOffset = inOff;
                while (x < halfSizeX) {
                    output[outOff++] = input[inOffset];
                    ++x;
                    inOffset += 2;
                }
                inOff += sizeX * 2;
                ++y;
            }
        }
    }

    static void downscaleBy2(int[] input, int sizeX, int sizeY, boolean signed, boolean filter, int[] output) {
        int halfSizeX = sizeX / 2;
        int halfSizeY = sizeY / 2;
        if (filter) {
            int inOff = 0;
            int outOff = 0;
            int y = 0;
            while (y < halfSizeY) {
                int x = 0;
                int inOffset = inOff;
                while (x < halfSizeX) {
                    long val;
                    if (signed) {
                        val = input[inOffset + 0];
                        val += (long)input[inOffset + 1];
                        val += (long)input[inOffset + sizeX + 0];
                        val += (long)input[inOffset + sizeX + 1];
                    } else {
                        val = (long)input[inOffset + 0] & 0xFFFFFFFFL;
                        val += (long)input[inOffset + 1] & 0xFFFFFFFFL;
                        val += (long)input[inOffset + sizeX + 0] & 0xFFFFFFFFL;
                        val += (long)input[inOffset + sizeX + 1] & 0xFFFFFFFFL;
                    }
                    output[outOff++] = (int)(val >>= 2);
                    ++x;
                    inOffset += 2;
                }
                inOff += sizeX * 2;
                ++y;
            }
        } else {
            int inOff = 0;
            int outOff = 0;
            int y = 0;
            while (y < halfSizeY) {
                int x = 0;
                int inOffset = inOff;
                while (x < halfSizeX) {
                    output[outOff++] = input[inOffset];
                    ++x;
                    inOffset += 2;
                }
                inOff += sizeX * 2;
                ++y;
            }
        }
    }

    static void downscaleBy2(float[] input, int sizeX, int sizeY, boolean filter, float[] output) {
        int halfSizeX = sizeX / 2;
        int halfSizeY = sizeY / 2;
        if (filter) {
            int inOff = 0;
            int outOff = 0;
            int y = 0;
            while (y < halfSizeY) {
                int x = 0;
                int inOffset = inOff;
                while (x < halfSizeX) {
                    float val = input[inOffset + 0];
                    val += input[inOffset + 1];
                    val += input[inOffset + sizeX + 0];
                    val += input[inOffset + sizeX + 1];
                    output[outOff++] = val /= 4.0f;
                    ++x;
                    inOffset += 2;
                }
                inOff += sizeX * 2;
                ++y;
            }
        } else {
            int inOff = 0;
            int outOff = 0;
            int y = 0;
            while (y < halfSizeY) {
                int x = 0;
                int inOffset = inOff;
                while (x < halfSizeX) {
                    output[outOff++] = input[inOffset];
                    ++x;
                    inOffset += 2;
                }
                inOff += sizeX * 2;
                ++y;
            }
        }
    }

    static void downscaleBy2(double[] input, int sizeX, int sizeY, boolean filter, double[] output) {
        int halfSizeX = sizeX / 2;
        int halfSizeY = sizeY / 2;
        if (filter) {
            int inOff = 0;
            int outOff = 0;
            int y = 0;
            while (y < halfSizeY) {
                int x = 0;
                int inOffset = inOff;
                while (x < halfSizeX) {
                    double val = input[inOffset + 0];
                    val += input[inOffset + 1];
                    val += input[inOffset + sizeX + 0];
                    val += input[inOffset + sizeX + 1];
                    output[outOff++] = val /= 4.0;
                    ++x;
                    inOffset += 2;
                }
                inOff += sizeX * 2;
                ++y;
            }
        } else {
            int inOff = 0;
            int outOff = 0;
            int y = 0;
            while (y < halfSizeY) {
                int x = 0;
                int inOffset = inOff;
                while (x < halfSizeX) {
                    output[outOff++] = input[inOffset];
                    ++x;
                    inOffset += 2;
                }
                inOff += sizeX * 2;
                ++y;
            }
        }
    }

    public static Object downscaleBy2(Object input, int sizeX, int sizeY, boolean signed, boolean filter, Object output) {
        if (input == null) {
            return output;
        }
        ArrayType arrayType = ArrayUtil.getArrayType(input);
        Object result = ArrayUtil.allocIfNull(output, arrayType, sizeX / 2 * (sizeY / 2));
        switch (arrayType.getDataType().getJavaType()) {
            case BYTE: {
                IcyBufferedImageUtil.downscaleBy2((byte[])input, sizeX, sizeY, signed, filter, (byte[])result);
                break;
            }
            case SHORT: {
                IcyBufferedImageUtil.downscaleBy2((short[])input, sizeX, sizeY, signed, filter, (short[])result);
                break;
            }
            case INT: {
                IcyBufferedImageUtil.downscaleBy2((int[])input, sizeX, sizeY, signed, filter, (int[])result);
                break;
            }
            case FLOAT: {
                IcyBufferedImageUtil.downscaleBy2((float[])input, sizeX, sizeY, filter, (float[])result);
                break;
            }
            case DOUBLE: {
                IcyBufferedImageUtil.downscaleBy2((double[])input, sizeX, sizeY, filter, (double[])result);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type: " + (Object)((Object)arrayType.getDataType().getJavaType()));
            }
        }
        return result;
    }

    public static Object downscaleBy2(Object input, int sizeX, int sizeY, boolean signed, boolean filter) {
        return IcyBufferedImageUtil.downscaleBy2(input, sizeX, sizeY, signed, filter, null);
    }

    public static IcyBufferedImage downscaleBy2(IcyBufferedImage input, boolean filter, IcyBufferedImage output) {
        if (input == null) {
            return output;
        }
        int sizeX = input.getSizeX();
        int sizeY = input.getSizeY();
        int sizeC = input.getSizeC();
        IcyBufferedImage result = output != null ? output : new IcyBufferedImage(sizeX / 2, sizeY / 2, input.getIcyColorModel());
        int c = 0;
        while (c < sizeC) {
            IcyBufferedImageUtil.downscaleBy2(input.getDataXY(c), sizeX, sizeY, input.isSignedDataType(), filter, result.getDataXY(c));
            ++c;
        }
        return result;
    }

    public static IcyBufferedImage downscaleBy2(IcyBufferedImage input, boolean filter) {
        return IcyBufferedImageUtil.downscaleBy2(input, filter, null);
    }

    public static IcyBufferedImage downscaleBy2(IcyBufferedImage source, boolean filter, int level) {
        IcyBufferedImage result = source;
        int it = level;
        while (it-- > 0) {
            if (result != source) {
                result.setVolatile(false);
            }
            result = IcyBufferedImageUtil.downscaleBy2(result, true);
        }
        return result;
    }

    public static IcyBufferedImage scale(IcyBufferedImage source, int width, int height, boolean resizeContent, int xAlign, int yAlign, FilterType filterType) {
        IcyBufferedImage result;
        boolean resize;
        if (source == null) {
            return null;
        }
        int srcW = source.getWidth();
        int srcH = source.getHeight();
        boolean bl = resize = resizeContent && (width != srcW || height != srcH);
        if (!resize) {
            int yt;
            int xt;
            int dx = width - srcW;
            switch (xAlign) {
                default: {
                    xt = 0;
                    break;
                }
                case 0: {
                    xt = dx / 2;
                    break;
                }
                case 4: {
                    xt = dx;
                }
            }
            int dy = height - srcH;
            switch (yAlign) {
                default: {
                    yt = 0;
                    break;
                }
                case 0: {
                    yt = dy / 2;
                    break;
                }
                case 3: {
                    yt = dy;
                }
            }
            result = new IcyBufferedImage(width, height, source.getIcyColorModel());
            result.copyData(source, null, new Point(xt, yt));
        } else {
            Interpolation interpolation;
            Float xScale = Float.valueOf((float)width / (float)srcW);
            Float yScale = Float.valueOf((float)height / (float)srcH);
            switch (filterType) {
                default: {
                    interpolation = Interpolation.getInstance((int)0);
                    break;
                }
                case BILINEAR: {
                    interpolation = Interpolation.getInstance((int)1);
                    break;
                }
                case BICUBIC: {
                    interpolation = Interpolation.getInstance((int)2);
                }
            }
            IcyBufferedImage srcCopy = IcyBufferedImageUtil.getCopy(source);
            srcCopy.lockRaster();
            try {
                RenderedOp renderedOp = ScaleDescriptor.create((RenderedImage)srcCopy, (Float)xScale, (Float)yScale, (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Interpolation)interpolation, (RenderingHints)new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1)));
                result = IcyBufferedImage.createFrom((PlanarImage)renderedOp, source.isSignedDataType());
            }
            finally {
                srcCopy.releaseRaster(false);
            }
        }
        return result;
    }

    public static IcyBufferedImage scale(IcyBufferedImage source, int width, int height, boolean resizeContent, int xAlign, int yAlign) {
        return IcyBufferedImageUtil.scale(source, width, height, resizeContent, xAlign, yAlign, FilterType.BILINEAR);
    }

    public static IcyBufferedImage scale(IcyBufferedImage source, int width, int height, FilterType filterType) {
        return IcyBufferedImageUtil.scale(source, width, height, true, 0, 0, filterType);
    }

    public static IcyBufferedImage scale(IcyBufferedImage source, int width, int height) {
        return IcyBufferedImageUtil.scale(source, width, height, FilterType.BILINEAR);
    }

    public static void translate(IcyBufferedImage source, int dx, int dy, int channel) {
        int toFill;
        int fromFill;
        int wCopy;
        int toCopy;
        int fromCopy;
        if (source == null) {
            return;
        }
        if (dx == 0 && dy == 0) {
            return;
        }
        int sizeX = source.getSizeX();
        int sizeY = source.getSizeY();
        int adx = Math.min(Math.max(-sizeX, dx), sizeX);
        int ady = Math.min(Math.max(-sizeY, dy), sizeY);
        if (adx < 0) {
            fromCopy = -adx;
            toCopy = 0;
            fromFill = wCopy = sizeX + adx;
            toFill = sizeX;
        } else {
            fromFill = 0;
            toFill = adx;
            fromCopy = fromFill;
            toCopy = toFill;
            wCopy = sizeX - adx;
        }
        source.lockRaster();
        try {
            Object data = source.getDataXY(channel);
            if (ady < 0) {
                int hCopy = sizeY + ady;
                int toOffset = 0;
                int fromOffset = -ady * sizeX;
                int y = 0;
                while (y < hCopy) {
                    Array1DUtil.innerCopy(data, fromOffset + fromCopy, toOffset + toCopy, wCopy);
                    Array1DUtil.fill(data, toOffset + fromFill, toOffset + toFill, 0.0);
                    fromOffset += sizeX;
                    toOffset += sizeX;
                    ++y;
                }
                Array1DUtil.fill(data, toOffset, fromOffset, 0.0);
            } else {
                int hCopy = sizeY - ady;
                int toOffset = (sizeY - 1) * sizeX;
                int fromOffset = toOffset - ady * sizeX;
                int y = 0;
                while (y < hCopy) {
                    Array1DUtil.innerCopy(data, fromOffset + fromCopy, toOffset + toCopy, wCopy);
                    Array1DUtil.fill(data, toOffset + fromFill, toOffset + toFill, 0.0);
                    fromOffset -= sizeX;
                    toOffset -= sizeX;
                    ++y;
                }
                Array1DUtil.fill(data, 0, 0 + ady * sizeX, 0.0);
            }
        }
        finally {
            source.releaseRaster(true);
        }
        source.dataChanged();
    }

    public static void translate(IcyBufferedImage source, int dx, int dy) {
        if (source != null) {
            int sizeC = source.getSizeC();
            source.beginUpdate();
            try {
                int c = 0;
                while (c < sizeC) {
                    IcyBufferedImageUtil.translate(source, dx, dy, c);
                    ++c;
                }
            }
            finally {
                source.endUpdate();
            }
        }
    }

    public static enum FilterType {
        NEAREST,
        BILINEAR,
        BICUBIC;

    }
}

