/*
 * Decompiled with CFR 0.152.
 */
package icy.image.colormap;

import icy.file.xml.XMLPersistent;
import icy.image.colormap.IcyColorMap;
import icy.math.Interpolator;
import icy.util.XMLUtil;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IcyColorMapComponent
implements XMLPersistent {
    static final String ID_INDEX = "index";
    static final String ID_VALUE = "value";
    private static final String ID_RAWDATA = "rawdata";
    private static final String ID_POINT = "point";
    private final IcyColorMap colormap;
    protected final ArrayList<ControlPoint> controlPoints = new ArrayList();
    public final short[] map;
    public final float[] mapf;
    private int updateCnt;
    private boolean controlPointsChangedPending;
    private boolean mapDataChangedPending;
    private boolean mapFDataChangedPending;
    private boolean rawData;

    public IcyColorMapComponent(IcyColorMap colorMap, short initValue) {
        this.colormap = colorMap;
        this.map = new short[256];
        this.mapf = new float[256];
        Arrays.fill(this.map, initValue);
        this.updateFloatMapFromIntMap();
        this.controlPoints.add(new ControlPoint(0, this.map[0], true));
        this.controlPoints.add(new ControlPoint(255, this.map[255], true));
        this.updateCnt = 0;
        this.controlPointsChangedPending = false;
        this.mapDataChangedPending = false;
        this.mapFDataChangedPending = false;
        this.rawData = false;
    }

    public IcyColorMapComponent(IcyColorMap colorMap) {
        this(colorMap, 0);
    }

    public int getControlPointCount() {
        return this.controlPoints.size();
    }

    public ArrayList<ControlPoint> getControlPoints() {
        return this.controlPoints;
    }

    public ControlPoint getControlPoint(int index) {
        return this.controlPoints.get(index);
    }

    public ControlPoint getControlPointWithIndex(int index, boolean create) {
        for (ControlPoint cp : this.controlPoints) {
            if (cp.getIndex() != index) continue;
            return cp;
        }
        if (create) {
            ControlPoint result = new ControlPoint(index, 0, index == 0 || index == 255);
            this.controlPoints.add(result);
            return result;
        }
        return null;
    }

    public boolean hasControlPointWithIndex(int index) {
        return this.getControlPointWithIndex(index, false) != null;
    }

    public ControlPoint setControlPoint(int index, float value) {
        return this.setControlPoint(index, (int)(value * 255.0f));
    }

    public ControlPoint setControlPoint(int index, int value) {
        this.rawData = false;
        ControlPoint controlPoint = this.getControlPointWithIndex(index, false);
        if (controlPoint == null) {
            controlPoint = new ControlPoint(index, value);
            this.controlPoints.add(controlPoint);
            this.controlPointAdded(controlPoint);
        } else {
            controlPoint.setValue(value);
        }
        return controlPoint;
    }

    public void removeControlPoint(ControlPoint controlPoint) {
        if (this.controlPoints.remove(controlPoint)) {
            this.controlPointRemoved(controlPoint);
        }
    }

    public void removeAllControlPoint() {
        if (this.controlPoints.size() <= 2) {
            return;
        }
        this.beginUpdate();
        try {
            while (this.controlPoints.size() > 2) {
                this.removeControlPoint(this.controlPoints.get(1));
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void copyFrom(IcyColorMapComponent source) {
        this.rawData = source.rawData;
        this.controlPoints.clear();
        for (ControlPoint cp : source.controlPoints) {
            this.controlPoints.add(new ControlPoint(cp.getIndex(), cp.getValue(), cp.isFixed()));
        }
        if (this.controlPoints.size() <= 2) {
            System.arraycopy(source.map, 0, this.map, 0, 256);
            this.mapDataChanged();
        } else {
            this.controlPointsChanged();
        }
    }

    public void copyFrom(byte[] src) {
        this.controlPoints.clear();
        double srcOffsetStep = src.length / 256;
        double srcOffset = 0.0;
        int dstOffset = 0;
        while (dstOffset < 256) {
            this.map[dstOffset] = (short)(src[(int)srcOffset] & 0xFF);
            srcOffset += srcOffsetStep;
            ++dstOffset;
        }
        this.rawData = true;
        this.mapDataChanged();
    }

    public void copyFrom(short[] src, int shift) {
        byte[] byteMap = new byte[src.length];
        int i = 0;
        while (i < src.length) {
            byteMap[i] = (byte)(src[i] >> shift);
            ++i;
        }
        this.copyFrom(byteMap);
    }

    public byte[] asByteArray() {
        byte[] result = new byte[256];
        int i = 0;
        while (i < result.length) {
            result[i] = (byte)this.getValue(i);
            ++i;
        }
        return result;
    }

    public short getValue(int index) {
        return this.map[index];
    }

    @Deprecated
    public short getIntensity(int index) {
        return this.getValue(index);
    }

    public void setValue(int index, int value) {
        this.rawData = true;
        if (this.map[index] != value) {
            this.removeAllControlPoint();
            this.map[index] = (short)value;
            this.mapDataChanged();
        }
    }

    public void setNormalizedValue(int index, float value) {
        this.rawData = true;
        if (this.mapf[index] != value) {
            this.removeAllControlPoint();
            this.mapf[index] = value;
            this.mapFDataChanged();
        }
    }

    public boolean isAllSame() {
        short value = this.map[0];
        int i = 1;
        while (i < 256) {
            if (this.map[i] != value) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isAllZero() {
        short[] sArray = this.map;
        int n = this.map.length;
        int n2 = 0;
        while (n2 < n) {
            short value = sArray[n2];
            if (value != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean isAllOne() {
        short[] sArray = this.map;
        int n = this.map.length;
        int n2 = 0;
        while (n2 < n) {
            short value = sArray[n2];
            if (value != 255) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean isLinear() {
        float lastdiff = this.mapf[1] - this.mapf[0];
        int i = 2;
        while (i < 256) {
            float diff = this.mapf[i] - this.mapf[i - 1];
            if (diff != 0.0f && lastdiff != 0.0f) {
                if (diff != lastdiff && Math.abs(diff / (diff - lastdiff)) < 1000.0f) {
                    return false;
                }
                lastdiff = diff;
            }
            ++i;
        }
        return true;
    }

    private void updateFloatMapFromIntMap() {
        int i = 0;
        while (i < 256) {
            this.mapf[i] = (float)this.map[i] / 255.0f;
            ++i;
        }
    }

    private void updateIntMapFromFloatMap() {
        int i = 0;
        while (i < 256) {
            this.map[i] = (short)(this.mapf[i] * 255.0f);
            ++i;
        }
    }

    private void updateFixedCP() {
        this.getControlPointWithIndex((int)0, (boolean)true).value = this.map[0];
        this.getControlPointWithIndex((int)255, (boolean)true).value = this.map[255];
    }

    public void controlPointChanged(ControlPoint controlPoint) {
        this.controlPointsChanged();
    }

    public void controlPointAdded(ControlPoint controlPoint) {
        this.controlPointsChanged();
    }

    public void controlPointRemoved(ControlPoint controlPoint) {
        this.controlPointsChanged();
    }

    public void onControlPointsChanged() {
        Collections.sort(this.controlPoints);
        ArrayList<Point> points = new ArrayList<Point>();
        for (ControlPoint point : this.controlPoints) {
            points.add(point.getPosition());
        }
        double[] values = Interpolator.doYLinearInterpolation(points, 1.0);
        int i = 0;
        while (i < 256) {
            this.map[i] = (short)Math.round(values[i]);
            ++i;
        }
        this.mapDataChanged();
    }

    public void onMapDataChanged() {
        this.updateFloatMapFromIntMap();
        this.updateFixedCP();
        if (this.rawData) {
            this.rawData = !this.isLinear();
        }
        this.colormap.changed();
    }

    public void onMapFDataChanged() {
        this.updateIntMapFromFloatMap();
        this.updateFixedCP();
        this.colormap.changed();
    }

    public void controlPointsChanged() {
        if (this.isUpdating()) {
            this.controlPointsChangedPending = true;
            this.mapDataChangedPending = false;
            this.mapFDataChangedPending = false;
        } else {
            this.onControlPointsChanged();
        }
    }

    public void mapDataChanged() {
        if (this.isUpdating()) {
            this.mapDataChangedPending = true;
            this.mapFDataChangedPending = false;
            this.controlPointsChangedPending = false;
        } else {
            this.onMapDataChanged();
        }
    }

    public void mapFDataChanged() {
        if (this.isUpdating()) {
            this.mapFDataChangedPending = true;
            this.mapDataChangedPending = false;
            this.controlPointsChangedPending = false;
        } else {
            this.onMapFDataChanged();
        }
    }

    public void beginUpdate() {
        ++this.updateCnt;
    }

    public void endUpdate() {
        --this.updateCnt;
        if (this.updateCnt <= 0) {
            if (this.controlPointsChangedPending) {
                this.onControlPointsChanged();
                this.controlPointsChangedPending = false;
            } else if (this.mapDataChangedPending) {
                this.onMapDataChanged();
                this.mapDataChangedPending = false;
            } else if (this.mapFDataChangedPending) {
                this.onMapFDataChanged();
                this.mapFDataChangedPending = false;
            }
        }
    }

    public boolean isUpdating() {
        return this.updateCnt > 0;
    }

    public boolean isRawData() {
        return this.rawData;
    }

    @Override
    public boolean loadFromXML(Node node) {
        if (node == null) {
            return false;
        }
        this.rawData = XMLUtil.getAttributeBooleanValue((Element)node, ID_RAWDATA, false);
        ArrayList<Node> nodesPoint = XMLUtil.getChildren(node, ID_POINT);
        this.beginUpdate();
        try {
            if (this.rawData) {
                int ind = 0;
                if (nodesPoint.size() == 0) {
                    byte[] data = XMLUtil.getElementBytesValue(node, ID_VALUE, new byte[0]);
                    if (data == null) {
                        return false;
                    }
                    this.copyFrom(data);
                } else {
                    for (Node nodePoint : nodesPoint) {
                        int val = XMLUtil.getElementIntValue(nodePoint, ID_VALUE, 0);
                        this.setValue(ind, val);
                        ++ind;
                    }
                }
            } else {
                this.removeAllControlPoint();
                for (Node nodePoint : nodesPoint) {
                    int ind = XMLUtil.getElementIntValue(nodePoint, ID_INDEX, 0);
                    int val = XMLUtil.getElementIntValue(nodePoint, ID_VALUE, 0);
                    this.setControlPoint(ind, val);
                }
            }
        }
        finally {
            this.endUpdate();
        }
        return true;
    }

    @Override
    public boolean saveToXML(Node node) {
        if (node == null) {
            return false;
        }
        XMLUtil.setAttributeBooleanValue((Element)node, ID_RAWDATA, this.rawData);
        XMLUtil.removeChildren(node, ID_POINT);
        boolean result = true;
        if (this.rawData) {
            XMLUtil.removeChildren(node, ID_VALUE);
            XMLUtil.setElementBytesValue(node, ID_VALUE, this.asByteArray());
        } else {
            int ind = 0;
            while (ind < this.controlPoints.size()) {
                ControlPoint cp = this.controlPoints.get(ind);
                Element nodePoint = XMLUtil.addElement(node, ID_POINT);
                result = result && cp.saveToXML(nodePoint);
                ++ind;
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IcyColorMapComponent) {
            return Arrays.equals(this.map, ((IcyColorMapComponent)obj).map);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public class ControlPoint
    implements Comparable<ControlPoint>,
    XMLPersistent {
        int index;
        int value;
        private final boolean fixed;

        public ControlPoint(int index, int value, boolean fixed) {
            this.index = index;
            this.value = value;
            this.fixed = fixed;
        }

        public ControlPoint(int index, int value) {
            this(index, value, false);
        }

        public boolean isFixed() {
            return this.fixed;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            if (!this.fixed && this.index != index) {
                this.index = index;
                this.changed();
            }
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            if (this.value != value) {
                this.value = value;
                this.changed();
            }
        }

        public void setPosition(Point p) {
            this.setPosition(p.x, p.y);
        }

        public Point getPosition() {
            return new Point(this.index, this.value);
        }

        public void setPosition(int index, int value) {
            if (!this.fixed && this.index != index || this.value != value) {
                if (!this.fixed) {
                    this.index = index;
                }
                this.value = value;
                this.changed();
            }
        }

        public void remove() {
            if (!this.fixed) {
                IcyColorMapComponent.this.removeControlPoint(this);
            }
        }

        protected void onChanged() {
        }

        protected void changed() {
            this.onChanged();
            IcyColorMapComponent.this.controlPointChanged(this);
        }

        @Override
        public int compareTo(ControlPoint o) {
            if (this.index < o.getIndex()) {
                return -1;
            }
            if (this.index > o.getIndex()) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean loadFromXML(Node node) {
            if (node == null) {
                return false;
            }
            int ind = XMLUtil.getElementIntValue(node, IcyColorMapComponent.ID_INDEX, 0);
            int val = XMLUtil.getElementIntValue(node, IcyColorMapComponent.ID_VALUE, 0);
            this.setPosition(ind, val);
            return true;
        }

        @Override
        public boolean saveToXML(Node node) {
            if (node == null) {
                return false;
            }
            XMLUtil.setElementIntValue(node, IcyColorMapComponent.ID_INDEX, this.getIndex());
            XMLUtil.setElementIntValue(node, IcyColorMapComponent.ID_VALUE, this.getValue());
            return true;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ControlPoint) {
                ControlPoint pt = (ControlPoint)obj;
                return this.index == pt.index && this.value == pt.value;
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.index ^ this.value;
        }
    }
}

