/*
 * Decompiled with CFR 0.152.
 */
package icy.math;

public class RateMeter {
    private double lastCnt;
    private double rate;
    private double rateCnt;
    private double lastRateCnt;

    public RateMeter() {
        this.reset();
    }

    public void reset() {
        this.lastCnt = System.nanoTime();
        this.rate = 0.0;
        this.rateCnt = 0.0;
        this.lastRateCnt = 0.0;
    }

    public double updateFromDelta(double delta) {
        return this.updateFromTotal(this.rateCnt + delta);
    }

    public double updateFromTotal(double total) {
        double curCnt = System.nanoTime();
        double difCnt = curCnt - this.lastCnt;
        this.rateCnt = total;
        if (difCnt > 1.0E9) {
            this.lastCnt = curCnt;
            this.rate = this.rateCnt - this.lastRateCnt;
            this.rate *= 1.0E9;
            this.rate /= difCnt;
            this.lastRateCnt = this.rateCnt;
        }
        return this.rate;
    }

    public double getRate() {
        return this.rate;
    }
}

