/*
 * Decompiled with CFR 0.152.
 */
package icy.sequence;

import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;

public class SequencePrefetcher
extends Thread {
    private static final SequencePrefetcher prefetcher = new SequencePrefetcher();
    private final Set<PrefetchEntry> prefetchSet = new HashSet<PrefetchEntry>();
    private final Deque<PrefetchEntry> prefetchQueue = new LinkedBlockingDeque<PrefetchEntry>();

    public static void prefetch(Sequence sequence, int t, int z) {
        prefetcher.prefetchInternal(sequence, t, z);
    }

    public static void cancel(Sequence sequence) {
        prefetcher.cancelInternal(sequence);
    }

    public static void shutdown() {
        prefetcher.interrupt();
    }

    public SequencePrefetcher() {
        super("Sequence prefetcher");
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prefetchInternal(Sequence sequence, int t, int z) {
        PrefetchEntry entry = new PrefetchEntry(sequence, t, z);
        if (this.prefetchSet.contains(entry)) {
            return;
        }
        IcyBufferedImage image = sequence.getImage(t, z, false);
        if (image == null) {
            return;
        }
        if (image.isDataInitialized()) {
            return;
        }
        Set<PrefetchEntry> set = this.prefetchSet;
        synchronized (set) {
            this.prefetchSet.add(entry);
            this.prefetchQueue.addFirst(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelInternal(Sequence sequence) {
        ArrayList<PrefetchEntry> toRemove = new ArrayList<PrefetchEntry>();
        Set<PrefetchEntry> set = this.prefetchSet;
        synchronized (set) {
            for (PrefetchEntry entry : this.prefetchSet) {
                Sequence entrySeq = entry.sequence.get();
                if (entrySeq != null && entrySeq != sequence) continue;
                toRemove.add(entry);
            }
            this.prefetchSet.removeAll(toRemove);
            this.prefetchQueue.removeAll(toRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!SequencePrefetcher.interrupted()) {
            PrefetchEntry entry;
            Set<PrefetchEntry> set = this.prefetchSet;
            synchronized (set) {
                entry = this.prefetchQueue.pollFirst();
                if (entry != null) {
                    this.prefetchSet.remove(entry);
                }
            }
            if (entry != null) {
                Sequence entrySeq = entry.sequence.get();
                if (entrySeq == null) continue;
                entrySeq.getImage(entry.t, entry.z, true);
                continue;
            }
            try {
                SequencePrefetcher.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static class PrefetchEntry {
        final Reference<Sequence> sequence;
        final int t;
        final int z;
        final int hc;

        public PrefetchEntry(Sequence sequence, int t, int z) {
            this.sequence = new WeakReference<Sequence>(sequence);
            this.t = t;
            this.z = z;
            this.hc = sequence.hashCode() ^ t << 0 ^ z << 16;
        }

        public int hashCode() {
            return this.hc;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PrefetchEntry) {
                PrefetchEntry entry = (PrefetchEntry)obj;
                return entry.sequence.get() == this.sequence.get() && entry.t == this.t && entry.z == this.z;
            }
            return super.equals(obj);
        }
    }
}

