/*
 * Decompiled with CFR 0.152.
 */
package icy.vtk;

import icy.preferences.CanvasPreferences;
import icy.util.EventUtil;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Timer;
import java.util.TimerTask;
import vtk.vtkActor;
import vtk.vtkPanel;
import vtk.vtkPropPicker;

public class IcyVtkPanelOld
extends vtkPanel {
    private static final long serialVersionUID = -8455671369400627703L;
    protected Timer timer = new Timer("Timer - vtkPanel");
    protected final vtkPropPicker picker = new vtkPropPicker();

    public IcyVtkPanelOld() {
        this.lgt.SetAmbientColor(1.0, 1.0, 1.0);
    }

    public void Delete() {
        super.Delete();
        this.timer.cancel();
    }

    public void removeNotify() {
        super.removeNotify();
        this.timer.cancel();
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (this.windowset == 1) {
            this.Lock();
            this.rw.SetSize(width, height);
            this.UnLock();
        }
    }

    public void setSize(int w, int h) {
        this.resize(w, h);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
    }

    public void mouseMoved(MouseEvent e) {
        this.lastX = e.getX();
        this.lastY = e.getY();
    }

    public void mouseDragged(MouseEvent e) {
        if (this.cam == null) {
            return;
        }
        if (e.isConsumed()) {
            return;
        }
        if (this.ren.VisibleActorCount() == 0) {
            return;
        }
        this.timer.cancel();
        int x = e.getX();
        int y = e.getY();
        int deltaX = this.lastX - x;
        int deltaY = this.lastY - y;
        if (EventUtil.isControlDown(e)) {
            deltaX *= 3;
            deltaY *= 3;
        }
        if (EventUtil.isRightMouseButton(e) || EventUtil.isLeftMouseButton(e) && EventUtil.isShiftDown(e)) {
            this.translateView(-deltaX, deltaY);
        } else if (EventUtil.isLeftMouseButton(e)) {
            this.rotateView(deltaX, -deltaY);
        } else {
            this.zoomView(Math.pow(1.02, -deltaY));
        }
        this.lastX = x;
        this.lastY = y;
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (this.ren.VisibleActorCount() == 0) {
            return;
        }
        this.setCoarseRendering(0L);
    }

    public void mouseReleased(MouseEvent e) {
        this.setFineRendering(1000L);
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.cam == null) {
            return;
        }
        this.setCoarseRendering(0L);
        double delta = (double)e.getWheelRotation() * CanvasPreferences.getMouseWheelSensitivity();
        if (CanvasPreferences.getInvertMouseWheelAxis()) {
            delta = -delta;
        }
        if (EventUtil.isControlDown(e)) {
            delta *= 3.0;
        }
        this.zoomView(Math.pow(1.02, delta));
        this.repaint();
        this.setFineRendering(1000L);
    }

    public void keyPressed(KeyEvent e) {
        if (!e.isConsumed()) {
            super.keyPressed(e);
        }
    }

    public void keyReleased(KeyEvent e) {
        if (!e.isConsumed()) {
            super.keyReleased(e);
        }
    }

    public void lock() {
        if (this.windowset == 0) {
            return;
        }
        super.lock();
    }

    public void unlock() {
        if (this.windowset == 0) {
            return;
        }
        super.unlock();
    }

    public boolean isRendering() {
        return this.rendering;
    }

    public vtkPropPicker getPicker() {
        return this.picker;
    }

    public vtkActor pick(int x, int y) {
        this.Lock();
        this.picker.PickProp((double)x, (double)(this.rw.GetSize()[1] - y), this.ren);
        this.UnLock();
        return this.picker.GetActor();
    }

    public void translateView(double dx, double dy) {
        double[] APoint = new double[3];
        double[] FPoint = this.cam.GetFocalPoint();
        double[] PPoint = this.cam.GetPosition();
        this.ren.SetWorldPoint(FPoint[0], FPoint[1], FPoint[2], 1.0);
        this.ren.WorldToDisplay();
        double focalDepth = this.ren.GetDisplayPoint()[2];
        APoint[0] = (double)this.rw.GetSize()[0] / 2.0 + dx;
        APoint[1] = (double)this.rw.GetSize()[1] / 2.0 + dy;
        APoint[2] = focalDepth;
        this.ren.SetDisplayPoint(APoint);
        this.ren.DisplayToWorld();
        double[] RPoint = this.ren.GetWorldPoint();
        if (RPoint[3] != 0.0) {
            RPoint[0] = RPoint[0] / RPoint[3];
            RPoint[1] = RPoint[1] / RPoint[3];
            RPoint[2] = RPoint[2] / RPoint[3];
        }
        this.cam.SetFocalPoint((FPoint[0] - RPoint[0]) / 2.0 + FPoint[0], (FPoint[1] - RPoint[1]) / 2.0 + FPoint[1], (FPoint[2] - RPoint[2]) / 2.0 + FPoint[2]);
        this.cam.SetPosition((FPoint[0] - RPoint[0]) / 2.0 + PPoint[0], (FPoint[1] - RPoint[1]) / 2.0 + PPoint[1], (FPoint[2] - RPoint[2]) / 2.0 + PPoint[2]);
        this.resetCameraClippingRange();
    }

    public void rotateView(int dx, int dy) {
        this.cam.Azimuth((double)dx);
        this.cam.Elevation((double)dy);
        this.cam.OrthogonalizeViewUp();
        this.resetCameraClippingRange();
        if (this.LightFollowCamera == 1) {
            this.lgt.SetPosition(this.cam.GetPosition());
            this.lgt.SetFocalPoint(this.cam.GetFocalPoint());
        }
    }

    public void zoomView(double factor) {
        if (this.cam.GetParallelProjection() == 1) {
            this.cam.SetParallelScale(this.cam.GetParallelScale() / factor);
        } else {
            this.cam.Dolly(factor);
            this.resetCameraClippingRange();
        }
    }

    public void setCoarseRendering() {
        this.rw.SetDesiredUpdateRate(10.0);
    }

    public void setFineRendering() {
        this.rw.SetDesiredUpdateRate(0.01);
    }

    public void setCoarseRendering(long time) {
        this.timer.cancel();
        this.rw.SetDesiredUpdateRate(10.0);
        if (time > 0L) {
            this.setFineRendering(time);
        }
    }

    public void setFineRendering(long delay) {
        this.timer.cancel();
        if (delay > 0L) {
            this.timer = new Timer();
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (IcyVtkPanelOld.this.getParent() == null) {
                        return;
                    }
                    IcyVtkPanelOld.this.GetRenderWindow().SetDesiredUpdateRate(0.01);
                    IcyVtkPanelOld.this.repaint();
                }
            }, delay);
        } else {
            this.rw.SetDesiredUpdateRate(0.01);
        }
    }
}

