/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.descriptor.measure;

import icy.math.UnitUtil;
import icy.roi.ROI;
import icy.roi.ROIDescriptor;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.util.StringUtil;

public class ROIPerimeterDescriptor
extends ROIDescriptor {
    public static final String ID = "Perimeter";

    public ROIPerimeterDescriptor() {
        super(ID, ID, Double.class);
    }

    @Override
    public String getDescription() {
        return ID;
    }

    @Override
    public String getUnit(Sequence sequence) {
        if (sequence != null) {
            return String.valueOf(sequence.getBestPixelSizeUnit(2, 1).toString()) + "m";
        }
        return String.valueOf(UnitUtil.UnitPrefix.MICRO.toString()) + "m";
    }

    @Override
    public boolean needRecompute(SequenceEvent change) {
        SequenceEvent.SequenceEventSourceType sourceType = change.getSourceType();
        if (sourceType == SequenceEvent.SequenceEventSourceType.SEQUENCE_DATA) {
            return true;
        }
        if (sourceType == SequenceEvent.SequenceEventSourceType.SEQUENCE_META) {
            String metaName = (String)change.getSource();
            return StringUtil.isEmpty(metaName) || StringUtil.equals(metaName, "pixelSizeX") || StringUtil.equals(metaName, "pixelSizeY") || StringUtil.equals(metaName, "pixelSizeZ");
        }
        return false;
    }

    @Override
    public Object compute(ROI roi, Sequence sequence) throws UnsupportedOperationException {
        return ROIPerimeterDescriptor.computePerimeter(roi, sequence);
    }

    public static double computePerimeter(ROI roi, Sequence sequence) throws UnsupportedOperationException {
        if (sequence == null) {
            throw new UnsupportedOperationException("Cannot compute Perimeter with null Sequence parameter !");
        }
        UnitUtil.UnitPrefix bestUnit = sequence.getBestPixelSizeUnit(2, 1);
        double length = roi.getLength(sequence);
        return UnitUtil.getValueInUnit(length, UnitUtil.UnitPrefix.MICRO, bestUnit, 1);
    }
}

