/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations;

import plugins.adufour.blocks.util.VarList;
import plugins.ylemontag.mathoperations.Functor;
import plugins.ylemontag.mathoperations.MathOperationAbstractBlock;
import plugins.ylemontag.mathoperations.MathOperationPlugin;
import plugins.ylemontag.mathoperations.Variant;
import plugins.ylemontag.mathoperations.operations.Operation2;

public class MathOperationBasicBlocks {

    public static class DivideBlock
    extends AbstractBlock {
        public DivideBlock() {
            super(Operation2.DIVIDE);
        }
    }

    public static class MultiplyBlock
    extends AbstractBlock {
        public MultiplyBlock() {
            super(Operation2.MULTIPLY);
        }
    }

    public static class SubtractBlock
    extends AbstractBlock {
        public SubtractBlock() {
            super(Operation2.SUBTRACT);
        }
    }

    public static class AddBlock
    extends AbstractBlock {
        public AddBlock() {
            super(Operation2.ADD);
        }
    }

    private static class AbstractBlock
    extends MathOperationAbstractBlock {
        private Operation2 _operation;
        private String _name1;
        private String _name2;

        protected AbstractBlock(Operation2 operation) {
            super(operation.describeOperation("a", "b"));
            this._operation = operation;
            this._name1 = "a";
            this._name2 = "b";
        }

        public void declareInput(VarList inputMap) {
            this.addInputVariant(inputMap, this._name1, "In 1");
            this.addInputVariant(inputMap, this._name2, "In 2");
        }

        public String getMainPluginClassName() {
            return MathOperationPlugin.class.getName();
        }

        public String getName() {
            return this._operation.getFunctionName();
        }

        public void run() {
            Variant in1 = this.retrieveInputValue(this._name1);
            Variant in2 = this.retrieveInputValue(this._name2);
            String description = this._operation.getFunctor().describeOperation(in1.getRepresentation(true), in2.getRepresentation(true));
            try {
                Variant out = this._operation.getFunctor().apply(in1, in2);
                this.defineOutputValue(out);
            }
            catch (Functor.InconsistentArguments err) {
                AbstractBlock.reportError(err, description);
            }
        }
    }
}

