/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.geom;

import java.io.IOException;
import java.io.Writer;
import java.text.NumberFormat;
import javax.vecmath.Point3f;
import mcib3d.geom.Point3D;

public class Vector3D
extends Point3D {
    double length = -1.0;

    public Vector3D() {
    }

    public Vector3D(float x, float y, float z) {
        super(x, y, z);
    }

    public Vector3D(double x, double y, double z) {
        super(x, y, z);
    }

    public Vector3D(Vector3D V) {
        super(V.getX(), V.getY(), V.getZ());
    }

    public Vector3D(Point3D P) {
        super(P);
    }

    public Vector3D(Point3D P1, Point3D P2) {
        super(P2.getX() - P1.getX(), P2.getY() - P1.getY(), P2.getZ() - P1.getZ());
    }

    public void setVectorPoint3f(Point3f P) {
        this.x = P.x;
        this.y = P.y;
        this.z = P.z;
    }

    public void setVectorTwoPoint3f(Point3f P1, Point3f P2) {
        this.x = P2.x - P1.x;
        this.y = P2.y - P1.y;
        this.z = P2.z - P1.z;
    }

    public void setCoord(double x, double y, double z) {
        this.setX(x);
        this.setY(y);
        this.setZ(z);
    }

    @Override
    public void setCoordRandom() {
        super.setCoordRandom();
        this.normalize();
    }

    public double getLength() {
        return this.getLength(1.0, 1.0);
    }

    public double getLengthSquare() {
        return this.getLengthSquare(1.0, 1.0);
    }

    public double getLength(double resXY, double resZ) {
        this.computeLength(resXY, resZ);
        return this.length;
    }

    public double getLengthSquare(double resXY, double resZ) {
        return this.computeLengthSquare(resXY, resZ);
    }

    public double distance(Vector3D V) {
        Vector3D diff = this.add(V, 1.0f, -1.0f);
        return diff.getLength();
    }

    public double distanceSquare(Vector3D V) {
        Vector3D diff = this.add(V, 1.0f, -1.0f);
        return diff.getX() * diff.getX() + diff.getY() * diff.getY() + diff.getZ() * diff.getZ();
    }

    private void computeLength(double resXY, double resZ) {
        this.length = Math.sqrt(this.getX() * this.getX() * resXY * resXY + this.getY() * this.getY() * resXY * resXY + this.getZ() * this.getZ() * resZ * resZ);
    }

    private double computeLengthSquare(double resXY, double resZ) {
        return this.getX() * this.getX() * resXY * resXY + this.getY() * this.getY() * resXY * resXY + this.getZ() * this.getZ() * resZ * resZ;
    }

    public Vector3D add(Vector3D v) {
        return this.add(v, 1.0f, 1.0f);
    }

    public void addMe(Vector3D v) {
        this.x += v.getX();
        this.y += v.getY();
        this.z += v.getZ();
    }

    public void addMe(Vector3D v, double r) {
        this.x += v.getX() * r;
        this.y += v.getY() * r;
        this.z += v.getZ() * r;
    }

    public Vector3D add(Vector3D v, float f1, float f2) {
        return new Vector3D((double)f1 * this.getX() + (double)f2 * v.getX(), (double)f1 * this.getY() + (double)f2 * v.getY(), (double)f1 * this.getZ() + (double)f2 * v.getZ());
    }

    public Vector3D add(Vector3D v, double f1, double f2) {
        return new Vector3D(f1 * this.getX() + f2 * v.getX(), f1 * this.getY() + f2 * v.getY(), f1 * this.getZ() + f2 * v.getZ());
    }

    public Vector3D multiply(double f) {
        return new Vector3D(f * this.getX(), f * this.getY(), f * this.getZ());
    }

    public void multiplyMe(double f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
    }

    public Vector3D multiply(double fx, double fy, double fz) {
        return new Vector3D(fx * this.getX(), fy * this.getY(), fz * this.getZ());
    }

    public void multiplyMe(double fx, double fy, double fz) {
        this.x *= fx;
        this.y *= fy;
        this.z *= fz;
    }

    public double angle(Vector3D v) {
        double le = this.getLength() * v.getLength();
        double alpha = 0.0;
        if (le > 0.0) {
            double sca = this.dotProduct(v);
            if ((sca /= le) < 0.0) {
                sca *= -1.0;
            }
            alpha = Math.acos(sca);
        }
        return alpha;
    }

    public double anglePlane(double a, double b, double c, double d) {
        Vector3D proj = new Vector3D(this.projectionPlane(a, b, c, d));
        if (proj.getLength() > 0.0) {
            return this.angle(proj);
        }
        return 1.5707963267948966;
    }

    public double anglePlaneDegrees(double a, double b, double c, double d) {
        return Math.toDegrees(this.anglePlane(a, b, c, d));
    }

    public double angleDegrees(Vector3D v) {
        return Math.toDegrees(this.angle(v));
    }

    public double dotProduct(Vector3D V) {
        return this.getX() * V.getX() + this.getY() * V.getY() + this.getZ() * V.getZ();
    }

    public double dotProduct(Vector3D V, double resXY, double resZ) {
        return this.getX() * V.getX() * resXY * resXY + this.getY() * V.getY() * resXY * resXY + this.getZ() * V.getZ() * resZ * resZ;
    }

    public Vector3D getRandomPerpendicularVector() {
        double z;
        double y;
        double x;
        Vector3D res = new Vector3D();
        double a = this.getX();
        double b = this.getY();
        double c = this.getZ();
        if (c != 0.0) {
            x = 2.0 * Math.random() - 1.0;
            y = 2.0 * Math.random() - 1.0;
            z = (-a * x - b * y) / c;
        } else if (b != 0.0) {
            x = 1.0;
            y = -a / b;
            z = 0.0;
        } else {
            x = 0.0;
            y = 1.0;
            z = 0.0;
        }
        res.setX(x);
        res.setY(y);
        res.setZ(z);
        res.normalize();
        return res;
    }

    public Vector3D crossProduct(Vector3D V) {
        Vector3D res = new Vector3D();
        res.setCoord(this.getY() * V.getZ() - this.getZ() * V.getY(), this.getZ() * V.getX() - this.getX() * V.getZ(), this.getX() * V.getY() - this.getY() * V.getX());
        return res;
    }

    public double colinear(Vector3D other) {
        Vector3D V1 = new Vector3D(this);
        V1.normalize();
        Vector3D V2 = new Vector3D(other);
        V2.normalize();
        return V1.dotProduct(V2);
    }

    public void normalize() {
        this.computeLength(1.0, 1.0);
        if (this.length > 0.0) {
            this.setX(this.getX() / this.length);
            this.setY(this.getY() / this.length);
            this.setZ(this.getZ() / this.length);
            this.length = 1.0;
        } else {
            this.length = 0.0;
        }
    }

    public Vector3D getNormalizedVector() {
        Vector3D tmp = new Vector3D(this);
        tmp.normalize();
        return tmp;
    }

    public Vector3D getComposante(Vector3D base) {
        Vector3D cv = new Vector3D(this);
        double co = cv.dotProduct(base);
        return base.multiply(co);
    }

    public double intersection_unit_cube(double x, double y, double z, double rx, double ry, double rz) {
        double t;
        double t1 = 0.0;
        double t2 = 0.0;
        int found_t = 0;
        double prec = 1.0E-7;
        Vector3D r = new Vector3D(rx - x, ry - y, rz - z);
        if (this.getX() != 0.0) {
            t = (0.5 - r.getX()) / this.getX();
            if (Math.abs(r.getX() + t * this.getX()) - prec <= 0.5 && Math.abs(r.getY() + t * this.getY()) - prec <= 0.5 && Math.abs(r.getZ() + t * this.getZ()) - prec <= 0.5) {
                if (found_t == 0) {
                    ++found_t;
                    t1 = t;
                } else if (found_t == 1) {
                    ++found_t;
                    t2 = t;
                }
            }
            t = (-0.5 - r.getX()) / this.getX();
            if (Math.abs(r.getX() + t * this.getX()) - prec <= 0.5 && Math.abs(r.getY() + t * this.getY()) - prec <= 0.5 && Math.abs(r.getZ() + t * this.getZ()) - prec <= 0.5) {
                if (found_t == 0) {
                    ++found_t;
                    t1 = t;
                } else if (found_t == 1) {
                    ++found_t;
                    t2 = t;
                }
            }
        }
        if (this.getY() != 0.0 && found_t != 2) {
            t = (0.5 - r.getY()) / this.getY();
            if (Math.abs(r.getX() + t * this.getX()) - prec <= 0.5 && Math.abs(r.getY() + t * this.getY()) - prec <= 0.5 && Math.abs(r.getZ() + t * this.getZ()) - prec <= 0.5) {
                if (found_t == 0) {
                    ++found_t;
                    t1 = t;
                } else if (found_t == 1) {
                    ++found_t;
                    t2 = t;
                }
            }
            t = (-0.5 - r.getY()) / this.getY();
            if (Math.abs(r.getX() + t * this.getX()) - prec <= 0.5 && Math.abs(r.getY() + t * this.getY()) - prec <= 0.5 && Math.abs(r.getZ() + t * this.getZ()) - prec <= 0.5) {
                if (found_t == 0) {
                    ++found_t;
                    t1 = t;
                } else if (found_t == 1) {
                    ++found_t;
                    t2 = t;
                }
            }
        }
        if (this.getZ() != 0.0 && found_t != 2) {
            t = (0.5 - r.getZ()) / this.getZ();
            if (Math.abs(r.getX() + t * this.getX()) - prec <= 0.5 && Math.abs(r.getY() + t * this.getY()) - prec <= 0.5 && Math.abs(r.getZ() + t * this.getZ()) - prec <= 0.5) {
                if (found_t == 0) {
                    ++found_t;
                    t1 = t;
                } else if (found_t == 1) {
                    ++found_t;
                    t2 = t;
                }
            }
            t = (-0.5 - r.getZ()) / this.getZ();
            if (Math.abs(r.getX() + t * this.getX()) - prec <= 0.5 && Math.abs(r.getY() + t * this.getY()) - prec <= 0.5 && Math.abs(r.getZ() + t * this.getZ()) - prec <= 0.5) {
                if (found_t == 0) {
                    ++found_t;
                    t1 = t;
                } else if (found_t == 1) {
                    ++found_t;
                    t2 = t;
                }
            }
        }
        if (found_t == 2) {
            return Math.abs(t1 - t2);
        }
        return 0.0;
    }

    @Override
    public String toString() {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(3);
        return "(" + nf.format(this.getX()) + ", " + nf.format(this.getY()) + ", " + nf.format(this.getZ()) + ")";
    }

    @Override
    public void xmlWrite(Writer wr) {
        try {
            wr.write("<Vector3D x=\"" + this.getX() + "\" y=\"" + this.getY() + "\" z=\"" + this.getZ() + "\" />");
            wr.flush();
        }
        catch (IOException e) {
            System.out.println("error in Vector3D::xmlWrite " + e);
        }
    }
}

