/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.MHTracker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import lpsolve.LpSolve;
import lpsolve.LpSolveException;
import plugins.nchenouard.particletracking.MHTracker.Association;
import plugins.nchenouard.particletracking.MHTracker.Cluster;
import plugins.nchenouard.particletracking.MHTracker.Family;
import plugins.nchenouard.particletracking.MHTracker.GlobalHypothesis;
import plugins.nchenouard.particletracking.MHTracker.HMMMHTracker;
import plugins.nchenouard.particletracking.MHTracker.Hypothesis;

public class ClusterSolveLP
extends Cluster {
    double pFA;

    public ClusterSolveLP(HMMMHTracker tracker, int firstT, int lastT, int K, double pFA) {
        super(tracker, firstT, lastT, K);
        this.pFA = pFA;
    }

    @Override
    public void buildAndApplyBestHypTree(int t2) {
        int t = t2;
        int firstTtemp = -1;
        boolean buildAndApplyBestHyp = false;
        for (Object i : this.concurrentFamilies.keySet()) {
            if (firstTtemp >= 0 && (Integer)i >= firstTtemp) continue;
            firstTtemp = (Integer)i;
        }
        buildAndApplyBestHyp = firstTtemp >= 0 && firstTtemp <= t - this.K;
        int firstT = firstTtemp;
        if (buildAndApplyBestHyp) {
            this.println("-----build best Hyp");
            this.println("different root time for families " + this.concurrentFamilies.size());
            this.println("firstT " + firstT + " first time " + firstT + "  time " + t);
            for (Map.Entry entry : this.concurrentFamilies.entrySet()) {
                this.println("time " + (Integer)entry.getKey() + "numFamily " + ((ArrayList)entry.getValue()).size());
            }
            int currentT = firstT;
            ArrayList arrayList = (ArrayList)this.concurrentFamilies.get(new Integer(currentT));
            ArrayList<Family> mandatoryFamilies = new ArrayList<Family>();
            ArrayList<Family> optionalFamilies = new ArrayList<Family>();
            for (Family f : arrayList) {
                if (f.rootTrack == null) {
                    optionalFamilies.add(f);
                    continue;
                }
                mandatoryFamilies.add(f);
                this.println("mandatory family : begin = " + f.rootTrack.associations.getFirst().t + " root time " + f.rootTime);
            }
            this.bestHypSafe.bestHyp = this.solvePbWithLp(firstT, t);
        }
        this.applyBestHyp(t);
        for (Collection collection : this.concurrentFamilies.values()) {
            for (Family f : collection) {
                f.hypotheses.clear();
            }
        }
    }

    public GlobalHypothesis solvePbWithLp(int firstT, int t) {
        int v;
        LpSolve solver;
        ArrayList<Association> associations = new ArrayList<Association>();
        ArrayList<Iterator<Association>> mandatoryAssociations = new ArrayList<Iterator<Association>>();
        for (ArrayList flist : this.concurrentFamilies.values()) {
            for (Family f : flist) {
                if (f.rootTrack == null) continue;
                Association rootAssociation = f.rootNode.association;
                if (rootAssociation != null && !associations.contains(rootAssociation) && !mandatoryAssociations.contains(rootAssociation)) {
                    mandatoryAssociations.add((Iterator<Association>)((Object)rootAssociation));
                    continue;
                }
                System.out.println("Error: rootrack without association!");
            }
            for (Family f : flist) {
                for (Association a : f.usedAssociations) {
                    if (associations.contains(a) || mandatoryAssociations.contains(a)) continue;
                    associations.add(a);
                }
            }
        }
        ArrayList<boolean[]> tuples = new ArrayList<boolean[]>();
        ArrayList<Double> scores = new ArrayList<Double>();
        ArrayList<Hypothesis> hypList = new ArrayList<Hypothesis>();
        ArrayList<Boolean> isPredList = new ArrayList<Boolean>();
        for (ArrayList flist : this.concurrentFamilies.values()) {
            for (Family f : flist) {
                if (f.rootTrack == null && mandatoryAssociations.contains(f.rootNode.association)) continue;
                for (Hypothesis h : f.hypotheses) {
                    boolean[] detectionTab = new boolean[associations.size() + mandatoryAssociations.size()];
                    int cnt = 0;
                    for (Association association : associations) {
                        detectionTab[cnt] = h.usedAssociations.contains(association);
                        ++cnt;
                    }
                    for (Association association : mandatoryAssociations) {
                        Association rootAssociation = f.rootNode.association;
                        detectionTab[cnt] = rootAssociation != null && rootAssociation == association;
                        ++cnt;
                    }
                    tuples.add(detectionTab);
                    scores.add(new Double(h.leaf.score));
                    hypList.add(h);
                    isPredList.add(new Boolean(false));
                }
            }
        }
        for (int cnt = 0; cnt < associations.size(); ++cnt) {
            boolean[] detectionTab = new boolean[associations.size() + mandatoryAssociations.size()];
            detectionTab[cnt] = true;
            tuples.add(detectionTab);
            if (((Association)associations.get((int)cnt)).isPrediction) {
                scores.add(new Double(0.0));
                isPredList.add(new Boolean(true));
            } else {
                scores.add(new Double(Math.log(this.pFA)));
                isPredList.add(new Boolean(false));
            }
            hypList.add((Hypothesis)associations.get(cnt));
        }
        int numVariables = tuples.size();
        int numConstraints = ((boolean[])tuples.get(0)).length;
        try {
            solver = LpSolve.makeLp(0, numVariables);
        }
        catch (LpSolveException e1) {
            e1.printStackTrace();
            return null;
        }
        double[] objFn = new double[numVariables + 1];
        for (v = 0; v < numVariables; ++v) {
            objFn[v + 1] = (Double)scores.get(v);
        }
        try {
            solver.setObjFn(objFn);
        }
        catch (LpSolveException e) {
            e.printStackTrace();
            return null;
        }
        for (int n = 0; n < numConstraints; ++n) {
            double[] eq = new double[numVariables + 1];
            for (int i = 0; i < numVariables; ++i) {
                boolean b = ((boolean[])tuples.get(i))[n];
                eq[i + 1] = b ? 1.0 : 0.0;
            }
            int constrType = 3;
            double rh = 1.0;
            try {
                solver.addConstraint(eq, constrType, rh);
                continue;
            }
            catch (LpSolveException lpSolveException) {
                lpSolveException.printStackTrace();
                return null;
            }
        }
        for (v = 0; v < numVariables; ++v) {
            try {
                solver.setBinary(v + 1, true);
                continue;
            }
            catch (LpSolveException e) {
                e.printStackTrace();
                return null;
            }
        }
        solver.setMaxim();
        solver.setVerbose(1);
        try {
            solver.solve();
        }
        catch (LpSolveException e) {
            e.printStackTrace();
            return null;
        }
        GlobalHypothesis gh = new GlobalHypothesis(firstT, t, this.tracker);
        try {
            double[] sol = solver.getPtrVariables();
            if (solver.getStatus() != 0) {
                System.out.println("NON OPTIMAL");
            }
            for (int cnt = 0; cnt < sol.length; ++cnt) {
                int idx = cnt;
                if (!(sol[idx] > 0.5) || !(hypList.get(idx) instanceof Hypothesis)) continue;
                gh.addHypothesis((Hypothesis)hypList.get(idx));
            }
        }
        catch (LpSolveException e) {
            e.printStackTrace();
            return null;
        }
        gh.penalizeAllFD(this.pFA, this.realAssociations);
        solver.deleteLp();
        return gh;
    }
}

