/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.particletracking.MHTracker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Stack;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import plugins.nchenouard.particletracking.MHTracker.Association;
import plugins.nchenouard.particletracking.MHTracker.GlobalHypothesis;
import plugins.nchenouard.particletracking.MHTracker.Hypothesis;
import plugins.nchenouard.particletracking.MHTracker.IdCluster;
import plugins.nchenouard.particletracking.MHTracker.MHTrack2s;
import plugins.nchenouard.particletracking.MHTracker.ThreadCounter;
import plugins.nchenouard.particletracking.MHTracker.ValidatedTrack;

public class Family {
    MHTrack2s rootNode;
    ValidatedTrack rootTrack;
    double trackScore = 0.0;
    double rootScore = 0.0;
    HashSet<Association> usedAssociations = new HashSet();
    LinkedList<MHTrack2s> leafs = new LinkedList();
    LinkedList<Hypothesis> hypotheses = new LinkedList();
    int rootTime;
    MHTrack2s lastSelectedLeaf = null;
    IdCluster cluster = null;

    protected void recursUpdate(MHTrack2s trk) {
        trk.confirmed = true;
        this.usedAssociations.add(trk.association);
        if (trk.followingSegments.isEmpty()) {
            this.leafs.add(trk);
        } else {
            for (MHTrack2s trk2 : trk.followingSegments) {
                this.recursUpdate(trk2);
            }
        }
    }

    public void updateFamily(MHTrack2s track, ValidatedTrack validatedTrack, int leafTime) {
        this.rootNode = track;
        this.rootTrack = validatedTrack;
        this.rootTime = this.rootNode.association.t;
        this.trackScore = this.rootScore;
        this.rootScore = this.rootNode.score;
        for (MHTrack2s trk : this.leafs) {
            trk.hypothesis = null;
        }
        this.leafs.clear();
        this.usedAssociations.clear();
        this.recursUpdate(track);
    }

    Vector<Hypothesis> getCompatibleHypothesis(GlobalHypothesis gh) {
        Vector<Hypothesis> hypList = new Vector<Hypothesis>();
        if (!gh.usedAssociations.contains(this.rootNode.association)) {
            if (this.rootNode.followingSegments.size() > 0) {
                for (MHTrack2s trk : this.rootNode.followingSegments) {
                    this.recursCompatibleHypotheses(gh, trk, hypList);
                }
            } else if (this.rootNode.hypothesis != null) {
                hypList.add(this.rootNode.hypothesis);
            }
        }
        return hypList;
    }

    void recursCompatibleHypotheses(GlobalHypothesis gh, MHTrack2s node, Vector<Hypothesis> hypList) {
        if (!gh.usedAssociations.contains(node.association)) {
            if (node.followingSegments.size() > 0) {
                for (MHTrack2s trk : node.followingSegments) {
                    this.recursCompatibleHypotheses(gh, trk, hypList);
                }
            } else if (node.hypothesis != null) {
                hypList.add(node.hypothesis);
            }
        }
    }

    private boolean belowBound(GlobalHypothesis gh, double bestScore, MHTrack2s node) {
        return gh.score + node.bestScore < bestScore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Vector<Hypothesis> getCompatibleHypothesis(GlobalHypothesis gh, double bestScore) {
        ThreadCounter tc = new ThreadCounter();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        tc.reset();
        Vector<Hypothesis> hypList = new Vector<Hypothesis>();
        if (!this.belowBound(gh, bestScore, this.rootNode) && !gh.usedAssociations.contains(this.rootNode.association)) {
            if (this.rootNode.followingSegments.size() > 0) {
                for (MHTrack2s trk : this.rootNode.followingSegments) {
                    tc.increaseCount();
                    executor.execute(new RecursCompatibleThr(gh, bestScore, trk, hypList, tc, executor));
                }
            } else if (this.rootNode.hypothesis != null) {
                hypList.add(this.rootNode.hypothesis);
            }
        }
        tc.lock.lock();
        try {
            while (tc.cntThreads != 0) {
                tc.countAndDeathEquality.await();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            tc.lock.unlock();
        }
        executor.shutdown();
        return hypList;
    }

    ArrayList<Hypothesis> getCompatibleHypothesisSingleThread(GlobalHypothesis gh, double bestScore) {
        ArrayList<Hypothesis> hypList = new ArrayList<Hypothesis>();
        Stack<MHTrack2s> waitingTracks = new Stack<MHTrack2s>();
        if (!this.belowBound(gh, bestScore, this.rootNode) && !gh.usedAssociations.contains(this.rootNode.association)) {
            if (this.rootNode.followingSegments.size() > 0) {
                waitingTracks.addAll(this.rootNode.followingSegments);
            } else if (this.rootNode.hypothesis != null) {
                hypList.add(this.rootNode.hypothesis);
            }
        }
        while (!waitingTracks.isEmpty()) {
            this.recursCompatibleHypotheses(gh, bestScore, (MHTrack2s)waitingTracks.pop(), hypList, waitingTracks);
        }
        Collections.sort(hypList, new HypothesisComparator());
        return hypList;
    }

    void getCompatibleHypothesisSingleThread(GlobalHypothesis gh, double bestScore, ArrayList<Hypothesis> hypList, Stack<MHTrack2s> waitingTracks) {
        if (!this.belowBound(gh, bestScore, this.rootNode) && !gh.usedAssociations.contains(this.rootNode.association)) {
            if (this.rootNode.followingSegments.size() > 0) {
                waitingTracks.addAll(this.rootNode.followingSegments);
            } else if (this.rootNode.hypothesis != null) {
                hypList.add(this.rootNode.hypothesis);
            }
        }
        while (!waitingTracks.isEmpty()) {
            this.recursCompatibleHypotheses(gh, bestScore, waitingTracks.pop(), hypList, waitingTracks);
        }
        Collections.sort(hypList, new HypothesisComparator());
    }

    void recursCompatibleHypotheses(GlobalHypothesis gh, double bestScore, MHTrack2s node, Vector<Hypothesis> hypList, ThreadCounter tc, ExecutorService executor) {
        if (!this.belowBound(gh, bestScore, this.rootNode) && !gh.usedAssociations.contains(node.association)) {
            if (node.followingSegments.size() > 0) {
                for (MHTrack2s trk : node.followingSegments) {
                    tc.increaseCount();
                    executor.execute(new RecursCompatibleThr(gh, bestScore, trk, hypList, tc, executor));
                }
            } else if (node.hypothesis != null) {
                hypList.add(node.hypothesis);
            }
        }
    }

    void recursCompatibleHypotheses(GlobalHypothesis gh, double bestScore, MHTrack2s node, ArrayList<Hypothesis> hypList, Stack<MHTrack2s> taskList) {
        if (!this.belowBound(gh, bestScore, this.rootNode) && !gh.usedAssociations.contains(node.association)) {
            if (node.followingSegments.size() > 0) {
                for (MHTrack2s trk : node.followingSegments) {
                    taskList.add(trk);
                }
            } else if (node.hypothesis != null) {
                hypList.add(node.hypothesis);
            }
        }
    }

    public void buildHypothesesAndResetBestScores() {
        ArrayList<Association> measurementsList = new ArrayList<Association>();
        measurementsList.add(this.rootNode.association);
        this.rootNode.resetBestScore();
        Hypothesis h = new Hypothesis(measurementsList, this.rootNode);
        if (this.rootNode.followingSegments.isEmpty()) {
            if (this.rootNode.confirmed) {
                this.hypotheses.add(h);
                this.rootNode.hypothesis = h;
            }
        } else {
            this.recursBuildHyp(h, this.hypotheses);
        }
        this.usedAssociations.clear();
        for (Hypothesis hyp : this.hypotheses) {
            this.usedAssociations.addAll(hyp.usedAssociations);
        }
        this.correctHypothesesScore();
        this.putScoresOnNodes();
    }

    private void correctHypothesesScore() {
        for (Hypothesis hyp : this.hypotheses) {
            double bnf = 0.0;
            for (Association a : hyp.usedAssociations) {
                bnf += a.getBestScore();
            }
            hyp.leaf.bestScore = hyp.leaf.score - bnf - this.rootScore;
        }
    }

    private void putScoresOnNodes() {
        for (Hypothesis h : this.hypotheses) {
            this.recursPutScoresOnNodes(h.leaf);
        }
    }

    private void recursPutScoresOnNodes(MHTrack2s node) {
        if (node.precedingSegment != null && node.precedingSegment.bestScore < node.bestScore) {
            node.precedingSegment.bestScore = node.bestScore;
            this.recursPutScoresOnNodes(node.precedingSegment);
        }
    }

    protected void recursBuildHyp(Hypothesis h, LinkedList<Hypothesis> hList) {
        for (MHTrack2s nextTrk : h.leaf.followingSegments) {
            nextTrk.resetBestScore();
            ArrayList<Association> associationList = new ArrayList<Association>(h.usedAssociations);
            associationList.add(nextTrk.association);
            Hypothesis nextH = new Hypothesis(associationList, nextTrk);
            if (nextTrk.followingSegments.isEmpty()) {
                if (!nextTrk.confirmed) continue;
                hList.add(nextH);
                nextTrk.hypothesis = nextH;
                continue;
            }
            this.recursBuildHyp(nextH, hList);
        }
    }

    protected void printHypotheses() {
    }

    class HypothesisComparator
    implements Comparator<Hypothesis> {
        HypothesisComparator() {
        }

        @Override
        public int compare(Hypothesis o1, Hypothesis o2) {
            if (o1.leaf.score > o2.leaf.score) {
                return 1;
            }
            if (o1.leaf.score < o2.leaf.score) {
                return -1;
            }
            return 0;
        }
    }

    class RecursCompatibleThr
    implements Runnable {
        ThreadCounter tc;
        ExecutorService executor;
        GlobalHypothesis gh;
        MHTrack2s trk;
        Vector<Hypothesis> hypList;
        double bestScore;

        public RecursCompatibleThr(GlobalHypothesis gh, double bestScore, MHTrack2s trk, Vector<Hypothesis> hypList, ThreadCounter tc, ExecutorService executor) {
            this.tc = tc;
            this.gh = gh;
            this.trk = trk;
            this.hypList = hypList;
            this.bestScore = bestScore;
            this.executor = executor;
        }

        @Override
        public void run() {
            Family.this.recursCompatibleHypotheses(this.gh, this.bestScore, this.trk, this.hypList, this.tc, this.executor);
            this.tc.increaseDeath();
        }
    }
}

