/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.roiintensityevolution;

import icy.main.Icy;
import icy.swimmingPool.SwimmingObject;
import icy.swimmingPool.SwimmingPoolEvent;
import icy.swimmingPool.SwimmingPoolListener;
import icy.util.StringUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;

public class SwimmingObjectBox<T>
extends JComboBox
implements SwimmingPoolListener {
    private static final long serialVersionUID = 1594001236878708868L;
    private final Class<T> itemClass;
    private ArrayList<SwimmingObjectListener<T>> listeners;

    public SwimmingObjectBox(Class<T> itemClass) {
        this(itemClass, 50, "No valid object to display in SwimmingPool");
    }

    public SwimmingObjectBox(Class<T> itemClass, final int maxSize, final String defaultMessage) {
        this.itemClass = itemClass;
        this.listeners = new ArrayList();
        Icy.getMainInterface().getSwimmingPool().addListener((SwimmingPoolListener)this);
        this.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value == null) {
                    return new JLabel(defaultMessage);
                }
                if (value instanceof SwimmingObject) {
                    JLabel label = new JLabel(StringUtil.limit((String)((SwimmingObject)value).getName(), (int)maxSize));
                    label.setToolTipText(((SwimmingObject)value).getName());
                    return label;
                }
                return new JLabel(value.toString());
            }
        });
    }

    public T getSelectedObject() {
        Object o = this.getSelectedItem();
        if (o != null && o instanceof SwimmingObject) {
            Object oo = ((SwimmingObject)o).getObject();
            if (oo.getClass() == this.itemClass) {
                return this.itemClass.cast(oo);
            }
            return null;
        }
        return null;
    }

    public void swimmingPoolChangeEvent(final SwimmingPoolEvent event) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwimmingObjectBox.this.refreshList();
                if (event.getResult().getObject().getClass() == SwimmingObjectBox.this.itemClass) {
                    SwimmingObjectBox.this.setSelectedItem(event.getResult().getObject());
                }
            }
        });
    }

    void refreshList() {
        Object oldSelected = this.getSelectedItem();
        this.setModel(new DefaultComboBoxModel<SwimmingObject>(this.getSwimmingObjectList()));
        this.setSelectedItem(oldSelected);
    }

    Vector<SwimmingObject> getSwimmingObjectList() {
        Vector<SwimmingObject> objectList = new Vector<SwimmingObject>();
        ArrayList objects = Icy.getMainInterface().getSwimmingPool().getObjects();
        for (SwimmingObject so : objects) {
            Object o = so.getObject();
            if (o.getClass() != this.itemClass) continue;
            objectList.add(so);
        }
        return objectList;
    }

    public void addListener(SwimmingObjectListener<T> listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(SwimmingObjectListener<T> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void fireItemStateChanged(ItemEvent e) {
        for (SwimmingObjectListener<T> listener : this.listeners) {
            listener.swimmingObjectChanged(this.getSelectedObject());
        }
        super.fireItemStateChanged(e);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (SwimmingObjectListener<T> listener : this.listeners) {
            listener.swimmingObjectChanged(this.getSelectedObject());
        }
        super.actionPerformed(e);
    }

    public static interface SwimmingObjectListener<T> {
        public void swimmingObjectChanged(T var1);
    }
}

