/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations;

import icy.sequence.DimensionId;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import plugins.ylemontag.mathoperations.FormattedTextField;

public class DimensionsPickerComponent
extends JPanel {
    private static final long serialVersionUID = 1L;
    private DimensionId _dimension;
    private List<ValueListener> _listeners;
    private boolean _shuntListeners;
    private JRadioButton _buttonAll;
    private JRadioButton _buttonSelection;
    private ButtonGroup _buttonGroup;
    private boolean _allSelected;
    private IntegerArrayTextField _indexField;

    public DimensionsPickerComponent() {
        this(DimensionId.NULL);
    }

    public DimensionsPickerComponent(DimensionId dimension) {
        super(new BorderLayout(5, 5));
        this._dimension = dimension;
        this._listeners = new LinkedList<ValueListener>();
        this._shuntListeners = false;
        this._allSelected = true;
        this._buttonAll = new JRadioButton(this.makeButtonAllLabel(), true);
        this._buttonSelection = new JRadioButton("Selection");
        this._buttonGroup = new ButtonGroup();
        this._buttonGroup.add(this._buttonAll);
        this._buttonGroup.add(this._buttonSelection);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(this._buttonAll);
        buttonPanel.add(Box.createHorizontalStrut(5));
        buttonPanel.add(this._buttonSelection);
        buttonPanel.add(Box.createHorizontalGlue());
        this.add((Component)buttonPanel, "North");
        this._buttonAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DimensionsPickerComponent.this._shuntListeners) {
                    return;
                }
                DimensionsPickerComponent.this.onButtonClicked(true);
            }
        });
        this._buttonSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DimensionsPickerComponent.this._shuntListeners) {
                    return;
                }
                DimensionsPickerComponent.this.onButtonClicked(false);
            }
        });
        this._indexField = new IntegerArrayTextField();
        this.add((Component)this._indexField, "Center");
        this._indexField.setEnabled(false);
        this._indexField.addValueListener(new FormattedTextField.ValueListener<int[]>(){

            @Override
            public void valueChanged(int[] newValue) {
                if (DimensionsPickerComponent.this._shuntListeners) {
                    return;
                }
                DimensionsPickerComponent.this.onIndexFieldChanged();
            }
        });
    }

    public void addValueListener(ValueListener l) {
        this._listeners.add(l);
    }

    public void removeValueListener(ValueListener l) {
        this._listeners.remove(l);
    }

    public boolean isValueValid() {
        return this._allSelected || this._indexField.getValue() != null;
    }

    public int[] getValue() {
        return this._allSelected ? null : (int[])this._indexField.getValue();
    }

    public void setValue(int[] value) {
        boolean wasValid = this.isValueValid();
        int[] oldValue = this.getValue();
        this._shuntListeners = true;
        if (value == null) {
            this._allSelected = true;
            this._buttonAll.setSelected(true);
            this._indexField.setEnabled(false);
            if (this._indexField.getValue() == null) {
                this._indexField.setValue(new int[0]);
            }
        } else {
            this._allSelected = false;
            this._buttonSelection.setSelected(true);
            this._indexField.setEnabled(true);
            this._indexField.setValue(value);
        }
        this._shuntListeners = false;
        if (!wasValid || !DimensionsPickerComponent.areIdenticIntegerArray(oldValue, value)) {
            this.fireValueListeners();
        }
    }

    private void onButtonClicked(boolean allButtonClicked) {
        if (allButtonClicked == this._allSelected) {
            return;
        }
        this._indexField.setEnabled(!allButtonClicked);
        this._allSelected = allButtonClicked;
        this.fireValueListeners();
    }

    private void onIndexFieldChanged() {
        if (this._allSelected) {
            return;
        }
        this.fireValueListeners();
    }

    private void fireValueListeners() {
        boolean valid = this.isValueValid();
        int[] newValue = this.getValue();
        for (ValueListener l : this._listeners) {
            l.valueChanged(valid, newValue);
        }
    }

    private String makeButtonAllLabel() {
        if (this._dimension == null || this._dimension == DimensionId.NULL) {
            return "All";
        }
        switch (this._dimension) {
            case X: {
                return "All columns";
            }
            case Y: {
                return "All rows";
            }
            case Z: {
                return "All slices";
            }
            case T: {
                return "All frames";
            }
            case C: {
                return "All channels";
            }
        }
        throw new RuntimeException("Unreachable code point");
    }

    private String makeNoSelectionText() {
        if (this._dimension == null || this._dimension == DimensionId.NULL) {
            return "Nothing";
        }
        switch (this._dimension) {
            case X: {
                return "No column";
            }
            case Y: {
                return "No row";
            }
            case Z: {
                return "No slice";
            }
            case T: {
                return "No frame";
            }
            case C: {
                return "No channel";
            }
        }
        throw new RuntimeException("Unreachable code point");
    }

    private static boolean areIdenticIntegerArray(int[] obj1, int[] obj2) {
        if (obj1 == null || obj2 == null) {
            return obj1 == obj2;
        }
        int lg = obj1.length;
        if (obj2.length != lg) {
            return false;
        }
        for (int k = 0; k < lg; ++k) {
            if (obj1[k] == obj2[k]) continue;
            return false;
        }
        return true;
    }

    private class IntegerArrayTextField
    extends FormattedTextField<int[]> {
        private static final long serialVersionUID = 1L;

        public IntegerArrayTextField() {
            this.initializeComponent();
        }

        @Override
        protected String makeHelpText() {
            return DimensionsPickerComponent.this.makeNoSelectionText();
        }

        @Override
        protected int[] stringToObject(String text) {
            try {
                text = text.trim();
                if (text.isEmpty()) {
                    return new int[0];
                }
                String[] rawValues = text.split(" +");
                int[] retVal = new int[rawValues.length];
                for (int k = 0; k < retVal.length; ++k) {
                    retVal[k] = Integer.parseInt(rawValues[k]);
                }
                return retVal;
            }
            catch (NumberFormatException err) {
                return null;
            }
        }

        @Override
        protected String objectToString(int[] object) {
            if (object == null) {
                return "[invalid]";
            }
            String retVal = "";
            for (int k = 0; k < object.length; ++k) {
                if (k > 0) {
                    retVal = retVal + " ";
                }
                retVal = retVal + object[k];
            }
            return retVal;
        }

        @Override
        protected boolean areIdenticObjects(int[] obj1, int[] obj2) {
            return DimensionsPickerComponent.areIdenticIntegerArray(obj1, obj2);
        }
    }

    public static interface ValueListener {
        public void valueChanged(boolean var1, int[] var2);
    }
}

