/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations.variants;

import plugins.ylemontag.mathoperations.Variant;
import plugins.ylemontag.mathoperations.variants.VariantSequence;

public class DimensionSequence
extends Variant.Dimension {
    private int _sizeX;
    private int _sizeY;
    private int _sizeZ;
    private int _sizeT;
    private int _sizeC;

    public DimensionSequence(int sizeX, int sizeY, int sizeZ, int sizeT, int sizeC) {
        super(Variant.DimensionType.SEQUENCE);
        this._sizeX = sizeX;
        this._sizeY = sizeY;
        this._sizeZ = sizeZ;
        this._sizeT = sizeT;
        this._sizeC = sizeC;
    }

    public int getSizeX() {
        return this._sizeX;
    }

    public int getSizeY() {
        return this._sizeY;
    }

    public int getSizeZ() {
        return this._sizeZ;
    }

    public int getSizeT() {
        return this._sizeT;
    }

    public int getSizeC() {
        return this._sizeC;
    }

    @Override
    public boolean equals(Variant.Dimension dimension) {
        if (!(dimension instanceof DimensionSequence)) {
            return false;
        }
        DimensionSequence dim = (DimensionSequence)dimension;
        return this._sizeX == dim._sizeX && this._sizeY == dim._sizeY && this._sizeZ == dim._sizeZ && this._sizeT == dim._sizeT && this._sizeC == dim._sizeC;
    }

    @Override
    public String getRepresentation() {
        return String.format("sequence of size (X,Y,Z,T,C)=(%d,%d,%d,%d,%d)", this._sizeX, this._sizeY, this._sizeZ, this._sizeT, this._sizeC);
    }

    @Override
    public long getFlatSize() {
        long result = this._sizeX;
        result *= (long)this._sizeY;
        result *= (long)this._sizeZ;
        result *= (long)this._sizeT;
        return result *= (long)this._sizeC;
    }

    @Override
    public int getGranularity() {
        return this._sizeX * this._sizeY;
    }

    @Override
    public Variant allocateNewVariant() {
        return new VariantSequence(this._sizeX, this._sizeY, this._sizeZ, this._sizeT, this._sizeC);
    }
}

