/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.plugin;

import icy.gui.frame.error.ErrorReportFrame;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.frame.progress.CancelableProgressFrame;
import icy.gui.frame.progress.ProgressFrame;
import icy.main.Icy;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginInstaller;
import icy.plugin.PluginRepositoryLoader;
import icy.plugin.PluginUpdater;
import icy.system.IcyExceptionHandler;
import icy.system.thread.ThreadUtil;
import icy.util.StringUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;

public class PluginErrorReport {
    public static void report(final PluginDescriptor plugin, final String devId, final String title, final String message) {
        if (Icy.getMainInterface().isHeadLess()) {
            return;
        }
        if (ErrorReportFrame.hasErrorFrameOpened()) {
            return;
        }
        ThreadUtil.bgRun(new Runnable(){

            @Override
            public void run() {
                if (plugin != null) {
                    CancelableProgressFrame info = new CancelableProgressFrame("Plugin '" + plugin.getName() + "' has crashed, searching for update...");
                    PluginRepositoryLoader.waitLoaded();
                    PluginDescriptor onlinePlugin = null;
                    try {
                        if (!info.isCancelRequested()) {
                            onlinePlugin = PluginUpdater.getUpdate(plugin);
                        }
                    }
                    finally {
                        info.close();
                    }
                    if (!info.isCancelRequested() && onlinePlugin != null) {
                        PluginInstaller.install(onlinePlugin, true);
                        new AnnounceFrame("The plugin crashed but a new version has been found, try it again when installation is done", 10);
                        return;
                    }
                    ThreadUtil.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PluginErrorReport.doReport(plugin, null, title, message);
                        }
                    });
                } else {
                    ThreadUtil.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PluginErrorReport.doReport(null, devId, title, message);
                        }
                    });
                }
            }
        });
    }

    public static void report(PluginDescriptor plugin, String devId, String message) {
        PluginErrorReport.report(plugin, devId, null, message);
    }

    public static void report(PluginDescriptor plugin, String message) {
        PluginErrorReport.report(plugin, null, null, message);
    }

    static void doReport(final PluginDescriptor plugin, final String devId, String title, String message) {
        ImageIcon icon;
        String str;
        if (Icy.getMainInterface().isHeadLess()) {
            return;
        }
        if (plugin != null) {
            str = "<html><br>The plugin named <b>" + plugin.getName() + "</b> has encountered a problem";
            icon = plugin.getIcon();
        } else if (!StringUtil.isEmpty(devId)) {
            str = "<html><br>The plugin from the developer <b>" + devId + "</b> has encountered a problem";
            icon = null;
        } else {
            str = "<html><br>The application has encountered a problem";
            icon = null;
        }
        str = StringUtil.isEmpty(title) ? String.valueOf(str) + ".<br><br>" : String.valueOf(str) + " :<br><i>" + title + "</i><br><br>";
        str = String.valueOf(str) + "Reporting this problem is anonymous and will help improving this plugin.<br><br></html>";
        final ErrorReportFrame frame = new ErrorReportFrame(icon, str, message);
        frame.setReportAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try (ProgressFrame progressFrame = new ProgressFrame("Sending report...");){
                    try {
                        IcyExceptionHandler.report(plugin, devId, frame.getReportMessage());
                    }
                    catch (BadLocationException ex) {
                        System.err.println("Error while reporting error :");
                        IcyExceptionHandler.showErrorMessage(ex, true);
                        progressFrame.close();
                    }
                }
            }
        });
    }
}

