/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.sequence.tools;

import icy.gui.component.sequence.SequencePreviewPanel;
import icy.sequence.DimensionId;
import icy.sequence.Sequence;
import icy.sequence.SequenceModel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SequenceDimensionExtendPanel
extends JPanel {
    private static final long serialVersionUID = -5908902915282090447L;
    protected SequencePreviewPanel sequencePreview;
    private JLabel lblInsertPosition;
    JSpinner insertPositionSpinner;
    private JLabel lblNewZSize;
    private JSpinner newSizeSpinner;
    private JLabel lblImages;
    JSpinner duplicateSpinner;
    JCheckBox duplicateCheckBox;
    protected final DimensionId dim;

    public SequenceDimensionExtendPanel(DimensionId dim) {
        if (dim != DimensionId.Z && dim != DimensionId.T) {
            throw new IllegalArgumentException("Only Z or T dimension allowed");
        }
        this.dim = dim;
        this.initialize();
        this.newSizeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SequenceDimensionExtendPanel.this.previewDimensionChanged();
                SequenceDimensionExtendPanel.this.fireChangedEvent();
            }
        });
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SequenceDimensionExtendPanel.this.previewImageChanged();
                SequenceDimensionExtendPanel.this.fireChangedEvent();
            }
        };
        this.insertPositionSpinner.addChangeListener(changeListener);
        this.duplicateSpinner.addChangeListener(changeListener);
        this.duplicateCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceDimensionExtendPanel.this.duplicateSpinner.setEnabled(SequenceDimensionExtendPanel.this.duplicateCheckBox.isSelected());
                SequenceDimensionExtendPanel.this.previewImageChanged();
                SequenceDimensionExtendPanel.this.fireChangedEvent();
            }
        });
        this.refreshButtonsState();
    }

    private void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        int[] nArray = new int[7];
        nArray[0] = 20;
        nArray[2] = 20;
        gridBagLayout.columnWidths = nArray;
        int[] nArray2 = new int[5];
        nArray2[3] = 174;
        gridBagLayout.rowHeights = nArray2;
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.lblNewZSize = new JLabel("New size");
        this.lblNewZSize.setToolTipText("New dimension size");
        this.lblNewZSize.setHorizontalAlignment(11);
        GridBagConstraints gbc_lblNewZSize = new GridBagConstraints();
        gbc_lblNewZSize.fill = 1;
        gbc_lblNewZSize.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewZSize.gridx = 1;
        gbc_lblNewZSize.gridy = 0;
        this.add((Component)this.lblNewZSize, gbc_lblNewZSize);
        this.newSizeSpinner = new JSpinner();
        this.newSizeSpinner.setToolTipText("Enter new size");
        this.newSizeSpinner.setModel(new SpinnerNumberModel(0, 0, 99999, 1));
        GridBagConstraints gbc_newSizeSpinner = new GridBagConstraints();
        gbc_newSizeSpinner.fill = 1;
        gbc_newSizeSpinner.insets = new Insets(0, 0, 5, 5);
        gbc_newSizeSpinner.gridx = 3;
        gbc_newSizeSpinner.gridy = 0;
        this.add((Component)this.newSizeSpinner, gbc_newSizeSpinner);
        this.lblInsertPosition = new JLabel("Insert position");
        this.lblInsertPosition.setToolTipText("Index where to add the new image(s)");
        this.lblInsertPosition.setHorizontalAlignment(11);
        GridBagConstraints gbc_lblInsertPosition = new GridBagConstraints();
        gbc_lblInsertPosition.fill = 1;
        gbc_lblInsertPosition.insets = new Insets(0, 0, 5, 5);
        gbc_lblInsertPosition.gridx = 1;
        gbc_lblInsertPosition.gridy = 1;
        this.add((Component)this.lblInsertPosition, gbc_lblInsertPosition);
        this.insertPositionSpinner = new JSpinner();
        this.insertPositionSpinner.setToolTipText("Index where to add the new image(s)");
        this.insertPositionSpinner.setModel(new SpinnerNumberModel(0, 0, 99999, 1));
        GridBagConstraints gbc_insertPositionSpinner = new GridBagConstraints();
        gbc_insertPositionSpinner.fill = 1;
        gbc_insertPositionSpinner.insets = new Insets(0, 0, 5, 5);
        gbc_insertPositionSpinner.gridx = 3;
        gbc_insertPositionSpinner.gridy = 1;
        this.add((Component)this.insertPositionSpinner, gbc_insertPositionSpinner);
        this.duplicateCheckBox = new JCheckBox("Duplicate last");
        this.duplicateCheckBox.setToolTipText("Duplicate last images in new images");
        GridBagConstraints gbc_duplicateCheckBox = new GridBagConstraints();
        gbc_duplicateCheckBox.fill = 1;
        gbc_duplicateCheckBox.insets = new Insets(0, 0, 5, 5);
        gbc_duplicateCheckBox.gridx = 1;
        gbc_duplicateCheckBox.gridy = 2;
        this.add((Component)this.duplicateCheckBox, gbc_duplicateCheckBox);
        this.duplicateSpinner = new JSpinner();
        this.duplicateSpinner.setToolTipText("Number of last images to duplicate");
        this.duplicateSpinner.setEnabled(false);
        this.duplicateSpinner.setModel(new SpinnerNumberModel(1, 1, 99999, 1));
        GridBagConstraints gbc_duplicateSpinner = new GridBagConstraints();
        gbc_duplicateSpinner.fill = 1;
        gbc_duplicateSpinner.insets = new Insets(0, 0, 5, 5);
        gbc_duplicateSpinner.gridx = 3;
        gbc_duplicateSpinner.gridy = 2;
        this.add((Component)this.duplicateSpinner, gbc_duplicateSpinner);
        this.lblImages = new JLabel("image(s)");
        GridBagConstraints gbc_lblImages = new GridBagConstraints();
        gbc_lblImages.gridwidth = 2;
        gbc_lblImages.fill = 1;
        gbc_lblImages.insets = new Insets(0, 0, 5, 0);
        gbc_lblImages.gridx = 4;
        gbc_lblImages.gridy = 2;
        this.add((Component)this.lblImages, gbc_lblImages);
        this.sequencePreview = new SequencePreviewPanel();
        this.sequencePreview.setBorder(new TitledBorder(null, "Preview", 4, 2, null, null));
        GridBagConstraints gbc_sequencePreview = new GridBagConstraints();
        gbc_sequencePreview.gridwidth = 6;
        gbc_sequencePreview.fill = 1;
        gbc_sequencePreview.gridx = 0;
        gbc_sequencePreview.gridy = 3;
        this.add((Component)this.sequencePreview, gbc_sequencePreview);
    }

    public DimensionId getDimensionId() {
        return this.dim;
    }

    void refreshButtonsState() {
    }

    public SequenceModel getModel() {
        return this.sequencePreview.getModel();
    }

    public void setModel(SequenceModel model) {
        this.sequencePreview.setModel(model);
    }

    public void previewDimensionChanged() {
        this.sequencePreview.dimensionChanged();
    }

    public void previewImageChanged() {
        this.sequencePreview.imageChanged();
    }

    public int getNewSize() {
        return (Integer)this.newSizeSpinner.getValue();
    }

    public int getInsertPosition() {
        return (Integer)this.insertPositionSpinner.getValue();
    }

    public int getDuplicateNumber() {
        if (!this.duplicateCheckBox.isSelected()) {
            return 0;
        }
        return (Integer)this.duplicateSpinner.getValue();
    }

    public void setNewSize(int size) {
        this.newSizeSpinner.setModel(new SpinnerNumberModel(size, size, 99999, 1));
        this.insertPositionSpinner.setModel(new SpinnerNumberModel(size, 0, size, 1));
    }

    public void setInsertPosition(int position) {
        this.insertPositionSpinner.setValue(position);
    }

    public void setMaxDuplicate(int max) {
        this.duplicateSpinner.setModel(new SpinnerNumberModel(1, 1, Math.max(max, 1), 1));
    }

    protected void fireChangedEvent() {
        ChangeEvent event = new ChangeEvent(this);
        ChangeListener[] changeListenerArray = (ChangeListener[])this.getListeners(ChangeListener.class);
        int n = changeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeListener listener = changeListenerArray[n2];
            listener.stateChanged(event);
            ++n2;
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    static class SequenceChannelEntry {
        final Sequence sequence;
        final int c;

        public SequenceChannelEntry(Sequence sequence, int c) {
            this.sequence = sequence;
            this.c = c;
        }

        public SequenceChannelEntry(Sequence sequence) {
            this(sequence, -1);
        }

        public String toString() {
            if (this.c == -1) {
                return this.sequence.toString();
            }
            return String.valueOf(this.sequence.toString()) + "    [channel " + this.c + "]";
        }
    }
}

