/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.util;

import icy.gui.frame.IcyFrame;
import icy.gui.frame.IcyFrameAdapter;
import icy.gui.frame.IcyFrameEvent;
import icy.gui.frame.TitledFrame;
import icy.gui.util.ComponentUtil;
import icy.gui.util.SwingUtil;
import icy.util.GraphicsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class GuiUtil {
    public static JPanel createLoweredPanel(Component comp) {
        JPanel result = new JPanel();
        result.setBorder(BorderFactory.createLoweredBevelBorder());
        if (comp != null) {
            result.setLayout(new BorderLayout());
            result.add(comp, "Center");
        }
        result.validate();
        return result;
    }

    public static JPanel createRaisedPanel(Component comp) {
        JPanel result = new JPanel();
        result.setBorder(BorderFactory.createRaisedBevelBorder());
        if (comp != null) {
            result.setLayout(new BorderLayout());
            result.add(comp, "Center");
        }
        result.validate();
        return result;
    }

    public static JLabel createBoldLabel(String text) {
        JLabel label = new JLabel(text);
        ComponentUtil.setFontBold(label);
        return label;
    }

    public static JLabel createBigBoldLabel(String text, int incSize) {
        JLabel label = GuiUtil.createBoldLabel(text);
        ComponentUtil.increaseFontSize(label, incSize);
        return label;
    }

    public static JPanel createCenteredLabel(String text) {
        return GuiUtil.createCenteredLabel(new JLabel(text));
    }

    public static JPanel createCenteredLabel(JLabel label) {
        return GuiUtil.createLineBoxPanel(Box.createHorizontalGlue(), label, Box.createHorizontalGlue());
    }

    public static JPanel createCenteredBoldLabel(String text) {
        return GuiUtil.createCenteredLabel(GuiUtil.createBoldLabel(text));
    }

    public static JLabel createFixedWidthLabel(String text, int w) {
        JLabel result = new JLabel(text);
        ComponentUtil.setFixedWidth(result, w);
        return result;
    }

    public static JLabel createFixedWidthBoldLabel(String text, int w) {
        JLabel result = GuiUtil.createBoldLabel(text);
        ComponentUtil.setFixedWidth(result, w);
        return result;
    }

    public static JLabel createFixedWidthRightAlignedLabel(String text, int w) {
        JLabel result = new JLabel(text);
        ComponentUtil.setFixedWidth(result, w);
        result.setHorizontalAlignment(4);
        return result;
    }

    public static JPanel createTabLabel(String text, int width) {
        return GuiUtil.createTabLabel(new JLabel(text), width);
    }

    public static JPanel createTabLabel(JLabel label, int width) {
        label.setVerticalTextPosition(1);
        label.setHorizontalTextPosition(10);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        if (width > 0) {
            panel.add(Box.createHorizontalStrut(width));
        }
        panel.add(label);
        panel.add(Box.createHorizontalGlue());
        panel.validate();
        return panel;
    }

    public static JPanel createTabBoldLabel(String text, int width) {
        return GuiUtil.createTabLabel(GuiUtil.createBoldLabel(text), width);
    }

    public static JPanel createTabArea(String text, int width) {
        return GuiUtil.createTabArea(new JTextArea(text), width);
    }

    public static JPanel createTabArea(JTextArea area, int width) {
        area.setEditable(false);
        area.setOpaque(false);
        area.setLineWrap(true);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        if (width > 0) {
            panel.add(Box.createHorizontalStrut(width));
        }
        panel.add(area);
        panel.validate();
        return panel;
    }

    public static JPanel createTabArea(String text, int width, int height) {
        return GuiUtil.createTabArea(new JTextArea(text), width, height);
    }

    public static JPanel createTabArea(JTextArea area, int width, int height) {
        area.setEditable(false);
        area.setOpaque(false);
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        JScrollPane scrollArea = new JScrollPane(area);
        scrollArea.setPreferredSize(new Dimension(320, height));
        scrollArea.setBorder(null);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        if (width > 0) {
            panel.add(Box.createHorizontalStrut(width));
        }
        panel.add(scrollArea);
        panel.validate();
        return panel;
    }

    public static JPanel createLineBoxPanel(Component ... componentArray) {
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 2));
        Component[] componentArray2 = componentArray;
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray2[n2];
            result.add(c);
            ++n2;
        }
        result.validate();
        return result;
    }

    public static JPanel createPageBoxPanel(Component ... componentArray) {
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 3));
        Component[] componentArray2 = componentArray;
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray2[n2];
            result.add(c);
            ++n2;
        }
        result.validate();
        return result;
    }

    public static JPanel besidesPanel(Component jc1, Component jc2, int widthOfSecondComponent) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add(jc1, "Center");
        panel.add(jc2, "East");
        jc2.setPreferredSize(new Dimension(widthOfSecondComponent, jc2.getPreferredSize().height));
        panel.validate();
        return panel;
    }

    public static JPanel besidesPanel(Component ... componentArray) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, componentArray.length));
        int i = 0;
        while (i < componentArray.length) {
            panel.add(componentArray[i]);
            ++i;
        }
        panel.validate();
        return panel;
    }

    public static JPanel generatePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return panel;
    }

    public static JPanel generatePanel(String string) {
        JPanel panel = GuiUtil.generatePanel();
        panel.setBorder(new TitledBorder(string));
        panel.setLayout(new BoxLayout(panel, 3));
        return panel;
    }

    public static JPanel generatePanelWithoutBorder() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        return panel;
    }

    @Deprecated
    public static void setEnableContainer(Container container, boolean enable) {
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof Container) {
                GuiUtil.setEnableContainer((Container)c, enable);
            }
            c.setEnabled(enable);
            ++n2;
        }
    }

    public static TitledFrame generateTitleFrame(String title, JPanel panel, Dimension titleDimension, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable) {
        Dimension dim = titleDimension == null ? new Dimension(400, 70) : titleDimension;
        TitledFrame result = new TitledFrame(title, dim, resizable, closable, maximizable, iconifiable);
        result.getMainPanel().add(panel);
        result.setVisible(true);
        return result;
    }

    public static IcyFrame createIcyFrameFromWindow(final Window window) {
        JMenuBar menuBar;
        Component content;
        String title;
        if (window instanceof Frame) {
            Frame f = (Frame)window;
            title = f.getTitle();
            if (f instanceof JFrame) {
                content = ((JFrame)f).getContentPane();
                menuBar = ((JFrame)f).getJMenuBar();
            } else {
                content = f.getComponent(0);
                menuBar = SwingUtil.getJMenuBar(f.getMenuBar(), false);
            }
        } else if (window instanceof Dialog) {
            Dialog d = (Dialog)window;
            title = d.getTitle();
            if (d instanceof JDialog) {
                content = ((JDialog)d).getContentPane();
                menuBar = ((JDialog)d).getJMenuBar();
            } else {
                content = d.getComponent(0);
                menuBar = null;
            }
        } else {
            title = window.getName();
            content = window.getComponent(0);
            menuBar = null;
        }
        final IcyFrame frame = new IcyFrame(title, true, true, false, false);
        frame.setLayout(new BorderLayout());
        frame.add(content, "Center");
        frame.setJMenuBar(menuBar);
        if (window instanceof JFrame) {
            frame.setDefaultCloseOperation(((JFrame)window).getDefaultCloseOperation());
        } else if (window instanceof JDialog) {
            frame.setDefaultCloseOperation(((JDialog)window).getDefaultCloseOperation());
        }
        frame.pack();
        frame.getIcyExternalFrame().setSize(window.getSize());
        frame.getIcyInternalFrame().setSize(window.getSize());
        frame.center();
        frame.setFocusable(window.isFocusable());
        frame.setResizable(false);
        frame.addFrameListener(new IcyFrameAdapter(){

            @Override
            public void icyFrameOpened(IcyFrameEvent e) {
                WindowListener[] windowListenerArray = window.getWindowListeners();
                int n = windowListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    WindowListener l = windowListenerArray[n2];
                    l.windowOpened(new WindowEvent(window, e.getEvent().getID()));
                    ++n2;
                }
            }

            @Override
            public void icyFrameClosing(IcyFrameEvent e) {
                if (window.isVisible()) {
                    window.setLocation(frame.getLocation());
                    WindowListener[] windowListenerArray = window.getWindowListeners();
                    int n = windowListenerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        WindowListener l = windowListenerArray[n2];
                        l.windowClosing(new WindowEvent(window, e.getEvent().getID()));
                        ++n2;
                    }
                }
            }

            @Override
            public void icyFrameClosed(IcyFrameEvent e) {
                if (window.isVisible()) {
                    WindowListener[] windowListenerArray = window.getWindowListeners();
                    int n = windowListenerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        WindowListener l = windowListenerArray[n2];
                        l.windowClosed(new WindowEvent(window, e.getEvent().getID()));
                        ++n2;
                    }
                }
            }
        });
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                super.windowClosed(e);
                frame.close();
            }
        });
        return frame;
    }

    public static void setCursor(Component c, int cursor) {
        if (c == null) {
            return;
        }
        if (c.getCursor().getType() != cursor) {
            c.setCursor(Cursor.getPredefinedCursor(cursor));
        }
    }

    @Deprecated
    public static void paintBackGround(int width, int height, Graphics g) {
        GraphicsUtil.paintIcyBackGround(width, height, g);
    }

    @Deprecated
    public static void paintBackGround(Component component, Graphics g) {
        GraphicsUtil.paintIcyBackGround(component, g);
    }

    @Deprecated
    public static void paintBackGround(Image image) {
        GraphicsUtil.paintIcyBackGround(image);
    }

    @Deprecated
    public static Rectangle2D getStringBounds(Graphics g, Font f, String s) {
        return GraphicsUtil.getStringBounds(g, f, s);
    }

    @Deprecated
    public static Rectangle2D getStringBounds(Component c, String s) {
        return GraphicsUtil.getStringBounds(c, s);
    }

    @Deprecated
    public static Rectangle2D getStringBounds(Graphics g, String s) {
        return GraphicsUtil.getStringBounds(g, s);
    }

    @Deprecated
    public static void drawHCenteredText(Graphics g, String string, int w, int y) {
        GraphicsUtil.drawHCenteredString(g, string, w / 2, y, false);
    }

    @Deprecated
    public static void drawCenteredText(Graphics g, String string, int w, int h) {
        GraphicsUtil.drawCenteredString(g, string, w / 2, h / 2, false);
    }
}

