/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.util;

import icy.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JFlowRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.RibbonElementPriority;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.pushingpixels.flamingo.api.ribbon.resize.CoreRibbonResizePolicies;
import org.pushingpixels.flamingo.api.ribbon.resize.IconRibbonBandResizePolicy;
import org.pushingpixels.flamingo.api.ribbon.resize.RibbonBandResizePolicy;
import org.pushingpixels.flamingo.internal.ui.ribbon.AbstractBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.JBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.JFlowBandControlPanel;

public class RibbonUtil {
    private static final int DEFAULT_HEIGHT = 48;
    private static final int DEFAULT_GAP = 4;

    private static List<RibbonBandResizePolicy> getPermissiveResizePolicies(JBandControlPanel controlPanel) {
        ArrayList<RibbonBandResizePolicy> result = new ArrayList<RibbonBandResizePolicy>();
        CoreRibbonResizePolicies.None none = new CoreRibbonResizePolicies.None(controlPanel);
        CoreRibbonResizePolicies.Low2Mid low2Mid = new CoreRibbonResizePolicies.Low2Mid(controlPanel);
        CoreRibbonResizePolicies.Mid2Mid mid2Mid = new CoreRibbonResizePolicies.Mid2Mid(controlPanel);
        CoreRibbonResizePolicies.Mirror mirror = new CoreRibbonResizePolicies.Mirror(controlPanel);
        CoreRibbonResizePolicies.Mid2Low mid2Low = new CoreRibbonResizePolicies.Mid2Low(controlPanel);
        CoreRibbonResizePolicies.High2Mid high2Mid = new CoreRibbonResizePolicies.High2Mid(controlPanel);
        CoreRibbonResizePolicies.High2Low high2Low = new CoreRibbonResizePolicies.High2Low(controlPanel);
        IconRibbonBandResizePolicy icon = new IconRibbonBandResizePolicy((AbstractBandControlPanel)controlPanel);
        int noneW = none.getPreferredWidth(48, 4);
        int low2MidW = low2Mid.getPreferredWidth(48, 4);
        int mid2MidW = mid2Mid.getPreferredWidth(48, 4);
        int mirrorW = mirror.getPreferredWidth(48, 4);
        int mid2LowW = mid2Low.getPreferredWidth(48, 4);
        int high2MidW = high2Mid.getPreferredWidth(48, 4);
        int high2LowW = high2Low.getPreferredWidth(48, 4);
        int iconW = icon.getPreferredWidth(48, 4);
        result.add((RibbonBandResizePolicy)none);
        if (low2MidW < noneW) {
            result.add((RibbonBandResizePolicy)low2Mid);
        }
        if (mid2MidW < low2MidW) {
            result.add((RibbonBandResizePolicy)mid2Mid);
        }
        if (mirrorW < mid2MidW) {
            result.add((RibbonBandResizePolicy)mirror);
        }
        if (mid2LowW < mirrorW) {
            result.add((RibbonBandResizePolicy)mid2Low);
        }
        if (high2MidW < mid2LowW) {
            result.add((RibbonBandResizePolicy)high2Mid);
        }
        if (high2LowW < high2MidW) {
            result.add((RibbonBandResizePolicy)high2Low);
        }
        if (iconW < high2LowW) {
            result.add((RibbonBandResizePolicy)icon);
        }
        return result;
    }

    private static List<RibbonBandResizePolicy> getRestrictiveResizePolicies(JBandControlPanel controlPanel, int gap) {
        ArrayList<RibbonBandResizePolicy> result = new ArrayList<RibbonBandResizePolicy>();
        CoreRibbonResizePolicies.Mirror mirror = new CoreRibbonResizePolicies.Mirror(controlPanel);
        CoreRibbonResizePolicies.Mid2Low mid2Low = new CoreRibbonResizePolicies.Mid2Low(controlPanel);
        CoreRibbonResizePolicies.High2Mid high2Mid = new CoreRibbonResizePolicies.High2Mid(controlPanel);
        CoreRibbonResizePolicies.High2Low high2Low = new CoreRibbonResizePolicies.High2Low(controlPanel);
        IconRibbonBandResizePolicy icon = new IconRibbonBandResizePolicy((AbstractBandControlPanel)controlPanel);
        int mirrorW = mirror.getPreferredWidth(48, gap);
        int mid2LowW = mid2Low.getPreferredWidth(48, gap);
        int high2MidW = high2Mid.getPreferredWidth(48, gap);
        int high2LowW = high2Low.getPreferredWidth(48, gap);
        int iconW = icon.getPreferredWidth(48, gap);
        result.add((RibbonBandResizePolicy)mirror);
        if (mid2LowW < mirrorW) {
            result.add((RibbonBandResizePolicy)mid2Low);
        }
        if (high2MidW < mid2LowW) {
            result.add((RibbonBandResizePolicy)high2Mid);
        }
        if (high2LowW < high2MidW) {
            result.add((RibbonBandResizePolicy)high2Low);
        }
        if (iconW < high2LowW) {
            result.add((RibbonBandResizePolicy)icon);
        }
        return result;
    }

    private static List<RibbonBandResizePolicy> getFixedResizePolicies(JBandControlPanel controlPanel) {
        ArrayList<RibbonBandResizePolicy> result = new ArrayList<RibbonBandResizePolicy>();
        result.add((RibbonBandResizePolicy)new CoreRibbonResizePolicies.Mirror(controlPanel));
        return result;
    }

    private static List<RibbonBandResizePolicy> getRestrictiveResizePolicies(JFlowBandControlPanel controlPanel, int step) {
        ArrayList<RibbonBandResizePolicy> result = new ArrayList<RibbonBandResizePolicy>();
        CoreRibbonResizePolicies.FlowTwoRows twoRows = new CoreRibbonResizePolicies.FlowTwoRows(controlPanel);
        CoreRibbonResizePolicies.FlowThreeRows threeRows = new CoreRibbonResizePolicies.FlowThreeRows(controlPanel);
        IconRibbonBandResizePolicy icon = new IconRibbonBandResizePolicy((AbstractBandControlPanel)controlPanel);
        int twoRowsW = twoRows.getPreferredWidth(48, 4);
        int threeRowsW = threeRows.getPreferredWidth(48, 4);
        int iconW = twoRows.getPreferredWidth(48, 4);
        if (twoRowsW > threeRowsW) {
            int i = 0;
            while (i < step) {
                result.add((RibbonBandResizePolicy)new CoreRibbonResizePolicies.FlowTwoRows(controlPanel));
                ++i;
            }
            i = 0;
            while (i < step) {
                result.add((RibbonBandResizePolicy)new CoreRibbonResizePolicies.FlowThreeRows(controlPanel));
                ++i;
            }
            if (iconW < threeRowsW) {
                result.add((RibbonBandResizePolicy)icon);
            }
        } else {
            int i = 0;
            while (i < step) {
                result.add((RibbonBandResizePolicy)new CoreRibbonResizePolicies.FlowThreeRows(controlPanel));
                ++i;
            }
            i = 0;
            while (i < step) {
                result.add((RibbonBandResizePolicy)new CoreRibbonResizePolicies.FlowTwoRows(controlPanel));
                ++i;
            }
            if (iconW < twoRowsW) {
                result.add((RibbonBandResizePolicy)icon);
            }
        }
        return result;
    }

    public static void setPermissiveResizePolicies(JRibbonBand band) {
        band.setResizePolicies(RibbonUtil.getPermissiveResizePolicies((JBandControlPanel)band.getControlPanel()));
    }

    public static void setRestrictiveResizePolicies(JRibbonBand band) {
        RibbonUtil.setRestrictiveResizePolicies(band, 4);
    }

    public static void setRestrictiveResizePolicies(JRibbonBand band, int gap) {
        band.setResizePolicies(RibbonUtil.getRestrictiveResizePolicies((JBandControlPanel)band.getControlPanel(), gap));
    }

    public static void setFixedResizePolicies(JRibbonBand band) {
        band.setResizePolicies(RibbonUtil.getFixedResizePolicies((JBandControlPanel)band.getControlPanel()));
    }

    public static void setRestrictiveResizePolicies(JFlowRibbonBand band, int step) {
        band.setResizePolicies(RibbonUtil.getRestrictiveResizePolicies((JFlowBandControlPanel)band.getControlPanel(), step));
    }

    public static ArrayList<RibbonTask> getTasks(JRibbon ribbon) {
        ArrayList<RibbonTask> result = new ArrayList<RibbonTask>();
        if (ribbon != null) {
            int taskCount = ribbon.getTaskCount();
            int i = 0;
            while (i < taskCount) {
                result.add(ribbon.getTask(i));
                ++i;
            }
        }
        return result;
    }

    public static RibbonTask getTask(JRibbon ribbon, String name) {
        if (ribbon != null) {
            int taskCount = ribbon.getTaskCount();
            int i = 0;
            while (i < taskCount) {
                RibbonTask ribbonTask = ribbon.getTask(i);
                if (StringUtil.equals(ribbonTask.getTitle(), name)) {
                    return ribbonTask;
                }
                ++i;
            }
        }
        return null;
    }

    public static JRibbonBand getBand(RibbonTask ribbonTask, String name) {
        if (ribbonTask != null) {
            for (AbstractRibbonBand ribbonBand : ribbonTask.getBands()) {
                if (!StringUtil.equals(ribbonBand.getTitle(), name) || !(ribbonBand instanceof JRibbonBand)) continue;
                return (JRibbonBand)ribbonBand;
            }
        }
        return null;
    }

    public static JFlowRibbonBand getFlowBand(RibbonTask ribbonTask, String name) {
        if (ribbonTask != null) {
            for (AbstractRibbonBand ribbonBand : ribbonTask.getBands()) {
                if (!StringUtil.equals(ribbonBand.getTitle(), name) || !(ribbonBand instanceof JFlowRibbonBand)) continue;
                return (JFlowRibbonBand)ribbonBand;
            }
        }
        return null;
    }

    public static RibbonElementPriority getButtonPriority(JRibbonBand band, AbstractCommandButton button) {
        RibbonElementPriority result = ((JBandControlPanel)band.getControlPanel()).getPriority(button);
        if (result != null) {
            return result;
        }
        return RibbonElementPriority.LOW;
    }

    public static List<AbstractCommandButton> getButtons(JRibbonBand band) {
        return ((JBandControlPanel)band.getControlPanel()).getAllCommandButtons();
    }

    public static AbstractCommandButton findButton(List<AbstractCommandButton> buttons, String name) {
        for (AbstractCommandButton button : buttons) {
            if (!StringUtil.equals(button.getName(), name)) continue;
            return button;
        }
        return null;
    }

    public static AbstractCommandButton findButton(JRibbonBand band, String name) {
        if (band != null) {
            return RibbonUtil.findButton(((JBandControlPanel)band.getControlPanel()).getAllCommandButtons(), name);
        }
        return null;
    }

    public static void removeButton(JRibbonBand band, String name) {
        band.removeCommandButton(RibbonUtil.findButton(band, name));
    }
}

