/*
 * Decompiled with CFR 0.152.
 */
package icy.script;

import icy.gui.frame.IcyFrame;
import icy.gui.util.WindowPositionSaver;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;

public class ScriptEditor
extends IcyFrame
implements ActionListener {
    private JTextArea codeArea = new JTextArea("print('Hello, world!')", 15, 20);
    private JTextArea messageArea = new JTextArea("message text", 5, 20);
    private JPanel mainPanel = new JPanel();
    JPanel codePanel = new JPanel();
    JPanel codeActionPanel = new JPanel();
    JPanel messagePanel = new JPanel();
    JPanel messageActionPanel = new JPanel();
    JButton runButton = new JButton("Run");
    JMenuItem loadFileMenuItem = new JMenuItem("Load...");
    JMenuItem saveFileMenuItem = new JMenuItem("Save...");
    final WindowPositionSaver positionSaver = new WindowPositionSaver(this, "frame/scriptEditor", new Point(300, 300), new Dimension(400, 300));

    public ScriptEditor() {
        super("Script Editor", true, true, true, true);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(this.loadFileMenuItem);
        fileMenu.add(this.saveFileMenuItem);
        this.loadFileMenuItem.addActionListener(this);
        this.saveFileMenuItem.addActionListener(this);
        menuBar.add(fileMenu);
        this.setVisible(true);
        this.codePanel.setLayout(new BoxLayout(this.codePanel, 3));
        this.codeActionPanel.add(this.runButton);
        this.runButton.addActionListener(this);
        this.codeActionPanel.add(new JButton("Compile"));
        this.codePanel.add(this.codeArea);
        this.codePanel.add(this.codeActionPanel);
        this.codeArea.setLineWrap(true);
        this.messagePanel.setLayout(new BoxLayout(this.messagePanel, 3));
        this.messageActionPanel.add(new JButton("Clear"));
        this.messagePanel.add(this.messageArea);
        this.messagePanel.add(this.messageActionPanel);
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 3));
        this.mainPanel.add(this.codePanel);
        this.mainPanel.add(this.messagePanel);
        this.codeArea.setVisible(true);
        this.codeArea.setTabSize(2);
        this.messageArea.setLineWrap(true);
        this.getContentPane().setLayout(new FlowLayout());
        JSplitPane splitPane = new JSplitPane(0, this.codePanel, this.messagePanel);
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this.getContentPane().add(splitPane);
        this.pack();
        this.addToDesktopPane();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.runButton) {
            this.messageArea.setText("");
            ScriptEngineManager mgr = new ScriptEngineManager();
            ScriptEngine jsEngine = mgr.getEngineByName("JavaScript");
            if (jsEngine == null) {
                System.err.println("Unable to use ScriptEngine with JavaScript.");
                return;
            }
            try {
                jsEngine.eval(this.codeArea.getText());
            }
            catch (ScriptException ex) {
                this.messageArea.append("Line : " + ex.getLineNumber() + "\n");
                this.messageArea.append(ex.getMessage());
            }
        }
        e.getSource();
        e.getSource();
    }
}

