/*
 * Decompiled with CFR 0.152.
 */
package icy.undo;

import icy.undo.AbstractIcyUndoableEdit;
import icy.undo.IcyUndoManagerListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class IcyUndoManager
extends AbstractUndoableEdit
implements UndoableEditListener {
    private static final long serialVersionUID = 3080107472163005941L;
    private static final int INITIAL_LIMIT = 64;
    protected final Object owner;
    protected List<AbstractIcyUndoableEdit> edits = new ArrayList<AbstractIcyUndoableEdit>(32);
    protected final EventListenerList listeners;
    protected int indexOfNextAdd;
    protected int limit;

    public IcyUndoManager(Object owner, int limit) {
        this.owner = owner;
        this.listeners = new EventListenerList();
        this.indexOfNextAdd = 0;
        this.limit = limit;
    }

    public IcyUndoManager(Object owner) {
        this(owner, 64);
    }

    public Object getOwner() {
        return this.owner;
    }

    public synchronized int getLimit() {
        return this.limit;
    }

    public void discardAllEdits() {
        if (this.trimEdits(0, this.edits.size() - 1)) {
            this.fireChangeEvent();
        }
    }

    public synchronized void discardFutureEdits(int keep) {
        if (this.trimEdits(this.indexOfNextAdd + keep, this.edits.size() - 1)) {
            this.fireChangeEvent();
        }
    }

    public synchronized void discardFutureEdits() {
        this.discardFutureEdits(0);
    }

    public synchronized void discardOldEdits(int keep) {
        if (this.trimEdits(0, this.indexOfNextAdd - (1 + keep))) {
            this.fireChangeEvent();
        }
    }

    public synchronized void discardOldEdits() {
        this.discardOldEdits(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean trimForLimit() {
        boolean result = false;
        if (this.limit >= 0) {
            List<AbstractIcyUndoableEdit> list = this.edits;
            synchronized (list) {
                int size = this.edits.size();
                if (size > this.limit) {
                    int halfLimit = this.limit / 2;
                    int keepTo = this.indexOfNextAdd - 1 + halfLimit;
                    int keepFrom = this.indexOfNextAdd - 1 - halfLimit;
                    if (keepTo - keepFrom + 1 > this.limit) {
                        ++keepFrom;
                    }
                    if (keepFrom < 0) {
                        keepTo -= keepFrom;
                        keepFrom = 0;
                    }
                    if (keepTo >= size) {
                        int delta = size - keepTo - 1;
                        keepTo += delta;
                        keepFrom += delta;
                    }
                    if (this.trimEdits(keepTo + 1, size - 1)) {
                        result = true;
                    }
                    if (this.trimEdits(0, keepFrom - 1)) {
                        result = true;
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean trimEdits(int from, int to) {
        if (from <= to) {
            List<AbstractIcyUndoableEdit> list = this.edits;
            synchronized (list) {
                int i = to;
                while (i >= from) {
                    this.edits.get(i).die();
                    this.edits.remove(i);
                    --i;
                }
            }
            if (this.indexOfNextAdd > to) {
                this.indexOfNextAdd -= to - from + 1;
            } else if (this.indexOfNextAdd >= from) {
                this.indexOfNextAdd = from;
            }
            return true;
        }
        return false;
    }

    public synchronized void setLimit(int l) {
        this.limit = l;
        if (this.trimForLimit()) {
            this.fireChangeEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractIcyUndoableEdit editToBeUndone() {
        List<AbstractIcyUndoableEdit> list = this.edits;
        synchronized (list) {
            int i = this.indexOfNextAdd;
            while (i > 0) {
                AbstractIcyUndoableEdit edit;
                if (!(edit = this.edits.get(--i)).isSignificant()) continue;
                return edit;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractIcyUndoableEdit editToBeRedone() {
        List<AbstractIcyUndoableEdit> list = this.edits;
        synchronized (list) {
            int count = this.edits.size();
            int i = this.indexOfNextAdd;
            while (i < count) {
                AbstractIcyUndoableEdit edit;
                if (!(edit = this.edits.get(i++)).isSignificant()) continue;
                return edit;
            }
        }
        return null;
    }

    public void undoAll() throws CannotUndoException {
        while (this.indexOfNextAdd > 0) {
            AbstractIcyUndoableEdit next = this.edits.get(--this.indexOfNextAdd);
            next.undo();
        }
        if (!this.canRedo()) {
            this.discardFutureEdits();
        }
        this.fireChangeEvent();
    }

    protected void undoTo(AbstractIcyUndoableEdit edit) throws CannotUndoException {
        boolean done = false;
        while (!done) {
            AbstractIcyUndoableEdit next = this.edits.get(--this.indexOfNextAdd);
            next.undo();
            boolean bl = done = next == edit;
        }
    }

    @Override
    public synchronized void undo() throws CannotUndoException {
        AbstractIcyUndoableEdit edit = this.editToBeUndone();
        if (edit == null) {
            throw new CannotUndoException();
        }
        this.undoTo(edit);
        if (!this.canRedo()) {
            this.discardFutureEdits();
        }
        this.fireChangeEvent();
    }

    @Override
    public synchronized boolean canUndo() {
        AbstractIcyUndoableEdit edit = this.editToBeUndone();
        return edit != null && edit.canUndo();
    }

    protected void redoTo(AbstractIcyUndoableEdit edit) throws CannotRedoException {
        boolean done = false;
        while (!done) {
            AbstractIcyUndoableEdit next = this.edits.get(this.indexOfNextAdd++);
            next.redo();
            boolean bl = done = next == edit;
        }
    }

    @Override
    public synchronized void redo() throws CannotRedoException {
        AbstractIcyUndoableEdit edit = this.editToBeRedone();
        if (edit == null) {
            throw new CannotRedoException();
        }
        this.redoTo(edit);
        if (!this.canUndo()) {
            this.discardOldEdits();
        }
        this.fireChangeEvent();
    }

    @Override
    public synchronized boolean canRedo() {
        AbstractIcyUndoableEdit edit = this.editToBeRedone();
        return edit != null && edit.canRedo();
    }

    public synchronized void undoOrRedoTo(AbstractIcyUndoableEdit edit) throws CannotRedoException, CannotUndoException {
        int index = this.getIndex(edit);
        if (index != -1) {
            AbstractIcyUndoableEdit next;
            while (this.indexOfNextAdd - 1 > index) {
                next = this.edits.get(--this.indexOfNextAdd);
                next.undo();
            }
            while (this.indexOfNextAdd <= index) {
                next = this.edits.get(this.indexOfNextAdd++);
                next.redo();
            }
            if (!this.canUndo()) {
                this.discardOldEdits();
            }
            if (!this.canRedo()) {
                this.discardFutureEdits();
            }
            this.fireChangeEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractIcyUndoableEdit lastEdit() {
        List<AbstractIcyUndoableEdit> list = this.edits;
        synchronized (list) {
            int count = this.edits.size();
            if (count > 0) {
                return this.edits.get(count - 1);
            }
        }
        return null;
    }

    @Override
    public boolean addEdit(UndoableEdit anEdit) {
        if (anEdit instanceof AbstractIcyUndoableEdit) {
            this.addEdit((AbstractIcyUndoableEdit)anEdit);
        }
        return super.addEdit(anEdit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addEdit(AbstractIcyUndoableEdit anEdit) {
        List<AbstractIcyUndoableEdit> list = this.edits;
        synchronized (list) {
            this.trimEdits(this.indexOfNextAdd, this.edits.size() - 1);
            AbstractIcyUndoableEdit last = this.lastEdit();
            if (last == null) {
                this.edits.add(anEdit);
            } else if (!last.addEdit(anEdit)) {
                if (anEdit.replaceEdit(last)) {
                    this.edits.set(this.edits.size() - 1, anEdit);
                } else {
                    this.edits.add(anEdit);
                }
            }
            this.indexOfNextAdd = this.edits.size();
            this.trimForLimit();
        }
        this.fireChangeEvent();
    }

    public void noMergeForNextEdit() {
        if (this.indexOfNextAdd > 0) {
            this.edits.get(this.indexOfNextAdd - 1).setMergeable(false);
        }
    }

    @Override
    public synchronized String getUndoPresentationName() {
        if (this.canUndo()) {
            return this.editToBeUndone().getUndoPresentationName();
        }
        return UIManager.getString("AbstractUndoableEdit.undoText");
    }

    @Override
    public synchronized String getRedoPresentationName() {
        if (this.canRedo()) {
            return this.editToBeRedone().getRedoPresentationName();
        }
        return UIManager.getString("AbstractUndoableEdit.redoText");
    }

    public void addListener(IcyUndoManagerListener listener) {
        this.listeners.add(IcyUndoManagerListener.class, listener);
    }

    public void removeListener(IcyUndoManagerListener listener) {
        this.listeners.remove(IcyUndoManagerListener.class, listener);
    }

    public IcyUndoManagerListener[] getListeners() {
        return (IcyUndoManagerListener[])this.listeners.getListeners(IcyUndoManagerListener.class);
    }

    private void fireChangeEvent() {
        IcyUndoManagerListener[] icyUndoManagerListenerArray = (IcyUndoManagerListener[])this.listeners.getListeners(IcyUndoManagerListener.class);
        int n = icyUndoManagerListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IcyUndoManagerListener listener = icyUndoManagerListenerArray[n2];
            listener.undoManagerChanged(this);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AbstractIcyUndoableEdit> getAllEdits() {
        List<AbstractIcyUndoableEdit> list = this.edits;
        synchronized (list) {
            return new ArrayList<AbstractIcyUndoableEdit>(this.edits);
        }
    }

    public int getEditsCount() {
        return this.edits.size();
    }

    public int getIndex(AbstractIcyUndoableEdit e) {
        return this.edits.indexOf(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSignificantIndex(AbstractIcyUndoableEdit e) {
        int result = 0;
        List<AbstractIcyUndoableEdit> list = this.edits;
        synchronized (list) {
            for (AbstractIcyUndoableEdit edit : this.edits) {
                if (!edit.isSignificant()) continue;
                if (edit == e) {
                    return result;
                }
                ++result;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSignificantEditsCountBefore(int index) {
        int result = 0;
        List<AbstractIcyUndoableEdit> list = this.edits;
        synchronized (list) {
            int i = 0;
            while (i < index) {
                if (this.edits.get(i).isSignificant()) {
                    ++result;
                }
                ++i;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSignificantEditsCount() {
        int result = 0;
        List<AbstractIcyUndoableEdit> list = this.edits;
        synchronized (list) {
            for (AbstractIcyUndoableEdit edit : this.edits) {
                if (!edit.isSignificant()) continue;
                ++result;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractIcyUndoableEdit getEdit(int index) {
        List<AbstractIcyUndoableEdit> list = this.edits;
        synchronized (list) {
            if (index < this.edits.size()) {
                return this.edits.get(index);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractIcyUndoableEdit getSignificantEdit(int index) {
        int i = 0;
        List<AbstractIcyUndoableEdit> list = this.edits;
        synchronized (list) {
            for (AbstractIcyUndoableEdit edit : this.edits) {
                if (!edit.isSignificant()) continue;
                if (i == index) {
                    return edit;
                }
                ++i;
            }
        }
        return null;
    }

    public int getNextAddIndex() {
        return this.indexOfNextAdd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFirstEditIndex(Object source) {
        if (source == null) {
            return -1;
        }
        List<AbstractIcyUndoableEdit> list = this.edits;
        synchronized (list) {
            int i = 0;
            while (i < this.edits.size()) {
                if (this.edits.get(i).getSource() == source) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastEditIndex(Object source) {
        if (source == null) {
            return -1;
        }
        List<AbstractIcyUndoableEdit> list = this.edits;
        synchronized (list) {
            int i = this.edits.size() - 1;
            while (i >= 0) {
                if (this.edits.get(i).getSource() == source) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardEdits(Object source) {
        List<AbstractIcyUndoableEdit> list = this.edits;
        synchronized (list) {
            int lastIndex = this.getLastEditIndex(source);
            if (lastIndex != -1) {
                ArrayList<AbstractIcyUndoableEdit> validEdits = new ArrayList<AbstractIcyUndoableEdit>();
                int i = lastIndex + 1;
                while (i < this.edits.size()) {
                    validEdits.add(this.edits.get(i));
                    ++i;
                }
                this.edits.clear();
                this.indexOfNextAdd = 0;
                for (AbstractIcyUndoableEdit edit : validEdits) {
                    this.edits.add(edit);
                }
                this.indexOfNextAdd = this.edits.size();
                this.fireChangeEvent();
            }
        }
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        this.addEdit(e.getEdit());
    }
}

