/*
 * Decompiled with CFR 0.152.
 */
package icy.util;

import icy.util.StringUtil;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static final long DAY_IN_MS = 86400000L;

    public static long getTime() {
        return System.currentTimeMillis();
    }

    public static long keepDay(long time) {
        return time / 86400000L * 86400000L;
    }

    public static long keepTime(long time) {
        return time % 86400000L;
    }

    public static long getDay() {
        return DateUtil.getTime() / 86400000L;
    }

    public static Date now() {
        return Calendar.getInstance().getTime();
    }

    public static String now(String format) {
        return new SimpleDateFormat(format).format(DateUtil.now());
    }

    public static String format(String format, Date date) {
        return new SimpleDateFormat(format).format(date);
    }

    public static String getTimeAsString(double valueInMs) {
        String result = "";
        double v = valueInMs;
        if (v >= 3600000.0) {
            result = String.valueOf(result) + (int)(v / 3600000.0);
            v %= 3600000.0;
        }
        if (v >= 60000.0) {
            if (StringUtil.isEmpty(result)) {
                result = String.valueOf(result) + ":";
            }
            result = String.valueOf(result) + (int)(v / 60000.0);
            v %= 60000.0;
        }
        if (v >= 1000.0) {
            if (StringUtil.isEmpty(result)) {
                result = String.valueOf(result) + ":";
            }
            result = String.valueOf(result) + (int)(v / 1000.0);
            v %= 1000.0;
        }
        if (v != 0.0) {
            if (StringUtil.isEmpty(result)) {
                result = String.valueOf(result) + ".";
            }
            result = String.valueOf(result) + (int)v;
        }
        return result;
    }
}

