/*
 * Decompiled with CFR 0.152.
 */
package icy.util;

import icy.network.NetworkUtil;
import icy.network.URLUtil;
import icy.system.IcyExceptionHandler;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarUtil {
    public static final String FILE_EXTENSION = "jar";
    public static final String FILE_DOT_EXTENSION = ".jar";

    public static boolean isJarURL(String path) {
        return path != null && path.toUpperCase().startsWith("JAR:") && URLUtil.isURL(path.substring(4));
    }

    public static URL getJarURL(String path) {
        if (path == null) {
            return null;
        }
        if (path.toUpperCase().startsWith("JAR:")) {
            return URLUtil.getURL(path.substring(4));
        }
        return URLUtil.getURL("jar:" + URLUtil.getURL(path) + "!/");
    }

    public static URL getJarURL(String jarPath, JarEntry entry) {
        return URLUtil.getURL(JarUtil.getJarURL(jarPath) + entry.getName());
    }

    public static JarFile getJarFile(String path) {
        try {
            if (JarUtil.isJarURL(path)) {
                return ((JarURLConnection)NetworkUtil.openConnection(JarUtil.getJarURL(path), false, true)).getJarFile();
            }
            return new JarFile(path);
        }
        catch (IOException e) {
            System.err.println("Cannot open " + path + ":");
            IcyExceptionHandler.showErrorMessage(e, false, true);
            return null;
        }
    }

    public static JarEntry getJarClassEntry(JarFile file, String className) {
        return file.getJarEntry(String.valueOf(className.replace('.', '/')) + ".class");
    }

    public static JarEntry getJarEntry(JarFile file, String entryName) {
        return file.getJarEntry(entryName);
    }

    public static void getAllFiles(String fileName, boolean includeFolderEntry, boolean includeHidden, List<String> result) {
        JarFile jarFile = JarUtil.getJarFile(fileName);
        if (jarFile == null) {
            return;
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            if (jarEntry.isDirectory() && !includeFolderEntry) continue;
            String name = jarEntry.getName();
            if (!includeHidden && name.startsWith(".")) continue;
            result.add(jarEntry.getName());
        }
        try {
            jarFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static List<String> getAllFiles(String fileName, boolean includeFolderEntry, boolean includeHidden) {
        ArrayList<String> result = new ArrayList<String>();
        JarUtil.getAllFiles(fileName, includeFolderEntry, includeHidden, result);
        return result;
    }
}

