/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.Microscopy.MicroManager.gui;

import icy.math.MathUtil;
import icy.system.thread.ThreadUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.geom.Point2D;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import mmcorej.CMMCore;
import plugins.tprovoost.Microscopy.MicroManager.MicroManager;
import plugins.tprovoost.Microscopy.MicroManager.gui.MMMainFrame;
import plugins.tprovoost.Microscopy.MicroManager.tools.StageMover;

public class AcquisitionInfoPanel
extends JPanel
implements Runnable {
    private static final long serialVersionUID = -6615066602497363425L;
    final MMMainFrame mainFrame;
    private JLabel imgResField;
    private JLabel depthField;
    private JLabel pixelSizeField;
    private JLabel posXYField;
    private JLabel posZField;
    private JLabel lblNewLabel;
    private JLabel lblPixel;
    private JLabel lblUm;
    private JLabel lblUm_1;
    private JLabel lblUm_2;

    public AcquisitionInfoPanel(MMMainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.initialize();
    }

    private void initialize() {
        this.setBorder(new TitledBorder(null, "Informations", 4, 2, null, null));
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{70, 90, 44, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, 1.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JLabel lblImageResolution = new JLabel("Image res. ");
        lblImageResolution.setToolTipText("Image resolution (pixel)");
        GridBagConstraints gbc_lblImageResolution = new GridBagConstraints();
        gbc_lblImageResolution.anchor = 17;
        gbc_lblImageResolution.insets = new Insets(0, 0, 5, 5);
        gbc_lblImageResolution.gridx = 0;
        gbc_lblImageResolution.gridy = 0;
        this.add((Component)lblImageResolution, gbc_lblImageResolution);
        this.imgResField = new JLabel("512 x 512");
        GridBagConstraints gbc_imgResField = new GridBagConstraints();
        gbc_imgResField.anchor = 13;
        gbc_imgResField.insets = new Insets(0, 0, 5, 5);
        gbc_imgResField.gridx = 1;
        gbc_imgResField.gridy = 0;
        this.add((Component)this.imgResField, gbc_imgResField);
        this.lblPixel = new JLabel("pixel");
        GridBagConstraints gbc_lblPixel = new GridBagConstraints();
        gbc_lblPixel.anchor = 17;
        gbc_lblPixel.insets = new Insets(0, 0, 5, 0);
        gbc_lblPixel.gridx = 2;
        gbc_lblPixel.gridy = 0;
        this.add((Component)this.lblPixel, gbc_lblPixel);
        JLabel lblDepth = new JLabel("Depth ");
        lblDepth.setToolTipText("Image depth");
        GridBagConstraints gbc_lblDepth = new GridBagConstraints();
        gbc_lblDepth.anchor = 17;
        gbc_lblDepth.insets = new Insets(0, 0, 5, 5);
        gbc_lblDepth.gridx = 0;
        gbc_lblDepth.gridy = 1;
        this.add((Component)lblDepth, gbc_lblDepth);
        this.depthField = new JLabel("8");
        GridBagConstraints gbc_depthField = new GridBagConstraints();
        gbc_depthField.anchor = 13;
        gbc_depthField.insets = new Insets(0, 0, 5, 5);
        gbc_depthField.gridx = 1;
        gbc_depthField.gridy = 1;
        this.add((Component)this.depthField, gbc_depthField);
        JLabel lblBit = new JLabel("bit");
        GridBagConstraints gbc_lblBit = new GridBagConstraints();
        gbc_lblBit.anchor = 17;
        gbc_lblBit.insets = new Insets(0, 0, 5, 0);
        gbc_lblBit.gridx = 2;
        gbc_lblBit.gridy = 1;
        this.add((Component)lblBit, gbc_lblBit);
        JLabel lblPixelSize = new JLabel("Pixel size");
        lblPixelSize.setToolTipText("Pixel size (micro meter)");
        GridBagConstraints gbc_lblPixelSize = new GridBagConstraints();
        gbc_lblPixelSize.anchor = 17;
        gbc_lblPixelSize.insets = new Insets(0, 0, 5, 5);
        gbc_lblPixelSize.gridx = 0;
        gbc_lblPixelSize.gridy = 2;
        this.add((Component)lblPixelSize, gbc_lblPixelSize);
        this.pixelSizeField = new JLabel("10");
        GridBagConstraints gbc_pixelSizeField = new GridBagConstraints();
        gbc_pixelSizeField.anchor = 13;
        gbc_pixelSizeField.insets = new Insets(0, 0, 5, 5);
        gbc_pixelSizeField.gridx = 1;
        gbc_pixelSizeField.gridy = 2;
        this.add((Component)this.pixelSizeField, gbc_pixelSizeField);
        this.lblUm = new JLabel("um");
        GridBagConstraints gbc_lblUm = new GridBagConstraints();
        gbc_lblUm.anchor = 17;
        gbc_lblUm.insets = new Insets(0, 0, 5, 0);
        gbc_lblUm.gridx = 2;
        gbc_lblUm.gridy = 2;
        this.add((Component)this.lblUm, gbc_lblUm);
        this.lblNewLabel = new JLabel("Position XY ");
        this.lblNewLabel.setToolTipText("Stage position XY (micro meter)");
        GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
        gbc_lblNewLabel.anchor = 17;
        gbc_lblNewLabel.fill = 3;
        gbc_lblNewLabel.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel.gridx = 0;
        gbc_lblNewLabel.gridy = 3;
        this.add((Component)this.lblNewLabel, gbc_lblNewLabel);
        this.posXYField = new JLabel("0.00 , 0.00");
        GridBagConstraints gbc_posXYField = new GridBagConstraints();
        gbc_posXYField.anchor = 13;
        gbc_posXYField.insets = new Insets(0, 0, 5, 5);
        gbc_posXYField.gridx = 1;
        gbc_posXYField.gridy = 3;
        this.add((Component)this.posXYField, gbc_posXYField);
        this.lblUm_1 = new JLabel("um");
        GridBagConstraints gbc_lblUm_1 = new GridBagConstraints();
        gbc_lblUm_1.anchor = 17;
        gbc_lblUm_1.insets = new Insets(0, 0, 5, 0);
        gbc_lblUm_1.gridx = 2;
        gbc_lblUm_1.gridy = 3;
        this.add((Component)this.lblUm_1, gbc_lblUm_1);
        JLabel lblNewLabel_1 = new JLabel("Position Z");
        lblNewLabel_1.setToolTipText("Stage position Z (micro meter)");
        GridBagConstraints gbc_lblNewLabel_1 = new GridBagConstraints();
        gbc_lblNewLabel_1.anchor = 17;
        gbc_lblNewLabel_1.insets = new Insets(0, 0, 0, 5);
        gbc_lblNewLabel_1.gridx = 0;
        gbc_lblNewLabel_1.gridy = 4;
        this.add((Component)lblNewLabel_1, gbc_lblNewLabel_1);
        this.posZField = new JLabel("0.00");
        GridBagConstraints gbc_posZField = new GridBagConstraints();
        gbc_posZField.insets = new Insets(0, 0, 0, 5);
        gbc_posZField.anchor = 13;
        gbc_posZField.gridx = 1;
        gbc_posZField.gridy = 4;
        this.add((Component)this.posZField, gbc_posZField);
        this.lblUm_2 = new JLabel("um");
        GridBagConstraints gbc_lblUm_2 = new GridBagConstraints();
        gbc_lblUm_2.anchor = 17;
        gbc_lblUm_2.gridx = 2;
        gbc_lblUm_2.gridy = 4;
        this.add((Component)this.lblUm_2, gbc_lblUm_2);
    }

    private void setDepth(int value) {
        this.depthField.setText(Integer.toString(value));
    }

    private void setImageRes(int x, int y) {
        this.imgResField.setText(Integer.toString(x) + " x " + Integer.toString(y));
    }

    private void setPixelSize(double value) {
        this.pixelSizeField.setText(Double.toString(value));
    }

    private void setPositionXY(double x, double y) {
        String str = Double.isNaN(x) ? "--" : Double.toString(x);
        str = str + " , ";
        str = Double.isNaN(y) ? str + "--" : str + Double.toString(y);
        this.posXYField.setText(str);
    }

    private void setPositionZ(double value) {
        if (Double.isNaN(value)) {
            this.posZField.setText("--");
        } else {
            this.posZField.setText(Double.toString(value));
        }
    }

    void refreshXYPosition() {
        try {
            Point2D.Double xy = StageMover.getXY();
            this.setPositionXY(MathUtil.roundSignificant((double)xy.getX(), (int)5), MathUtil.roundSignificant((double)xy.getY(), (int)5));
        }
        catch (Exception e) {
            this.setPositionXY(Double.NaN, Double.NaN);
        }
    }

    void refreshZPosition() {
        try {
            this.setPositionZ(MathUtil.roundSignificant((double)StageMover.getZ(), (int)5));
        }
        catch (Exception e) {
            this.setPositionZ(Double.NaN);
        }
    }

    void refreshImageInfo() {
        CMMCore core = MicroManager.getCore();
        if (core != null) {
            try {
                this.setImageRes((int)core.getImageWidth(), (int)core.getImageHeight());
                this.setDepth((int)core.getImageBitDepth());
                this.setPixelSize(core.getPixelSizeUm());
            }
            catch (Throwable t) {
                System.err.println("Warning: can't read camera informations from Micro-Manager");
                System.err.println("Cause: " + t);
            }
        }
    }

    public void refreshNow() {
        this.refreshXYPosition();
        this.refreshZPosition();
        this.refreshImageInfo();
    }

    public void refresh() {
        ThreadUtil.bgRunSingle((Runnable)this);
    }

    @Override
    public void run() {
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                AcquisitionInfoPanel.this.refreshNow();
            }
        });
        ThreadUtil.sleep((int)20);
    }
}

