/*
 * Decompiled with CFR 0.152.
 */
package mitiv.utils;

import java.util.stream.IntStream;
import mitiv.array.ArrayFactory;
import mitiv.array.Byte1D;
import mitiv.array.ByteArray;
import mitiv.array.Double1D;
import mitiv.array.DoubleArray;
import mitiv.array.FloatArray;
import mitiv.array.Int1D;
import mitiv.array.ShapedArray;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.DoubleFunction;
import mitiv.base.mapping.FloatFunction;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.ShapedVector;

public class HistoMap {
    private double alpha;
    private double beta;
    private boolean computationRequired = true;
    protected Int1D count = null;
    protected Int1D histo = null;
    protected Double1D mean = null;
    protected int nans = 0;
    protected int nbin = 1;
    protected int neginfs = 0;
    protected int posinfs = 0;
    protected int sat = 0;
    protected Double1D var = null;
    protected double vmax = Double.NaN;
    protected double vmin = Double.NaN;

    public HistoMap(DoubleArray truth, DoubleArray data) {
        this.update(truth, data, null, Double.NaN);
    }

    public HistoMap(DoubleShapedVector truth, DoubleShapedVector data) {
        this.update(truth, data, null, Double.NaN);
    }

    public HistoMap(ShapedArray truth, ShapedArray data, ByteArray badpix) {
        this.update(truth.toDouble(), data.toDouble(), badpix, Double.NaN);
    }

    public HistoMap(ShapedArray truth, ShapedArray data, ByteArray badpix, double satval) {
        this.update(truth.toDouble(), data.toDouble(), badpix, satval);
    }

    public HistoMap(ShapedVector truth, ShapedVector data, ByteArray badpix, double satval) {
        this.update(truth, data, badpix, satval);
    }

    public double getMaximumValue() {
        return this.vmax;
    }

    public double getMinimumValue() {
        return this.vmin;
    }

    public int getNumberOfBins() {
        return this.nbin;
    }

    public int getNumberOfNaNs() {
        return this.nans;
    }

    public int getNumberOfPositiveInfinites() {
        return this.posinfs;
    }

    public int getNumberOfSaturated() {
        return this.sat;
    }

    public double getAlpha() {
        if (this.computationRequired) {
            this.compute();
            this.computationRequired = false;
        }
        return this.alpha;
    }

    public double getBeta() {
        if (this.computationRequired) {
            this.compute();
            this.computationRequired = false;
        }
        return this.beta;
    }

    public ShapedArray computeWeightMap(ShapedArray model) {
        ShapedArray wgt;
        if (this.computationRequired) {
            this.compute();
            this.computationRequired = false;
        }
        if ((wgt = model.copy()).getType() == 4) {
            ((FloatArray)wgt).map(new FloatPrecisionlaw());
        } else {
            ((DoubleArray)wgt).map(new DoublePrecisionlaw());
        }
        return wgt;
    }

    public Int1D getAxis() {
        int j = -1;
        for (int i = 0; i < this.nbin; ++i) {
            if (this.count.get(i) <= 1) continue;
            ++j;
        }
        if (j > 1) {
            return this.histo.view(new Range(0, j - 1));
        }
        return null;
    }

    public Int1D getCount() {
        Int1D realcount = this.count.create();
        int j = -1;
        for (int i = 0; i < this.nbin; ++i) {
            int c = this.count.get(i);
            if (c <= 1) continue;
            realcount.set(++j, c);
        }
        if (j > 1) {
            return realcount.view(new Range(0, j - 1));
        }
        return null;
    }

    public Double1D getMean() {
        Double1D realmean = this.mean.create();
        int j = -1;
        for (int i = 0; i < this.nbin; ++i) {
            double d;
            double c = this.count.get(i);
            if (!(d > 1.0)) continue;
            realmean.set(++j, this.mean.get(i) / c);
        }
        if (j > 1) {
            return realmean.view(new Range(0, j - 1));
        }
        return null;
    }

    public Double1D getVar() {
        Double1D realvar = this.var.create();
        int j = -1;
        for (int i = 0; i < this.nbin; ++i) {
            double d;
            double c = this.count.get(i);
            if (!(d > 1.0)) continue;
            realvar.set(++j, this.var.get(i) / (c - 1.0));
        }
        if (j > 1) {
            return realvar.view(new Range(0, j - 1));
        }
        return null;
    }

    public HistoMap reset() {
        this.vmin = Double.NaN;
        this.vmax = Double.NaN;
        this.histo = null;
        this.nans = 0;
        this.posinfs = 0;
        this.neginfs = 0;
        this.nbin = 1;
        this.count = null;
        this.mean = null;
        this.var = null;
        this.computationRequired = true;
        return this;
    }

    public void Show(int n) {
        System.out.format(" Histogram :\n", new Object[0]);
        Int1D axis = this.getAxis();
        Double1D variance = this.getVar();
        Double1D avg = this.getMean();
        Int1D cnt = this.getCount();
        if (this.count != null) {
            for (int j = 0; j < Math.min(cnt.getNumber(), n); ++j) {
                System.out.format("  %d \t %d \t %e \t %e \n", axis.get(j), cnt.get(j), avg.get(j), variance.get(j));
            }
        }
    }

    public HistoMap update(DoubleArray truth, DoubleArray data, ByteArray badpix, double satval) {
        if (truth != null || data != null) {
            if (!truth.getShape().equals(data.getShape())) {
                throw new IllegalArgumentException("truth does not have the same shape as data");
            }
            double[] mm = truth.getMinAndMax();
            double tmpmin = mm[0];
            double tmpmax = mm[1];
            this.updateSize(tmpmin, tmpmax);
            if (badpix != null) {
                if (!badpix.getShape().equals(data.getShape())) {
                    throw new IllegalArgumentException("bad pixels map does not have the same shape as data");
                }
                for (int i = 0; i < truth.getNumber(); ++i) {
                    double val = Math.floor(((Double1D)truth.as1D().toDouble()).get(i));
                    double mapval = ((Double1D)data.as1D().toDouble()).get(i);
                    if (((Byte1D)badpix.as1D()).get(i) != 0) continue;
                    if (Double.isNaN(mapval)) {
                        ++this.nans;
                        ((Byte1D)badpix.as1D()).set(i, (byte)1);
                        continue;
                    }
                    if (Double.isInfinite(mapval)) {
                        ((Byte1D)badpix.as1D()).set(i, (byte)1);
                        if (mapval > 0.0) {
                            ++this.posinfs;
                            continue;
                        }
                        ++this.neginfs;
                        continue;
                    }
                    if (mapval == satval) {
                        ((Byte1D)badpix.as1D()).set(i, (byte)1);
                        ++this.sat;
                        continue;
                    }
                    int idx = (int)Math.floor(val) - this.histo.get(0);
                    this.count.set(idx, this.count.get(idx) + 1);
                    this.mean.set(idx, this.mean.get(idx) + (mapval -= (double)this.histo.get(idx)));
                    this.var.set(idx, this.var.get(idx) + mapval * mapval);
                }
            } else {
                for (int i = 0; i < truth.getNumber(); ++i) {
                    double val = Math.floor(((Double1D)truth.as1D().toDouble()).get(i));
                    double mapval = ((Double1D)data.as1D().toDouble()).get(i);
                    if (Double.isNaN(mapval)) {
                        ++this.nans;
                        continue;
                    }
                    if (Double.isInfinite(mapval)) {
                        if (mapval > 0.0) {
                            ++this.posinfs;
                            continue;
                        }
                        ++this.neginfs;
                        continue;
                    }
                    if (mapval == satval) {
                        ++this.sat;
                        continue;
                    }
                    int idx = (int)Math.floor(val) - this.histo.get(0);
                    this.count.set(idx, this.count.get(idx) + 1);
                    this.mean.set(idx, this.mean.get(idx) + (mapval -= (double)this.histo.get(idx)));
                    this.var.set(idx, this.var.get(idx) + mapval * mapval);
                }
            }
        }
        this.computationRequired = true;
        return this;
    }

    public HistoMap update(ShapedVector vec, ShapedVector vec2, ByteArray badpix, double satval) {
        return this.update(ArrayFactory.wrap(vec).toDouble(), ArrayFactory.wrap(vec2).toDouble(), badpix, satval);
    }

    private void compute() {
        double sw = 0.0;
        double swrg = 0.0;
        double swg = 0.0;
        double swg2 = 0.0;
        for (int i = 0; i < this.nbin; ++i) {
            int c = this.count.get(i);
            if (c <= 1) continue;
            sw += (double)(c - 1);
            double g = this.histo.get(i);
            swrg += g * this.var.get(i) * (double)(c - 1);
            swg += g * (double)(c - 1);
            swg2 += g * g * (double)(c - 1);
        }
        this.alpha = Math.max(swrg * sw / (sw * swg2 - swg * swg), 0.0);
        this.beta = Math.max(this.alpha * swg / sw, Double.MIN_VALUE);
    }

    private void updateSize(double tmpmin, double tmpmax) {
        boolean updte = false;
        if (Double.isNaN(this.vmin) || this.vmin > tmpmin) {
            this.vmin = tmpmin;
            updte = true;
        }
        if (Double.isNaN(this.vmax) || this.vmax < tmpmax) {
            this.vmax = tmpmax;
            updte = true;
        }
        if (updte) {
            this.nbin = (int)(Math.ceil(this.vmax) - Math.floor(this.vmin)) + 1;
            if (this.count == null || this.histo == null) {
                this.count = Int1D.create(this.nbin);
                this.mean = Double1D.create(this.nbin);
                this.var = Double1D.create(this.nbin);
                this.histo = Int1D.wrap(IntStream.rangeClosed((int)Math.floor(this.vmin), (int)Math.ceil(this.vmax)).toArray(), this.nbin);
            } else {
                Int1D oldcount = this.count.copy();
                Double1D oldmean = this.mean.copy();
                Double1D oldvar = this.var.copy();
                int first = (int)Math.floor(this.vmin) - this.histo.get(0);
                this.count = Int1D.create(this.nbin);
                this.mean = Double1D.create(this.nbin);
                this.var = Double1D.create(this.nbin);
                this.histo = Int1D.wrap(IntStream.rangeClosed((int)Math.floor(this.vmin), (int)Math.ceil(this.vmax)).toArray(), this.nbin);
                Range rng1 = new Range(first, first + oldcount.getNumber() - 1);
                this.count.view(rng1).assign(oldcount);
                this.mean.view(rng1).assign(oldmean);
                this.var.view(rng1).assign(oldvar);
            }
        }
    }

    private class FloatPrecisionlaw
    implements FloatFunction {
        private FloatPrecisionlaw() {
        }

        @Override
        public float apply(float arg) {
            return (float)(1.0 / (HistoMap.this.alpha * (double)arg + HistoMap.this.beta));
        }
    }

    private class DoublePrecisionlaw
    implements DoubleFunction {
        private DoublePrecisionlaw() {
        }

        @Override
        public double apply(double arg) {
            return 1.0 / (HistoMap.this.alpha * arg + HistoMap.this.beta);
        }
    }
}

