/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.flamingo.common.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.CommandButtonLayoutManager;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.api.common.JCommandToggleMenuButton;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.common.model.ActionButtonModel;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.internal.ui.common.BasicCommandToggleButtonUI;
import org.pushingpixels.flamingo.internal.ui.common.ResizableIconUIResource;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.lafwidget.animation.effects.GhostPaintingUtils;
import org.pushingpixels.lafwidget.animation.effects.GhostingListener;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.ComponentStateFacet;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.flamingo.common.ui.ActionPopupTransitionAwareUI;
import org.pushingpixels.substance.flamingo.utils.CommandButtonBackgroundDelegate;
import org.pushingpixels.substance.flamingo.utils.CommandButtonVisualStateTracker;
import org.pushingpixels.substance.flamingo.utils.SubstanceDisabledResizableIcon;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.utils.ButtonBackgroundDelegate;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.icon.TransitionAware;

public class SubstanceCommandToggleButtonUI
extends BasicCommandToggleButtonUI
implements ActionPopupTransitionAwareUI {
    protected Set lafWidgets;
    protected ButtonBackgroundDelegate backgroundDelegate = new ButtonBackgroundDelegate();
    protected PropertyChangeListener substancePropertyListener;
    private GhostingListener substanceModelChangeListener;
    protected CommandButtonVisualStateTracker substanceVisualStateTracker = new CommandButtonVisualStateTracker();

    protected void __org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleButtonUI__installComponents() {
        super.installComponents();
    }

    @Override
    protected void installComponents() {
        this.__org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleButtonUI__installComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installComponents();
        }
    }

    public void __org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleButtonUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleButtonUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    @Override
    protected void installDefaults() {
        this.__org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleButtonUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void installListeners() {
        this.__org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleButtonUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    protected void uninstallListeners() {
        this.__org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleButtonUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    protected void __org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleButtonUI__uninstallComponents() {
        super.uninstallComponents();
    }

    @Override
    protected void uninstallComponents() {
        this.__org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleButtonUI__uninstallComponents();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallComponents();
        }
    }

    public void __org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleButtonUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.__org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleButtonUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    protected void __org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleButtonUI__uninstallDefaults() {
        super.uninstallDefaults();
    }

    @Override
    protected void uninstallDefaults() {
        this.__org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleButtonUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public void __org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleButtonUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints(graphics2D, jComponent);
        this.__org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleButtonUI__update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceCommandToggleButtonUI();
    }

    protected void __org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleButtonUI__installDefaults() {
        super.installDefaults();
        this.commandButton.putClientProperty("substancelaf.buttonShaper", ClassicButtonShaper.INSTANCE);
        this.commandButton.setOpaque(false);
    }

    @Override
    protected void updateBorder() {
        Border currBorder = this.commandButton.getBorder();
        if (currBorder == null || currBorder instanceof UIResource) {
            Insets extra = SubstanceSizeUtils.getDefaultBorderInsets(SubstanceSizeUtils.getComponentFontSize(this.commandButton));
            double hgapScaleFactor = this.commandButton.getHGapScaleFactor();
            double vgapScaleFactor = this.commandButton.getVGapScaleFactor();
            int top = 1 + (int)(vgapScaleFactor * (double)extra.top);
            int left = 2 + (int)(hgapScaleFactor * (double)(1 + extra.left));
            int bottom = 0 + (int)(vgapScaleFactor * (double)extra.bottom);
            int right = 2 + (int)(hgapScaleFactor * (double)(1 + extra.right));
            this.commandButton.setBorder(new BorderUIResource.EmptyBorderUIResource(top, left, bottom, right));
        }
    }

    protected void __org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleButtonUI__installListeners() {
        super.installListeners();
        this.substanceVisualStateTracker.installListeners(this.commandButton);
        this.substancePropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("model".equals(evt.getPropertyName())) {
                    if (SubstanceCommandToggleButtonUI.this.substanceModelChangeListener != null) {
                        SubstanceCommandToggleButtonUI.this.substanceModelChangeListener.unregisterListeners();
                    }
                    SubstanceCommandToggleButtonUI.this.substanceModelChangeListener = new GhostingListener(SubstanceCommandToggleButtonUI.this.commandButton, SubstanceCommandToggleButtonUI.this.commandButton.getActionModel());
                    SubstanceCommandToggleButtonUI.this.substanceModelChangeListener.registerListeners();
                }
            }
        };
        this.commandButton.addPropertyChangeListener(this.substancePropertyListener);
        this.substanceModelChangeListener = new GhostingListener(this.commandButton, this.commandButton.getActionModel());
        this.substanceModelChangeListener.registerListeners();
    }

    protected void __org__pushingpixels__substance__flamingo__common__ui__SubstanceCommandToggleButtonUI__uninstallListeners() {
        this.substanceVisualStateTracker.uninstallListeners(this.commandButton);
        this.substanceVisualStateTracker = null;
        this.commandButton.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.substanceModelChangeListener.unregisterListeners();
        this.substanceModelChangeListener = null;
        super.uninstallListeners();
    }

    @Override
    protected void paintButtonIcon(Graphics g, Rectangle iconRect) {
        JCommandToggleButton jctb = (JCommandToggleButton)this.commandButton;
        ResizableIcon regular = jctb.getIcon();
        if (this.toUseDisabledIcon() && jctb.getDisabledIcon() != null && regular != null && !regular.getClass().isAnnotationPresent(TransitionAware.class)) {
            regular = jctb.getDisabledIcon();
        }
        boolean useThemed = SubstanceCoreUtilities.useThemedDefaultIcon(this.commandButton);
        if (iconRect == null || regular == null || iconRect.width == 0 || iconRect.height == 0) {
            return;
        }
        if (regular != null) {
            Graphics2D g2d = (Graphics2D)g.create();
            GhostPaintingUtils.paintGhostIcon(g2d, jctb, regular, iconRect);
            g2d.setComposite(LafWidgetUtilities.getAlphaComposite((Component)jctb, g));
            if (!useThemed) {
                regular.paintIcon(jctb, g2d, iconRect.x, iconRect.y);
            } else {
                CommandButtonBackgroundDelegate.paintThemedCommandButtonIcon(g2d, iconRect, jctb, regular, jctb.getActionModel(), this.substanceVisualStateTracker.getPopupStateTransitionTracker());
            }
            g2d.dispose();
        }
    }

    @Override
    protected boolean isPaintingBackground() {
        if (super.isPaintingBackground()) {
            return true;
        }
        return this.getActionTransitionTracker().getFacetStrength(ComponentStateFacet.ROLLOVER) > 0.0f;
    }

    @Override
    protected boolean isPaintingSeparators() {
        return false;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setFont(FlamingoUtilities.getFont(this.commandButton, "Ribbon.font", "Button.font", "Panel.font"));
        this.layoutInfo = this.layoutManager.getLayoutInfo(this.commandButton, g);
        this.commandButton.putClientProperty("icon.bounds", this.layoutInfo.iconRect);
        this.commandButton.putClientProperty("icon", this.commandButton.getIcon());
        if (this.isPaintingBackground()) {
            this.paintButtonBackground(g2d, new Rectangle(0, 0, c.getWidth(), c.getHeight()));
        }
        StateTransitionTracker.ModelStateInfo modelStateInfo = this.substanceVisualStateTracker.getActionStateTransitionTracker().getModelStateInfo();
        Color fgColor = this.getForegroundColor(modelStateInfo);
        if (this.layoutInfo.textLayoutInfoList != null) {
            for (CommandButtonLayoutManager.TextLayoutInfo mainTextLayoutInfo : this.layoutInfo.textLayoutInfoList) {
                if (mainTextLayoutInfo.text == null) continue;
                SubstanceTextUtilities.paintText(g2d, c, mainTextLayoutInfo.textRect, mainTextLayoutInfo.text, -1, g2d.getFont(), fgColor, g2d.getClipBounds());
            }
        }
        if (this.layoutInfo.extraTextLayoutInfoList != null) {
            Color disabledFgColor = SubstanceColorSchemeUtilities.getColorScheme(this.commandButton, ComponentState.DISABLED_UNSELECTED).getForegroundColor();
            float buttonAlpha = SubstanceColorSchemeUtilities.getAlpha(this.commandButton, ComponentState.DISABLED_UNSELECTED);
            if (buttonAlpha < 1.0f) {
                Color bgFillColor = SubstanceColorUtilities.getBackgroundFillColor(this.commandButton);
                disabledFgColor = SubstanceColorUtilities.getInterpolatedColor(disabledFgColor, bgFillColor, buttonAlpha);
            }
            if (modelStateInfo.getCurrModelState().isDisabled()) {
                disabledFgColor = SubstanceColorUtilities.getInterpolatedColor(disabledFgColor, SubstanceColorUtilities.getBackgroundFillColor(c), 0.5);
            }
            for (CommandButtonLayoutManager.TextLayoutInfo extraTextLayoutInfo : this.layoutInfo.extraTextLayoutInfoList) {
                if (extraTextLayoutInfo.text == null) continue;
                SubstanceTextUtilities.paintText(g2d, c, extraTextLayoutInfo.textRect, extraTextLayoutInfo.text, -1, g2d.getFont(), disabledFgColor, g2d.getClipBounds());
            }
        }
        if (this.layoutInfo.iconRect != null) {
            this.paintButtonIcon(g2d, this.layoutInfo.iconRect);
        }
        g2d.dispose();
    }

    protected Color getForegroundColor(StateTransitionTracker.ModelStateInfo modelStateInfo) {
        Color fgColor = this.commandButton.getForeground();
        if (fgColor instanceof UIResource) {
            float buttonAlpha = SubstanceColorSchemeUtilities.getAlpha(this.commandButton, modelStateInfo.getCurrModelState());
            fgColor = SubstanceTextUtilities.getForegroundColor((JComponent)this.commandButton, this.commandButton.getText(), modelStateInfo, buttonAlpha);
        }
        return fgColor;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        AbstractCommandButton button = (AbstractCommandButton)c;
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(button);
        Dimension superPref = super.getPreferredSize(button);
        if (superPref == null) {
            return null;
        }
        if (shaper == null) {
            return superPref;
        }
        if (button.getDisplayState() == CommandButtonDisplayState.MEDIUM && SwingUtilities.getAncestorOfClass(AbstractRibbonBand.class, button) == null) {
            JButton dummy = new JButton(button.getText(), button.getIcon());
            return shaper.getPreferredSize(dummy, superPref);
        }
        return superPref;
    }

    @Override
    protected void paintButtonBackground(Graphics graphics, Rectangle toFill) {
        if (SubstanceCoreUtilities.isButtonNeverPainted(this.commandButton)) {
            return;
        }
        ActionButtonModel actionModel = this.commandButton.getActionModel();
        SubstanceFillPainter fillPainter = SubstanceCoreUtilities.getFillPainter(this.commandButton);
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(this.commandButton);
        boolean ignoreSelections = this.commandButton instanceof JCommandToggleMenuButton;
        BufferedImage fullAlphaBackground = CommandButtonBackgroundDelegate.getFullAlphaBackground(this.commandButton, actionModel, fillPainter, borderPainter, this.commandButton.getWidth(), this.commandButton.getHeight(), this.getActionTransitionTracker(), ignoreSelections);
        StateTransitionTracker.ModelStateInfo modelStateInfo = this.getActionTransitionTracker().getModelStateInfo();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = ignoreSelections ? modelStateInfo.getStateNoSelectionContributionMap() : modelStateInfo.getStateContributionMap();
        boolean isFlat = this.commandButton.isFlat();
        boolean isSpecial = isFlat || !this.commandButton.isEnabled();
        float extraAlpha = 1.0f;
        if (isSpecial) {
            if (isFlat) {
                extraAlpha = 0.0f;
                for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
                    ComponentState activeState = activeEntry.getKey();
                    if (activeState.isDisabled() || activeState == ComponentState.ENABLED) continue;
                    extraAlpha += activeEntry.getValue().getContribution();
                }
            } else {
                ComponentState actionAreaState = ComponentState.getState(actionModel, this.commandButton);
                if (actionAreaState.isDisabled()) {
                    extraAlpha = SubstanceColorSchemeUtilities.getAlpha(this.commandButton, actionAreaState);
                }
            }
        }
        if ((extraAlpha = Math.min(1.0f, extraAlpha)) > 0.0f) {
            Graphics2D g2d = (Graphics2D)graphics.create();
            g2d.setComposite(LafWidgetUtilities.getAlphaComposite(this.commandButton, extraAlpha, graphics));
            g2d.drawImage((Image)fullAlphaBackground, 0, 0, null);
            g2d.dispose();
        }
    }

    @Override
    protected void syncDisabledIcon() {
        ResizableIcon currDisabledIcon = this.commandButton.getDisabledIcon();
        ResizableIcon icon = this.commandButton.getIcon();
        if (currDisabledIcon == null || currDisabledIcon instanceof UIResource && !currDisabledIcon.getClass().isAnnotationPresent(TransitionAware.class)) {
            if (icon != null) {
                this.commandButton.setDisabledIcon(new ResizableIconUIResource(new SubstanceDisabledResizableIcon(icon)));
            } else {
                this.commandButton.setDisabledIcon(null);
            }
        } else if (icon != null) {
            this.commandButton.getDisabledIcon().setDimension(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        }
    }

    @Override
    public StateTransitionTracker getActionTransitionTracker() {
        return this.substanceVisualStateTracker.getActionStateTransitionTracker();
    }

    @Override
    public StateTransitionTracker getPopupTransitionTracker() {
        return this.substanceVisualStateTracker.getPopupStateTransitionTracker();
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.substanceVisualStateTracker.getActionStateTransitionTracker();
    }

    @Override
    public boolean isInside(MouseEvent me) {
        return this.getLayoutInfo().actionClickArea.contains(me.getPoint());
    }
}

