/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.kymographtracker;

import icy.gui.frame.progress.AnnounceFrame;
import icy.main.Icy;
import icy.sequence.Sequence;
import icy.swimmingPool.SwimmingObject;
import icy.util.XMLUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.nchenouard.kymographtracker.ActionPanel;
import plugins.nchenouard.kymographtracker.KymographExtractionResult;
import plugins.nchenouard.kymographtracker.ResultExportPanel;

class ResultImportPanel
extends ActionPanel {
    private static final long serialVersionUID = 2908249721576764010L;
    Sequence selectedSequence;

    public ResultImportPanel() {
        this.description = "Import previous work";
        this.node = new DefaultMutableTreeNode(this.description);
        this.setLayout(new BorderLayout());
        JPanel northPanel = new JPanel(new GridLayout(2, 1));
        this.add((Component)northPanel, "North");
        JEditorPane descriptionPane = new JEditorPane();
        descriptionPane.setContentType("text/html");
        descriptionPane.setEditable(false);
        descriptionPane.setText("Load a .xml file containing kymograph analysis results and which was generated with the 'export results' function.");
        descriptionPane.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        descriptionPane.setEditable(false);
        northPanel.add(descriptionPane);
        JButton importButton = new JButton(this.description);
        importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ResultImportPanel.this.importResults();
            }
        });
        northPanel.add(importButton);
    }

    @Override
    protected void changeSelectedSequence(Sequence sequence) {
        this.selectedSequence = sequence;
    }

    public void importResults() {
        Sequence seq = null;
        if (this.selectedSequence == null) {
            new AnnounceFrame("Need to load a sequence before loading results.");
        } else {
            seq = this.selectedSequence;
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileFilter(new FileFilter(){

                @Override
                public String getDescription() {
                    return "XML file filter";
                }

                @Override
                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    return file.getName().endsWith(".xml");
                }
            });
            fileChooser.setMultiSelectionEnabled(false);
            fileChooser.setFileSelectionMode(0);
            fileChooser.setName("Input xml file selection");
            int returnVal = fileChooser.showOpenDialog(this);
            if (returnVal == 0) {
                File file = fileChooser.getSelectedFile();
                this.loadResultsFromFile(file, seq);
            }
        }
    }

    protected void loadResultsFromFile(File file, Sequence seq) {
        Document document = XMLUtil.loadDocument((File)file);
        Element root = XMLUtil.getRootElement((Document)document);
        if (root == null) {
            throw new IllegalArgumentException("can't find: <root> tag.");
        }
        Element resultsElement = (Element)XMLUtil.getElements((Node)root, (String)ResultExportPanel.KYMOGRAPH_RESULTS).get(0);
        if (resultsElement == null) {
            throw new IllegalArgumentException("can't find: <root><" + ResultExportPanel.KYMOGRAPH_RESULTS + "> tag.");
        }
        ArrayList<KymographExtractionResult> loadedResults = KymographExtractionResult.loadResultsFromXML(resultsElement, seq, file.getParentFile());
        if (loadedResults != null) {
            for (KymographExtractionResult ker : loadedResults) {
                Icy.getMainInterface().getSwimmingPool().add(new SwimmingObject((Object)ker));
            }
        }
    }
}

