/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.kymographtracker.spline;

public class Polynomial
implements Cloneable {
    private double[] coeff;

    public Polynomial(double ... coeff) {
        if (coeff == null) {
            throw new NullPointerException();
        }
        if (coeff.length == 0) {
            throw new IllegalArgumentException("At least one coefficient is needed");
        }
        this.coeff = (double[])coeff.clone();
    }

    public int getDegree() {
        return this.coeff.length - 1;
    }

    public double[] getCoefficients() {
        return (double[])this.coeff.clone();
    }

    public double getCoefficient(int i) {
        return this.coeff[i];
    }

    public void setCoefficients(double ... coeff) {
        if (coeff == null) {
            throw new NullPointerException();
        }
        if (coeff.length == 0) {
            throw new IllegalArgumentException("At least one coefficient is needed");
        }
        this.coeff = (double[])coeff.clone();
    }

    public double evaluate(double x) {
        double res = this.coeff[this.coeff.length - 1];
        for (int i = this.coeff.length - 2; i >= 0; --i) {
            res = this.coeff[i] + x * res;
        }
        return res;
    }

    public double derivative(double x) {
        return this.derivative(x, 1);
    }

    public double derivative(double x, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n < 0");
        }
        if (n == 0) {
            return this.evaluate(x);
        }
        if (n >= this.coeff.length) {
            return 0.0;
        }
        double res = this.getCoeffDer(this.coeff.length - 1, n);
        for (int i = this.coeff.length - 2; i >= n; --i) {
            res = this.getCoeffDer(i, n) + x * res;
        }
        return res;
    }

    public Polynomial derivativePolynomial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n < 0");
        }
        if (n == 0) {
            return this;
        }
        if (n >= this.coeff.length) {
            return new Polynomial(0.0);
        }
        double[] coeffDer = new double[this.coeff.length - n];
        for (int i = this.coeff.length - 1; i >= n; --i) {
            coeffDer[i - n] = this.getCoeffDer(i, n);
        }
        return new Polynomial(coeffDer);
    }

    private double getCoeffDer(int i, int n) {
        double coeffDer = this.coeff[i];
        for (int j = i; j > i - n; --j) {
            coeffDer *= (double)j;
        }
        return coeffDer;
    }

    public double integral(double a, double b) {
        return this.integralA0(b) - this.integralA0(a);
    }

    private double integralA0(double u) {
        int n = this.coeff.length - 1;
        double res = u * this.coeff[n] / (double)(n + 1);
        for (int i = this.coeff.length - 2; i >= 0; --i) {
            res = this.coeff[i] * u / (double)(i + 1) + u * res;
        }
        return res;
    }

    public Polynomial integralPolynomial(double c) {
        double[] coeffInt = new double[this.coeff.length + 1];
        coeffInt[0] = c;
        for (int i = 0; i < this.coeff.length; ++i) {
            coeffInt[i + 1] = this.coeff[i] / (double)(i + 1);
        }
        return new Polynomial(coeffInt);
    }

    public Polynomial clone() {
        Polynomial pol;
        try {
            pol = (Polynomial)super.clone();
        }
        catch (CloneNotSupportedException cne) {
            throw new IllegalStateException("Clone not supported");
        }
        pol.coeff = (double[])this.coeff.clone();
        return pol;
    }
}

