/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.ContrastEnhancer;
import ij.plugin.FFT;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.image.ColorModel;

public class FHT
extends FloatProcessor {
    private boolean isFrequencyDomain;
    private int maxN;
    private float[] C;
    private float[] S;
    private int[] bitrev;
    private float[] tempArr;
    private boolean showProgress = true;
    public boolean quadrantSwapNeeded;
    public ColorProcessor rgb;
    public int originalWidth;
    public int originalHeight;
    public int originalBitDepth;
    public ColorModel originalColorModel;
    public double powerSpectrumMean;
    public static int NO_WINDOW = 0;
    public static int HAMMING = 1;
    public static int HANN = 2;
    public static int FLATTOP = 3;

    public FHT(ImageProcessor ip) {
        this(ip, false);
    }

    public FHT(ImageProcessor ip, boolean isFrequencyDomain) {
        super(ip.getWidth(), ip.getHeight(), (float[])(ip instanceof FloatProcessor ? ip.duplicate().getPixels() : ip.convertToFloat().getPixels()), null);
        this.isFrequencyDomain = isFrequencyDomain;
        this.maxN = this.getWidth();
        this.resetRoi();
    }

    public FHT() {
        super(8, 8);
    }

    public boolean powerOf2Size() {
        int i;
        for (i = 2; i < this.width; i *= 2) {
        }
        return i == this.width && this.width == this.height;
    }

    public void transform() {
        this.transform(false);
    }

    public void inverseTransform() {
        this.transform(true);
    }

    public float[] fourier1D(float[] data, int windowType) {
        int x;
        int size;
        int n = data.length;
        for (size = 2; size < n; size *= 2) {
        }
        float[] y = new float[size];
        System.arraycopy(data, 0, y, 0, n);
        double sum = 0.0;
        if (windowType != NO_WINDOW) {
            x = 0;
            while (x < n) {
                double z = ((double)x + 0.5) * (Math.PI * 2 / (double)n);
                double w = 0.0;
                if (windowType == HAMMING) {
                    w = 0.54 - 0.46 * Math.cos(z);
                } else if (windowType == HANN) {
                    w = 1.0 - Math.cos(z);
                } else if (windowType == FLATTOP) {
                    w = 1.0 - 1.90796 * Math.cos(z) + 1.07349 * Math.cos(2.0 * z) - 0.18199 * Math.cos(3.0 * z);
                } else {
                    throw new IllegalArgumentException("Invalid Fourier Window Type");
                }
                int n2 = x++;
                y[n2] = (float)((double)y[n2] * w);
                sum += w;
            }
        } else {
            sum = n;
        }
        x = 0;
        while (x < n) {
            int n3 = x++;
            y[n3] = (float)((double)y[n3] * (1.0 / sum));
        }
        this.transform1D(y);
        float[] result = new float[size / 2];
        result[0] = (float)Math.sqrt(y[0] * y[0]);
        for (int x2 = 1; x2 < size / 2; ++x2) {
            result[x2] = (float)Math.sqrt(y[x2] * y[x2] + y[size - x2] * y[size - x2]);
        }
        return result;
    }

    public void transform1D(float[] x) {
        int n = x.length;
        if (this.S == null || n != this.maxN) {
            if (!FHT.isPowerOf2(n)) {
                throw new IllegalArgumentException("Not power of 2 length: " + n);
            }
            this.initializeTables(n);
        }
        this.dfht3(x, 0, false, n);
    }

    public void inverseTransform1D(float[] fht) {
        int n = fht.length;
        if (this.S == null || n != this.maxN) {
            if (!FHT.isPowerOf2(n)) {
                throw new IllegalArgumentException("Not power of 2 length: " + n);
            }
            this.initializeTables(n);
        }
        this.dfht3(fht, 0, true, n);
    }

    void transform(boolean inverse) {
        if (!this.powerOf2Size()) {
            throw new IllegalArgumentException("Image not power of 2 size or not square: " + this.width + "x" + this.height);
        }
        this.maxN = this.width;
        if (this.S == null) {
            this.initializeTables(this.maxN);
        }
        float[] fht = (float[])this.getPixels();
        this.rc2DFHT(fht, inverse, this.maxN);
        this.isFrequencyDomain = !inverse;
    }

    void initializeTables(int maxN) {
        if (maxN > 0x40000000) {
            throw new IllegalArgumentException("Too large for FHT:  " + maxN + " >2^30");
        }
        this.makeSinCosTables(maxN);
        this.makeBitReverseTable(maxN);
        this.tempArr = new float[maxN];
    }

    void makeSinCosTables(int maxN) {
        int n = maxN / 4;
        this.C = new float[n];
        this.S = new float[n];
        double theta = 0.0;
        double dTheta = Math.PI * 2 / (double)maxN;
        for (int i = 0; i < n; ++i) {
            this.C[i] = (float)Math.cos(theta);
            this.S[i] = (float)Math.sin(theta);
            theta += dTheta;
        }
    }

    void makeBitReverseTable(int maxN) {
        this.bitrev = new int[maxN];
        int nLog2 = this.log2(maxN);
        for (int i = 0; i < maxN; ++i) {
            this.bitrev[i] = this.bitRevX(i, nLog2);
        }
    }

    public void rc2DFHT(float[] x, boolean inverse, int maxN) {
        int row;
        if (this.S == null) {
            this.initializeTables(maxN);
        }
        for (row = 0; row < maxN; ++row) {
            this.dfht3(x, row * maxN, inverse, maxN);
        }
        this.progress(0.4);
        this.transposeR(x, maxN);
        this.progress(0.5);
        for (row = 0; row < maxN; ++row) {
            this.dfht3(x, row * maxN, inverse, maxN);
        }
        this.progress(0.7);
        this.transposeR(x, maxN);
        this.progress(0.8);
        for (int row2 = 0; row2 <= maxN / 2; ++row2) {
            for (int col = 0; col <= maxN / 2; ++col) {
                int mRow = (maxN - row2) % maxN;
                int mCol = (maxN - col) % maxN;
                float A = x[row2 * maxN + col];
                float B = x[mRow * maxN + col];
                float C = x[row2 * maxN + mCol];
                float D = x[mRow * maxN + mCol];
                float E = (A + D - (B + C)) / 2.0f;
                x[row2 * maxN + col] = A - E;
                x[mRow * maxN + col] = B + E;
                x[row2 * maxN + mCol] = C + E;
                x[mRow * maxN + mCol] = D - E;
            }
        }
        this.progress(0.95);
    }

    void progress(double percent) {
        if (this.showProgress) {
            IJ.showProgress(percent);
        }
    }

    public void dfht3(float[] x, int base, boolean inverse, int maxN) {
        float rt2;
        float rt1;
        int Ad4;
        int Ad3;
        int Ad2;
        int Ad1;
        int gpNum;
        if (this.S == null) {
            this.initializeTables(maxN);
        }
        int Nlog2 = this.log2(maxN);
        this.BitRevRArr(x, base, Nlog2, maxN);
        int gpSize = 2;
        int numGps = maxN / 4;
        for (gpNum = 0; gpNum < numGps; ++gpNum) {
            Ad1 = gpNum * 4;
            Ad2 = Ad1 + 1;
            Ad3 = Ad1 + gpSize;
            Ad4 = Ad2 + gpSize;
            rt1 = x[base + Ad1] + x[base + Ad2];
            rt2 = x[base + Ad1] - x[base + Ad2];
            float rt3 = x[base + Ad3] + x[base + Ad4];
            float rt4 = x[base + Ad3] - x[base + Ad4];
            x[base + Ad1] = rt1 + rt3;
            x[base + Ad2] = rt2 + rt4;
            x[base + Ad3] = rt1 - rt3;
            x[base + Ad4] = rt2 - rt4;
        }
        if (Nlog2 > 2) {
            gpSize = 4;
            int numBfs = 2;
            numGps /= 2;
            for (int stage = 2; stage < Nlog2; ++stage) {
                for (gpNum = 0; gpNum < numGps; ++gpNum) {
                    int Ad0;
                    Ad1 = Ad0 = gpNum * gpSize * 2;
                    Ad2 = Ad1 + gpSize;
                    Ad3 = Ad1 + gpSize / 2;
                    Ad4 = Ad3 + gpSize;
                    rt1 = x[base + Ad1];
                    x[base + Ad1] = x[base + Ad1] + x[base + Ad2];
                    x[base + Ad2] = rt1 - x[base + Ad2];
                    rt1 = x[base + Ad3];
                    x[base + Ad3] = x[base + Ad3] + x[base + Ad4];
                    x[base + Ad4] = rt1 - x[base + Ad4];
                    for (int bfNum = 1; bfNum < numBfs; ++bfNum) {
                        Ad1 = bfNum + Ad0;
                        Ad2 = Ad1 + gpSize;
                        Ad3 = gpSize - bfNum + Ad0;
                        Ad4 = Ad3 + gpSize;
                        int CSAd = bfNum * numGps;
                        rt1 = x[base + Ad2] * this.C[CSAd] + x[base + Ad4] * this.S[CSAd];
                        rt2 = x[base + Ad4] * this.C[CSAd] - x[base + Ad2] * this.S[CSAd];
                        x[base + Ad2] = x[base + Ad1] - rt1;
                        x[base + Ad1] = x[base + Ad1] + rt1;
                        x[base + Ad4] = x[base + Ad3] + rt2;
                        x[base + Ad3] = x[base + Ad3] - rt2;
                    }
                }
                gpSize *= 2;
                numBfs *= 2;
                numGps /= 2;
            }
        }
        if (inverse) {
            for (int i = 0; i < maxN; ++i) {
                x[base + i] = x[base + i] / (float)maxN;
            }
        }
    }

    void transposeR(float[] x, int maxN) {
        for (int r = 0; r < maxN; ++r) {
            for (int c = r; c < maxN; ++c) {
                if (r == c) continue;
                float rTemp = x[r * maxN + c];
                x[r * maxN + c] = x[c * maxN + r];
                x[c * maxN + r] = rTemp;
            }
        }
    }

    int log2(int x) {
        int count = 31;
        while (!this.btst(x, count)) {
            --count;
        }
        return count;
    }

    private boolean btst(int x, int bit) {
        return (x & 1 << bit) != 0;
    }

    void BitRevRArr(float[] x, int base, int bitlen, int maxN) {
        int i;
        for (i = 0; i < maxN; ++i) {
            this.tempArr[i] = x[base + this.bitrev[i]];
        }
        for (i = 0; i < maxN; ++i) {
            x[base + i] = this.tempArr[i];
        }
    }

    private int bitRevX(int x, int bitlen) {
        int temp = 0;
        for (int i = 0; i <= bitlen; ++i) {
            if ((x & 1 << i) == 0) continue;
            temp |= 1 << bitlen - i - 1;
        }
        return temp;
    }

    private int bset(int x, int bit) {
        return x |= 1 << bit;
    }

    public ImageProcessor getPowerSpectrum() {
        ImagePlus imp2;
        float r;
        int col;
        int base;
        int row;
        if (!this.isFrequencyDomain) {
            throw new IllegalArgumentException("Frequency domain image required");
        }
        float min = Float.MAX_VALUE;
        float max = Float.MIN_VALUE;
        float[] fps = new float[this.maxN * this.maxN];
        byte[] ps = new byte[this.maxN * this.maxN];
        float[] fht = (float[])this.getPixels();
        for (row = 0; row < this.maxN; ++row) {
            this.FHTps(row, this.maxN, fht, fps);
            base = row * this.maxN;
            for (col = 0; col < this.maxN; ++col) {
                r = fps[base + col];
                if (r < min) {
                    min = r;
                }
                if (!(r > max)) continue;
                max = r;
            }
        }
        max = (float)Math.log(max);
        if (Float.isNaN(min = (float)Math.log(min)) || max - min > 50.0f) {
            min = max - 50.0f;
        }
        float scale = (float)(253.999 / (double)(max - min));
        for (row = 0; row < this.maxN; ++row) {
            base = row * this.maxN;
            for (col = 0; col < this.maxN; ++col) {
                r = fps[base + col];
                if (Float.isNaN(r = ((float)Math.log(r) - min) * scale) || r < 0.0f) {
                    r = 0.0f;
                }
                ps[base + col] = (byte)(r + 1.0f);
            }
        }
        ByteProcessor ip = new ByteProcessor(this.maxN, this.maxN, ps, null);
        this.swapQuadrants(ip);
        if (FFT.displayRawPS) {
            FloatProcessor ip2 = new FloatProcessor(this.maxN, this.maxN, fps, null);
            this.swapQuadrants(ip2);
            new ImagePlus("PS of " + FFT.fileName, ip2).show();
        }
        if (FFT.displayFHT) {
            FloatProcessor ip3 = new FloatProcessor(this.maxN, this.maxN, fht, null);
            imp2 = new ImagePlus("FHT of " + FFT.fileName, ((ImageProcessor)ip3).duplicate());
            new ContrastEnhancer().stretchHistogram(imp2, 0.1);
            imp2.show();
        }
        if (FFT.displayComplex) {
            ImageStack ct = this.getComplexTransform();
            imp2 = new ImagePlus("Complex of " + FFT.fileName, ct);
            new ContrastEnhancer().stretchHistogram(imp2, 0.1);
            imp2.setProperty("FFT width", "" + this.originalWidth);
            imp2.setProperty("FFT height", "" + this.originalHeight);
            imp2.show();
        }
        return ip;
    }

    void FHTps(int row, int maxN, float[] fht, float[] ps) {
        int base = row * maxN;
        for (int c = 0; c < maxN; ++c) {
            int l = (maxN - row) % maxN * maxN + (maxN - c) % maxN;
            ps[base + c] = (this.sqr(fht[base + c]) + this.sqr(fht[l])) / 2.0f;
        }
    }

    public ImageStack getComplexTransform() {
        if (!this.isFrequencyDomain) {
            throw new IllegalArgumentException("Frequency domain image required");
        }
        float[] fht = (float[])this.getPixels();
        float[] re = new float[this.maxN * this.maxN];
        float[] im = new float[this.maxN * this.maxN];
        for (int i = 0; i < this.maxN; ++i) {
            this.FHTreal(i, this.maxN, fht, re);
            this.FHTimag(i, this.maxN, fht, im);
        }
        this.swapQuadrants(new FloatProcessor(this.maxN, this.maxN, re, null));
        this.swapQuadrants(new FloatProcessor(this.maxN, this.maxN, im, null));
        ImageStack stack = new ImageStack(this.maxN, this.maxN);
        stack.addSlice("Real", re);
        stack.addSlice("Imaginary", im);
        return stack;
    }

    void FHTreal(int row, int maxN, float[] fht, float[] real) {
        int base = row * maxN;
        int offs = (maxN - row) % maxN * maxN;
        for (int c = 0; c < maxN; ++c) {
            real[base + c] = (fht[base + c] + fht[offs + (maxN - c) % maxN]) * 0.5f;
        }
    }

    void FHTimag(int row, int maxN, float[] fht, float[] imag) {
        int base = row * maxN;
        int offs = (maxN - row) % maxN * maxN;
        for (int c = 0; c < maxN; ++c) {
            imag[base + c] = (-fht[base + c] + fht[offs + (maxN - c) % maxN]) * 0.5f;
        }
    }

    ImageProcessor calculateAmplitude(float[] fht, int maxN) {
        float[] amp = new float[maxN * maxN];
        for (int row = 0; row < maxN; ++row) {
            this.amplitude(row, maxN, fht, amp);
        }
        FloatProcessor ip = new FloatProcessor(maxN, maxN, amp, null);
        this.swapQuadrants(ip);
        return ip;
    }

    void amplitude(int row, int maxN, float[] fht, float[] amplitude) {
        int base = row * maxN;
        for (int c = 0; c < maxN; ++c) {
            int l = (maxN - row) % maxN * maxN + (maxN - c) % maxN;
            amplitude[base + c] = (float)Math.sqrt(this.sqr(fht[base + c]) + this.sqr(fht[l]));
        }
    }

    private float sqr(float x) {
        return x * x;
    }

    public void swapQuadrants(ImageProcessor ip) {
        int size = ip.getWidth() / 2;
        ip.setRoi(size, 0, size, size);
        ImageProcessor t1 = ip.crop();
        ip.setRoi(0, size, size, size);
        ImageProcessor t2 = ip.crop();
        ip.insert(t1, 0, size);
        ip.insert(t2, size, 0);
        ip.setRoi(0, 0, size, size);
        t1 = ip.crop();
        ip.setRoi(size, size, size, size);
        t2 = ip.crop();
        ip.insert(t1, size, size);
        ip.insert(t2, 0, 0);
        ip.resetRoi();
    }

    public void swapQuadrants() {
        this.swapQuadrants(this);
    }

    void changeValues(ImageProcessor ip, int v1, int v2, int v3) {
        byte[] pixels = (byte[])ip.getPixels();
        for (int i = 0; i < pixels.length; ++i) {
            int v = pixels[i] & 0xFF;
            if (v < v1 || v > v2) continue;
            pixels[i] = (byte)v3;
        }
    }

    public FHT multiply(FHT fht) {
        return this.multiply(fht, false);
    }

    public FHT conjugateMultiply(FHT fht) {
        return this.multiply(fht, true);
    }

    FHT multiply(FHT fht, boolean conjugate) {
        float[] h1 = (float[])this.getPixels();
        float[] h2 = (float[])fht.getPixels();
        float[] tmp = new float[this.maxN * this.maxN];
        for (int r = 0; r < this.maxN; ++r) {
            int rowMod = (this.maxN - r) % this.maxN;
            for (int c = 0; c < this.maxN; ++c) {
                int colMod = (this.maxN - c) % this.maxN;
                double h2e = (h2[r * this.maxN + c] + h2[rowMod * this.maxN + colMod]) / 2.0f;
                double h2o = (h2[r * this.maxN + c] - h2[rowMod * this.maxN + colMod]) / 2.0f;
                tmp[r * this.maxN + c] = conjugate ? (float)((double)h1[r * this.maxN + c] * h2e - (double)h1[rowMod * this.maxN + colMod] * h2o) : (float)((double)h1[r * this.maxN + c] * h2e + (double)h1[rowMod * this.maxN + colMod] * h2o);
            }
        }
        FHT fht2 = new FHT(new FloatProcessor(this.maxN, this.maxN, tmp, null));
        fht2.isFrequencyDomain = true;
        return fht2;
    }

    public FHT divide(FHT fht) {
        float[] h1 = (float[])this.getPixels();
        float[] h2 = (float[])fht.getPixels();
        float[] out = new float[this.maxN * this.maxN];
        for (int r = 0; r < this.maxN; ++r) {
            int rowMod = (this.maxN - r) % this.maxN;
            for (int c = 0; c < this.maxN; ++c) {
                int colMod = (this.maxN - c) % this.maxN;
                double mag = h2[r * this.maxN + c] * h2[r * this.maxN + c] + h2[rowMod * this.maxN + colMod] * h2[rowMod * this.maxN + colMod];
                if (mag < 1.0E-20) {
                    mag = 1.0E-20;
                }
                double h2e = h2[r * this.maxN + c] + h2[rowMod * this.maxN + colMod];
                double h2o = h2[r * this.maxN + c] - h2[rowMod * this.maxN + colMod];
                double tmp = (double)h1[r * this.maxN + c] * h2e - (double)h1[rowMod * this.maxN + colMod] * h2o;
                out[r * this.maxN + c] = (float)(tmp / mag);
            }
        }
        FHT fht2 = new FHT(new FloatProcessor(this.maxN, this.maxN, out, null));
        fht2.isFrequencyDomain = true;
        return fht2;
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    public FHT getCopy() {
        ImageProcessor ip = super.duplicate();
        FHT fht = new FHT(ip);
        fht.isFrequencyDomain = this.isFrequencyDomain;
        fht.quadrantSwapNeeded = this.quadrantSwapNeeded;
        fht.rgb = this.rgb;
        fht.originalWidth = this.originalWidth;
        fht.originalHeight = this.originalHeight;
        fht.originalBitDepth = this.originalBitDepth;
        fht.originalColorModel = this.originalColorModel;
        fht.powerSpectrumMean = this.powerSpectrumMean;
        return fht;
    }

    public static boolean isPowerOf2(int n) {
        int i;
        for (i = 2; i < n; i *= 2) {
        }
        return i == n;
    }

    @Override
    public String toString() {
        return "FHT, " + this.getWidth() + "x" + this.getHeight() + ", fd=" + this.isFrequencyDomain;
    }
}

