/*
 * Decompiled with CFR 0.152.
 */
package plugins.stef.roi.bloc.convert;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import icy.roi.ROI;
import icy.roi.ROIUtil;
import plugins.adufour.blocks.tools.roi.ROIBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.stef.roi.bloc.RoiBlocks;

public class ROIToEllipse
extends Plugin
implements ROIBlock,
PluginLibrary,
PluginBundled {
    protected final VarROIArray input = new VarROIArray("Roi(s)");
    protected final VarDouble radiusX = new VarDouble("Radius X", 1.0);
    protected final VarDouble radiusY = new VarDouble("Radius Y", 1.0);
    protected final VarROIArray output = new VarROIArray("Ellipse roi(s)");

    public void run() {
        ROI[] rois = (ROI[])this.input.getValue();
        ROI[] result = new ROI[rois != null ? rois.length : 0];
        double rx = this.radiusX.getValue();
        double ry = this.radiusY.getValue();
        try {
            if (rois != null) {
                for (int r = 0; r < rois.length; ++r) {
                    result[r] = ROIUtil.convertToEllipse((ROI)rois[r], (double)rx, (double)ry);
                }
            }
        }
        catch (InterruptedException e) {
            System.err.println("ROIToEllipse process interrupted !");
            this.output.setValue(null);
            return;
        }
        this.output.setValue((Object)result);
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("input", (Var)this.input);
        inputMap.add("radiusX", (Var)this.radiusX);
        inputMap.add("radiuxY", (Var)this.radiusY);
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("output", (Var)this.output);
    }

    public String getMainPluginClassName() {
        return RoiBlocks.class.getName();
    }
}

