/*
 * Decompiled with CFR 0.152.
 */
package plugins.stef.roi.bloc.property;

import icy.plugin.abstract_.Plugin;
import icy.plugin.interface_.PluginBundled;
import icy.plugin.interface_.PluginLibrary;
import icy.roi.ROI;
import icy.type.point.Point5D;
import icy.type.rectangle.Rectangle5D;
import plugins.adufour.blocks.tools.roi.ROIBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarBoolean;
import plugins.adufour.vars.lang.VarDouble;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.stef.roi.bloc.RoiBlocks;

public class SetROIPosition
extends Plugin
implements ROIBlock,
PluginLibrary,
PluginBundled {
    protected VarROIArray roiSet = new VarROIArray("ROI(s)", null);
    protected VarDouble posX = new VarDouble("position X", 0.0);
    protected VarDouble posY = new VarDouble("position Y", 0.0);
    protected VarDouble posZ = new VarDouble("position Z", -1.0);
    protected VarDouble posT = new VarDouble("position T", -1.0);
    protected VarDouble posC = new VarDouble("position C", -1.0);
    protected VarBoolean useCenter = new VarBoolean("Set XYZ Center", false);

    public void run() {
        Point5D.Double pos = new Point5D.Double(this.posX.getValue().doubleValue(), this.posY.getValue().doubleValue(), this.posZ.getValue().doubleValue(), this.posT.getValue().doubleValue(), this.posC.getValue().doubleValue());
        for (ROI roi : this.roiSet) {
            if (roi == null || !roi.canSetPosition()) continue;
            if (((Boolean)this.useCenter.getValue()).booleanValue()) {
                Rectangle5D bounds = roi.getBounds5D();
                Point5D.Double newPos = (Point5D.Double)pos.clone();
                newPos.setX(pos.getX() - bounds.getSizeX() / 2.0);
                newPos.setY(pos.getY() - bounds.getSizeY() / 2.0);
                newPos.setZ(pos.getZ() - bounds.getSizeZ() / 2.0);
                roi.setPosition5D((Point5D)newPos);
                continue;
            }
            roi.setPosition5D((Point5D)pos);
        }
    }

    public void declareInput(VarList inputMap) {
        inputMap.add("rois", (Var)this.roiSet);
        inputMap.add("posX", (Var)this.posX);
        inputMap.add("posY", (Var)this.posY);
        inputMap.add("posZ", (Var)this.posZ);
        inputMap.add("posT", (Var)this.posT);
        inputMap.add("posC", (Var)this.posC);
        inputMap.add("useXYZCenter", (Var)this.useCenter);
    }

    public void declareOutput(VarList outputMap) {
    }

    public String getMainPluginClassName() {
        return RoiBlocks.class.getName();
    }
}

