/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d.processing;

import ij.IJ;
import java.util.LinkedList;
import mcib3d.geom.IntCoord3D;
import mcib3d.image3d.Coordinate3D;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageShort;
import mcib3d.utils.ThreadRunner;
import mcib3d.utils.exceptionPrinter;

public class FillHoles3D {
    public static void process(ImageHandler mask, int foregroundValue, int nbCPUs, boolean verbose) {
        if (mask instanceof ImageByte) {
            FillHoles3D.process((ImageByte)mask, foregroundValue, nbCPUs, verbose);
        } else if (mask instanceof ImageShort) {
            FillHoles3D.process((ImageShort)mask, foregroundValue, nbCPUs, verbose);
        } else {
            IJ.log((String)("Cannot perform Fillholes 3D on image type" + mask.getType()));
        }
    }

    public static void process(ImageByte mask, int foregroundValue, int nbCPUs, boolean verbose) {
        final byte[][] pixels = mask.pixels;
        final int sizeX = mask.sizeX;
        final int sizeZ = mask.sizeZ;
        final int sizeY = mask.sizeY;
        int sizeXY = mask.sizeXY;
        final byte fgValue = (byte)foregroundValue;
        int mid = foregroundValue > 1 ? foregroundValue - 1 : foregroundValue + 1;
        final byte midValue = (byte)mid;
        final ThreadRunner tr = new ThreadRunner(0, sizeY, nbCPUs);
        for (int i = 0; i < tr.threads.length; ++i) {
            tr.threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int idx = tr.ai.getAndIncrement();
                    while (idx < tr.end) {
                        try {
                            int offsetY = sizeX * idx;
                            for (int x = 0; x < sizeX; ++x) {
                                int z;
                                for (z = 0; z < sizeZ && pixels[z][x + offsetY] == 0; ++z) {
                                    pixels[z][x + offsetY] = midValue;
                                }
                                if (z >= sizeZ - 1) continue;
                                for (z = sizeZ - 1; z >= 0 && pixels[z][x + offsetY] == 0; --z) {
                                    pixels[z][x + offsetY] = midValue;
                                }
                            }
                        }
                        catch (Exception e) {
                            exceptionPrinter.print(e, "fillHoles 3D Z:" + idx + "::error::", true);
                        }
                        idx = tr.ai.getAndIncrement();
                    }
                }
            });
        }
        tr.startAndJoin();
        final ThreadRunner tr2 = new ThreadRunner(0, sizeZ, nbCPUs);
        for (int i = 0; i < tr2.threads.length; ++i) {
            tr2.threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int idx = tr2.ai.getAndIncrement();
                    while (idx < tr2.end) {
                        try {
                            for (int y = 0; y < sizeY; ++y) {
                                byte value;
                                int x;
                                int offsetY = sizeX * y;
                                boolean bcg = pixels[idx][offsetY] == 0;
                                for (x = 0; x < sizeX; ++x) {
                                    value = pixels[idx][offsetY + x];
                                    if (value == fgValue) {
                                        bcg = false;
                                        continue;
                                    }
                                    if (value == 0 && bcg) {
                                        pixels[idx][offsetY + x] = midValue;
                                        continue;
                                    }
                                    if (value != midValue) continue;
                                    bcg = true;
                                }
                                bcg = pixels[idx][offsetY + sizeX - 1] == 0;
                                for (x = sizeX - 1; x >= 0; --x) {
                                    value = pixels[idx][offsetY + x];
                                    if (value == fgValue) {
                                        bcg = false;
                                        continue;
                                    }
                                    if (value == 0 && bcg) {
                                        pixels[idx][offsetY + x] = midValue;
                                        continue;
                                    }
                                    if (value != midValue) continue;
                                    bcg = true;
                                }
                            }
                        }
                        catch (Exception e) {
                            exceptionPrinter.print(e, "fillHoles 3D Y:" + idx + "::error::", true);
                        }
                        idx = tr2.ai.getAndIncrement();
                    }
                }
            });
        }
        tr2.startAndJoin();
        final ThreadRunner tr3 = new ThreadRunner(0, sizeZ, nbCPUs);
        for (int i = 0; i < tr3.threads.length; ++i) {
            tr3.threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int idx = tr3.ai.getAndIncrement();
                    while (idx < tr3.end) {
                        try {
                            for (int x = 0; x < sizeX; ++x) {
                                byte value;
                                int y;
                                boolean bcg = pixels[idx][x] == 0;
                                for (y = 0; y < sizeY; ++y) {
                                    value = pixels[idx][y * sizeX + x];
                                    if (value == fgValue) {
                                        bcg = false;
                                        continue;
                                    }
                                    if (value == 0 && bcg) {
                                        pixels[idx][y * sizeX + x] = midValue;
                                        continue;
                                    }
                                    if (value != midValue) continue;
                                    bcg = true;
                                }
                                bcg = pixels[idx][(sizeY - 1) * sizeX + x] == 0;
                                for (y = sizeY - 1; y >= 0; --y) {
                                    value = pixels[idx][y * sizeX + x];
                                    if (value == fgValue) {
                                        bcg = false;
                                        continue;
                                    }
                                    if (value == 0 && bcg) {
                                        pixels[idx][y * sizeX + x] = midValue;
                                        continue;
                                    }
                                    if (value != midValue) continue;
                                    bcg = true;
                                }
                            }
                        }
                        catch (Exception e) {
                            exceptionPrinter.print(e, "fillHoles 3D X:" + idx + "::error::", true);
                        }
                        idx = tr3.ai.getAndIncrement();
                    }
                }
            });
        }
        tr3.startAndJoin();
        LinkedList<IntCoord3D> heap = new LinkedList<IntCoord3D>();
        for (int z = 0; z < sizeZ; ++z) {
            for (int y = 0; y < sizeY; ++y) {
                for (int x = 0; x < sizeX; ++x) {
                    if (pixels[z][x + sizeX * y] != 0 || !FillHoles3D.checkVoxel(pixels, x, y, z, sizeX, sizeY, sizeZ, midValue)) continue;
                    heap.add(new IntCoord3D(x, y, z));
                }
            }
        }
        while (!heap.isEmpty()) {
            IntCoord3D c = (IntCoord3D)heap.remove();
            if (c.z < 0 || c.z >= sizeZ || c.x + c.y * sizeX < 0 || c.x + c.y * sizeX >= sizeXY) {
                IJ.log((String)("souci " + c));
            }
            if (pixels[c.z][c.x + c.y * sizeX] != 0) continue;
            pixels[c.z][c.x + c.y * sizeX] = midValue;
            if (c.z > 0 && pixels[c.z - 1][c.x + c.y * sizeX] == 0) {
                heap.add(new IntCoord3D(c.x, c.y, c.z - 1));
            }
            if (c.z < sizeZ - 1 && pixels[c.z + 1][c.x + c.y * sizeX] == 0) {
                heap.add(new IntCoord3D(c.x, c.y, c.z + 1));
            }
            if (c.x > 0 && pixels[c.z][c.x - 1 + c.y * sizeX] == 0) {
                heap.add(new IntCoord3D(c.x - 1, c.y, c.z));
            }
            if (c.x < sizeX - 1 && pixels[c.z][c.x + 1 + c.y * sizeX] == 0) {
                heap.add(new IntCoord3D(c.x + 1, c.y, c.z));
            }
            if (c.y > 0 && pixels[c.z][c.x + (c.y - 1) * sizeX] == 0) {
                heap.add(new IntCoord3D(c.x, c.y - 1, c.z));
            }
            if (c.y >= sizeY - 1 || pixels[c.z][c.x + (c.y + 1) * sizeX] != 0) continue;
            heap.add(new IntCoord3D(c.x, c.y + 1, c.z));
        }
        final ThreadRunner tr4 = new ThreadRunner(0, sizeZ, nbCPUs);
        for (int i = 0; i < tr4.threads.length; ++i) {
            tr4.threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int idx = tr4.ai.getAndIncrement();
                    while (idx < tr4.end) {
                        try {
                            for (int xy = 0; xy < sizeX * sizeY; ++xy) {
                                if (pixels[idx][xy] == midValue) {
                                    pixels[idx][xy] = 0;
                                    continue;
                                }
                                if (pixels[idx][xy] != 0) continue;
                                pixels[idx][xy] = fgValue;
                            }
                        }
                        catch (Exception e) {
                            exceptionPrinter.print(e, "fillHoles 3D final step:" + idx + "::error::", true);
                        }
                        idx = tr4.ai.getAndIncrement();
                    }
                }
            });
        }
        tr4.startAndJoin();
    }

    private static boolean checkVoxel(byte[][] pixels, int x, int y, int z, int sizeX, int sizeY, int sizeZ, byte midValue) {
        if (z > 0 && pixels[z - 1][x + y * sizeX] == midValue) {
            return true;
        }
        if (z < sizeZ - 1 && pixels[z + 1][x + y * sizeX] == midValue) {
            return true;
        }
        if (x > 0 && pixels[z][x - 1 + y * sizeX] == midValue) {
            return true;
        }
        if (x < sizeX - 1 && pixels[z][x + 1 + y * sizeX] == midValue) {
            return true;
        }
        if (y > 0 && pixels[z][x + (y - 1) * sizeX] == midValue) {
            return true;
        }
        return y < sizeY - 1 && pixels[z][x + (y + 1) * sizeX] == midValue;
    }

    public static void process(ImageShort mask, int foregroundValue, int nbCPUs, boolean verbose) {
        final short[][] pixels = mask.pixels;
        final int sizeX = mask.sizeX;
        final int sizeZ = mask.sizeZ;
        final int sizeY = mask.sizeY;
        int sizeXY = mask.sizeXY;
        final short fgValue = (short)foregroundValue;
        int mid = foregroundValue > 1 ? foregroundValue - 1 : foregroundValue + 1;
        final short midValue = (short)mid;
        final ThreadRunner tr = new ThreadRunner(0, sizeY, nbCPUs);
        for (int i = 0; i < tr.threads.length; ++i) {
            tr.threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int idx = tr.ai.getAndIncrement();
                    while (idx < tr.end) {
                        try {
                            int offsetY = sizeX * idx;
                            for (int x = 0; x < sizeX; ++x) {
                                int z;
                                for (z = 0; z < sizeZ && pixels[z][x + offsetY] == 0; ++z) {
                                    pixels[z][x + offsetY] = midValue;
                                }
                                if (z >= sizeZ - 1) continue;
                                for (z = sizeZ - 1; z >= 0 && pixels[z][x + offsetY] == 0; --z) {
                                    pixels[z][x + offsetY] = midValue;
                                }
                            }
                        }
                        catch (Exception e) {
                            exceptionPrinter.print(e, "fillHoles 3D Z:" + idx + "::error::", true);
                        }
                        idx = tr.ai.getAndIncrement();
                    }
                }
            });
        }
        tr.startAndJoin();
        final ThreadRunner tr2 = new ThreadRunner(0, sizeZ, nbCPUs);
        for (int i = 0; i < tr2.threads.length; ++i) {
            tr2.threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int idx = tr2.ai.getAndIncrement();
                    while (idx < tr2.end) {
                        try {
                            for (int y = 0; y < sizeY; ++y) {
                                short value;
                                int x;
                                int offsetY = sizeX * y;
                                boolean bcg = pixels[idx][offsetY] == 0;
                                for (x = 0; x < sizeX; ++x) {
                                    value = pixels[idx][offsetY + x];
                                    if (value == fgValue) {
                                        bcg = false;
                                        continue;
                                    }
                                    if (value == 0 && bcg) {
                                        pixels[idx][offsetY + x] = midValue;
                                        continue;
                                    }
                                    if (value != midValue) continue;
                                    bcg = true;
                                }
                                bcg = pixels[idx][offsetY + sizeX - 1] == 0;
                                for (x = sizeX - 1; x >= 0; --x) {
                                    value = pixels[idx][offsetY + x];
                                    if (value == fgValue) {
                                        bcg = false;
                                        continue;
                                    }
                                    if (value == 0 && bcg) {
                                        pixels[idx][offsetY + x] = midValue;
                                        continue;
                                    }
                                    if (value != midValue) continue;
                                    bcg = true;
                                }
                            }
                        }
                        catch (Exception e) {
                            exceptionPrinter.print(e, "fillHoles 3D Y:" + idx + "::error::", true);
                        }
                        idx = tr2.ai.getAndIncrement();
                    }
                }
            });
        }
        tr2.startAndJoin();
        final ThreadRunner tr3 = new ThreadRunner(0, sizeZ, nbCPUs);
        for (int i = 0; i < tr3.threads.length; ++i) {
            tr3.threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int idx = tr3.ai.getAndIncrement();
                    while (idx < tr3.end) {
                        try {
                            for (int x = 0; x < sizeX; ++x) {
                                short value;
                                int y;
                                boolean bcg = pixels[idx][x] == 0;
                                for (y = 0; y < sizeY; ++y) {
                                    value = pixels[idx][y * sizeX + x];
                                    if (value == fgValue) {
                                        bcg = false;
                                        continue;
                                    }
                                    if (value == 0 && bcg) {
                                        pixels[idx][y * sizeX + x] = midValue;
                                        continue;
                                    }
                                    if (value != midValue) continue;
                                    bcg = true;
                                }
                                bcg = pixels[idx][(sizeY - 1) * sizeX + x] == 0;
                                for (y = sizeY - 1; y >= 0; --y) {
                                    value = pixels[idx][y * sizeX + x];
                                    if (value == fgValue) {
                                        bcg = false;
                                        continue;
                                    }
                                    if (value == 0 && bcg) {
                                        pixels[idx][y * sizeX + x] = midValue;
                                        continue;
                                    }
                                    if (value != midValue) continue;
                                    bcg = true;
                                }
                            }
                        }
                        catch (Exception e) {
                            exceptionPrinter.print(e, "fillHoles 3D X:" + idx + "::error::", true);
                        }
                        idx = tr3.ai.getAndIncrement();
                    }
                }
            });
        }
        tr3.startAndJoin();
        LinkedList<Integer> heap = new LinkedList<Integer>();
        for (int z = 0; z < sizeZ; ++z) {
            for (int y = 0; y < sizeY; ++y) {
                for (int x = 0; x < sizeX; ++x) {
                    if (pixels[z][x + sizeX * y] != 0 || !FillHoles3D.checkVoxel(pixels, x, y, z, sizeX, sizeY, sizeZ, midValue)) continue;
                    heap.add(x + y * sizeX + z * sizeXY);
                }
            }
        }
        Coordinate3D c = new Coordinate3D(0, sizeX, sizeY, sizeZ);
        while (!heap.isEmpty()) {
            int coord = (Integer)heap.remove();
            c.setCoord(coord);
            if (pixels[c.z][c.x + c.y * sizeX] != 0) continue;
            pixels[c.z][c.x + c.y * sizeX] = midValue;
            if (c.z > 0 && pixels[c.z - 1][c.x + c.y * sizeX] == 0) {
                heap.add(coord - sizeXY);
            }
            if (c.z < sizeZ - 1 && pixels[c.z + 1][c.x + c.y * sizeX] == 0) {
                heap.add(coord + sizeXY);
            }
            if (c.x > 0 && pixels[c.z][c.x - 1 + c.y * sizeX] == 0) {
                heap.add(coord - 1);
            }
            if (c.x < sizeX - 1 && pixels[c.z][c.x + 1 + c.y * sizeX] == 0) {
                heap.add(coord + 1);
            }
            if (c.y > 0 && pixels[c.z][c.x + (c.y - 1) * sizeX] == 0) {
                heap.add(coord - sizeX);
            }
            if (c.y >= sizeY - 1 || pixels[c.z][c.x + (c.y + 1) * sizeX] != 0) continue;
            heap.add(coord + sizeX);
        }
        final ThreadRunner tr4 = new ThreadRunner(0, sizeZ, nbCPUs);
        for (int i = 0; i < tr4.threads.length; ++i) {
            tr4.threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int idx = tr4.ai.getAndIncrement();
                    while (idx < tr4.end) {
                        try {
                            for (int xy = 0; xy < sizeX * sizeY; ++xy) {
                                if (pixels[idx][xy] == midValue) {
                                    pixels[idx][xy] = 0;
                                    continue;
                                }
                                if (pixels[idx][xy] != 0) continue;
                                pixels[idx][xy] = fgValue;
                            }
                        }
                        catch (Exception e) {
                            exceptionPrinter.print(e, "fillHoles 3D final step:" + idx + "::error::", true);
                        }
                        idx = tr4.ai.getAndIncrement();
                    }
                }
            });
        }
        tr4.startAndJoin();
    }

    private static boolean checkVoxel(short[][] pixels, int x, int y, int z, int sizeX, int sizeY, int sizeZ, short midValue) {
        if (z > 0 && pixels[z - 1][x + y * sizeX] == midValue) {
            return true;
        }
        if (z < sizeZ - 1 && pixels[z + 1][x + y * sizeX] == midValue) {
            return true;
        }
        if (x > 0 && pixels[z][x - 1 + y * sizeX] == midValue) {
            return true;
        }
        if (x < sizeX - 1 && pixels[z][x + 1 + y * sizeX] == midValue) {
            return true;
        }
        if (y > 0 && pixels[z][x + (y - 1) * sizeX] == midValue) {
            return true;
        }
        return y < sizeY - 1 && pixels[z][x + (y + 1) * sizeX] == midValue;
    }
}

