/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.frame;

import icy.action.IcyAbstractAction;
import icy.common.MenuCallback;
import icy.gui.frame.IcyExternalFrame;
import icy.gui.frame.IcyFrameEvent;
import icy.gui.frame.IcyFrameListener;
import icy.gui.frame.IcyInternalFrame;
import icy.gui.main.IcyDesktopPane;
import icy.gui.main.MainFrame;
import icy.gui.util.ComponentUtil;
import icy.main.Icy;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.system.thread.ThreadUtil;
import icy.util.StringUtil;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class IcyFrame
implements InternalFrameListener,
WindowListener,
ImageObserver,
PropertyChangeListener {
    static ArrayList<IcyFrame> frames = new ArrayList();
    protected IcyExternalFrame externalFrame;
    protected IcyInternalFrame internalFrame;
    protected IcyFrameState state;
    protected boolean syncProcess;
    protected EventListenerList frameEventListeners;
    protected MenuCallback defaultSystemMenuCallback;
    protected SwitchStateAction switchStateAction;
    protected boolean switchStateItemVisible;
    protected IcyFrameState previousState;
    protected final boolean headless = Icy.getMainInterface().isHeadLess();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<IcyFrame> getAllFrames() {
        ArrayList<IcyFrame> arrayList = frames;
        synchronized (arrayList) {
            return new ArrayList<IcyFrame>(frames);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<IcyFrame> getAllFrames(Class<?> frameClass) {
        ArrayList<IcyFrame> result = new ArrayList<IcyFrame>();
        if (frameClass != null) {
            ArrayList<IcyFrame> arrayList = frames;
            synchronized (arrayList) {
                for (IcyFrame frame : frames) {
                    if (!frameClass.isInstance(frame)) continue;
                    result.add(frame);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IcyFrame findIcyFrame(JInternalFrame frame) {
        ArrayList<IcyFrame> arrayList = frames;
        synchronized (arrayList) {
            for (IcyFrame f : frames) {
                if (f.getInternalFrame() != frame) continue;
                return f;
            }
            return null;
        }
    }

    public IcyFrame() {
        this("", false, true, false, false, true);
    }

    public IcyFrame(String title) {
        this(title, false, true, false, false, true);
    }

    public IcyFrame(String title, boolean resizable) {
        this(title, resizable, true, false, false, true);
    }

    public IcyFrame(String title, boolean resizable, boolean closable) {
        this(title, resizable, closable, false, false, true);
    }

    public IcyFrame(String title, boolean resizable, boolean closable, boolean maximizable) {
        this(title, resizable, closable, maximizable, false, true);
    }

    public IcyFrame(String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable) {
        this(title, resizable, closable, maximizable, iconifiable, true);
    }

    public IcyFrame(final String title, final boolean resizable, final boolean closable, final boolean maximizable, final boolean iconifiable, boolean waitCreate) {
        if (this.headless) {
            return;
        }
        this.frameEventListeners = new EventListenerList();
        this.defaultSystemMenuCallback = new MenuCallback(){

            public JMenu getMenu() {
                return IcyFrame.this.getDefaultSystemMenu();
            }
        };
        this.syncProcess = false;
        this.state = this.canBeInternalized() ? IcyFrameState.INTERNALIZED : IcyFrameState.EXTERNALIZED;
        this.switchStateItemVisible = true;
        this.previousState = IcyFrameState.INTERNALIZED;
        this.switchStateAction = new SwitchStateAction();
        this.switchStateAction.setEnabled(this.canBeInternalized());
        ThreadUtil.invoke(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IcyFrame.this.externalFrame = IcyFrame.this.createExternalFrame(title);
                IcyFrame.this.externalFrame.addWindowListener((WindowListener)IcyFrame.this);
                IcyFrame.this.externalFrame.setLocationRelativeTo(null);
                IcyFrame.this.externalFrame.setResizable(resizable);
                IcyFrame.this.externalFrame.setDefaultCloseOperation(2);
                IcyFrame.this.externalFrame.setSize(480, 400);
                IcyFrame.this.internalFrame = IcyFrame.this.createInternalFrame(title, resizable, closable, maximizable, iconifiable);
                IcyFrame.this.internalFrame.addInternalFrameListener((InternalFrameListener)IcyFrame.this);
                IcyFrame.this.internalFrame.setSize(480, 400);
                IcyFrame.this.externalFrame.setSystemMenuCallback(IcyFrame.this.defaultSystemMenuCallback);
                IcyFrame.this.internalFrame.setSystemMenuCallback(IcyFrame.this.defaultSystemMenuCallback);
                ArrayList<IcyFrame> arrayList = frames;
                synchronized (arrayList) {
                    frames.add(IcyFrame.this);
                }
            }
        }, waitCreate);
        MainFrame mainFrame = Icy.getMainInterface().getMainFrame();
        if (mainFrame != null) {
            mainFrame.addPropertyChangeListener("detachedMode", (PropertyChangeListener)this);
        }
    }

    protected IcyExternalFrame createExternalFrame(String title) {
        return new IcyExternalFrame(title);
    }

    protected IcyInternalFrame createInternalFrame(String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable) {
        return new IcyInternalFrame(title, resizable, closable, maximizable, iconifiable);
    }

    protected boolean canBeInternalized() {
        MainFrame frame = Icy.getMainInterface().getMainFrame();
        if (frame != null) {
            return !frame.isDetachedMode();
        }
        return false;
    }

    public void updateSystemMenu() {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                if (IcyFrame.this.isInternalized()) {
                    IcyFrame.this.internalFrame.updateSystemMenu();
                } else {
                    IcyFrame.this.externalFrame.updateSystemMenu();
                }
            }
        }, this.syncProcess);
    }

    public void close() {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                IcyFrame.this.internalFrame.close(true);
                IcyFrame.this.externalFrame.close();
            }
        }, this.syncProcess);
    }

    public void dispose() {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                if (IcyFrame.this.isInternalized()) {
                    IcyFrame.this.internalFrame.dispose();
                } else {
                    IcyFrame.this.externalFrame.dispose();
                }
            }
        }, this.syncProcess);
    }

    public void switchState() {
        if (this.isInternalized()) {
            this.detach();
        } else {
            this.attach();
        }
    }

    public void internalize() {
        if (this.isExternalized()) {
            this.attach();
        }
    }

    public void externalize() {
        if (this.isInternalized()) {
            this.detach();
        }
    }

    public void attach() {
        if (this.headless) {
            return;
        }
        if (this.isInternalized() || !this.canBeInternalized()) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                boolean visible = IcyFrame.this.externalFrame.isVisible();
                if (visible) {
                    IcyFrame.this.externalFrame.setVisible(false);
                }
                JMenuBar menuBar = IcyFrame.this.externalFrame.getJMenuBar();
                Container content = IcyFrame.this.externalFrame.getContentPane();
                IcyFrame.this.externalFrame.setJMenuBar(null);
                IcyFrame.this.externalFrame.setContentPane((Container)new JPanel());
                IcyFrame.this.externalFrame.validate();
                IcyFrame.this.internalFrame.setJMenuBar(menuBar);
                IcyFrame.this.internalFrame.setContentPane(content);
                IcyFrame.this.internalFrame.validate();
                if (visible) {
                    IcyFrame.this.internalFrame.setVisible(true);
                    try {
                        IcyFrame.this.internalFrame.setSelected(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
                IcyFrame.this.state = IcyFrameState.INTERNALIZED;
                IcyFrame.this.stateChanged();
            }
        }, this.syncProcess);
    }

    public void detach() {
        if (this.headless) {
            return;
        }
        if (this.isExternalized()) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                boolean visible = IcyFrame.this.internalFrame.isVisible();
                if (visible) {
                    IcyFrame.this.internalFrame.setVisible(false);
                }
                JMenuBar menuBar = IcyFrame.this.internalFrame.getJMenuBar();
                Container content = IcyFrame.this.internalFrame.getContentPane();
                IcyFrame.this.internalFrame.setJMenuBar(null);
                IcyFrame.this.internalFrame.setContentPane((Container)new JPanel());
                IcyFrame.this.internalFrame.validate();
                IcyFrame.this.externalFrame.setJMenuBar(menuBar);
                IcyFrame.this.externalFrame.setContentPane(content);
                IcyFrame.this.externalFrame.validate();
                if (visible) {
                    IcyFrame.this.externalFrame.setVisible(true);
                    IcyFrame.this.externalFrame.requestFocus();
                }
                IcyFrame.this.state = IcyFrameState.EXTERNALIZED;
                IcyFrame.this.stateChanged();
            }
        }, this.syncProcess);
    }

    public void stateChanged() {
        if (this.headless) {
            return;
        }
        this.switchStateAction.refreshState();
        this.updateSystemMenu();
        if (this.isInternalized()) {
            this.fireFrameInternalized(new IcyFrameEvent(this, null, null));
        } else {
            this.fireFrameExternalized(new IcyFrameEvent(this, null, null));
        }
    }

    public void center() {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                if (IcyFrame.this.isInternalized()) {
                    ComponentUtil.center((JInternalFrame)IcyFrame.this.internalFrame);
                } else {
                    ComponentUtil.center((Window)IcyFrame.this.externalFrame);
                }
            }
        }, this.syncProcess);
    }

    public void addTo(final Container c) {
        if (this.headless) {
            return;
        }
        if (this.isInternalized()) {
            ThreadUtil.invoke(new Runnable(){

                @Override
                public void run() {
                    c.add((Component)IcyFrame.this.internalFrame);
                }
            }, this.syncProcess);
        }
    }

    public void addTo(final Container c, final int index) {
        if (this.headless) {
            return;
        }
        if (this.isInternalized()) {
            ThreadUtil.invoke(new Runnable(){

                @Override
                public void run() {
                    c.add((Component)IcyFrame.this.internalFrame, index);
                }
            }, this.syncProcess);
        }
    }

    @Deprecated
    public void addTo(final Container c, final Object constraints) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                c.add((Component)IcyFrame.this.internalFrame, constraints);
            }
        }, this.syncProcess);
    }

    public void addToDesktopPane(final Object constraints) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                IcyDesktopPane desktop = Icy.getMainInterface().getDesktopPane();
                if (desktop != null) {
                    desktop.add((Component)IcyFrame.this.internalFrame, constraints);
                }
            }
        }, this.syncProcess);
    }

    public void addToDesktopPane() {
        if (this.headless) {
            return;
        }
        this.addToDesktopPane(JLayeredPane.DEFAULT_LAYER);
    }

    @Deprecated
    public void addToMainDesktopPane() {
        this.addToDesktopPane();
    }

    public void add(final Component comp) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                if (IcyFrame.this.isInternalized()) {
                    IcyFrame.this.internalFrame.add(comp);
                } else {
                    IcyFrame.this.externalFrame.add(comp);
                }
            }
        }, this.syncProcess);
    }

    public void add(final Component comp, final Object constraints) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                if (IcyFrame.this.isInternalized()) {
                    IcyFrame.this.internalFrame.add(comp, constraints);
                } else {
                    IcyFrame.this.externalFrame.add(comp, constraints);
                }
            }
        }, this.syncProcess);
    }

    public void add(final String name, final Component comp) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                if (IcyFrame.this.isInternalized()) {
                    IcyFrame.this.internalFrame.add(name, comp);
                } else {
                    IcyFrame.this.externalFrame.add(name, comp);
                }
            }
        }, this.syncProcess);
    }

    public void removeFrom(final Container c) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                c.remove((Component)IcyFrame.this.internalFrame);
            }
        }, this.syncProcess);
    }

    public void removeAll() {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                if (IcyFrame.this.isInternalized()) {
                    IcyFrame.this.internalFrame.removeAll();
                } else {
                    IcyFrame.this.externalFrame.removeAll();
                }
            }
        }, this.syncProcess);
    }

    public void remove(final Component comp) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                if (IcyFrame.this.isInternalized()) {
                    IcyFrame.this.internalFrame.remove(comp);
                } else {
                    IcyFrame.this.externalFrame.remove(comp);
                }
            }
        }, this.syncProcess);
    }

    public void removeFromMainDesktopPane() {
        if (this.headless) {
            return;
        }
        this.removeFrom((Container)Icy.getMainInterface().getDesktopPane());
    }

    public void toFront() {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                if (IcyFrame.this.isInternalized()) {
                    IcyFrame.this.internalFrame.toFront();
                } else {
                    IcyFrame.this.externalFrame.toFront();
                }
            }
        }, this.syncProcess);
    }

    public void toBack() {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                if (IcyFrame.this.isInternalized()) {
                    IcyFrame.this.internalFrame.toBack();
                } else {
                    IcyFrame.this.externalFrame.toBack();
                }
            }
        }, this.syncProcess);
    }

    public void pack() {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                if (IcyFrame.this.isInternalized()) {
                    IcyFrame.this.internalFrame.pack();
                } else {
                    IcyFrame.this.externalFrame.pack();
                }
            }
        }, this.syncProcess);
    }

    public Container getFrame() {
        if (this.headless) {
            return null;
        }
        if (this.isInternalized()) {
            return this.internalFrame;
        }
        return this.externalFrame;
    }

    public IcyInternalFrame getIcyInternalFrame() {
        return this.internalFrame;
    }

    public IcyExternalFrame getIcyExternalFrame() {
        return this.externalFrame;
    }

    public JInternalFrame getInternalFrame() {
        return this.internalFrame;
    }

    public JFrame getExternalFrame() {
        return this.externalFrame;
    }

    public void setSwitchStateItemVisible(boolean value) {
        if (this.headless) {
            return;
        }
        if (this.switchStateItemVisible != value) {
            this.switchStateItemVisible = value;
            this.switchStateAction.setEnabled(value);
            this.updateSystemMenu();
        }
    }

    public MenuCallback getSystemMenuCallback() {
        if (this.headless) {
            return null;
        }
        MenuCallback result = this.internalFrame.getSystemMenuCallback();
        if (result == this.defaultSystemMenuCallback) {
            return null;
        }
        return result;
    }

    public void setSystemMenuCallback(MenuCallback value) {
        if (this.headless) {
            return;
        }
        if (value != null) {
            this.internalFrame.setSystemMenuCallback(value);
            this.externalFrame.setSystemMenuCallback(value);
        } else {
            this.internalFrame.setSystemMenuCallback(this.defaultSystemMenuCallback);
            this.externalFrame.setSystemMenuCallback(this.defaultSystemMenuCallback);
        }
    }

    public JMenu getDefaultSystemMenu() {
        if (this.headless) {
            return null;
        }
        JMenu result = this.isInternalized() ? this.internalFrame.getDefaultSystemMenu() : this.externalFrame.getDefaultSystemMenu();
        if (this.switchStateItemVisible) {
            result.insert((Action)((Object)this.switchStateAction), 0);
            if (result.getMenuComponentCount() > 1) {
                result.insertSeparator(1);
            }
        }
        return result;
    }

    public Container getParent() {
        if (this.headless) {
            return null;
        }
        if (this.isInternalized()) {
            return this.internalFrame.getParent();
        }
        return this.externalFrame.getParent();
    }

    public Container getContentPane() {
        if (this.headless) {
            return null;
        }
        if (this.isInternalized()) {
            return this.internalFrame.getContentPane();
        }
        return this.externalFrame.getContentPane();
    }

    public JRootPane getRootPane() {
        if (this.headless) {
            return null;
        }
        if (this.isInternalized()) {
            return this.internalFrame.getRootPane();
        }
        return this.externalFrame.getRootPane();
    }

    public Border getBorder() {
        if (this.headless) {
            return null;
        }
        if (this.isInternalized()) {
            return this.internalFrame.getBorder();
        }
        return null;
    }

    public SwitchStateAction getSwitchStateAction() {
        return this.switchStateAction;
    }

    public Dimension getMinimumSize() {
        if (this.headless) {
            return new Dimension();
        }
        if (this.isInternalized()) {
            return this.internalFrame.getMinimumSize();
        }
        return this.externalFrame.getMinimumSize();
    }

    public Dimension getMinimumSizeInternal() {
        if (this.headless) {
            return new Dimension();
        }
        return this.internalFrame.getMinimumSize();
    }

    public Dimension getMinimumSizeExternal() {
        if (this.headless) {
            return new Dimension();
        }
        return this.externalFrame.getMinimumSize();
    }

    public Dimension getMaximumSize() {
        if (this.headless) {
            return new Dimension();
        }
        if (this.isInternalized()) {
            return this.internalFrame.getMaximumSize();
        }
        return this.externalFrame.getMaximumSize();
    }

    public Dimension getMaximumSizeInternal() {
        if (this.headless) {
            return new Dimension();
        }
        return this.internalFrame.getMaximumSize();
    }

    public Dimension getMaximumSizeExternal() {
        if (this.headless) {
            return new Dimension();
        }
        return this.externalFrame.getMaximumSize();
    }

    public Dimension getPreferredSize() {
        if (this.headless) {
            return new Dimension();
        }
        if (this.isInternalized()) {
            return this.internalFrame.getPreferredSize();
        }
        return this.externalFrame.getPreferredSize();
    }

    public Dimension getPreferredSizeInternal() {
        if (this.headless) {
            return new Dimension();
        }
        return this.internalFrame.getPreferredSize();
    }

    public Dimension getPreferredSizeExternal() {
        if (this.headless) {
            return new Dimension();
        }
        return this.externalFrame.getPreferredSize();
    }

    public Dimension getSize() {
        if (this.headless) {
            return new Dimension();
        }
        if (this.isInternalized()) {
            return this.internalFrame.getSize();
        }
        return this.externalFrame.getSize();
    }

    public Dimension getSizeInternal() {
        if (this.headless) {
            return new Dimension();
        }
        return this.internalFrame.getSize();
    }

    public Dimension getSizeExternal() {
        if (this.headless) {
            return new Dimension();
        }
        return this.externalFrame.getSize();
    }

    public int getHeight() {
        if (this.headless) {
            return 0;
        }
        if (this.isInternalized()) {
            return this.internalFrame.getHeight();
        }
        return this.externalFrame.getHeight();
    }

    public int getHeightInternal() {
        if (this.headless) {
            return 0;
        }
        return this.internalFrame.getHeight();
    }

    public int getHeightExternal() {
        if (this.headless) {
            return 0;
        }
        return this.externalFrame.getHeight();
    }

    public int getWidth() {
        if (this.headless) {
            return 0;
        }
        if (this.isInternalized()) {
            return this.internalFrame.getWidth();
        }
        return this.externalFrame.getWidth();
    }

    public int getWidthInternal() {
        if (this.headless) {
            return 0;
        }
        return this.internalFrame.getWidth();
    }

    public int getWidthExternal() {
        if (this.headless) {
            return 0;
        }
        return this.externalFrame.getWidth();
    }

    public int getX() {
        if (this.headless) {
            return 0;
        }
        if (this.isInternalized()) {
            return this.internalFrame.getX();
        }
        return this.externalFrame.getX();
    }

    public int getXInternal() {
        if (this.headless) {
            return 0;
        }
        return this.internalFrame.getX();
    }

    public int getXExternal() {
        if (this.headless) {
            return 0;
        }
        return this.externalFrame.getX();
    }

    public int getY() {
        if (this.headless) {
            return 0;
        }
        if (this.isInternalized()) {
            return this.internalFrame.getY();
        }
        return this.externalFrame.getY();
    }

    public int getYInternal() {
        if (this.headless) {
            return 0;
        }
        return this.internalFrame.getY();
    }

    public int getYExternal() {
        if (this.headless) {
            return 0;
        }
        return this.externalFrame.getY();
    }

    public Point getLocation() {
        if (this.headless) {
            return new Point();
        }
        if (this.isInternalized()) {
            return this.internalFrame.getLocation();
        }
        return this.externalFrame.getLocation();
    }

    public Point getLocationInternal() {
        if (this.headless) {
            return new Point();
        }
        return this.internalFrame.getLocation();
    }

    public Point getLocationExternal() {
        if (this.headless) {
            return new Point();
        }
        return this.externalFrame.getLocation();
    }

    public Rectangle getBounds() {
        if (this.headless) {
            return new Rectangle();
        }
        if (this.isInternalized()) {
            return this.internalFrame.getBounds();
        }
        return this.externalFrame.getBounds();
    }

    public Rectangle getBoundsInternal() {
        if (this.headless) {
            return new Rectangle();
        }
        return this.internalFrame.getBounds();
    }

    public Rectangle getBoundsExternal() {
        if (this.headless) {
            return new Rectangle();
        }
        return this.externalFrame.getBounds();
    }

    public Rectangle getVisibleRect() {
        if (this.headless) {
            return new Rectangle();
        }
        if (this.isInternalized()) {
            return this.internalFrame.getVisibleRect();
        }
        if (this.externalFrame.isVisible()) {
            return this.externalFrame.getBounds();
        }
        return new Rectangle();
    }

    public JMenuBar getJMenuBar() {
        if (this.headless) {
            return null;
        }
        if (this.isInternalized()) {
            return this.internalFrame.getJMenuBar();
        }
        return this.externalFrame.getJMenuBar();
    }

    public InputMap getInputMap(int condition) {
        if (this.headless) {
            return null;
        }
        if (this.isInternalized()) {
            return ((JPanel)this.internalFrame.getContentPane()).getInputMap(condition);
        }
        return ((JPanel)this.externalFrame.getContentPane()).getInputMap(condition);
    }

    public ActionMap getActionMap() {
        if (this.headless) {
            return null;
        }
        if (this.isInternalized()) {
            return ((JPanel)this.internalFrame.getContentPane()).getActionMap();
        }
        return ((JPanel)this.externalFrame.getContentPane()).getActionMap();
    }

    public Toolkit getToolkit() {
        if (this.headless) {
            return null;
        }
        if (this.isInternalized()) {
            return this.internalFrame.getToolkit();
        }
        return this.externalFrame.getToolkit();
    }

    public String getTitle() {
        if (this.headless) {
            return "";
        }
        if (this.isInternalized()) {
            return this.internalFrame.getTitle();
        }
        return this.externalFrame.getTitle();
    }

    public boolean getTitleBarVisible() {
        if (this.headless) {
            return false;
        }
        if (this.isInternalized()) {
            return this.internalFrame.isTitleBarVisible();
        }
        return this.externalFrame.isTitleBarVisible();
    }

    public boolean isSwitchStateItemVisible() {
        if (this.headless) {
            return false;
        }
        return this.switchStateItemVisible;
    }

    public Point getMousePosition() {
        if (this.headless) {
            return new Point();
        }
        if (this.isInternalized()) {
            return this.internalFrame.getMousePosition();
        }
        return this.externalFrame.getMousePosition();
    }

    public boolean isMinimized() {
        if (this.headless) {
            return false;
        }
        if (this.isInternalized()) {
            return this.internalFrame.isIcon();
        }
        return ComponentUtil.isMinimized((Frame)this.externalFrame);
    }

    public boolean isMinimizedInternal() {
        if (this.headless) {
            return false;
        }
        return this.internalFrame.isIcon();
    }

    public boolean isMinimizedExternal() {
        if (this.headless) {
            return false;
        }
        return ComponentUtil.isMinimized((Frame)this.externalFrame);
    }

    public boolean isMaximized() {
        if (this.headless) {
            return false;
        }
        if (this.isInternalized()) {
            return this.internalFrame.isMaximum();
        }
        return ComponentUtil.isMaximized((Frame)this.externalFrame);
    }

    public boolean isMaximizedInternal() {
        if (this.headless) {
            return false;
        }
        return this.internalFrame.isMaximum();
    }

    public boolean isMaximizedExternal() {
        if (this.headless) {
            return false;
        }
        return ComponentUtil.isMaximized((Frame)this.externalFrame);
    }

    public boolean isVisible() {
        if (this.headless) {
            return false;
        }
        if (this.isInternalized()) {
            return this.internalFrame.isVisible();
        }
        return this.externalFrame.isVisible();
    }

    public boolean isResizable() {
        if (this.headless) {
            return false;
        }
        if (this.isInternalized()) {
            return this.internalFrame.isResizable();
        }
        return this.externalFrame.isResizable();
    }

    public boolean isClosable() {
        if (this.headless) {
            return false;
        }
        if (this.isInternalized()) {
            return this.internalFrame.isClosable();
        }
        return true;
    }

    public boolean isInternalized() {
        return this.state == IcyFrameState.INTERNALIZED;
    }

    public boolean isExternalized() {
        return this.state == IcyFrameState.EXTERNALIZED;
    }

    public boolean isActive() {
        if (this.headless) {
            return false;
        }
        if (this.isInternalized()) {
            return this.internalFrame.isSelected();
        }
        return this.externalFrame.isActive();
    }

    public boolean isAlwaysOnTop() {
        if (this.headless) {
            return false;
        }
        return this.externalFrame.isAlwaysOnTop();
    }

    public boolean hasFocus() {
        if (this.headless) {
            return false;
        }
        if (this.isInternalized()) {
            return this.internalFrame.hasFocus();
        }
        return this.externalFrame.hasFocus();
    }

    public void setTitle(final String title) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                IcyFrame.this.internalFrame.setTitle(title);
                IcyFrame.this.externalFrame.setTitle(title);
            }
        }, this.syncProcess);
    }

    public void setToolTipText(final String text) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                IcyFrame.this.internalFrame.setToolTipText(text);
            }
        }, this.syncProcess);
    }

    public void setBackground(final Color value) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                IcyFrame.this.internalFrame.setBackground(value);
                IcyFrame.this.externalFrame.setBackground(value);
            }
        }, this.syncProcess);
    }

    public void setForeground(final Color value) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                IcyFrame.this.internalFrame.setForeground(value);
                IcyFrame.this.externalFrame.setForeground(value);
            }
        }, this.syncProcess);
    }

    public void setResizable(final boolean value) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                IcyFrame.this.internalFrame.setResizable(value);
                IcyFrame.this.externalFrame.setResizable(value);
            }
        }, this.syncProcess);
    }

    public void setLocation(final Point p) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                if (IcyFrame.this.isInternalized()) {
                    IcyFrame.this.internalFrame.setLocation(p);
                } else {
                    IcyFrame.this.externalFrame.setLocation(p);
                }
            }
        }, this.syncProcess);
    }

    public void setLocation(final int x, final int y) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                if (IcyFrame.this.isInternalized()) {
                    IcyFrame.this.internalFrame.setLocation(x, y);
                } else {
                    IcyFrame.this.externalFrame.setLocation(x, y);
                }
            }
        }, this.syncProcess);
    }

    public void setLocationInternal(final Point p) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                IcyFrame.this.internalFrame.setLocation(p);
            }
        }, this.syncProcess);
    }

    public void setLocationInternal(final int x, final int y) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                IcyFrame.this.internalFrame.setLocation(x, y);
            }
        }, this.syncProcess);
    }

    public void setLocationExternal(final Point p) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                IcyFrame.this.externalFrame.setLocation(p);
            }
        }, this.syncProcess);
    }

    public void setLocationExternal(final int x, final int y) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                IcyFrame.this.externalFrame.setLocation(x, y);
            }
        }, this.syncProcess);
    }

    public void setSize(final Dimension d) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                if (IcyFrame.this.isInternalized()) {
                    IcyFrame.this.internalFrame.setSize(d);
                } else {
                    IcyFrame.this.externalFrame.setSize(d);
                }
            }
        }, this.syncProcess);
    }

    public void setSize(final int width, final int height) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                if (IcyFrame.this.isInternalized()) {
                    IcyFrame.this.internalFrame.setSize(width, height);
                } else {
                    IcyFrame.this.externalFrame.setSize(width, height);
                }
            }
        }, this.syncProcess);
    }

    public void setSizeInternal(final Dimension d) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                IcyFrame.this.internalFrame.setSize(d);
            }
        }, this.syncProcess);
    }

    public void setSizeInternal(final int width, final int height) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                IcyFrame.this.internalFrame.setSize(width, height);
            }
        }, this.syncProcess);
    }

    public void setSizeExternal(final Dimension d) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                IcyFrame.this.externalFrame.setSize(d);
            }
        }, this.syncProcess);
    }

    public void setSizeExternal(final int width, final int height) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                IcyFrame.this.externalFrame.setSize(width, height);
            }
        }, this.syncProcess);
    }

    public void setPreferredSize(final Dimension d) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                if (IcyFrame.this.isInternalized()) {
                    IcyFrame.this.internalFrame.setPreferredSize(d);
                } else {
                    IcyFrame.this.externalFrame.setPreferredSize(d);
                }
            }
        }, this.syncProcess);
    }

    public void setPreferredSizeInternal(final Dimension d) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                IcyFrame.this.internalFrame.setPreferredSize(d);
            }
        }, this.syncProcess);
    }

    public void setPreferredSizeExternal(final Dimension d) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                IcyFrame.this.externalFrame.setPreferredSize(d);
            }
        }, this.syncProcess);
    }

    public void setMinimumSize(final Dimension d) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                if (IcyFrame.this.isInternalized()) {
                    IcyFrame.this.internalFrame.setMinimumSize(d);
                } else {
                    IcyFrame.this.externalFrame.setMinimumSize(d);
                }
            }
        }, this.syncProcess);
    }

    public void setMaximumSize(final Dimension d) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                if (IcyFrame.this.isInternalized()) {
                    IcyFrame.this.internalFrame.setMaximumSize(d);
                } else {
                    IcyFrame.this.externalFrame.setMaximumSize(d);
                }
            }
        }, this.syncProcess);
    }

    public void setMinimumSizeInternal(final Dimension d) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                IcyFrame.this.internalFrame.setMinimumSize(d);
            }
        }, this.syncProcess);
    }

    public void setMaximumSizeInternal(final Dimension d) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                IcyFrame.this.internalFrame.setMaximumSize(d);
            }
        }, this.syncProcess);
    }

    public void setMinimumSizeExternal(final Dimension d) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                IcyFrame.this.externalFrame.setMinimumSize(d);
            }
        }, this.syncProcess);
    }

    public void setMaximumSizeExternal(final Dimension d) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                IcyFrame.this.externalFrame.setMaximumSize(d);
            }
        }, this.syncProcess);
    }

    public void setBounds(final Rectangle r) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                if (IcyFrame.this.isInternalized()) {
                    IcyFrame.this.internalFrame.setBounds(r);
                } else {
                    IcyFrame.this.externalFrame.setBounds(r);
                }
            }
        }, this.syncProcess);
    }

    public void setMaximisable(final boolean value) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                IcyFrame.this.internalFrame.setMaximizable(value);
            }
        }, this.syncProcess);
    }

    public void setMinimized(final boolean value) {
        if (this.headless) {
            return;
        }
        if (this.isMinimized() ^ value) {
            ThreadUtil.invoke(new Runnable(){

                @Override
                public void run() {
                    if (IcyFrame.this.isInternalized()) {
                        IcyFrame.this.internalFrame.setMinimized(value);
                    } else {
                        IcyFrame.this.externalFrame.setMinimized(value);
                    }
                }
            }, this.syncProcess);
        }
    }

    public void setMinimizedInternal(final boolean value) {
        if (this.headless) {
            return;
        }
        if (this.internalFrame.isMinimized() ^ value) {
            ThreadUtil.invoke(new Runnable(){

                @Override
                public void run() {
                    IcyFrame.this.internalFrame.setMinimized(value);
                }
            }, this.syncProcess);
        }
    }

    public void setMinimizedExternal(final boolean value) {
        if (this.headless) {
            return;
        }
        if (this.externalFrame.isMinimized() ^ value) {
            ThreadUtil.invoke(new Runnable(){

                @Override
                public void run() {
                    IcyFrame.this.externalFrame.setMinimized(value);
                }
            }, this.syncProcess);
        }
    }

    public void setMaximized(final boolean value) {
        if (this.headless) {
            return;
        }
        if (this.isMaximized() ^ value) {
            ThreadUtil.invoke(new Runnable(){

                @Override
                public void run() {
                    if (IcyFrame.this.isInternalized()) {
                        IcyFrame.this.internalFrame.setMaximized(value);
                    } else {
                        IcyFrame.this.externalFrame.setMaximized(value);
                    }
                }
            }, this.syncProcess);
        }
    }

    public void setMaximizedInternal(final boolean value) {
        if (this.headless) {
            return;
        }
        if (this.internalFrame.isMaximized() ^ value) {
            ThreadUtil.invoke(new Runnable(){

                @Override
                public void run() {
                    IcyFrame.this.internalFrame.setMaximized(value);
                }
            }, this.syncProcess);
        }
    }

    public void setMaximizedExternal(final boolean value) {
        if (this.headless) {
            return;
        }
        if (this.externalFrame.isMaximized() ^ value) {
            ThreadUtil.invoke(new Runnable(){

                @Override
                public void run() {
                    IcyFrame.this.externalFrame.setMaximized(value);
                }
            }, this.syncProcess);
        }
    }

    public void setClosable(final boolean value) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                IcyFrame.this.internalFrame.setClosable(value);
            }
        }, this.syncProcess);
    }

    public void setDefaultCloseOperation(final int operation) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                IcyFrame.this.internalFrame.setDefaultCloseOperation(operation);
                IcyFrame.this.externalFrame.setDefaultCloseOperation(operation);
            }
        }, this.syncProcess);
    }

    public void setFocusable(final boolean value) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                IcyFrame.this.internalFrame.setFocusable(value);
                IcyFrame.this.externalFrame.setFocusable(value);
            }
        }, this.syncProcess);
    }

    public void setVisible(final boolean value) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                if (IcyFrame.this.isInternalized()) {
                    IcyFrame.this.internalFrame.setVisible(value);
                } else {
                    IcyFrame.this.externalFrame.setVisible(value);
                }
            }
        }, this.syncProcess);
    }

    public void setAlwaysOnTop(final boolean alwaysOnTop) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                IcyFrame.this.externalFrame.setAlwaysOnTop(alwaysOnTop);
            }
        }, this.syncProcess);
    }

    public void setJMenuBar(final JMenuBar m) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                if (IcyFrame.this.isInternalized()) {
                    IcyFrame.this.internalFrame.setJMenuBar(m);
                } else {
                    IcyFrame.this.externalFrame.setJMenuBar(m);
                }
            }
        }, this.syncProcess);
    }

    public void setTitleBarVisible(final boolean value) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                IcyFrame.this.internalFrame.setTitleBarVisible(value);
                IcyFrame.this.externalFrame.setTitleBarVisible(value);
            }
        }, this.syncProcess);
    }

    public void setLayout(final LayoutManager layout) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                if (IcyFrame.this.isInternalized()) {
                    IcyFrame.this.internalFrame.setLayout(layout);
                } else {
                    IcyFrame.this.externalFrame.setLayout(layout);
                }
            }
        }, this.syncProcess);
    }

    public void setBorder(final Border border) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                IcyFrame.this.internalFrame.setBorder(border);
            }
        }, this.syncProcess);
    }

    public void setContentPane(final Container value) {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                if (IcyFrame.this.isInternalized()) {
                    IcyFrame.this.internalFrame.setContentPane(value);
                } else {
                    IcyFrame.this.externalFrame.setContentPane(value);
                }
            }
        }, this.syncProcess);
    }

    public boolean isSyncProcess() {
        return this.syncProcess;
    }

    public void setSyncProcess(boolean syncProcess) {
        this.syncProcess = syncProcess;
    }

    public void requestFocus() {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                if (IcyFrame.this.isInternalized()) {
                    try {
                        IcyFrame.this.internalFrame.setSelected(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    IcyFrame.this.externalFrame.requestFocus();
                }
            }
        }, this.syncProcess);
    }

    public void validate() {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                if (IcyFrame.this.isInternalized()) {
                    IcyFrame.this.internalFrame.validate();
                } else {
                    IcyFrame.this.externalFrame.validate();
                }
            }
        }, this.syncProcess);
    }

    public void revalidate() {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                if (IcyFrame.this.isInternalized()) {
                    IcyFrame.this.internalFrame.revalidate();
                } else {
                    IcyFrame.this.externalFrame.invalidate();
                    IcyFrame.this.externalFrame.repaint();
                }
            }
        }, this.syncProcess);
    }

    public void repaint() {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                if (IcyFrame.this.isInternalized()) {
                    IcyFrame.this.internalFrame.repaint();
                } else {
                    IcyFrame.this.externalFrame.repaint();
                }
            }
        }, this.syncProcess);
    }

    public void updateUI() {
        if (this.headless) {
            return;
        }
        ThreadUtil.invoke(new Runnable(){

            @Override
            public void run() {
                IcyFrame.this.internalFrame.updateUI();
            }
        }, this.syncProcess);
    }

    private void fireFrameActivated(IcyFrameEvent e) {
        for (IcyFrameListener l : (IcyFrameListener[])this.frameEventListeners.getListeners(IcyFrameListener.class)) {
            l.icyFrameActivated(e);
        }
    }

    private void fireFrameDeactivated(IcyFrameEvent e) {
        for (IcyFrameListener l : (IcyFrameListener[])this.frameEventListeners.getListeners(IcyFrameListener.class)) {
            l.icyFrameDeactivated(e);
        }
    }

    private void fireFrameClosing(IcyFrameEvent e) {
        for (IcyFrameListener l : (IcyFrameListener[])this.frameEventListeners.getListeners(IcyFrameListener.class)) {
            l.icyFrameClosing(e);
        }
    }

    private void fireFrameClosed(IcyFrameEvent e) {
        for (IcyFrameListener l : (IcyFrameListener[])this.frameEventListeners.getListeners(IcyFrameListener.class)) {
            l.icyFrameClosed(e);
        }
    }

    private void fireFrameIconified(IcyFrameEvent e) {
        for (IcyFrameListener l : (IcyFrameListener[])this.frameEventListeners.getListeners(IcyFrameListener.class)) {
            l.icyFrameIconified(e);
        }
    }

    private void fireFrameDeiconified(IcyFrameEvent e) {
        for (IcyFrameListener l : (IcyFrameListener[])this.frameEventListeners.getListeners(IcyFrameListener.class)) {
            l.icyFrameDeiconified(e);
        }
    }

    private void fireFrameOpened(IcyFrameEvent e) {
        for (IcyFrameListener l : (IcyFrameListener[])this.frameEventListeners.getListeners(IcyFrameListener.class)) {
            l.icyFrameOpened(e);
        }
    }

    void fireFrameInternalized(IcyFrameEvent e) {
        for (IcyFrameListener l : (IcyFrameListener[])this.frameEventListeners.getListeners(IcyFrameListener.class)) {
            l.icyFrameInternalized(e);
        }
    }

    void fireFrameExternalized(IcyFrameEvent e) {
        for (IcyFrameListener l : (IcyFrameListener[])this.frameEventListeners.getListeners(IcyFrameListener.class)) {
            l.icyFrameExternalized(e);
        }
    }

    public void addFrameListener(IcyFrameListener l) {
        if (this.headless) {
            return;
        }
        this.frameEventListeners.add(IcyFrameListener.class, l);
    }

    public void removeFrameListener(IcyFrameListener l) {
        if (this.headless) {
            return;
        }
        this.frameEventListeners.remove(IcyFrameListener.class, l);
    }

    public void addComponentListener(ComponentListener l) {
        if (this.headless) {
            return;
        }
        this.internalFrame.addComponentListener(l);
        this.externalFrame.addComponentListener(l);
    }

    public void removeComponentListener(ComponentListener l) {
        if (this.headless) {
            return;
        }
        this.internalFrame.removeComponentListener(l);
        this.externalFrame.removeComponentListener(l);
    }

    public void addKeyListener(KeyListener l) {
        if (this.headless) {
            return;
        }
        this.internalFrame.addKeyListener(l);
        this.externalFrame.addKeyListener(l);
    }

    public void removeKeyListener(KeyListener l) {
        if (this.headless) {
            return;
        }
        this.internalFrame.removeKeyListener(l);
        this.externalFrame.removeKeyListener(l);
    }

    public void frameClosed(AWTEvent e) {
        if (this.headless) {
            return;
        }
        MainFrame mainFrame = Icy.getMainInterface().getMainFrame();
        if (mainFrame != null) {
            mainFrame.removePropertyChangeListener("detachedMode", (PropertyChangeListener)this);
        }
        this.externalFrame.removeWindowListener((WindowListener)this);
        this.internalFrame.removeInternalFrameListener((InternalFrameListener)this);
        if (e instanceof InternalFrameEvent) {
            this.fireFrameClosed(new IcyFrameEvent(this, (InternalFrameEvent)e, null));
            this.externalFrame.dispose();
        } else if (e instanceof WindowEvent) {
            this.fireFrameClosed(new IcyFrameEvent(this, null, (WindowEvent)e));
            this.internalFrame.dispose();
        }
        this.onClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClosed() {
        if (this.headless) {
            return;
        }
        ArrayList<IcyFrame> arrayList = frames;
        synchronized (arrayList) {
            frames.remove(this);
        }
        this.externalFrame.systemMenuCallback = null;
        this.internalFrame.systemMenuCallback = null;
        this.switchStateAction = null;
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
        if (this.headless) {
            return;
        }
        this.fireFrameActivated(new IcyFrameEvent(this, e, null));
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
        if (this.headless) {
            return;
        }
        this.frameClosed(e);
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        if (this.headless) {
            return;
        }
        this.fireFrameClosing(new IcyFrameEvent(this, e, null));
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
        if (this.headless) {
            return;
        }
        this.fireFrameDeactivated(new IcyFrameEvent(this, e, null));
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
        if (this.headless) {
            return;
        }
        this.fireFrameDeiconified(new IcyFrameEvent(this, e, null));
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
        if (this.headless) {
            return;
        }
        this.fireFrameIconified(new IcyFrameEvent(this, e, null));
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
        if (this.headless) {
            return;
        }
        this.fireFrameOpened(new IcyFrameEvent(this, e, null));
    }

    @Override
    public void windowActivated(WindowEvent e) {
        if (this.headless) {
            return;
        }
        this.fireFrameActivated(new IcyFrameEvent(this, null, e));
    }

    @Override
    public void windowClosed(WindowEvent e) {
        if (this.headless) {
            return;
        }
        this.frameClosed(e);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (this.headless) {
            return;
        }
        this.fireFrameClosing(new IcyFrameEvent(this, null, e));
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
        if (this.headless) {
            return;
        }
        this.fireFrameDeactivated(new IcyFrameEvent(this, null, e));
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
        if (this.headless) {
            return;
        }
        this.fireFrameDeiconified(new IcyFrameEvent(this, null, e));
    }

    @Override
    public void windowIconified(WindowEvent e) {
        if (this.headless) {
            return;
        }
        this.fireFrameIconified(new IcyFrameEvent(this, null, e));
    }

    @Override
    public void windowOpened(WindowEvent e) {
        if (this.headless) {
            return;
        }
        this.fireFrameOpened(new IcyFrameEvent(this, null, e));
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if (this.headless) {
            return false;
        }
        if (this.isInternalized()) {
            return this.internalFrame.imageUpdate(img, infoflags, x, y, width, height);
        }
        return this.externalFrame.imageUpdate(img, infoflags, x, y, width, height);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.headless) {
            return;
        }
        if (StringUtil.equals(evt.getPropertyName(), "detachedMode")) {
            boolean detachedMode = (Boolean)evt.getNewValue();
            if (detachedMode) {
                this.previousState = this.state;
                this.externalize();
                if (this.switchStateAction != null) {
                    this.switchStateAction.setEnabled(false);
                }
            } else {
                if (this.previousState == IcyFrameState.INTERNALIZED) {
                    this.internalize();
                }
                if (this.switchStateAction != null) {
                    this.switchStateAction.setEnabled(true);
                }
            }
        }
    }

    public static enum IcyFrameState {
        INTERNALIZED,
        EXTERNALIZED;

    }

    private class SwitchStateAction
    extends IcyAbstractAction {
        private static final long serialVersionUID = -4433831471426743128L;
        final IcyIcon detachIcon;
        final IcyIcon attachIcon;

        public SwitchStateAction() {
            super("");
            this.detachIcon = new IcyIcon(ResourceUtil.ICON_WINDOW_EXPAND, 20);
            this.attachIcon = new IcyIcon(ResourceUtil.ICON_WINDOW_COLLAPSE, 20);
            this.setAccelerator(114);
            this.refreshState();
        }

        public boolean doAction(ActionEvent e) {
            IcyFrame.this.switchState();
            return true;
        }

        void refreshState() {
            if (IcyFrame.this.isInternalized()) {
                this.setName("Detach");
                this.setIcon(this.detachIcon);
                this.setDescription("Externalize the window");
            } else {
                this.setName("Attach");
                this.setIcon(this.attachIcon);
                this.setDescription("Internalize the window");
            }
        }
    }
}

