/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.xml.BaseHandler;
import loci.common.xml.XMLTools;
import loci.formats.ChannelSeparator;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.in.SVSReader;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.Timestamp;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class AFIReader
extends FormatReader {
    private static final int EXTRA_IMAGES = 2;
    private ArrayList<String> pixels = new ArrayList();
    private ChannelSeparator[] reader;

    public AFIReader() {
        super("Aperio AFI", "afi");
        this.domains = new String[]{"Histology"};
        this.hasCompanionFiles = true;
        this.datasetDescription = "One .afi file and several similarly-named .svs files";
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 4;
        return FormatTools.validStream(stream, 4, false);
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    @Override
    public int getOptimalTileWidth() {
        this.reader[0].setCoreIndex(this.getCoreIndex());
        return this.reader[0].getOptimalTileWidth();
    }

    @Override
    public int getOptimalTileHeight() {
        this.reader[0].setCoreIndex(this.getCoreIndex());
        return this.reader[0].getOptimalTileHeight();
    }

    @Override
    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.getCoreIndex() >= this.core.size() - 2) {
            this.reader[0].setCoreIndex(this.getCoreIndex());
            return this.reader[0].openThumbBytes(no);
        }
        int coreIndex = this.getCoreIndex();
        this.setCoreIndex(this.core.size() - 2 - 1);
        byte[] thumb = FormatTools.openThumbBytes(this, no);
        this.setCoreIndex(coreIndex);
        return thumb;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        if (this.getCoreIndex() >= this.core.size() - 2) {
            this.reader[0].setCoreIndex(this.getCoreIndex());
            return this.reader[0].openBytes(no, buf, x, y, w, h2);
        }
        int[] coords = this.getZCTCoords(no);
        int channel = coords[1];
        int index = this.getIndex(coords[0], 0, coords[2]);
        this.reader[channel].setCoreIndex(this.getCoreIndex());
        int srcBytes = FormatTools.getBytesPerPixel(this.reader[channel].getPixelType());
        int destBytes = FormatTools.getBytesPerPixel(this.getPixelType());
        int diff = destBytes - srcBytes;
        if (diff == 0) {
            return this.reader[channel].openBytes(index, buf, x, y, w, h2);
        }
        if (diff > 0) {
            Arrays.fill(buf, (byte)0);
            byte[] tmp = this.reader[channel].openBytes(index, x, y, w, h2);
            int i = 0;
            int dest = 0;
            while (i < tmp.length) {
                int j;
                if (this.isLittleEndian()) {
                    for (j = 0; j < srcBytes; ++j) {
                        buf[dest + j] = tmp[i + j];
                    }
                } else {
                    for (j = 0; j < srcBytes; ++j) {
                        buf[dest + destBytes - j - 1] = tmp[i + srcBytes - j - 1];
                    }
                }
                i += srcBytes;
                dest += destBytes;
            }
            Object s2 = DataTools.makeDataArray(buf, destBytes, FormatTools.isFloatingPoint(this.getPixelType()), this.isLittleEndian());
            long max = (long)Math.pow(2.0, destBytes * 8) - 1L;
            for (int i2 = 0; i2 < Array.getLength(s2); ++i2) {
                double scale = Array.getDouble(s2, i2) / 255.0;
                DataTools.unpackBytes((long)(scale * (double)max), buf, i2 * destBytes, destBytes, this.isLittleEndian());
            }
            return buf;
        }
        throw new FormatException("Downsampling images is not supported");
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            return new String[]{this.currentId};
        }
        String[] files = new String[this.pixels.size() + 1];
        files[0] = this.currentId;
        for (int i = 0; i < this.pixels.size(); ++i) {
            files[i + 1] = this.pixels.get(i);
        }
        return files;
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.reader != null) {
                for (ChannelSeparator r : this.reader) {
                    if (r == null) continue;
                    r.close();
                }
            }
            this.reader = null;
            this.pixels.clear();
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        int i;
        super.initFile(id);
        String xml = DataTools.readFile(id);
        XMLTools.parseXML(xml, (DefaultHandler)new AFIHandler());
        String parent = new Location(id).getAbsoluteFile().getParent();
        String[] channelNames = new String[this.pixels.size()];
        this.reader = new ChannelSeparator[this.pixels.size()];
        for (i = 0; i < this.pixels.size(); ++i) {
            String file2 = this.pixels.get(i);
            int underscore = file2.indexOf(95);
            int fullStop = file2.indexOf(46);
            if (underscore >= 0 && fullStop > underscore) {
                channelNames[i] = file2.substring(underscore + 1, fullStop);
            }
            this.pixels.set(i, new Location(parent, file2).getAbsolutePath());
            this.reader[i] = new ChannelSeparator(new SVSReader());
            this.reader[i].setFlattenedResolutions(this.hasFlattenedResolutions());
            this.reader[i].setId(this.pixels.get(i));
            ArrayList<String> dyeNames = ((SVSReader)this.reader[i].getReader()).getDyeNames();
            if (dyeNames.size() <= 0) continue;
            channelNames[i] = dyeNames.get(0);
        }
        this.core = this.reader[0].getCoreMetadataList();
        for (i = 0; i < this.core.size() - 2; ++i) {
            CoreMetadata c = (CoreMetadata)this.core.get(i);
            c.sizeC = this.pixels.size();
            c.imageCount = c.sizeC * c.sizeZ * c.sizeT;
            c.rgb = false;
            if (i == 0) {
                c.resolutionCount = this.core.size() - 2;
                continue;
            }
            c.pixelType = ((CoreMetadata)this.core.get((int)0)).pixelType;
        }
        for (int s2 = 0; s2 < this.core.size(); ++s2) {
            this.setCoreIndex(s2);
            ((CoreMetadata)this.core.get((int)s2)).seriesMetadata = new Hashtable();
            for (int i2 = 0; i2 < this.reader.length; ++i2) {
                this.reader[i2].setCoreIndex(s2);
                Hashtable<String, Object> m3 = this.reader[i2].getSeriesMetadata();
                for (String key : m3.keySet()) {
                    this.addSeriesMetaList(key, m3.get(key));
                }
            }
        }
        this.setCoreIndex(0);
        MetadataStore store = this.makeFilterMetadata();
        boolean minimalMetadata = this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM;
        MetadataTools.populatePixels(store, this, !minimalMetadata);
        String fileID = this.currentId.substring(this.currentId.lastIndexOf(File.separator) + 1);
        if (this.hasFlattenedResolutions()) {
            for (int i3 = 0; i3 < this.getSeriesCount(); ++i3) {
                store.setImageName(fileID + " - image #" + (i3 + 1), i3);
            }
        } else {
            store.setImageName("", 0);
            store.setImageName("label image", 1);
            store.setImageName("macro image", 2);
        }
        if (!minimalMetadata) {
            Length[] emission = new Length[this.pixels.size()];
            Length[] excitation = new Length[this.pixels.size()];
            Double[] exposure = new Double[this.pixels.size()];
            Timestamp[] datestamp = new Timestamp[this.pixels.size()];
            Length[] physicalSizes = null;
            double magnification = Double.NaN;
            Color[] displayColor = new Color[this.pixels.size()];
            for (int c = 0; c < this.pixels.size(); ++c) {
                SVSReader baseReader = (SVSReader)this.reader[c].getReader();
                emission[c] = baseReader.getEmission();
                excitation[c] = baseReader.getExcitation();
                exposure[c] = baseReader.getExposureTime();
                datestamp[c] = baseReader.getDatestamp();
                physicalSizes = baseReader.getPhysicalSizes();
                displayColor[c] = baseReader.getDisplayColor();
                if (c != 0) continue;
                magnification = baseReader.getMagnification();
            }
            String instrument = MetadataTools.createLSID("Instrument", 0);
            String objective = MetadataTools.createLSID("Objective", 0, 0);
            store.setInstrumentID(instrument, 0);
            store.setObjectiveID(objective, 0, 0);
            store.setObjectiveNominalMagnification(magnification, 0, 0);
            for (int i4 = 0; i4 < this.getSeriesCount() - 2; ++i4) {
                if (datestamp[0] != null) {
                    store.setImageAcquisitionDate(datestamp[0], i4);
                }
                store.setImageInstrumentRef(instrument, i4);
                store.setObjectiveSettingsID(objective, i4);
                if (i4 < physicalSizes.length && physicalSizes[i4] != null && physicalSizes[i4].value(UNITS.MICROMETER).doubleValue() - 1.0E-6 > 0.0) {
                    Length size = physicalSizes[i4];
                    store.setPixelsPhysicalSizeX(size, i4);
                    store.setPixelsPhysicalSizeY(size, i4);
                }
                for (int c = 0; c < channelNames.length; ++c) {
                    store.setChannelName(channelNames[c], i4, c);
                    if (emission[c] != null) {
                        store.setChannelEmissionWavelength(emission[c], i4, c);
                    }
                    if (excitation[c] != null) {
                        store.setChannelExcitationWavelength(excitation[c], i4, c);
                    }
                    if (displayColor[c] != null) {
                        store.setChannelColor(displayColor[c], i4, c);
                    }
                    store.setPlaneExposureTime(FormatTools.createTime(exposure[c], UNITS.SECOND), i4, c);
                }
            }
        }
    }

    class AFIHandler
    extends BaseHandler {
        private String currentElement;

        AFIHandler() {
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            String value = new String(ch, start, length);
            if (this.currentElement.equals("Path") && value.trim().length() > 0) {
                AFIReader.this.pixels.add(value);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.currentElement = qName;
        }
    }
}

