/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.IniTable;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MinimalTiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffIFDEntry;
import loci.formats.tiff.TiffParser;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;

public class BDReader
extends FormatReader {
    private static final String EXPERIMENT_FILE = "Experiment.exp";
    private static final String[] META_EXT = new String[]{"drt", "dye", "exp", "plt", "txt", "geo", "ltp", "ffc", "afc", "mon", "xyz", "mac", "bmp", "roi", "adf"};
    private List<String> metadataFiles = new ArrayList<String>();
    private List<String> channelNames = new ArrayList<String>();
    private List<String> wellLabels = new ArrayList<String>();
    private String plateName;
    private String plateDescription;
    private String[][] tiffs;
    private MinimalTiffReader reader;
    private String roiFile;
    private double[] emWave;
    private double[] exWave;
    private double[] gain;
    private double[] offset;
    private double[] exposure;
    private String binning;
    private String objective;
    private int wellRows;
    private int wellCols;
    private int fieldRows;
    private int fieldCols;
    private String[] rootList;
    private List<String[]> wellList = new ArrayList<String[]>();

    public BDReader() {
        super("BD Pathway", new String[]{"exp", "tif"});
        this.domains = new String[]{"High-Content Screening (HCS)"};
        this.hasCompanionFiles = true;
        this.suffixSufficient = false;
        this.suffixNecessary = false;
        this.datasetDescription = "Multiple files (.exp, .dye, .ltp, \u2026) plus one or more directories containing .tif and .bmp files";
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        Location location = new Location(name);
        String id = location.getAbsolutePath();
        boolean dirCheck = location.isDirectory();
        if (dirCheck) {
            return false;
        }
        if (name.endsWith(EXPERIMENT_FILE)) {
            return true;
        }
        if (!open) {
            return false;
        }
        try {
            id = this.locateExperimentFile(id);
        }
        catch (FormatException f) {
            return false;
        }
        catch (IOException f) {
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
        if (id.endsWith(EXPERIMENT_FILE)) {
            return true;
        }
        return super.isThisType(name, open);
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        TiffParser p = new TiffParser(stream);
        IFD ifd = p.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        String software = ifd.getIFDTextValue(305);
        if (software == null) {
            return false;
        }
        return software.trim().startsWith("MATROX Imaging Library");
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        ArrayList<String> files = new ArrayList<String>();
        files.add(new Location(this.currentId).getAbsolutePath());
        for (String file2 : this.metadataFiles) {
            if (file2 == null || files.contains(file2)) continue;
            files.add(file2);
        }
        if (!noPixels && this.tiffs != null) {
            int well = this.getSeries() / (this.fieldRows * this.fieldCols);
            for (int i = 0; i < this.tiffs[well].length; ++i) {
                if (files.contains(this.tiffs[well][i])) continue;
                files.add(this.tiffs[well][i]);
            }
        }
        return files.toArray(new String[files.size()]);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.reader != null) {
                this.reader.close();
            }
            this.reader = null;
            this.tiffs = null;
            this.plateName = null;
            this.plateDescription = null;
            this.channelNames.clear();
            this.metadataFiles.clear();
            this.wellLabels.clear();
            this.wellRows = 0;
            this.wellCols = 0;
            this.fieldRows = 0;
            this.fieldCols = 0;
            this.wellList.clear();
            this.rootList = null;
        }
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    @Override
    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        String file2 = this.getFilename(this.getSeries(), no);
        int field = this.getSeries() % (this.fieldRows * this.fieldCols);
        int fieldRow = field / this.fieldCols;
        int fieldCol = field % this.fieldCols;
        if (file2 != null) {
            try {
                if (this.reader.getCurrentFile() == null || !new Location(file2).getAbsolutePath().equals(new Location(this.reader.getCurrentFile()).getAbsolutePath())) {
                    this.reader.setId(file2);
                }
                if (this.fieldRows * this.fieldCols == 1) {
                    this.reader.openBytes(0, buf, x, y, w, h2);
                } else {
                    int fx = x + fieldCol * this.getSizeX();
                    int fy = y + fieldRow * this.getSizeY();
                    this.reader.openBytes(0, buf, fx, fy, w, h2);
                }
            }
            catch (FormatException e) {
                LOGGER.debug("Could not read file " + file2, e);
                return buf;
            }
            catch (IOException e) {
                LOGGER.debug("Could not read file " + file2, e);
                return buf;
            }
        }
        return buf;
    }

    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.reader.getOptimalTileWidth() / this.fieldCols;
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        return Math.max(1, this.reader.getOptimalTileHeight() / this.fieldRows);
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        int nChannels;
        id = this.locateExperimentFile(id);
        super.initFile(id);
        Location dir = new Location(id).getAbsoluteFile().getParentFile();
        this.rootList = dir.list(true);
        Arrays.sort(this.rootList);
        for (int i = 0; i < this.rootList.length; ++i) {
            String file2 = this.rootList[i];
            Location f = new Location(dir, file2);
            this.rootList[i] = f.getAbsolutePath();
            if (!f.isDirectory()) {
                if (!BDReader.checkSuffix(file2, META_EXT) || f.isDirectory()) continue;
                this.metadataFiles.add(f.getAbsolutePath());
                continue;
            }
            Object[] wells = f.list(true);
            Arrays.sort(wells);
            this.wellList.add((String[])wells);
            for (Object well : wells) {
                Location wellFile = new Location(f, (String)well);
                if (wellFile.isDirectory() || !BDReader.checkSuffix((String)well, META_EXT)) continue;
                this.metadataFiles.add(wellFile.getAbsolutePath());
            }
        }
        IniList experiment = this.readMetaData(id);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            this.objective = (String)experiment.getTable("Geometry").get("Name");
            IniTable camera = experiment.getTable("Camera");
            this.binning = (String)camera.get("BinX") + "x" + (String)camera.get("BinY");
            this.parseChannelData(dir);
            this.addGlobalMeta("Objective", this.objective);
            this.addGlobalMeta("Camera binning", this.binning);
        }
        ArrayList<String> uniqueRows = new ArrayList<String>();
        ArrayList<String> uniqueColumns = new ArrayList<String>();
        for (String well : this.wellLabels) {
            String row = well.substring(0, 1).trim();
            String column = well.substring(1).trim();
            if (!uniqueRows.contains(row) && row.length() > 0) {
                uniqueRows.add(row);
            }
            if (uniqueColumns.contains(column) || column.length() <= 0) continue;
            uniqueColumns.add(column);
        }
        int nSlices = this.getSizeZ() == 0 ? 1 : this.getSizeZ();
        int nTimepoints = this.getSizeT();
        int nWells = this.wellLabels.size();
        int n = nChannels = this.getSizeC() == 0 ? this.channelNames.size() : this.getSizeC();
        if (nChannels == 0) {
            nChannels = 1;
        }
        this.tiffs = this.getTiffs();
        this.reader = new MinimalTiffReader();
        this.reader.setId(this.tiffs[0][0]);
        int sizeX = this.reader.getSizeX();
        int sizeY = this.reader.getSizeY();
        int pixelType = this.reader.getPixelType();
        boolean rgb = this.reader.isRGB();
        boolean interleaved = this.reader.isInterleaved();
        boolean indexed = this.reader.isIndexed();
        boolean littleEndian = this.reader.isLittleEndian();
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            IniParser parser = new IniParser();
            for (String metadataFile : this.metadataFiles) {
                String filename = new Location(metadataFile).getName();
                if (BDReader.checkSuffix(metadataFile, new String[]{"txt", "bmp", "adf", "roi"})) continue;
                String data = DataTools.readFile(metadataFile);
                IniList ini = parser.parseINI(new BufferedReader(new StringReader(data)));
                HashMap<String, String> h2 = ini.flattenIntoHashMap();
                for (String key : h2.keySet()) {
                    this.addGlobalMeta(filename + " " + key, h2.get(key));
                }
            }
        }
        int coresize = this.core.size();
        this.core.clear();
        for (int i = 0; i < coresize; ++i) {
            CoreMetadata ms = new CoreMetadata();
            this.core.add(ms);
            ms.sizeC = nChannels;
            ms.sizeZ = nSlices;
            ms.sizeT = nTimepoints;
            ms.sizeX = sizeX / this.fieldCols;
            ms.sizeY = sizeY / this.fieldRows;
            ms.pixelType = pixelType;
            ms.rgb = rgb;
            ms.interleaved = interleaved;
            ms.indexed = indexed;
            ms.littleEndian = littleEndian;
            ms.dimensionOrder = "XYZTC";
            ms.imageCount = nSlices * nTimepoints * nChannels;
        }
        MetadataStore store = this.makeFilterMetadata();
        boolean populatePlanes = this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM;
        MetadataTools.populatePixels(store, this, populatePlanes);
        String plateAcqID = MetadataTools.createLSID("PlateAcquisition", 0, 0);
        store.setPlateAcquisitionID(plateAcqID, 0, 0);
        PositiveInteger fieldCount = FormatTools.getMaxFieldCount(this.fieldRows * this.fieldCols);
        if (fieldCount != null) {
            store.setPlateAcquisitionMaximumFieldCount(fieldCount, 0, 0);
        }
        for (int row = 0; row < this.wellRows; ++row) {
            for (int col = 0; col < this.wellCols; ++col) {
                int index = row * this.wellCols + col;
                store.setWellID(MetadataTools.createLSID("Well", 0, index), 0, index);
                store.setWellRow(new NonNegativeInteger(row), 0, index);
                store.setWellColumn(new NonNegativeInteger(col), 0, index);
            }
        }
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            int well = i / (this.fieldRows * this.fieldCols);
            int field = i % (this.fieldRows * this.fieldCols);
            MetadataTools.setDefaultCreationDate(store, this.tiffs[well][0], i);
            String name = this.wellLabels.get(well);
            String row = name.substring(0, 1);
            Integer col = Integer.parseInt(name.substring(1));
            int index = (row.charAt(0) - 65) * this.wellCols + col - 1;
            String wellSampleID = MetadataTools.createLSID("WellSample", 0, index, field);
            store.setWellSampleID(wellSampleID, 0, index, field);
            store.setWellSampleIndex(new NonNegativeInteger(i), 0, index, field);
            String imageID = MetadataTools.createLSID("Image", i);
            store.setWellSampleImageRef(imageID, 0, index, field);
            store.setImageID(imageID, i);
            store.setImageName(name + " Field #" + (field + 1), i);
            store.setPlateAcquisitionWellSampleRef(wellSampleID, 0, 0, i);
        }
        MetadataLevel level = this.getMetadataOptions().getMetadataLevel();
        if (level != MetadataLevel.MINIMUM) {
            String instrumentID = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrumentID, 0);
            String objectiveID = MetadataTools.createLSID("Objective", 0, 0);
            store.setObjectiveID(objectiveID, 0, 0);
            if (this.objective != null) {
                String[] tokens = this.objective.split(" ");
                String mag = tokens[0].replaceAll("[xX]", "");
                String na = null;
                int naIndex = 0;
                for (int i = 0; i < tokens.length; ++i) {
                    if (!tokens[i].equals("NA")) continue;
                    naIndex = i + 1;
                    na = tokens[naIndex];
                    break;
                }
                Double magnification = new Double(mag);
                store.setObjectiveNominalMagnification(magnification, 0, 0);
                if (na != null) {
                    na = na.substring(0, 1) + "." + na.substring(1);
                    store.setObjectiveLensNA(new Double(na), 0, 0);
                }
                if (naIndex + 1 < tokens.length) {
                    store.setObjectiveManufacturer(tokens[naIndex + 1], 0, 0);
                }
            }
            for (int i = 0; i < this.getSeriesCount(); ++i) {
                store.setImageInstrumentRef(instrumentID, i);
                store.setObjectiveSettingsID(objectiveID, i);
                for (int c = 0; c < this.getSizeC(); ++c) {
                    store.setChannelName(this.channelNames.get(c), i, c);
                    Length emission = FormatTools.getEmissionWavelength(this.emWave[c]);
                    Length excitation = FormatTools.getExcitationWavelength(this.exWave[c]);
                    if (emission != null) {
                        store.setChannelEmissionWavelength(emission, i, c);
                    }
                    if (excitation != null) {
                        store.setChannelExcitationWavelength(excitation, i, c);
                    }
                    String detectorID = MetadataTools.createLSID("Detector", 0, c);
                    store.setDetectorID(detectorID, 0, c);
                    store.setDetectorSettingsID(detectorID, i, c);
                    store.setDetectorSettingsGain(this.gain[c], i, c);
                    store.setDetectorSettingsOffset(this.offset[c], i, c);
                    store.setDetectorSettingsBinning(MetadataTools.getBinning(this.binning), i, c);
                }
                long firstPlane = 0L;
                for (int p = 0; p < this.getImageCount(); ++p) {
                    int[] zct = this.getZCTCoords(p);
                    store.setPlaneExposureTime(new Time(this.exposure[zct[1]], UNITS.SECOND), i, p);
                    String file3 = this.getFilename(i, p);
                    if (file3 == null) continue;
                    long plane = this.getTimestamp(file3);
                    if (p == 0) {
                        firstPlane = plane;
                    }
                    double timestamp = (double)(plane - firstPlane) / 1000.0;
                    store.setPlaneDeltaT(new Time(timestamp, UNITS.SECOND), i, p);
                }
            }
            store.setPlateID(MetadataTools.createLSID("Plate", 0), 0);
            store.setPlateRowNamingConvention(MetadataTools.getNamingConvention("Letter"), 0);
            store.setPlateColumnNamingConvention(MetadataTools.getNamingConvention("Number"), 0);
            store.setPlateName(this.plateName, 0);
            store.setPlateDescription(this.plateDescription, 0);
            if (level != MetadataLevel.NO_OVERLAYS) {
                this.parseROIs(store);
            }
        }
    }

    private String locateExperimentFile(String id) throws FormatException, IOException {
        if (!BDReader.checkSuffix(id, "exp")) {
            Location expFile;
            Location parent = new Location(id).getAbsoluteFile().getParentFile();
            if (BDReader.checkSuffix(id, "tif")) {
                parent = parent.getParentFile();
            }
            if ((expFile = new Location(parent, EXPERIMENT_FILE)).exists()) {
                return expFile.getAbsolutePath();
            }
            throw new FormatException("Could not find Experiment.exp in " + parent.getAbsolutePath());
        }
        return id;
    }

    private IniList readMetaData(String id) throws IOException {
        IniParser parser = new IniParser();
        IniList plate = null;
        IniList xyz = null;
        for (String filename : this.metadataFiles) {
            InputStreamReader isr;
            RandomAccessInputStream stream;
            if (BDReader.checkSuffix(filename, "plt")) {
                stream = new RandomAccessInputStream(filename);
                try {
                    isr = new InputStreamReader((InputStream)stream, "UTF-8");
                    try {
                        BufferedReader br = new BufferedReader(isr);
                        try {
                            plate = parser.parseINI(br);
                            continue;
                        }
                        finally {
                            br.close();
                            continue;
                        }
                    }
                    finally {
                        isr.close();
                        continue;
                    }
                }
                finally {
                    stream.close();
                    continue;
                }
            }
            if (BDReader.checkSuffix(filename, "xyz")) {
                stream = new RandomAccessInputStream(filename);
                try {
                    isr = new InputStreamReader((InputStream)stream, "UTF-8");
                    try {
                        BufferedReader br = new BufferedReader(isr);
                        try {
                            xyz = parser.parseINI(br);
                            continue;
                        }
                        finally {
                            br.close();
                            continue;
                        }
                    }
                    finally {
                        isr.close();
                        continue;
                    }
                }
                finally {
                    stream.close();
                    continue;
                }
            }
            if (!filename.endsWith("RoiSummary.txt")) continue;
            this.roiFile = filename;
            if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM) continue;
            try (String[] s2 = new RandomAccessInputStream(filename);){
                String line = s2.readLine().trim();
                while (!line.endsWith(".adf\"")) {
                    line = s2.readLine().trim();
                }
                this.plateName = line.substring(line.indexOf(58)).trim();
                this.plateName = this.plateName.replace('/', File.separatorChar);
                this.plateName = this.plateName.replace('\\', File.separatorChar);
                for (int i = 0; i < 3; ++i) {
                    this.plateName = this.plateName.substring(0, this.plateName.lastIndexOf(File.separator));
                }
                this.plateName = this.plateName.substring(this.plateName.lastIndexOf(File.separator) + 1);
            }
        }
        if (plate == null) {
            throw new IOException("No Plate File");
        }
        IniTable plateType = plate.getTable("PlateType");
        if (this.plateName == null) {
            this.plateName = (String)plateType.get("Brand");
        }
        this.plateDescription = (String)plateType.get("Brand") + " " + (String)plateType.get("Description");
        int nWells = Integer.parseInt((String)plateType.get("Wells"));
        if (nWells == 96) {
            this.wellRows = 8;
            this.wellCols = 12;
        } else if (nWells == 384) {
            this.wellRows = 16;
            this.wellCols = 24;
        }
        for (String filename : this.rootList) {
            String name = new Location(filename).getName();
            if (!name.startsWith("Well ")) continue;
            this.wellLabels.add(name.split("\\s|\\.")[1]);
        }
        IniList exp = null;
        try (RandomAccessInputStream idStream = new RandomAccessInputStream(id);
             InputStreamReader isr = new InputStreamReader((InputStream)idStream, "UTF-8");
             BufferedReader br = new BufferedReader(isr);){
            exp = parser.parseINI(br);
        }
        IniTable imageTable = exp.getTable("Image");
        boolean montage = ((String)imageTable.get("Montaged")).equals("1");
        if (montage) {
            this.fieldRows = Integer.parseInt((String)imageTable.get("TilesY"));
            this.fieldCols = Integer.parseInt((String)imageTable.get("TilesX"));
        } else {
            this.fieldRows = 1;
            this.fieldCols = 1;
        }
        this.core.clear();
        int coresize = this.wellLabels.size() * this.fieldRows * this.fieldCols;
        CoreMetadata ms0 = new CoreMetadata();
        this.core.add(ms0);
        for (int i = 1; i < coresize; ++i) {
            this.core.add(new CoreMetadata());
        }
        ms0.sizeC = Integer.parseInt((String)exp.getTable("General").get("Dyes"));
        ms0.bitsPerPixel = Integer.parseInt((String)exp.getTable("Camera").get("BitdepthUsed"));
        IniTable dyeTable = exp.getTable("Dyes");
        for (int i = 1; i <= this.getSizeC(); ++i) {
            this.channelNames.add((String)dyeTable.get(Integer.toString(i)));
        }
        if (xyz != null) {
            boolean zEnabled;
            IniTable zTable = xyz.getTable("Z1Axis");
            boolean bl = zEnabled = "1".equals(zTable.get("Z1AxisEnabled")) && "1".equals(zTable.get("Z1AxisMode"));
            ms0.sizeZ = zEnabled ? (int)Double.parseDouble((String)zTable.get("Z1AxisValue")) + 1 : 1;
        } else {
            ms0.sizeZ = 1;
        }
        ms0.sizeT = 0;
        for (String channelName : this.channelNames) {
            int images = 0;
            for (String filename : this.wellList.get(1)) {
                if (!filename.startsWith(channelName) || !filename.endsWith(".tif")) continue;
                ++images;
            }
            if (images <= this.getImageCount()) continue;
            ms0.sizeT = images / this.getSizeZ();
            ms0.imageCount = this.getSizeZ() * this.getSizeT() * this.channelNames.size();
        }
        return exp;
    }

    private void parseChannelData(Location dir) throws IOException {
        this.emWave = new double[this.channelNames.size()];
        this.exWave = new double[this.channelNames.size()];
        this.exposure = new double[this.channelNames.size()];
        this.gain = new double[this.channelNames.size()];
        this.offset = new double[this.channelNames.size()];
        for (int c = 0; c < this.channelNames.size(); ++c) {
            Location dyeFile = new Location(dir, this.channelNames.get(c) + ".dye");
            IniList dye = null;
            try (RandomAccessInputStream stream = new RandomAccessInputStream(dyeFile.getAbsolutePath());
                 InputStreamReader isr = new InputStreamReader((InputStream)stream, "UTF-8");
                 BufferedReader br = new BufferedReader(isr);){
                dye = new IniParser().parseINI(br);
            }
            IniTable numerator = dye.getTable("Numerator");
            String em = (String)numerator.get("Emission");
            em = em.substring(0, em.indexOf(32));
            this.emWave[c] = Double.parseDouble(em);
            String ex = (String)numerator.get("Excitation");
            ex = ex.substring(0, ex.lastIndexOf(" "));
            if (ex.indexOf(32) != -1) {
                ex = ex.substring(ex.lastIndexOf(" ") + 1);
            }
            this.exWave[c] = Double.parseDouble(ex);
            this.exposure[c] = Double.parseDouble((String)numerator.get("Exposure"));
            this.gain[c] = Double.parseDouble((String)numerator.get("Gain"));
            this.offset[c] = Double.parseDouble((String)numerator.get("Offset"));
        }
    }

    private String[][] getTiffs() {
        ArrayList files = new ArrayList();
        Pattern p = Pattern.compile(".* - n\\d\\d\\d\\d\\d\\d\\.tif");
        int nextWell = 0;
        for (String filename : this.rootList) {
            Location file2 = new Location(filename).getAbsoluteFile();
            if (!file2.getName().startsWith("Well ") || !file2.isDirectory()) continue;
            String[] list = this.wellList.get(nextWell++);
            ArrayList<String> tiffList = new ArrayList<String>();
            for (String tiff : list) {
                if (!p.matcher(tiff).matches()) continue;
                tiffList.add(new Location(file2, tiff).getAbsolutePath());
            }
            files.add(tiffList);
        }
        String[][] tiffFiles = new String[files.size()][];
        for (int i = 0; i < tiffFiles.length; ++i) {
            tiffFiles[i] = ((List)files.get(i)).toArray(new String[0]);
        }
        return tiffFiles;
    }

    private void parseROIs(MetadataStore store) throws IOException {
        String[] cols;
        int firstRow;
        if (this.roiFile == null) {
            return;
        }
        String roiData = DataTools.readFile(this.roiFile);
        String[] lines = roiData.split("\r\n");
        for (firstRow = 0; firstRow < lines.length && !lines[firstRow].startsWith("ROI"); ++firstRow) {
        }
        if ((firstRow += 2) >= lines.length) {
            return;
        }
        for (int i = firstRow; i < lines.length && (cols = lines[i].split("\t")).length >= 6; ++i) {
            if (cols[2].trim().length() <= 0) continue;
            String rectangleID = MetadataTools.createLSID("Shape", i - firstRow, 0);
            store.setRectangleID(rectangleID, i - firstRow, 0);
            store.setRectangleX(new Double(cols[2]), i - firstRow, 0);
            store.setRectangleY(new Double(cols[3]), i - firstRow, 0);
            store.setRectangleWidth(new Double(cols[4]), i - firstRow, 0);
            store.setRectangleHeight(new Double(cols[5]), i - firstRow, 0);
            String roiID = MetadataTools.createLSID("ROI", i - firstRow);
            store.setROIID(roiID, i - firstRow);
            for (int s2 = 0; s2 < this.getSeriesCount(); ++s2) {
                store.setImageROIRef(roiID, s2, i - firstRow);
            }
        }
    }

    private String getFilename(int series, int no) {
        int[] zct = this.getZCTCoords(no);
        String channel = this.channelNames.get(zct[1]);
        int well = series / (this.fieldRows * this.fieldCols);
        for (int i = 0; i < this.tiffs[well].length; ++i) {
            String name = this.tiffs[well][i];
            name = name.substring(name.lastIndexOf(File.separator) + 1);
            name = name.substring(0, name.lastIndexOf("."));
            String index = name.substring(name.lastIndexOf("n") + 1);
            int realIndex = this.getIndex(zct[0], 0, zct[2]);
            if (!name.startsWith(channel) || Integer.parseInt(index) != realIndex) continue;
            return this.tiffs[well][i];
        }
        return null;
    }

    private long getTimestamp(String file2) throws FormatException, IOException {
        try (RandomAccessInputStream s2 = new RandomAccessInputStream(file2, 16);){
            TiffIFDEntry timestamp;
            TiffParser parser = new TiffParser(s2);
            parser.setDoCaching(false);
            IFD firstIFD = parser.getFirstIFD();
            if (firstIFD != null && (timestamp = (TiffIFDEntry)firstIFD.get(306)) != null) {
                String stamp = parser.getIFDValue(timestamp).toString();
                stamp = DateTools.formatDate(stamp, BaseTiffReader.DATE_FORMATS, ".");
                Timestamp t = Timestamp.valueOf(stamp);
                long l = t.asInstant().getMillis();
                return l;
            }
        }
        return new Location(file2).lastModified();
    }
}

