package plugins.ylemontag.sequencecomparator;

/**
 * 
 * @author Yoann Le Montagner
 * 
 * Contains global indicators measuring the distance between two sequences
 */
public class ErrorMeasure implements Comparable<ErrorMeasure>
{
	/**
	 * Label
	 */
	public String label;
	
	/**
	 * Overall error
	 */
	public double errorAll;
	
	/**
	 * Error between the sequence in the hyper-planes z=constant
	 */
	public double[] errorZ;
	
	/**
	 * Error between the sequence in the hyper-planes t=constant
	 */
	public double[] errorT;
	
	/**
	 * Error between the sequence in the hyper-planes c=constant
	 */
	public double[] errorC;
	
	@Override
	public String toString()
	{
		return label;
	}
	
	@Override
	public int compareTo(ErrorMeasure op)
	{
		return op.hashCode() - hashCode();
	}
}
