/*
 * Decompiled with CFR 0.152.
 */
package plugins.ylemontag.mathoperations.expressions;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import plugins.ylemontag.mathoperations.Expression;

public class Token {
    private Type _type;
    private Object _value;

    private Token(Type type) {
        this(type, null);
    }

    private Token(Type type, Object value) {
        this._type = type;
        this._value = value;
    }

    public Type getType() {
        return this._type;
    }

    public Object getValue() {
        return this._value;
    }

    public String toString() {
        String retVal = this._type.getName();
        if (this._value != null) {
            retVal = retVal + "(" + this._value + ")";
        }
        return retVal;
    }

    public static LinkedList<Token> parse(String in) {
        LinkedList<Token> retVal = new LinkedList<Token>();
        int pos = 0;
        int length = in.length();
        while (pos < length) {
            Type type = null;
            Matcher m = null;
            for (Type t : Type.values()) {
                m = t.getPattern().matcher(in.subSequence(pos, length));
                if (!m.find()) continue;
                type = t;
                break;
            }
            if (type == null) {
                if (!Pattern.matches("[ \\t]*", in.subSequence(pos, length))) {
                    throw new Expression.ParsingException("Invalid token stream");
                }
                pos = length;
                continue;
            }
            pos += m.group(0).length();
            retVal.add(Token.decodeMatchedToken(type, m));
        }
        return retVal;
    }

    private static Token decodeMatchedToken(Type type, Matcher m) {
        if (type == Type.ID) {
            if (m.groupCount() != 1) {
                throw new Expression.ParsingException("ID token badly formatted");
            }
            return new Token(type, m.group(1));
        }
        if (type == Type.LITTERAL) {
            if (m.groupCount() != 1) {
                throw new Expression.ParsingException("Litteral token badly formatted");
            }
            try {
                double value = Double.parseDouble(m.group(1));
                return new Token(type, value);
            }
            catch (NumberFormatException err) {
                throw new Expression.ParsingException("Litteral token badly formatted");
            }
        }
        return new Token(type);
    }

    public static enum Type {
        PLUS("+", "\\+"),
        MINUS("-", "-"),
        TIMES("*", "\\*"),
        DIV_SIGN("/", "/"),
        POW_SIGN("^", "\\^"),
        OPEN_P("(", "\\("),
        CLOSE_P(")", "\\)"),
        COMMA(",", ","),
        ID("ID", "([A-Za-z_][A-Za-z_0-9]*)"),
        LITTERAL("L", "([0-9]+(?:\\.[0-9]+)?)");

        private String _name;
        private Pattern _pattern;

        private Type(String name, String regex) {
            this._name = name;
            this._pattern = Pattern.compile("^[ \\t]*" + regex);
        }

        public String getName() {
            return this._name;
        }

        public Pattern getPattern() {
            return this._pattern;
        }
    }
}

