/*
 * Decompiled with CFR 0.152.
 */
package icy.type.geom;

import icy.type.dimension.Dimension3D;
import icy.type.geom.ZShape3D;
import icy.type.point.Point3D;
import icy.type.rectangle.Rectangle3D;
import java.beans.Transient;

public abstract class BoxShape3D
extends ZShape3D {
    protected BoxShape3D() {
    }

    public abstract double getX();

    public abstract double getY();

    public abstract double getSizeX();

    public abstract double getSizeY();

    public double getMinX() {
        return this.getX();
    }

    public double getMinY() {
        return this.getY();
    }

    public double getMaxX() {
        return this.getX() + this.getSizeX();
    }

    public double getMaxY() {
        return this.getY() + this.getSizeY();
    }

    public double getCenterX() {
        return this.getX() + this.getSizeX() / 2.0;
    }

    public double getCenterY() {
        return this.getY() + this.getSizeY() / 2.0;
    }

    @Transient
    public Rectangle3D getFrame() {
        return new Rectangle3D.Double(this.getX(), this.getY(), this.getZ(), this.getSizeX(), this.getSizeY(), this.getSizeZ());
    }

    public abstract void setFrame(double var1, double var3, double var5, double var7, double var9, double var11);

    public void setFrame(Point3D loc, Dimension3D size) {
        this.setFrame(loc.getX(), loc.getY(), loc.getZ(), size.getSizeX(), size.getSizeY(), size.getSizeZ());
    }

    public void setFrame(Rectangle3D r) {
        this.setFrame(r.getX(), r.getY(), r.getZ(), r.getSizeX(), r.getSizeY(), r.getSizeZ());
    }

    public void setFrameFromDiagonal(double x1, double y1, double z1, double x2, double y2, double z2) {
        double t;
        if (x2 < x1) {
            t = x1;
            x1 = x2;
            x2 = t;
        }
        if (y2 < y1) {
            t = y1;
            y1 = y2;
            y2 = t;
        }
        if (z2 < z1) {
            t = z1;
            z1 = z2;
            z2 = t;
        }
        this.setFrame(x1, y1, z1, x2 - x1, y2 - y1, z2 - z1);
    }

    public void setFrameFromDiagonal(Point3D p1, Point3D p2) {
        this.setFrameFromDiagonal(p1.getX(), p1.getY(), p1.getZ(), p2.getX(), p2.getY(), p2.getZ());
    }

    public void setFrameFromCenter(double centerX, double centerY, double centerZ, double cornerX, double cornerY, double cornerZ) {
        double halfX = Math.abs(cornerX - centerX);
        double halfY = Math.abs(cornerY - centerY);
        double halfZ = Math.abs(cornerZ - centerZ);
        this.setFrame(centerX - halfX, centerY - halfY, centerZ - halfZ, halfX * 2.0, halfY * 2.0, halfZ * 2.0);
    }

    public void setFrameFromCenter(Point3D center, Point3D corner) {
        this.setFrameFromCenter(center.getX(), center.getY(), center.getZ(), corner.getX(), corner.getY(), corner.getZ());
    }

    public Rectangle3D getBounds() {
        return new Rectangle3D.Double(this.getX(), this.getY(), this.getZ(), this.getSizeX(), this.getSizeY(), this.getSizeZ());
    }
}

