/*
 * Decompiled with CFR 0.152.
 */
package plugins.kernel.roi.roi3d;

import icy.painter.Anchor3D;
import icy.painter.LineAnchor3D;
import icy.resource.ResourceUtil;
import icy.type.collection.CollectionUtil;
import icy.type.geom.FlatPolygon3D;
import icy.type.geom.Polygon2D;
import icy.type.point.Point3D;
import icy.type.point.Point5D;
import icy.type.rectangle.Rectangle3D;
import icy.util.XMLUtil;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.kernel.roi.roi2d.ROI2DPolygon;
import plugins.kernel.roi.roi2d.ROI2DShape;
import plugins.kernel.roi.roi3d.ROI3DZShape;

public class ROI3DFlatPolygon
extends ROI3DZShape {
    public static final String ID_POINTS = "points";
    public static final String ID_POINT = "point";

    public ROI3DFlatPolygon(FlatPolygon3D polygon3D) {
        super(new FlatPolygon3D());
        this.setPolygon3D(polygon3D);
        this.setIcon(ResourceUtil.ICON_ROI_FLATPOLYGON3D);
    }

    public ROI3DFlatPolygon(Polygon2D polygon, double z, double sizeZ) {
        this(new FlatPolygon3D(polygon, z, sizeZ));
    }

    public ROI3DFlatPolygon(Point5D pt) {
        this(new Polygon2D(CollectionUtil.createArrayList((Object)pt.toPoint2D())), pt.getZ(), 0.0);
    }

    public ROI3DFlatPolygon() {
        this(new FlatPolygon3D());
    }

    @Override
    public String getDefaultName() {
        return "FlatPolygon3D";
    }

    @Override
    protected Anchor3D createAnchor(Point3D pos) {
        return new ROI3DPolygonAnchor3D(pos, this.getColor(), this.getFocusedColor());
    }

    @Override
    protected ROI2DPolygon createROI2DShape() {
        return new ROI2DPolygon();
    }

    public FlatPolygon3D getPolygon3D() {
        return (FlatPolygon3D)this.shape;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPolygon3D(FlatPolygon3D polygon3D) {
        this.beginUpdate();
        try {
            double centerZ = polygon3D.getCenterZ();
            List<Point2D> pts = polygon3D.getPoints();
            List<Anchor3D> ctrlPts = this.getControlPoints();
            if (pts.size() == ctrlPts.size() - 2) {
                for (int i = 0; i < pts.size(); ++i) {
                    Point2D newPt = pts.get(i);
                    Anchor3D pt = ctrlPts.get(i + 2);
                    pt.setPosition(newPt.getX(), newPt.getY(), centerZ);
                }
            } else {
                this.removeAllPoint();
                for (Point2D pt : polygon3D.getPoints()) {
                    this.addNewPoint((Point3D)new Point3D.Double(pt.getX(), pt.getY(), centerZ), false);
                }
            }
            this.closeZ.setZ(polygon3D.getMinZ());
            this.farZ.setZ(polygon3D.getMaxZ());
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPoints(List<Point2D> pts) {
        this.beginUpdate();
        try {
            List<Anchor3D> ctrlPts = this.getControlPoints();
            if (pts.size() == ctrlPts.size() - 2) {
                for (int i = 0; i < pts.size(); ++i) {
                    Point2D newPt = pts.get(i);
                    Anchor3D pt = ctrlPts.get(i + 2);
                    pt.setPosition(newPt.getX(), newPt.getY(), pt.getZ());
                }
            } else {
                this.removeAllPoint();
                for (Point2D pt : pts) {
                    this.addNewPoint(pt, false);
                }
            }
        }
        finally {
            this.endUpdate();
        }
    }

    public void setPolygon2D(Polygon2D polygon2D) {
        this.setPoints(polygon2D.getPoints());
    }

    public Anchor3D addNewPoint(Point2D pos, boolean insert) {
        if (!this.canAddPoint()) {
            return null;
        }
        return this.addNewPoint((Point3D)new Point3D.Double(pos.getX(), pos.getY(), this.getZShape().getCenterZ()), insert);
    }

    @Override
    public boolean canSetBounds() {
        return true;
    }

    @Override
    public void setBounds3D(Rectangle3D bounds) {
        this.beginUpdate();
        try {
            this.closeZ.setPosition(this.closeZ.getX(), this.closeZ.getY(), bounds.getMinZ());
            this.farZ.setPosition(this.farZ.getX(), this.farZ.getY(), bounds.getMaxZ());
        }
        finally {
            this.endUpdate();
        }
    }

    @Override
    protected void updateShape2DROI() {
        ROI2DShape r = this.getShape2DROI();
        if (r instanceof ROI2DPolygon) {
            ROI2DPolygon roi = (ROI2DPolygon)r;
            roi.setPolygon2D(this.getPolygon3D().getShape2D());
        }
    }

    @Override
    protected void updateFromShape2DROI() {
        ROI2DShape r = this.getShape2DROI();
        if (r instanceof ROI2DPolygon) {
            ROI2DPolygon roi = (ROI2DPolygon)r;
            this.beginUpdate();
            try {
                this.setPolygon2D(roi.getPolygon2D());
            }
            finally {
                this.endUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateShapeInternal() {
        this.beginUpdate();
        try {
            super.updateShapeInternal();
            this.getPolygon3D().setPoints(this.getPoints2D());
            this.boundsInvalid = true;
            Rectangle3D bounds = this.getBounds3D();
            this.closeZ.setX(bounds.getCenterX());
            this.closeZ.setY(bounds.getCenterY());
            this.farZ.setX(bounds.getCenterX());
            this.farZ.setY(bounds.getCenterY());
            List list = this.controlPoints;
            synchronized (list) {
                for (int i = 2; i < this.controlPoints.size(); ++i) {
                    ((Anchor3D)this.controlPoints.get(i)).setZ(bounds.getCenterZ());
                }
            }
        }
        finally {
            this.endUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean loadFromXML(Node node) {
        this.beginUpdate();
        try {
            if (!super.loadFromXML(node)) {
                boolean bl = false;
                return bl;
            }
            this.removeAllPoint();
            ArrayList<Node> nodesPoint = XMLUtil.getChildren(XMLUtil.getElement(node, ID_POINTS), ID_POINT);
            if (nodesPoint != null) {
                for (Node n : nodesPoint) {
                    Anchor3D pt = this.createAnchor((Point3D)new Point3D.Double());
                    pt.loadPositionFromXML(n);
                    this.addPoint(pt);
                }
            }
        }
        finally {
            this.endUpdate();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveToXML(Node node) {
        if (!super.saveToXML(node)) {
            return false;
        }
        Element nodePoints = XMLUtil.setElement(node, ID_POINTS);
        List list = this.controlPoints;
        synchronized (list) {
            for (Anchor3D pt : this.controlPoints) {
                pt.savePositionToXML((Node)XMLUtil.addElement(nodePoints, ID_POINT));
            }
        }
        return true;
    }

    protected class ROI3DPolygonAnchor3D
    extends LineAnchor3D {
        public ROI3DPolygonAnchor3D(Point3D position, Color color, Color selectedColor) {
            super(position, color, selectedColor);
        }

        @Override
        protected Anchor3D getPreviousPoint() {
            int ind = ROI3DFlatPolygon.this.controlPoints.indexOf((Object)this);
            if (ind == 0) {
                if (ROI3DFlatPolygon.this.controlPoints.size() > 1) {
                    return (Anchor3D)ROI3DFlatPolygon.this.controlPoints.get(1);
                }
                return null;
            }
            if (ind != -1) {
                return (Anchor3D)ROI3DFlatPolygon.this.controlPoints.get(ind - 1);
            }
            return null;
        }
    }
}

