/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.MissingLibraryException;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.services.POIService;
import loci.formats.tiff.IFD;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffParser;
import ome.xml.model.primitives.Timestamp;

public class IPWReader
extends FormatReader {
    public static final int IPW_MAGIC_BYTES = -791735840;
    private Map<Integer, String> imageFiles;
    private transient POIService poi;

    public IPWReader() {
        super("Image-Pro Workspace", "ipw");
        this.domains = new String[]{"Unknown"};
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 4;
        if (!FormatTools.validStream(stream, 4, false)) {
            return false;
        }
        return stream.readInt() == -791735840;
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        try (RandomAccessInputStream stream = this.poi.getDocumentStream(this.imageFiles.get(0));){
            TiffParser tp = new TiffParser(stream);
            IFD firstIFD = tp.getFirstIFD();
            int[] bits = firstIFD.getBitsPerSample();
            if (bits[0] <= 8) {
                int[] colorMap = tp.getColorMap(firstIFD);
                if (colorMap == null) {
                    byte[][] byArray = null;
                    return byArray;
                }
                byte[][] table = new byte[3][colorMap.length / 3];
                int next = 0;
                for (int j = 0; j < table.length; ++j) {
                    for (int i = 0; i < table[0].length; ++i) {
                        table[j][i] = (byte)(colorMap[next++] >> 8);
                    }
                }
                byte[][] byArray = table;
                return byArray;
            }
        }
        return null;
    }

    @Override
    public int getOptimalTileWidth() {
        block10: {
            int n;
            block9: {
                FormatTools.assertId(this.currentId, true, 1);
                RandomAccessInputStream stream = this.poi.getDocumentStream(this.imageFiles.get(0));
                try {
                    TiffParser tp = new TiffParser(stream);
                    IFD ifd = tp.getFirstIFD();
                    n = (int)ifd.getTileWidth();
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (FormatException e) {
                        LOGGER.debug("Could not retrieve tile width", e);
                        break block10;
                    }
                    catch (IOException e) {
                        LOGGER.debug("Could not retrieve tile height", e);
                    }
                }
                stream.close();
            }
            return n;
        }
        return super.getOptimalTileWidth();
    }

    @Override
    public int getOptimalTileHeight() {
        block10: {
            int n;
            block9: {
                FormatTools.assertId(this.currentId, true, 1);
                RandomAccessInputStream stream = this.poi.getDocumentStream(this.imageFiles.get(0));
                try {
                    TiffParser tp = new TiffParser(stream);
                    IFD ifd = tp.getFirstIFD();
                    stream.close();
                    n = (int)ifd.getTileLength();
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (FormatException e) {
                        LOGGER.debug("Could not retrieve tile height", e);
                        break block10;
                    }
                    catch (IOException e) {
                        LOGGER.debug("Could not retrieve tile length", e);
                    }
                }
                stream.close();
            }
            return n;
        }
        return super.getOptimalTileHeight();
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        if (this.poi == null) {
            this.initPOIService();
        }
        try (RandomAccessInputStream stream = this.poi.getDocumentStream(this.imageFiles.get(no));){
            TiffParser tp = new TiffParser(stream);
            IFD ifd = tp.getFirstIFD();
            tp.getSamples(ifd, buf, x, y, w, h2);
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.poi != null) {
                this.poi.close();
            }
            this.poi = null;
            this.imageFiles = null;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.initPOIService();
        this.imageFiles = new HashMap<Integer, String>();
        Vector<String> fileList = this.poi.getDocumentList();
        String description = null;
        String creationDate = null;
        CoreMetadata m3 = (CoreMetadata)this.core.get(0);
        for (String name : fileList) {
            String relativePath = name.substring(name.lastIndexOf(File.separator) + 1);
            if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
                if (relativePath.equals("CONTENTS")) {
                    this.addGlobalMeta("Version", new String(this.poi.getDocumentBytes(name), "UTF-8").trim());
                } else if (relativePath.equals("FrameRate")) {
                    byte[] b = this.poi.getDocumentBytes(name, 4);
                    this.addGlobalMeta("Frame Rate", DataTools.bytesToInt(b, true));
                } else if (relativePath.equals("FrameInfo")) {
                    RandomAccessInputStream s2 = this.poi.getDocumentStream(name);
                    s2.order(true);
                    int q = 0;
                    while ((long)q < s2.length() / 2L) {
                        this.addGlobalMetaList("FrameInfo", s2.readShort());
                        ++q;
                    }
                    s2.close();
                }
            }
            if (relativePath.equals("ImageInfo")) {
                description = new String(this.poi.getDocumentBytes(name), "UTF-8").trim();
                this.addGlobalMeta("Image Description", description);
                String timestamp = null;
                if (description != null) {
                    String[] tokens;
                    for (String token : tokens = description.split("\n")) {
                        String label = "Timestamp";
                        String data = token.trim();
                        if (token.indexOf(61) != -1) {
                            label = token.substring(0, token.indexOf(61)).trim();
                            data = token.substring(token.indexOf(61) + 1).trim();
                        }
                        this.addGlobalMeta(label, data);
                        if (label.equals("frames")) {
                            m3.sizeT = Integer.parseInt(data);
                            continue;
                        }
                        if (label.equals("slices")) {
                            m3.sizeZ = Integer.parseInt(data);
                            continue;
                        }
                        if (label.equals("channels")) {
                            m3.sizeC = Integer.parseInt(data);
                            continue;
                        }
                        if (!label.equals("Timestamp")) continue;
                        timestamp = data;
                    }
                }
                if (timestamp == null) continue;
                if (timestamp.length() > 26) {
                    timestamp = timestamp.substring(timestamp.length() - 26);
                }
                creationDate = DateTools.formatDate(timestamp, "MM/dd/yyyy HH:mm:ss aa", ".");
                continue;
            }
            if (!relativePath.equals("ImageTIFF")) continue;
            String idx = "0";
            if (!name.substring(0, name.lastIndexOf(File.separator)).equals("Root Entry")) {
                idx = name.substring(21, name.indexOf(File.separator, 22));
            }
            this.imageFiles.put(new Integer(idx), name);
        }
        LOGGER.info("Populating metadata");
        m3.imageCount = this.imageFiles.size();
        IFD firstIFD = null;
        try (RandomAccessInputStream stream = this.poi.getDocumentStream(this.imageFiles.get(0));){
            TiffParser tp = new TiffParser(stream);
            firstIFD = tp.getFirstIFD();
        }
        boolean bl = m3.rgb = firstIFD.getSamplesPerPixel() > 1;
        if (!this.isRGB()) {
            boolean bl2 = m3.indexed = firstIFD.getPhotometricInterpretation() == PhotoInterp.RGB_PALETTE;
        }
        if (this.isIndexed()) {
            m3.sizeC = 1;
            m3.rgb = false;
        }
        m3.littleEndian = firstIFD.isLittleEndian();
        this.addGlobalMeta("slices", "1");
        this.addGlobalMeta("channels", "1");
        this.addGlobalMeta("frames", this.getImageCount());
        m3.sizeX = (int)firstIFD.getImageWidth();
        m3.sizeY = (int)firstIFD.getImageLength();
        String string = m3.dimensionOrder = this.isRGB() ? "XYCZT" : "XYZCT";
        if (this.getSizeZ() == 0) {
            m3.sizeZ = 1;
        }
        if (this.getSizeC() == 0) {
            m3.sizeC = 1;
        }
        if (this.getSizeT() == 0) {
            m3.sizeT = 1;
        }
        if (this.getSizeZ() * this.getSizeC() * this.getSizeT() == 1 && this.getImageCount() != 1) {
            m3.sizeZ = this.getImageCount();
        }
        if (this.isRGB()) {
            m3.sizeC *= 3;
        }
        int bitsPerSample = firstIFD.getBitsPerSample()[0];
        m3.pixelType = firstIFD.getPixelType();
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        store.setImageDescription(description, 0);
        if (creationDate != null) {
            store.setImageAcquisitionDate(new Timestamp(creationDate), 0);
        }
    }

    private void initPOIService() throws FormatException, IOException {
        try {
            ServiceFactory factory = new ServiceFactory();
            this.poi = factory.getInstance(POIService.class);
        }
        catch (DependencyException de) {
            throw new MissingLibraryException("POI library not found", de);
        }
        this.poi.initialize(Location.getMappedId(this.getCurrentFile()));
    }
}

