/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.image3d;

import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.sequence.VolumetricImage;
import icy.type.DataType;
import icy.type.collection.array.ArrayUtil;
import mcib3d.image3d.ImageByte;
import mcib3d.image3d.ImageFloat;
import mcib3d.image3d.ImageHandler;
import mcib3d.image3d.ImageShort;

public class ICY_Utils {
    public static void createVolumeFromImageHandler(ImageHandler res, DataType type, VolumetricImage vol) {
        for (int z = 0; z < res.sizeZ; ++z) {
            Object[] tabres;
            IcyBufferedImage icyimg = null;
            if (type.compareTo((Enum)DataType.USHORT) == 0) {
                tabres = (short[])res.getArray1D(z);
                icyimg = new IcyBufferedImage(res.sizeX, res.sizeY, (Object)tabres);
            } else if (type.compareTo((Enum)DataType.UBYTE) == 0) {
                tabres = (byte[])res.getArray1D(z);
                icyimg = new IcyBufferedImage(res.sizeX, res.sizeY, (Object)tabres);
            } else {
                tabres = (float[])res.getArray1D(z);
                icyimg = new IcyBufferedImage(res.sizeX, res.sizeY, (Object)tabres);
            }
            vol.setImage(z, icyimg);
        }
    }

    public static ImageHandler createImageHandlerFromSequence(Sequence seq, int t, int c) {
        ImageHandler img;
        int nbSlice = seq.getSizeZ();
        int nbPixel = seq.getSizeX() * seq.getSizeY();
        DataType type = seq.getDataType_();
        if (type.compareTo((Enum)DataType.USHORT) == 0) {
            img = new ImageShort(seq.getDataXYZAsShort(t, c), "tmp", seq.getWidth());
        } else if (type.compareTo((Enum)DataType.UBYTE) == 0) {
            img = new ImageByte(seq.getDataXYZAsByte(t, c), "tmp", seq.getWidth());
        } else if (type.compareTo((Enum)DataType.FLOAT) == 0) {
            img = new ImageFloat(seq.getDataXYZAsFloat(t, c), "tmp", seq.getWidth());
        } else {
            float[][] arrayImg = new float[nbSlice][nbPixel];
            System.out.println("basic type " + type + " not supported; converting to float");
            for (int z = 0; z < nbSlice; ++z) {
                arrayImg[z] = (float[])ArrayUtil.arrayToFloatArray((Object)seq.getDataXY(t, z, c), (boolean)type.isSigned());
            }
            img = new ImageFloat(arrayImg, "tmp", seq.getWidth());
        }
        return img;
    }
}

