/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayType;
import pl.edu.icm.jlargearrays.MemoryCounter;
import pl.edu.icm.jlargearrays.Utilities;
import sun.misc.Cleaner;

public class ByteLargeArray
extends LargeArray {
    private static final long serialVersionUID = 3135411647668758832L;
    private byte[] data;

    public ByteLargeArray(long l) {
        this(l, true);
    }

    public ByteLargeArray(long l, boolean bl) {
        this.type = LargeArrayType.BYTE;
        this.sizeof = 1L;
        if (l <= 0L) {
            throw new IllegalArgumentException(l + " is not a positive long value");
        }
        this.length = l;
        if (l > (long)LARGEST_32BIT_INDEX) {
            System.gc();
            this.ptr = Utilities.UNSAFE.allocateMemory(this.length * this.sizeof);
            if (bl) {
                this.zeroNativeMemory(l);
            }
            Cleaner.create((Object)this, (Runnable)new LargeArray.Deallocator(this.ptr, this.length, this.sizeof));
            MemoryCounter.increaseCounter(this.length * this.sizeof);
        } else {
            this.data = new byte[(int)l];
        }
    }

    public ByteLargeArray(byte[] byArray) {
        this.type = LargeArrayType.BYTE;
        this.sizeof = 1L;
        this.length = byArray.length;
        this.data = byArray;
    }

    @Override
    public ByteLargeArray clone() {
        ByteLargeArray byteLargeArray = new ByteLargeArray(this.length, false);
        Utilities.arraycopy(this, 0L, byteLargeArray, 0L, this.length);
        return byteLargeArray;
    }

    @Override
    public Byte get(long l) {
        return this.getByte(l);
    }

    @Override
    public Byte getFromNative(long l) {
        return Utilities.UNSAFE.getByte(this.ptr + l);
    }

    @Override
    public boolean getBoolean(long l) {
        if (this.ptr != 0L) {
            return Utilities.UNSAFE.getByte(this.ptr + l) != 0;
        }
        return this.data[(int)l] != 0;
    }

    @Override
    public byte getByte(long l) {
        if (this.isLarge()) {
            return Utilities.UNSAFE.getByte(this.ptr + l);
        }
        return this.data[(int)l];
    }

    @Override
    public short getShort(long l) {
        if (this.ptr != 0L) {
            return Utilities.UNSAFE.getByte(this.ptr + l);
        }
        return this.data[(int)l];
    }

    @Override
    public int getInt(long l) {
        if (this.ptr != 0L) {
            return Utilities.UNSAFE.getByte(this.ptr + l);
        }
        return this.data[(int)l];
    }

    @Override
    public long getLong(long l) {
        if (this.ptr != 0L) {
            return Utilities.UNSAFE.getByte(this.ptr + l);
        }
        return this.data[(int)l];
    }

    @Override
    public float getFloat(long l) {
        if (this.ptr != 0L) {
            return Utilities.UNSAFE.getByte(this.ptr + l);
        }
        return this.data[(int)l];
    }

    @Override
    public double getDouble(long l) {
        if (this.ptr != 0L) {
            return Utilities.UNSAFE.getByte(this.ptr + l);
        }
        return this.data[(int)l];
    }

    @Override
    public boolean[] getBooleanData(boolean[] blArray, long l, long l2, long l3) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (l2 < 0L || l2 > this.length || l2 < l) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (l3 < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long l4 = (long)Math.ceil((double)(l2 - l) / (double)l3);
        if (l4 > (long)ByteLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        boolean[] blArray2 = blArray != null && (long)blArray.length >= l4 ? blArray : new boolean[(int)l4];
        int n = 0;
        if (this.ptr != 0L) {
            for (long i = l; i < l2; i += l3) {
                byte by = Utilities.UNSAFE.getByte(this.ptr + i);
                blArray2[n++] = by == 1;
            }
        } else {
            for (long i = l; i < l2; i += l3) {
                byte by = this.data[(int)i];
                blArray2[n++] = by == 1;
            }
        }
        return blArray2;
    }

    @Override
    public boolean[] getBooleanData() {
        if (this.ptr != 0L) {
            return null;
        }
        boolean[] blArray = new boolean[(int)this.length];
        int n = 0;
        while ((long)n < this.length) {
            blArray[n] = this.data[n] != 0;
            ++n;
        }
        return blArray;
    }

    public byte[] getData() {
        if (this.ptr != 0L) {
            return null;
        }
        return this.data;
    }

    @Override
    public byte[] getByteData() {
        if (this.ptr != 0L) {
            return null;
        }
        return (byte[])this.data.clone();
    }

    @Override
    public byte[] getByteData(byte[] byArray, long l, long l2, long l3) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (l2 < 0L || l2 > this.length || l2 < l) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (l3 < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long l4 = (long)Math.ceil((double)(l2 - l) / (double)l3);
        if (l4 > (long)ByteLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        byte[] byArray2 = byArray != null && (long)byArray.length >= l4 ? byArray : new byte[(int)l4];
        int n = 0;
        if (this.ptr != 0L) {
            for (long i = l; i < l2; i += l3) {
                byArray2[n++] = Utilities.UNSAFE.getByte(this.ptr + i);
            }
        } else {
            for (long i = l; i < l2; i += l3) {
                byArray2[n++] = this.data[(int)i];
            }
        }
        return byArray2;
    }

    @Override
    public short[] getShortData() {
        if (this.ptr != 0L) {
            return null;
        }
        short[] sArray = new short[(int)this.length];
        int n = 0;
        while ((long)n < this.length) {
            sArray[n] = this.data[n];
            ++n;
        }
        return sArray;
    }

    @Override
    public short[] getShortData(short[] sArray, long l, long l2, long l3) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (l2 < 0L || l2 > this.length || l2 < l) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (l3 < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long l4 = (long)Math.ceil((double)(l2 - l) / (double)l3);
        if (l4 > (long)ByteLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        short[] sArray2 = sArray != null && (long)sArray.length >= l4 ? sArray : new short[(int)l4];
        int n = 0;
        if (this.ptr != 0L) {
            for (long i = l; i < l2; i += l3) {
                sArray2[n++] = Utilities.UNSAFE.getByte(this.ptr + i);
            }
        } else {
            for (long i = l; i < l2; i += l3) {
                sArray2[n++] = this.data[(int)i];
            }
        }
        return sArray2;
    }

    @Override
    public int[] getIntData() {
        if (this.ptr != 0L) {
            return null;
        }
        int[] nArray = new int[(int)this.length];
        int n = 0;
        while ((long)n < this.length) {
            nArray[n] = this.data[n];
            ++n;
        }
        return nArray;
    }

    @Override
    public int[] getIntData(int[] nArray, long l, long l2, long l3) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (l2 < 0L || l2 > this.length || l2 < l) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (l3 < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long l4 = (long)Math.ceil((double)(l2 - l) / (double)l3);
        if (l4 > (long)ByteLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        int[] nArray2 = nArray != null && (long)nArray.length >= l4 ? nArray : new int[(int)l4];
        int n = 0;
        if (this.ptr != 0L) {
            for (long i = l; i < l2; i += l3) {
                nArray2[n++] = Utilities.UNSAFE.getByte(this.ptr + i);
            }
        } else {
            for (long i = l; i < l2; i += l3) {
                nArray2[n++] = this.data[(int)i];
            }
        }
        return nArray2;
    }

    @Override
    public long[] getLongData() {
        if (this.ptr != 0L) {
            return null;
        }
        long[] lArray = new long[(int)this.length];
        int n = 0;
        while ((long)n < this.length) {
            lArray[n] = this.data[n];
            ++n;
        }
        return lArray;
    }

    @Override
    public long[] getLongData(long[] lArray, long l, long l2, long l3) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (l2 < 0L || l2 > this.length || l2 < l) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (l3 < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long l4 = (long)Math.ceil((double)(l2 - l) / (double)l3);
        if (l4 > (long)ByteLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        long[] lArray2 = lArray != null && (long)lArray.length >= l4 ? lArray : new long[(int)l4];
        int n = 0;
        if (this.ptr != 0L) {
            for (long i = l; i < l2; i += l3) {
                lArray2[n++] = Utilities.UNSAFE.getByte(this.ptr + i);
            }
        } else {
            for (long i = l; i < l2; i += l3) {
                lArray2[n++] = this.data[(int)i];
            }
        }
        return lArray2;
    }

    @Override
    public float[] getFloatData() {
        if (this.ptr != 0L) {
            return null;
        }
        float[] fArray = new float[(int)this.length];
        int n = 0;
        while ((long)n < this.length) {
            fArray[n] = this.data[n];
            ++n;
        }
        return fArray;
    }

    @Override
    public float[] getFloatData(float[] fArray, long l, long l2, long l3) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (l2 < 0L || l2 > this.length || l2 < l) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (l3 < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long l4 = (long)Math.ceil((double)(l2 - l) / (double)l3);
        if (l4 > (long)ByteLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        float[] fArray2 = fArray != null && (long)fArray.length >= l4 ? fArray : new float[(int)l4];
        int n = 0;
        if (this.ptr != 0L) {
            for (long i = l; i < l2; i += l3) {
                fArray2[n++] = Utilities.UNSAFE.getByte(this.ptr + i);
            }
        } else {
            for (long i = l; i < l2; i += l3) {
                fArray2[n++] = this.data[(int)i];
            }
        }
        return fArray2;
    }

    @Override
    public double[] getDoubleData() {
        if (this.ptr != 0L) {
            return null;
        }
        double[] dArray = new double[(int)this.length];
        int n = 0;
        while ((long)n < this.length) {
            dArray[n] = this.data[n];
            ++n;
        }
        return dArray;
    }

    @Override
    public double[] getDoubleData(double[] dArray, long l, long l2, long l3) {
        if (l < 0L || l >= this.length) {
            throw new ArrayIndexOutOfBoundsException("startPos < 0 || startPos >= length");
        }
        if (l2 < 0L || l2 > this.length || l2 < l) {
            throw new ArrayIndexOutOfBoundsException("endPos < 0 || endPos > length || endPos < startPos");
        }
        if (l3 < 1L) {
            throw new IllegalArgumentException("step < 1");
        }
        long l4 = (long)Math.ceil((double)(l2 - l) / (double)l3);
        if (l4 > (long)ByteLargeArray.getMaxSizeOf32bitArray()) {
            return null;
        }
        double[] dArray2 = dArray != null && (long)dArray.length >= l4 ? dArray : new double[(int)l4];
        int n = 0;
        if (this.ptr != 0L) {
            for (long i = l; i < l2; i += l3) {
                dArray2[n++] = Utilities.UNSAFE.getByte(this.ptr + i);
            }
        } else {
            for (long i = l; i < l2; i += l3) {
                dArray2[n++] = this.data[(int)i];
            }
        }
        return dArray2;
    }

    @Override
    public void setToNative(long l, Object object) {
        Utilities.UNSAFE.putByte(this.ptr + l, (Byte)object);
    }

    @Override
    public void setBoolean(long l, boolean bl) {
        if (this.ptr != 0L) {
            Utilities.UNSAFE.putByte(this.ptr + l, bl ? (byte)1 : 0);
        } else {
            this.data[(int)l] = bl ? (byte)1 : 0;
        }
    }

    @Override
    public void setByte(long l, byte by) {
        if (this.ptr != 0L) {
            Utilities.UNSAFE.putByte(this.ptr + l, by);
        } else {
            this.data[(int)l] = by;
        }
    }

    @Override
    public void setShort(long l, short s) {
        if (this.ptr != 0L) {
            Utilities.UNSAFE.putByte(this.ptr + l, (byte)s);
        } else {
            this.data[(int)l] = (byte)s;
        }
    }

    @Override
    public void setInt(long l, int n) {
        if (this.ptr != 0L) {
            Utilities.UNSAFE.putByte(this.ptr + l, (byte)n);
        } else {
            this.data[(int)l] = (byte)n;
        }
    }

    @Override
    public void setLong(long l, long l2) {
        if (this.ptr != 0L) {
            Utilities.UNSAFE.putByte(this.ptr + l, (byte)l2);
        } else {
            this.data[(int)l] = (byte)l2;
        }
    }

    @Override
    public void setFloat(long l, float f) {
        if (this.ptr != 0L) {
            Utilities.UNSAFE.putByte(this.ptr + l, (byte)f);
        } else {
            this.data[(int)l] = (byte)f;
        }
    }

    @Override
    public void setDouble(long l, double d) {
        if (this.ptr != 0L) {
            Utilities.UNSAFE.putByte(this.ptr + l, (byte)d);
        } else {
            this.data[(int)l] = (byte)d;
        }
    }
}

