/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array;

import mitiv.array.Array8D;
import mitiv.array.Byte1D;
import mitiv.array.Byte7D;
import mitiv.array.ByteArray;
import mitiv.array.Double8D;
import mitiv.array.Float8D;
import mitiv.array.Int8D;
import mitiv.array.Long8D;
import mitiv.array.ShapedArray;
import mitiv.array.Short8D;
import mitiv.array.impl.FlatByte8D;
import mitiv.array.impl.StriddenByte8D;
import mitiv.base.Shape;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ByteFunction;
import mitiv.base.mapping.ByteScanner;
import mitiv.exception.IllegalTypeException;
import mitiv.exception.NonConformableArrayException;
import mitiv.linalg.shaped.DoubleShapedVector;
import mitiv.linalg.shaped.FloatShapedVector;
import mitiv.linalg.shaped.ShapedVector;
import mitiv.random.ByteGenerator;

public abstract class Byte8D
extends Array8D
implements ByteArray {
    protected Byte8D(int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8) {
        super(dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8);
    }

    protected Byte8D(int[] dims) {
        super(dims);
    }

    protected Byte8D(Shape shape) {
        super(shape);
    }

    @Override
    public final int getType() {
        return 0;
    }

    public abstract byte get(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public abstract void set(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, byte var9);

    @Override
    public void fill(byte value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i5 = 0; i5 < this.dim5; ++i5) {
                                for (int i6 = 0; i6 < this.dim6; ++i6) {
                                    for (int i7 = 0; i7 < this.dim7; ++i7) {
                                        for (int i8 = 0; i8 < this.dim8; ++i8) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, value);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i8 = 0; i8 < this.dim8; ++i8) {
                for (int i7 = 0; i7 < this.dim7; ++i7) {
                    for (int i6 = 0; i6 < this.dim6; ++i6) {
                        for (int i5 = 0; i5 < this.dim5; ++i5) {
                            for (int i4 = 0; i4 < this.dim4; ++i4) {
                                for (int i3 = 0; i3 < this.dim3; ++i3) {
                                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, value);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void increment(byte value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i5 = 0; i5 < this.dim5; ++i5) {
                                for (int i6 = 0; i6 < this.dim6; ++i6) {
                                    for (int i7 = 0; i7 < this.dim7; ++i7) {
                                        for (int i8 = 0; i8 < this.dim8; ++i8) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, (byte)(this.get(i1, i2, i3, i4, i5, i6, i7, i8) + value));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i8 = 0; i8 < this.dim8; ++i8) {
                for (int i7 = 0; i7 < this.dim7; ++i7) {
                    for (int i6 = 0; i6 < this.dim6; ++i6) {
                        for (int i5 = 0; i5 < this.dim5; ++i5) {
                            for (int i4 = 0; i4 < this.dim4; ++i4) {
                                for (int i3 = 0; i3 < this.dim3; ++i3) {
                                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, (byte)(this.get(i1, i2, i3, i4, i5, i6, i7, i8) + value));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void decrement(byte value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i5 = 0; i5 < this.dim5; ++i5) {
                                for (int i6 = 0; i6 < this.dim6; ++i6) {
                                    for (int i7 = 0; i7 < this.dim7; ++i7) {
                                        for (int i8 = 0; i8 < this.dim8; ++i8) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, (byte)(this.get(i1, i2, i3, i4, i5, i6, i7, i8) - value));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i8 = 0; i8 < this.dim8; ++i8) {
                for (int i7 = 0; i7 < this.dim7; ++i7) {
                    for (int i6 = 0; i6 < this.dim6; ++i6) {
                        for (int i5 = 0; i5 < this.dim5; ++i5) {
                            for (int i4 = 0; i4 < this.dim4; ++i4) {
                                for (int i3 = 0; i3 < this.dim3; ++i3) {
                                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, (byte)(this.get(i1, i2, i3, i4, i5, i6, i7, i8) - value));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scale(byte value) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i5 = 0; i5 < this.dim5; ++i5) {
                                for (int i6 = 0; i6 < this.dim6; ++i6) {
                                    for (int i7 = 0; i7 < this.dim7; ++i7) {
                                        for (int i8 = 0; i8 < this.dim8; ++i8) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, (byte)(this.get(i1, i2, i3, i4, i5, i6, i7, i8) * value));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i8 = 0; i8 < this.dim8; ++i8) {
                for (int i7 = 0; i7 < this.dim7; ++i7) {
                    for (int i6 = 0; i6 < this.dim6; ++i6) {
                        for (int i5 = 0; i5 < this.dim5; ++i5) {
                            for (int i4 = 0; i4 < this.dim4; ++i4) {
                                for (int i3 = 0; i3 < this.dim3; ++i3) {
                                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, (byte)(this.get(i1, i2, i3, i4, i5, i6, i7, i8) * value));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void map(ByteFunction function) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i5 = 0; i5 < this.dim5; ++i5) {
                                for (int i6 = 0; i6 < this.dim6; ++i6) {
                                    for (int i7 = 0; i7 < this.dim7; ++i7) {
                                        for (int i8 = 0; i8 < this.dim8; ++i8) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, function.apply(this.get(i1, i2, i3, i4, i5, i6, i7, i8)));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i8 = 0; i8 < this.dim8; ++i8) {
                for (int i7 = 0; i7 < this.dim7; ++i7) {
                    for (int i6 = 0; i6 < this.dim6; ++i6) {
                        for (int i5 = 0; i5 < this.dim5; ++i5) {
                            for (int i4 = 0; i4 < this.dim4; ++i4) {
                                for (int i3 = 0; i3 < this.dim3; ++i3) {
                                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, function.apply(this.get(i1, i2, i3, i4, i5, i6, i7, i8)));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void fill(ByteGenerator generator) {
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i5 = 0; i5 < this.dim5; ++i5) {
                                for (int i6 = 0; i6 < this.dim6; ++i6) {
                                    for (int i7 = 0; i7 < this.dim7; ++i7) {
                                        for (int i8 = 0; i8 < this.dim8; ++i8) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, generator.nextByte());
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i8 = 0; i8 < this.dim8; ++i8) {
                for (int i7 = 0; i7 < this.dim7; ++i7) {
                    for (int i6 = 0; i6 < this.dim6; ++i6) {
                        for (int i5 = 0; i5 < this.dim5; ++i5) {
                            for (int i4 = 0; i4 < this.dim4; ++i4) {
                                for (int i3 = 0; i3 < this.dim3; ++i3) {
                                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, generator.nextByte());
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void scan(ByteScanner scanner) {
        boolean initialized = false;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i5 = 0; i5 < this.dim5; ++i5) {
                                for (int i6 = 0; i6 < this.dim6; ++i6) {
                                    for (int i7 = 0; i7 < this.dim7; ++i7) {
                                        for (int i8 = 0; i8 < this.dim8; ++i8) {
                                            if (initialized) {
                                                scanner.update(this.get(i1, i2, i3, i4, i5, i6, i7, i8));
                                                continue;
                                            }
                                            scanner.initialize(this.get(i1, i2, i3, i4, i5, i6, i7, i8));
                                            initialized = true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i8 = 0; i8 < this.dim8; ++i8) {
                for (int i7 = 0; i7 < this.dim7; ++i7) {
                    for (int i6 = 0; i6 < this.dim6; ++i6) {
                        for (int i5 = 0; i5 < this.dim5; ++i5) {
                            for (int i4 = 0; i4 < this.dim4; ++i4) {
                                for (int i3 = 0; i3 < this.dim3; ++i3) {
                                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                                            if (initialized) {
                                                scanner.update(this.get(i1, i2, i3, i4, i5, i6, i7, i8));
                                                continue;
                                            }
                                            scanner.initialize(this.get(i1, i2, i3, i4, i5, i6, i7, i8));
                                            initialized = true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public final byte[] flatten() {
        return this.flatten(false);
    }

    @Override
    public int min() {
        int minValue = this.get(0, 0, 0, 0, 0, 0, 0, 0) & 0xFF;
        boolean skip = true;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i5 = 0; i5 < this.dim5; ++i5) {
                                for (int i6 = 0; i6 < this.dim6; ++i6) {
                                    for (int i7 = 0; i7 < this.dim7; ++i7) {
                                        for (int i8 = 0; i8 < this.dim8; ++i8) {
                                            if (skip) {
                                                skip = false;
                                                continue;
                                            }
                                            int value = this.get(i1, i2, i3, i4, i5, i6, i7, i8) & 0xFF;
                                            if (value >= minValue) continue;
                                            minValue = value;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i8 = 0; i8 < this.dim8; ++i8) {
                for (int i7 = 0; i7 < this.dim7; ++i7) {
                    for (int i6 = 0; i6 < this.dim6; ++i6) {
                        for (int i5 = 0; i5 < this.dim5; ++i5) {
                            for (int i4 = 0; i4 < this.dim4; ++i4) {
                                for (int i3 = 0; i3 < this.dim3; ++i3) {
                                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                                            if (skip) {
                                                skip = false;
                                                continue;
                                            }
                                            int value = this.get(i1, i2, i3, i4, i5, i6, i7, i8) & 0xFF;
                                            if (value >= minValue) continue;
                                            minValue = value;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return minValue;
    }

    @Override
    public int max() {
        int maxValue = this.get(0, 0, 0, 0, 0, 0, 0, 0) & 0xFF;
        boolean skip = true;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i5 = 0; i5 < this.dim5; ++i5) {
                                for (int i6 = 0; i6 < this.dim6; ++i6) {
                                    for (int i7 = 0; i7 < this.dim7; ++i7) {
                                        for (int i8 = 0; i8 < this.dim8; ++i8) {
                                            if (skip) {
                                                skip = false;
                                                continue;
                                            }
                                            int value = this.get(i1, i2, i3, i4, i5, i6, i7, i8) & 0xFF;
                                            if (value <= maxValue) continue;
                                            maxValue = value;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i8 = 0; i8 < this.dim8; ++i8) {
                for (int i7 = 0; i7 < this.dim7; ++i7) {
                    for (int i6 = 0; i6 < this.dim6; ++i6) {
                        for (int i5 = 0; i5 < this.dim5; ++i5) {
                            for (int i4 = 0; i4 < this.dim4; ++i4) {
                                for (int i3 = 0; i3 < this.dim3; ++i3) {
                                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                                            if (skip) {
                                                skip = false;
                                                continue;
                                            }
                                            int value = this.get(i1, i2, i3, i4, i5, i6, i7, i8) & 0xFF;
                                            if (value <= maxValue) continue;
                                            maxValue = value;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return maxValue;
    }

    @Override
    public int[] getMinAndMax() {
        int[] result = new int[2];
        this.getMinAndMax(result);
        return result;
    }

    @Override
    public void getMinAndMax(int[] mm) {
        int minValue;
        int maxValue = minValue = this.get(0, 0, 0, 0, 0, 0, 0, 0) & 0xFF;
        boolean skip = true;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i5 = 0; i5 < this.dim5; ++i5) {
                                for (int i6 = 0; i6 < this.dim6; ++i6) {
                                    for (int i7 = 0; i7 < this.dim7; ++i7) {
                                        for (int i8 = 0; i8 < this.dim8; ++i8) {
                                            if (skip) {
                                                skip = false;
                                                continue;
                                            }
                                            int value = this.get(i1, i2, i3, i4, i5, i6, i7, i8) & 0xFF;
                                            if (value < minValue) {
                                                minValue = value;
                                            }
                                            if (value <= maxValue) continue;
                                            maxValue = value;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i8 = 0; i8 < this.dim8; ++i8) {
                for (int i7 = 0; i7 < this.dim7; ++i7) {
                    for (int i6 = 0; i6 < this.dim6; ++i6) {
                        for (int i5 = 0; i5 < this.dim5; ++i5) {
                            for (int i4 = 0; i4 < this.dim4; ++i4) {
                                for (int i3 = 0; i3 < this.dim3; ++i3) {
                                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                                            if (skip) {
                                                skip = false;
                                                continue;
                                            }
                                            int value = this.get(i1, i2, i3, i4, i5, i6, i7, i8) & 0xFF;
                                            if (value < minValue) {
                                                minValue = value;
                                            }
                                            if (value <= maxValue) continue;
                                            maxValue = value;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        mm[0] = minValue;
        mm[1] = maxValue;
    }

    @Override
    public int sum() {
        int totalValue = 0;
        if (this.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i5 = 0; i5 < this.dim5; ++i5) {
                                for (int i6 = 0; i6 < this.dim6; ++i6) {
                                    for (int i7 = 0; i7 < this.dim7; ++i7) {
                                        for (int i8 = 0; i8 < this.dim8; ++i8) {
                                            totalValue += this.get(i1, i2, i3, i4, i5, i6, i7, i8) & 0xFF;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i8 = 0; i8 < this.dim8; ++i8) {
                for (int i7 = 0; i7 < this.dim7; ++i7) {
                    for (int i6 = 0; i6 < this.dim6; ++i6) {
                        for (int i5 = 0; i5 < this.dim5; ++i5) {
                            for (int i4 = 0; i4 < this.dim4; ++i4) {
                                for (int i3 = 0; i3 < this.dim3; ++i3) {
                                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                                            totalValue += this.get(i1, i2, i3, i4, i5, i6, i7, i8) & 0xFF;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return totalValue;
    }

    @Override
    public double average() {
        return (double)this.sum() / (double)this.number;
    }

    @Override
    public Byte8D toByte() {
        return this;
    }

    @Override
    public Short8D toShort() {
        short[] out = new short[this.number];
        if (this.isFlat()) {
            byte[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = (short)(inp[i] & 0xFF);
            }
        } else {
            int i = -1;
            for (int i8 = 0; i8 < this.dim8; ++i8) {
                for (int i7 = 0; i7 < this.dim7; ++i7) {
                    for (int i6 = 0; i6 < this.dim6; ++i6) {
                        for (int i5 = 0; i5 < this.dim5; ++i5) {
                            for (int i4 = 0; i4 < this.dim4; ++i4) {
                                for (int i3 = 0; i3 < this.dim3; ++i3) {
                                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                                            out[++i] = (short)(this.get(i1, i2, i3, i4, i5, i6, i7, i8) & 0xFF);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Short8D.wrap(out, this.getShape());
    }

    @Override
    public Int8D toInt() {
        int[] out = new int[this.number];
        if (this.isFlat()) {
            byte[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = inp[i] & 0xFF;
            }
        } else {
            int i = -1;
            for (int i8 = 0; i8 < this.dim8; ++i8) {
                for (int i7 = 0; i7 < this.dim7; ++i7) {
                    for (int i6 = 0; i6 < this.dim6; ++i6) {
                        for (int i5 = 0; i5 < this.dim5; ++i5) {
                            for (int i4 = 0; i4 < this.dim4; ++i4) {
                                for (int i3 = 0; i3 < this.dim3; ++i3) {
                                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                                            out[++i] = this.get(i1, i2, i3, i4, i5, i6, i7, i8) & 0xFF;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Int8D.wrap(out, this.getShape());
    }

    @Override
    public Long8D toLong() {
        long[] out = new long[this.number];
        if (this.isFlat()) {
            byte[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = inp[i] & 0xFF;
            }
        } else {
            int i = -1;
            for (int i8 = 0; i8 < this.dim8; ++i8) {
                for (int i7 = 0; i7 < this.dim7; ++i7) {
                    for (int i6 = 0; i6 < this.dim6; ++i6) {
                        for (int i5 = 0; i5 < this.dim5; ++i5) {
                            for (int i4 = 0; i4 < this.dim4; ++i4) {
                                for (int i3 = 0; i3 < this.dim3; ++i3) {
                                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                                            out[++i] = this.get(i1, i2, i3, i4, i5, i6, i7, i8) & 0xFF;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Long8D.wrap(out, this.getShape());
    }

    @Override
    public Float8D toFloat() {
        float[] out = new float[this.number];
        if (this.isFlat()) {
            byte[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = inp[i] & 0xFF;
            }
        } else {
            int i = -1;
            for (int i8 = 0; i8 < this.dim8; ++i8) {
                for (int i7 = 0; i7 < this.dim7; ++i7) {
                    for (int i6 = 0; i6 < this.dim6; ++i6) {
                        for (int i5 = 0; i5 < this.dim5; ++i5) {
                            for (int i4 = 0; i4 < this.dim4; ++i4) {
                                for (int i3 = 0; i3 < this.dim3; ++i3) {
                                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                                            out[++i] = this.get(i1, i2, i3, i4, i5, i6, i7, i8) & 0xFF;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Float8D.wrap(out, this.getShape());
    }

    @Override
    public Double8D toDouble() {
        double[] out = new double[this.number];
        if (this.isFlat()) {
            byte[] inp = this.getData();
            for (int i = 0; i < this.number; ++i) {
                out[i] = inp[i] & 0xFF;
            }
        } else {
            int i = -1;
            for (int i8 = 0; i8 < this.dim8; ++i8) {
                for (int i7 = 0; i7 < this.dim7; ++i7) {
                    for (int i6 = 0; i6 < this.dim6; ++i6) {
                        for (int i5 = 0; i5 < this.dim5; ++i5) {
                            for (int i4 = 0; i4 < this.dim4; ++i4) {
                                for (int i3 = 0; i3 < this.dim3; ++i3) {
                                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                                            out[++i] = this.get(i1, i2, i3, i4, i5, i6, i7, i8) & 0xFF;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Double8D.wrap(out, this.getShape());
    }

    @Override
    public Byte8D copy() {
        return new FlatByte8D(this.flatten(true), this.shape);
    }

    @Override
    public void assign(ShapedArray arr) {
        if (!this.getShape().equals(arr.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        Byte8D src = arr.getType() == 0 ? (Byte8D)arr : (Byte8D)arr.toByte();
        if (this.getOrder() == 2 && src.getOrder() == 2) {
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                for (int i2 = 0; i2 < this.dim2; ++i2) {
                    for (int i3 = 0; i3 < this.dim3; ++i3) {
                        for (int i4 = 0; i4 < this.dim4; ++i4) {
                            for (int i5 = 0; i5 < this.dim5; ++i5) {
                                for (int i6 = 0; i6 < this.dim6; ++i6) {
                                    for (int i7 = 0; i7 < this.dim7; ++i7) {
                                        for (int i8 = 0; i8 < this.dim8; ++i8) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, src.get(i1, i2, i3, i4, i5, i6, i7, i8));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            for (int i8 = 0; i8 < this.dim8; ++i8) {
                for (int i7 = 0; i7 < this.dim7; ++i7) {
                    for (int i6 = 0; i6 < this.dim6; ++i6) {
                        for (int i5 = 0; i5 < this.dim5; ++i5) {
                            for (int i4 = 0; i4 < this.dim4; ++i4) {
                                for (int i3 = 0; i3 < this.dim3; ++i3) {
                                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, src.get(i1, i2, i3, i4, i5, i6, i7, i8));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void assign(ShapedVector vec) {
        if (!this.getShape().equals(vec.getShape())) {
            throw new NonConformableArrayException("Source and destination must have the same shape");
        }
        int i = -1;
        if (vec.getType() == 5) {
            DoubleShapedVector src = (DoubleShapedVector)vec;
            for (int i8 = 0; i8 < this.dim8; ++i8) {
                for (int i7 = 0; i7 < this.dim7; ++i7) {
                    for (int i6 = 0; i6 < this.dim6; ++i6) {
                        for (int i5 = 0; i5 < this.dim5; ++i5) {
                            for (int i4 = 0; i4 < this.dim4; ++i4) {
                                for (int i3 = 0; i3 < this.dim3; ++i3) {
                                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, (byte)src.get(++i));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (vec.getType() == 4) {
            FloatShapedVector src = (FloatShapedVector)vec;
            for (int i8 = 0; i8 < this.dim8; ++i8) {
                for (int i7 = 0; i7 < this.dim7; ++i7) {
                    for (int i6 = 0; i6 < this.dim6; ++i6) {
                        for (int i5 = 0; i5 < this.dim5; ++i5) {
                            for (int i4 = 0; i4 < this.dim4; ++i4) {
                                for (int i3 = 0; i3 < this.dim3; ++i3) {
                                    for (int i2 = 0; i2 < this.dim2; ++i2) {
                                        for (int i1 = 0; i1 < this.dim1; ++i1) {
                                            this.set(i1, i2, i3, i4, i5, i6, i7, i8, (byte)src.get(++i));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else {
            throw new IllegalTypeException();
        }
    }

    @Override
    public Byte8D create() {
        return new FlatByte8D(this.getShape());
    }

    public static Byte8D create(int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8) {
        return new FlatByte8D(dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8);
    }

    public static Byte8D create(int[] dims) {
        return new FlatByte8D(dims);
    }

    public static Byte8D create(Shape shape) {
        return new FlatByte8D(shape);
    }

    public static Byte8D wrap(byte[] data, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8) {
        return new FlatByte8D(data, dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8);
    }

    public static Byte8D wrap(byte[] data, int[] dims) {
        return new FlatByte8D(data, dims);
    }

    public static Byte8D wrap(byte[] data, Shape shape) {
        return new FlatByte8D(data, shape);
    }

    public static Byte8D wrap(byte[] data, int offset, int stride1, int stride2, int stride3, int stride4, int stride5, int stride6, int stride7, int stride8, int dim1, int dim2, int dim3, int dim4, int dim5, int dim6, int dim7, int dim8) {
        return new StriddenByte8D(data, offset, stride1, stride2, stride3, stride4, stride5, stride6, stride7, stride8, dim1, dim2, dim3, dim4, dim5, dim6, dim7, dim8);
    }

    @Override
    public abstract Byte7D slice(int var1);

    @Override
    public abstract Byte7D slice(int var1, int var2);

    @Override
    public abstract Byte8D view(Range var1, Range var2, Range var3, Range var4, Range var5, Range var6, Range var7, Range var8);

    @Override
    public abstract Byte8D view(int[] var1, int[] var2, int[] var3, int[] var4, int[] var5, int[] var6, int[] var7, int[] var8);

    @Override
    public abstract Byte1D as1D();
}

