/*
 * Decompiled with CFR 0.152.
 */
package icy.swimmingPool;

import icy.gui.frame.IcyFrame;
import icy.gui.util.ComponentUtil;
import icy.main.Icy;
import icy.swimmingPool.SwimmingObject;
import icy.swimmingPool.SwimmingPoolEvent;
import icy.swimmingPool.SwimmingPoolEventType;
import icy.swimmingPool.SwimmingPoolListener;
import icy.swimmingPool.SwimmingPoolObjectPanel;
import icy.swimmingPool.SwimmingPoolViewerPanel;
import icy.system.thread.ThreadUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;

public class SwimmingPoolViewer
implements SwimmingPoolListener,
ActionListener {
    IcyFrame mainFrame = new IcyFrame("Swimming Pool Viewer", true, true, true, true);
    SwimmingPoolViewerPanel spvp = new SwimmingPoolViewerPanel();

    public SwimmingPoolViewer() {
        this.mainFrame.getContentPane().setLayout(new BorderLayout());
        this.mainFrame.getContentPane().add((Component)this.spvp, "Center");
        this.mainFrame.setVisible(true);
        this.mainFrame.setPreferredSize(new Dimension(400, 400));
        this.mainFrame.addToDesktopPane();
        this.mainFrame.center();
        this.mainFrame.pack();
        Icy.getMainInterface().getSwimmingPool().addListener(this);
        this.spvp.getDeleteAllButton().addActionListener(this);
        this.refreshGUI();
        this.mainFrame.requestFocus();
    }

    private void refreshGUI() {
        this.spvp.getScrollPanel().removeAll();
        for (SwimmingObject result : Icy.getMainInterface().getSwimmingPool().getObjects()) {
            SwimmingPoolObjectPanel panel = new SwimmingPoolObjectPanel(result);
            ComponentUtil.setFixedHeight(panel, 40);
            this.spvp.getScrollPanel().add(panel);
        }
        this.spvp.getScrollPanel().add(Box.createVerticalGlue());
        String text = "No object in swimming pool.";
        int numberOfSwimmingObject = Icy.getMainInterface().getSwimmingPool().getObjects().size();
        if (numberOfSwimmingObject > 0) {
            text = numberOfSwimmingObject + " objects in swimming pool.";
        }
        this.spvp.getNumberOfSwimmingObjectLabel().setText(text);
        this.spvp.getScrollPane().invalidate();
        this.spvp.getScrollPane().repaint();
    }

    @Override
    public void swimmingPoolChangeEvent(SwimmingPoolEvent swimmingPoolEvent) {
        if (swimmingPoolEvent.getType() == SwimmingPoolEventType.ELEMENT_ADDED) {
            ThreadUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwimmingPoolViewer.this.refreshGUI();
                }
            });
        }
        if (swimmingPoolEvent.getType() == SwimmingPoolEventType.ELEMENT_REMOVED) {
            ThreadUtil.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SwimmingPoolViewer.this.refreshGUI();
                }
            });
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.spvp.getDeleteAllButton()) {
            Icy.getMainInterface().getSwimmingPool().removeAll();
        }
    }
}

