/*
 * Decompiled with CFR 0.152.
 */
package icy.type.collection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class CollectionUtil {
    public static <T> ArrayList<T> asArrayList(T ... a) {
        return new ArrayList<T>(Arrays.asList(a));
    }

    public static <T> List<T> asList(T ... a) {
        return Arrays.asList(a);
    }

    public static <T> ArrayList<T> createArrayList(T t, boolean addIfNull) {
        ArrayList<T> result = new ArrayList<T>();
        if (addIfNull || t != null) {
            result.add(t);
        }
        return result;
    }

    public static <T> ArrayList<T> createArrayList(T t) {
        return CollectionUtil.createArrayList(t, true);
    }

    public static <T> boolean addUniq(List<T> list, T t, boolean addIfNull) {
        if ((addIfNull || t != null) && !list.contains(t)) {
            return list.add(t);
        }
        return false;
    }

    public static <T> boolean addUniq(List<T> list, T t) {
        return CollectionUtil.addUniq(list, t, true);
    }

    public static <T> boolean equals(Collection<T> c1, Collection<T> c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null) {
            return false;
        }
        if (c2 == null) {
            return false;
        }
        if (c1.size() != c2.size()) {
            return false;
        }
        return c2.containsAll(c1);
    }
}

