/*
 * Decompiled with CFR 0.152.
 */
package icy.type.geom;

import icy.type.geom.Line3D;
import icy.type.geom.Shape3D;
import icy.type.point.Point3D;
import icy.type.rectangle.Rectangle3D;
import java.util.ArrayList;
import java.util.List;

public class Polyline3D
implements Shape3D,
Cloneable {
    public int npoints;
    public double[] xpoints;
    public double[] ypoints;
    public double[] zpoints;
    protected Rectangle3D bounds;
    protected List<Line3D> lines;

    public Polyline3D() {
        this.reset();
    }

    public Polyline3D(double[] xpoints, double[] ypoints, double[] zpoints, int npoints) {
        if (npoints > xpoints.length || npoints > ypoints.length || npoints > zpoints.length) {
            throw new IndexOutOfBoundsException("npoints > points.length");
        }
        this.npoints = npoints;
        this.xpoints = new double[npoints];
        this.ypoints = new double[npoints];
        this.zpoints = new double[npoints];
        System.arraycopy(xpoints, 0, this.xpoints, 0, npoints);
        System.arraycopy(ypoints, 0, this.ypoints, 0, npoints);
        System.arraycopy(zpoints, 0, this.zpoints, 0, npoints);
        this.calculateLines();
    }

    public Polyline3D(int[] xpoints, int[] ypoints, int[] zpoints, int npoints) {
        if (npoints > xpoints.length || npoints > ypoints.length || npoints > zpoints.length) {
            throw new IndexOutOfBoundsException("npoints > points.length");
        }
        this.npoints = npoints;
        this.xpoints = new double[npoints];
        this.ypoints = new double[npoints];
        this.zpoints = new double[npoints];
        int i = 0;
        while (i < npoints) {
            this.xpoints[i] = xpoints[i];
            this.ypoints[i] = ypoints[i];
            this.zpoints[i] = zpoints[i];
            ++i;
        }
        this.calculateLines();
    }

    public Polyline3D(Line3D line) {
        this.npoints = 2;
        this.xpoints = new double[2];
        this.ypoints = new double[2];
        this.zpoints = new double[2];
        this.xpoints[0] = line.getX1();
        this.xpoints[1] = line.getX2();
        this.ypoints[0] = line.getY1();
        this.ypoints[1] = line.getY2();
        this.zpoints[0] = line.getZ1();
        this.zpoints[1] = line.getZ2();
        this.calculateLines();
    }

    public void reset() {
        this.npoints = 0;
        this.xpoints = new double[0];
        this.ypoints = new double[0];
        this.zpoints = new double[0];
        this.bounds = new Rectangle3D.Double();
        this.lines = new ArrayList<Line3D>();
    }

    public Object clone() {
        Polyline3D pol = new Polyline3D();
        int i = 0;
        while (i < this.npoints) {
            pol.addPoint(this.xpoints[i], this.ypoints[i], this.zpoints[i]);
            ++i;
        }
        return pol;
    }

    public void calculateLines() {
        double zmin;
        double zmax;
        double ymin;
        double ymax;
        double xmin;
        double xmax;
        ArrayList<Line3D> newLines = new ArrayList<Line3D>();
        if (this.npoints > 0) {
            Point3D.Double pos = new Point3D.Double(this.xpoints[0], this.ypoints[0], this.zpoints[0]);
            xmin = xmax = ((Point3D)pos).getX();
            ymin = ymax = ((Point3D)pos).getY();
            zmin = zmax = ((Point3D)pos).getZ();
            if (this.npoints == 1) {
                newLines.add(new Line3D(pos, pos));
            } else {
                int i = 1;
                while (i < this.npoints) {
                    double x = this.xpoints[i];
                    double y = this.ypoints[i];
                    double z = this.zpoints[i];
                    Point3D.Double newPos = new Point3D.Double(x, y, z);
                    if (x < xmin) {
                        xmin = x;
                    }
                    if (y < ymin) {
                        ymin = y;
                    }
                    if (z < zmin) {
                        zmin = z;
                    }
                    if (x > xmax) {
                        xmax = x;
                    }
                    if (y > ymax) {
                        ymax = y;
                    }
                    if (z > zmax) {
                        zmax = z;
                    }
                    newLines.add(new Line3D(pos, newPos));
                    pos = newPos;
                    ++i;
                }
            }
        } else {
            zmin = 0.0;
            ymin = 0.0;
            xmin = 0.0;
            zmax = 0.0;
            ymax = 0.0;
            xmax = 0.0;
        }
        this.bounds = new Rectangle3D.Double(xmin, ymin, zmin, xmax - xmin, ymax - ymin, zmax - zmin);
        this.lines = newLines;
    }

    protected void updateLines(double x, double y, double z) {
        if (this.lines.isEmpty()) {
            this.lines.add(new Line3D(x, y, z, x, y, z));
            this.bounds = new Rectangle3D.Double(x, y, z, 0.0, 0.0, 0.0);
        } else {
            Line3D lastLine = this.lines.get(this.lines.size() - 1);
            Line3D newLine = new Line3D(lastLine.getX2(), lastLine.getY2(), lastLine.getZ2(), x, y, z);
            this.lines.add(newLine);
            this.bounds.add(newLine.getBounds());
        }
    }

    public void addPoint(Point3D p) {
        this.addPoint(p.getX(), p.getY(), p.getZ());
    }

    public void addPoint(double x, double y, double z) {
        if (this.npoints == this.xpoints.length) {
            double[] tmp = new double[this.npoints * 2 + 1];
            System.arraycopy(this.xpoints, 0, tmp, 0, this.npoints);
            this.xpoints = tmp;
            tmp = new double[this.npoints * 2 + 1];
            System.arraycopy(this.ypoints, 0, tmp, 0, this.npoints);
            this.ypoints = tmp;
            tmp = new double[this.npoints * 2 + 1];
            System.arraycopy(this.zpoints, 0, tmp, 0, this.npoints);
            this.zpoints = tmp;
        }
        this.xpoints[this.npoints] = x;
        this.ypoints[this.npoints] = y;
        this.zpoints[this.npoints] = z;
        ++this.npoints;
        this.updateLines(x, y, z);
    }

    @Override
    public Rectangle3D getBounds() {
        return (Rectangle3D)this.bounds.clone();
    }

    @Override
    public boolean contains(Point3D p) {
        return false;
    }

    @Override
    public boolean contains(double x, double y, double z) {
        return false;
    }

    @Override
    public boolean intersects(double x, double y, double z, double sizeX, double sizeY, double sizeZ) {
        return this.intersects(new Rectangle3D.Double(x, y, z, sizeX, sizeY, sizeZ));
    }

    @Override
    public boolean intersects(Rectangle3D r) {
        if (this.lines.isEmpty() || !this.bounds.intersects(r)) {
            return false;
        }
        for (Line3D line : this.lines) {
            if (!line.intersects(r)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(double x, double y, double z, double sizeX, double sizeY, double sizeZ) {
        return false;
    }

    @Override
    public boolean contains(Rectangle3D r) {
        return false;
    }
}

